/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.font;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;

public class FontPreviewArea
extends LWComponent {
    private static final String _KEY_EXAMPLE_TEXT = "FONTPANE.EXAMPLE_TEXT";
    private static final int _OUTER_HINSETS = 8;
    private static final int _OUTER_VINSETS = 8;
    private static final int _INNER_HINSETS = 4;
    private static final int _INNER_VINSETS = 4;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private Color _fontColor;
    private Color _fontBorderColor;
    private Color _fontBackground;
    private int _hAlignment;
    private int _vAlignment;
    private int _fontStyle;
    private int _fontWidth;
    private int _fontBaselineStyle;
    private String _exampleText;
    private boolean _fontBorderVisible;
    private boolean _baselineVisible;
    private Font _currentFont;
    private FontPane _pane;
    private FontPaneListener _listener;
    private boolean _isFontStyleSet;

    public FontPreviewArea() {
        this.setBackground(Color.white);
        this.setBorder(UIBorderFactory.getRaisedBevelBorder());
        this._hAlignment = 0;
        this._vAlignment = 0;
        this._fontStyle = 0;
        this._fontBaselineStyle = 1;
    }

    public Font getCurrentFont() {
        if (this._currentFont == null) {
            this._currentFont = this.getFont();
        }
        return this._currentFont;
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            font = this.getFont();
        }
        if (font == null) {
            this._isFontStyleSet = false;
            this._fontStyle = 0;
            this._createCurrentFont(null);
            return;
        }
        if (this._currentFont != font) {
            boolean newItalic;
            int currentStyle = this.getFontStyle();
            boolean oldBold = (currentStyle & 1) != 0;
            boolean oldItalic = (currentStyle & 2) != 0;
            int style = font.getStyle();
            boolean newBold = (style & 1) != 0;
            boolean bl = newItalic = (style & 2) != 0;
            if (oldBold != newBold) {
                currentStyle = oldBold ? (currentStyle &= 0xFFFFFFFE) : (currentStyle |= 1);
            }
            if (oldItalic != newItalic) {
                currentStyle = oldItalic ? (currentStyle &= 0xFFFFFFFD) : (currentStyle |= 2);
            }
            this._fontStyle = currentStyle;
            this._createCurrentFont(font);
            this.repaint();
        }
    }

    public void setFontColor(Color color) {
        if (this._fontColor != color) {
            this._fontColor = color;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public Color getFontColor() {
        if (this._fontColor == null) {
            this._fontColor = this.getUIDefaults().getColor(LookAndFeel.TEXT_TEXT);
        }
        return this._fontColor;
    }

    public void setFontBackgroundColor(Color color) {
        if (this._fontBackground != color) {
            this._fontBackground = color;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public Color getFontBackgroundColor() {
        if (this._fontBackground == null) {
            this._fontBackground = this.getUIDefaults().getColor(LookAndFeel.TEXT);
        }
        return this._fontBackground;
    }

    public void setFontBorderColor(Color color) {
        if (this._fontBorderColor != color) {
            this._fontBorderColor = color;
            if (this.isFontBorderVisible()) {
                this.repaint();
            }
        }
    }

    public Color getFontBorderColor() {
        if (this._fontBorderColor == null) {
            this._fontBorderColor = this.getFontBackgroundColor();
        }
        return this._fontBorderColor;
    }

    public boolean isFontBorderVisible() {
        return this._fontBorderVisible;
    }

    public void setFontBorderVisible(boolean visible) {
        if (this._fontBorderVisible != visible) {
            this._fontBorderVisible = visible;
            this.repaint();
        }
    }

    public void setFontHorizontalAlignment(int horizontalAlignment) {
        if (this._hAlignment != horizontalAlignment) {
            this._hAlignment = horizontalAlignment;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public int getFontHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setFontVerticalAlignment(int verticalAlignment) {
        if (this._vAlignment != verticalAlignment) {
            this._vAlignment = verticalAlignment;
            this.repaint();
        }
    }

    public int getFontVerticalAlignment() {
        return this._vAlignment;
    }

    public void setFontStyle(int style) {
        this._isFontStyleSet = true;
        if (this._fontStyle != style) {
            this._fontStyle = style;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public void setFontWidth(int width) {
        if (this._fontWidth != width) {
            this._fontWidth = width;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public int getFontWidth() {
        return this._fontWidth;
    }

    public void setFontBaselineStyle(int style) {
        if (this._fontBaselineStyle != style) {
            this._fontBaselineStyle = style;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public int getFontBaselineStyle() {
        return this._fontBaselineStyle;
    }

    public boolean isBaselineVisible() {
        return this._baselineVisible;
    }

    public void setBaselineVisible(boolean visible) {
        if (this._baselineVisible != visible) {
            this._baselineVisible = visible;
            this.repaint();
        }
    }

    public void setPreviewText(String text) {
        if (this._exampleText != text) {
            this._exampleText = text;
            this.repaint();
        }
    }

    public String getPreviewText() {
        if (this._exampleText == null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
            this._exampleText = b.getString(_KEY_EXAMPLE_TEXT);
        }
        return this._exampleText;
    }

    public void setFontPane(FontPane pane) {
        if (this._pane != pane) {
            if (this._pane != null) {
                this._pane.removePropertyChangeListener(this._listener);
            }
            if (this._listener == null) {
                this._listener = new FontPaneListener();
            }
            this._pane = pane;
            if (this._pane != null) {
                this._pane.addPropertyChangeListener(this._listener);
            }
            this._init(pane);
        }
    }

    public FontPane getFontPane() {
        return this._pane;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._currentFont == null) {
            Font f = this.getFont();
            if (this._isFontStyleSet) {
                this._createCurrentFont(f);
            } else {
                this.setCurrentFont(f);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean l2r;
        Shape oldClip = g.getClip();
        int width = this.getWidth();
        int height = this.getHeight();
        PaintContext context = this.getPaintContext();
        boolean enabled = (context.getPaintState() & 1) == 0;
        ImmInsets insets = this.getBorderInsets();
        if (enabled) {
            g.setColor(this.getBackground());
        } else {
            g.setColor(context.getPaintUIDefaults().getColor("lightIntensity"));
        }
        g.fillRect(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.bottom + insets.top));
        insets = new ImmInsets(insets.top + 8, insets.left + 8, insets.bottom + 8, insets.right + 8);
        width -= insets.left + insets.right;
        height -= insets.top + insets.bottom;
        if (enabled) {
            g.setColor(this.getFontBackgroundColor());
        } else {
            g.setColor(context.getPaintUIDefaults().getColor("lightIntensity"));
        }
        g.fillRect(insets.left, insets.top, width, height);
        if (this.isFontBorderVisible() && enabled) {
            g.setColor(this.getFontBorderColor());
            g.drawRect(insets.left, insets.top, width - 1, height - 1);
            g.drawRect(insets.left + 1, insets.top + 1, width - 3, height - 3);
        }
        Font currentFont = this.getCurrentFont();
        g.setFont(currentFont);
        String text = this.getPreviewText();
        FontMetrics metrics = this.getFontMetrics(g.getFont());
        int stringWidth = metrics.stringWidth(text);
        int hAlign = this.getFontHorizontalAlignment();
        int x = 0;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        boolean bl = l2r = LocaleUtils.getReadingDirectionForLocale((Locale)locale) == 1;
        if (hAlign == 10) {
            hAlign = l2r ? 2 : 4;
        } else if (hAlign == 11) {
            hAlign = l2r ? 4 : 2;
        }
        switch (hAlign) {
            case 0: {
                x = (this.getWidth() - stringWidth) / 2;
                break;
            }
            case 4: {
                x = this.getWidth() - (insets.right + 4) - stringWidth;
                break;
            }
            default: {
                x = insets.left + 4;
            }
        }
        int y = 0;
        int yTop = metrics.getMaxAscent() + insets.top;
        int yBottom = this.getHeight() - (metrics.getMaxDescent() + insets.bottom);
        int yMiddle = (yTop + yBottom) / 2;
        int vAlign = this.getFontVerticalAlignment();
        switch (vAlign) {
            case 1: {
                y = Math.min(yTop, yMiddle);
                break;
            }
            case 3: {
                y = Math.max(yBottom, yMiddle);
                break;
            }
            default: {
                y = yMiddle;
            }
        }
        int baseLineStyle = this.getFontBaselineStyle();
        switch (baseLineStyle) {
            case 2: {
                y -= 3;
                break;
            }
            case 3: {
                y += 3;
            }
        }
        g.setColor(this.getFontColor());
        g.clipRect(insets.left, insets.top, width, height);
        if (g instanceof Graphics2D) {
            AttributedString as = new AttributedString(text, currentFont.getAttributes());
            GraphicUtils.drawString(g, as.getIterator(), x, y);
        } else {
            GraphicUtils.drawString(g, text, x, y);
        }
        switch (baseLineStyle) {
            case 2: {
                y += 3;
                break;
            }
            case 3: {
                y -= 3;
            }
        }
        if (this.isBaselineVisible()) {
            g.setColor(Color.gray);
            int left = insets.left + 1;
            int right = this.getWidth() - insets.right - 3;
            g.drawLine(left, y - 3, left, y + 3);
            g.drawLine(++left, y - 2, left, y + 2);
            g.drawLine(++left, y - 1, left, y + 1);
            g.drawLine(right, y - 3, right, y + 3);
            g.drawLine(--right, y - 2, right, y + 2);
            g.drawLine(--right, y - 1, right, y + 1);
            for (int i = left; i < right; i += 3) {
                g.drawLine(i, y, i + 1, y);
            }
        }
        if (oldClip != null) {
            g.setClip(oldClip);
        }
    }

    private void _init(FontPane pane) {
        if (pane == null) {
            return;
        }
        this.setFontColor(pane.getFontColor());
        this.setFontBackgroundColor(pane.getFontBackgroundColor());
        this.setFontHorizontalAlignment(pane.getFontHorizontalAlignment());
        this.setFontVerticalAlignment(pane.getFontVerticalAlignment());
        this.setFontBaselineStyle(pane.getFontBaselineStyle());
        this._updateBaselineVisibility();
        this.setFontBorderColor(pane.getBorderColor());
        this._updateBorderVisibility();
        this.setFontStyle(pane.getFontStyle());
        Font font = pane.getCurrentFont();
        this._setExampleFont(font);
    }

    private void _setExampleFont(Font font) {
        FontPane pane = this.getFontPane();
        if (font != null && !pane.isActualFontSizeUsed()) {
            font = new Font(font.getName(), font.getStyle(), 12);
        } else {
            int size = pane.getFontSize();
            if (size == -1) {
                size = 12;
            }
            font = new Font(pane.getFontName(), pane.getFontStyle(), size);
        }
        this.setCurrentFont(font);
    }

    private void _updateBaselineVisibility() {
        FontPane pane = this.getFontPane();
        int baseStyle = pane.getFontBaselineStyle();
        boolean superSelected = baseStyle == 2;
        boolean subSelected = baseStyle == 3;
        int styleMask = pane.getStyleButtonMask();
        boolean superVisible = (styleMask & 0x10) != 0;
        boolean subVisible = (styleMask & 0x20) != 0;
        this.setBaselineVisible(superVisible | subVisible | superSelected | subSelected);
    }

    private void _updateBorderVisibility() {
        int colorMask = this.getFontPane().getColorComponentMask();
        boolean border = (colorMask & 4) != 0;
        this.setFontBorderVisible(border);
    }

    private void _createCurrentFont(Font font) {
        Color bgColor;
        int baseLineStyle;
        if (font == null) {
            this._currentFont = null;
            return;
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>(11);
        map.put(TextAttribute.FAMILY, font.getFamily());
        map.put(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        int style = this.getFontStyle();
        if ((style & 4) != 0) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if ((style & 8) != 0) {
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if ((baseLineStyle = this.getFontBaselineStyle()) == 2) {
            map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        } else if (baseLineStyle == 3) {
            map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (this.getFontHorizontalAlignment() == 100) {
            map.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        if ((style & 1) != 0) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        int width = this.getFontWidth();
        switch (width) {
            case 0: {
                map.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                break;
            }
            case 4: {
                map.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 1: {
                map.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                break;
            }
            case 3: {
                map.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
            }
        }
        Color fgColor = this.getFontColor();
        if (fgColor != null) {
            map.put(TextAttribute.FOREGROUND, fgColor);
        }
        if ((bgColor = this.getFontBackgroundColor()) != null) {
            map.put(TextAttribute.BACKGROUND, bgColor);
        }
        this._currentFont = new Font(map);
    }

    private class FontPaneListener
    implements PropertyChangeListener {
        private FontPaneListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            FontPane pane = FontPreviewArea.this.getFontPane();
            if ("fontName".equals(name) || "fontSize".equals(name)) {
                FontPreviewArea.this._setExampleFont(pane.getCurrentFont());
            } else if ("fontStyle".equals(name)) {
                FontPreviewArea.this.setFontStyle(pane.getFontStyle());
            } else if ("fontBaselineStyle".equals(name)) {
                FontPreviewArea.this.setFontBaselineStyle(pane.getFontBaselineStyle());
            } else if ("fontHorizontalAlignment".equals(name)) {
                FontPreviewArea.this.setFontHorizontalAlignment(pane.getFontHorizontalAlignment());
            } else if ("fontVerticalAlignment".equals(name)) {
                FontPreviewArea.this.setFontVerticalAlignment(pane.getFontVerticalAlignment());
            } else if ("actualFontSizeUsed".equals(name)) {
                FontPreviewArea.this._setExampleFont(pane.getCurrentFont());
            } else if ("fontColor".equals(name)) {
                FontPreviewArea.this.setFontColor(pane.getFontColor());
            } else if ("fontBackgroundColor".equals(name)) {
                FontPreviewArea.this.setFontBackgroundColor(pane.getFontBackgroundColor());
            } else if ("borderColor".equals(name)) {
                FontPreviewArea.this.setFontBorderColor(pane.getBorderColor());
            } else if ("colorComponentMask".equals(name)) {
                FontPreviewArea.this._updateBorderVisibility();
            } else if ("styleButtonMask".equals(name)) {
                FontPreviewArea.this._updateBaselineVisibility();
            } else if ("fontWidth".equals(name)) {
                FontPreviewArea.this.setFontWidth(pane.getFontWidth());
            } else if ("alignmentButtonMask".equals(name)) {
                // empty if block
            }
        }
    }
}

