/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.perf;

import java.util.logging.Level;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.adf.share.perf.StateTracker;
import oracle.adfinternal.share.perf.NounUtil;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SegregationType;
import oracle.dms.instrument.State;

public class StateTrackerImpl
extends StateTracker {
    private String mUnit;
    private State mState = null;

    private StateTrackerImpl(Level level, String sensorFullName, String unit, State state) {
        super(level, sensorFullName);
        this.mUnit = unit;
        this.mState = state;
    }

    public static StateTracker createDMSStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc, SegregationType sgType) {
        if ("__LAZY_NOUN_TYPE__".equals(type) || type == null) {
            type = LoggingUtils.getNounType(groupName);
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuilder groupNameBuf = LoggingUtils.standardizeGroupName2(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("s");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor state = SensorTable.getSensor(fullName);
        if (state != null && state instanceof StateTracker) {
            return (StateTracker)state;
        }
        State st = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = NounUtil.registerGroupNameIfNeeded(groupName, sgType, type);
            st = State.create((Noun)parentNoun, (String)name, (byte)valueType, (String)unit, (String)desc);
            st.deriveMetric(511);
        }
        StateTracker tr = new StateTrackerImpl(level, fullName, unit, st);
        tr = (StateTracker)SensorTable.putSensor(fullName, tr);
        return tr;
    }

    @Override
    public void increment(double increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(increasedAmount));
        }
    }

    @Override
    public void increment(int increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(increasedAmount));
        }
    }

    @Override
    public void increment(long increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(increasedAmount));
        }
    }

    @Override
    public void update(double newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(newValue));
        }
    }

    @Override
    public void update(int newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(newValue));
        }
    }

    @Override
    public void update(long newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(newValue));
        }
    }

    @Override
    public void update(Object newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(newValue.toString());
        }
    }

    private void log(String value) {
        if (this.mUnit != null && this.mUnit.length() != 0) {
            value = (String)value + this.mUnit;
        }
        this.log(System.currentTimeMillis(), (String)value, null);
    }

    @Override
    public void reset() {
        if (this.mState != null) {
            this.mState.reset();
        }
    }

    @Override
    public void destroy() {
        if (this.mState != null) {
            this.mState.destroy();
        }
    }

    @Override
    protected Object getClonedValue() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return null;
        }
        return this.mState.getClonedValue();
    }
}

