/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.jndi;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.LoaderUtil;
import oracle.adf.share.common.util.ADFJarUtil;
import oracle.adf.share.services.DefaultDescriptorContext;
import oracle.adf.share.services.DefaultDescriptorFilter;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.DescriptorFilter;
import oracle.adf.share.services.ResourceService;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.ServiceRef;
import oracle.adf.share.services.ServicesFactory;
import oracle.adf.share.services.URLDescriptor;
import oracle.adf.share.services.jndi.ClassLoaderHelper;
import oracle.adf.share.services.jndi.DescriptorNameParser;
import oracle.javatools.annotations.Concealed;

@Concealed
class DescriptorJndiContext
implements Context {
    private static final NameParser nameParser = new DescriptorNameParser();
    private static final String CLASS_NAME = DescriptorJndiContext.class.getName();
    @CodeSharingSafe(value="MutableStaticField")
    private static boolean dontTryDTAgain = false;
    private ClassLoaderHelper classLoaderHelper = this.initClassLoaderHelper();
    private Map env;
    private URL providerURL;
    private String namespaceName;
    private volatile transient boolean inited = false;
    private transient Collection<URL> loaderURLs;
    private transient LinkedHashMap<String, Binding> childCache;
    private static final Logger logger = Logger.getLogger(DescriptorJndiContext.class.getName());
    private static final String CODE_SOURCE = "code-source";
    private static final int CODE_SOURCE_LEN = "code-source".length();
    private static final String JAR = "jar";
    private static final String ZIP = "zip";
    private static final String JAR_FILE = "jar:file";
    private static final String FILE = "file";
    private static final String DT_CLASS_NAME = "oracle.adfdtinternal.library.services.ProjectUtils";
    private static final int SIGNATURE_SUB_LEN = ServicesFactory.getServiceFileName("oracle.adf.common.services.ResourceService").length();

    public DescriptorJndiContext() {
        this(new Hashtable());
    }

    public DescriptorJndiContext(Hashtable envIn) {
        this.env = new ConcurrentHashMap(envIn);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        this.init();
        this.populateChildCache();
        Binding cco = this.childCache.get(name.get(0));
        if (cco == null) {
            throw new NameNotFoundException(name.toString());
        }
        Binding b = cco;
        Object bo = b.getObject();
        if (name.size() == 1) {
            return bo;
        }
        if (bo instanceof Context) {
            return ((Context)bo).lookup(name.getSuffix(1));
        }
        throw new NameNotFoundException(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.internalList(name, false);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.internalList(name, true);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        this.init();
        return new Hashtable(this.env);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        this.init();
        return this.namespaceName;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    private NamingEnumeration internalList(Name name, boolean binding) throws NamingException {
        this.init();
        this.populateChildCache();
        String thisName = "";
        if (name.size() > 1) {
            Object o;
            Binding b = this.childCache.get(name.get(0));
            Object object = o = b != null ? b.getObject() : null;
            if (!(o instanceof Context)) {
                throw new NameNotFoundException(name.toString());
            }
            NamingEnumeration<NameClassPair> ret = binding ? ((Context)o).listBindings(name.getSuffix(1)) : ((Context)o).list(name.getSuffix(1));
            return ret;
        }
        if (name.size() == 1) {
            thisName = name.get(0);
            Binding b = this.childCache.get(thisName);
            if (b == null) {
                throw new NameNotFoundException(thisName);
            }
            Object o = b.getObject();
            if (o instanceof Context) {
                NamingEnumeration<NameClassPair> ret = binding ? ((Context)o).listBindings(name.getSuffix(1)) : ((Context)o).list(name.getSuffix(1));
                return ret;
            }
        }
        return new MyEnum(this, thisName);
    }

    protected synchronized void init() throws NamingException {
        DescriptorFilter df;
        if (this.inited) {
            return;
        }
        this.inited = true;
        boolean newDescrContext = false;
        this.providerURL = this.cleanupURL(this.env.get("java.naming.provider.url"));
        if (this.providerURL != null) {
            this.env.put("java.naming.provider.url", this.providerURL);
        }
        if (this.classLoaderHelper != null) {
            this.classLoaderHelper.initDesignEnvironment(this.env, this);
        }
        ServicePlugin envPlugin = (ServicePlugin)this.env.get("oracle.adf.share.services.servicePlugin");
        ClassLoader cl = (ClassLoader)this.env.get("oracle.adf.share.services.providerLoader");
        if (cl == null) {
            if (this.providerURL != null) {
                cl = LoaderUtil.getLoader(new URL[]{this.providerURL}, null);
                if (envPlugin == null) {
                    newDescrContext = true;
                    this.namespaceName = this.getJarName(this.providerURL);
                } else {
                    this.namespaceName = this.getJarName(this.providerURL) + "|" + envPlugin.getServiceType();
                }
            } else {
                ClassLoader clTmp;
                this.namespaceName = "";
                cl = this.classLoaderHelper != null ? ((clTmp = this.classLoaderHelper.getRunClassLoader(this.env, this)) != null ? clTmp : ClassUtils.getClassLoader(this.getClass())) : ClassUtils.getClassLoader(this.getClass());
                Boolean adflibsOnly = (Boolean)this.env.get("oracle.adf.share.services.adflibsOnly");
                if (adflibsOnly == null || adflibsOnly.booleanValue()) {
                    this.setLoaderURLs(cl);
                    cl = LoaderUtil.getLoader(this.loaderURLs.toArray(new URL[0]), null);
                }
            }
            newDescrContext = true;
            this.env.put("oracle.adf.share.services.providerLoader", cl);
        } else {
            this.setLoaderURLs(cl);
            if (this.providerURL != null) {
                if (envPlugin == null) {
                    newDescrContext = true;
                    this.namespaceName = this.getJarName(this.providerURL);
                } else {
                    this.namespaceName = this.getJarName(this.providerURL) + "|" + envPlugin.getServiceType();
                }
            } else {
                this.namespaceName = "";
            }
        }
        DescriptorContext dc = (DescriptorContext)this.env.get("oracle.adf.share.services.DescriptorContext");
        if (dc == null || newDescrContext) {
            dc = new DefaultDescriptorContext(this);
            this.env.put("oracle.adf.share.services.DescriptorContext", dc);
        }
        if ((df = (DescriptorFilter)this.env.get("oracle.adf.share.services.DescriptorFilter")) == null) {
            this.env.put("oracle.adf.share.services.DescriptorFilter", new DefaultDescriptorFilter());
        }
    }

    protected void populateChildCache() throws NamingException {
        String parentPrefix;
        if (this.childCache != null) {
            return;
        }
        String string = parentPrefix = this.namespaceName.length() == 0 ? "" : this.namespaceName + "|";
        if (this.providerURL != null) {
            this.childCache = new LinkedHashMap();
            ServicePlugin envPlugin = (ServicePlugin)this.env.get("oracle.adf.share.services.servicePlugin");
            try {
                if (envPlugin != null) {
                    DescriptorContext dc = (DescriptorContext)this.env.get("oracle.adf.share.services.DescriptorContext");
                    Collection<URLDescriptor> descrs = envPlugin.getTokenizedResources(dc);
                    if (descrs == null) {
                        descrs = envPlugin.getServiceStrategy(dc).getResources(dc);
                    }
                    for (URLDescriptor descr : descrs) {
                        String childName = descr.getName();
                        Binding b = new Binding(childName, descr.getClass().getName(), descr);
                        b.setNameInNamespace(parentPrefix + childName);
                        this.childCache.put(childName, b);
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                if (e.getCause() instanceof NamingException) {
                    throw (NamingException)e.getCause();
                }
                NamingException ne = new NamingException(parentPrefix);
                ne.initCause(e);
                throw ne;
            }
            ClassLoader childLoader = null;
            try {
                ResourceService svc = new ResourceService();
                childLoader = LoaderUtil.getLoader(new URL[]{this.providerURL}, null);
                String serviceType = (String)this.env.get("oracle.adf.share.services.serviceType");
                if (serviceType == null || serviceType.length() == 0) {
                    serviceType = "*";
                }
                for (ServicePlugin plugin : svc.getPluginsForType(childLoader, serviceType)) {
                    Hashtable<?, ?> childEnv = this.getEnvironment();
                    childEnv.put("oracle.adf.share.services.servicePlugin", plugin);
                    String childName = plugin.getServiceType();
                    Binding b = new Binding(childName, CLASS_NAME, new DescriptorJndiContext(childEnv));
                    b.setNameInNamespace(parentPrefix + childName);
                    this.childCache.put(childName, b);
                }
            }
            catch (IOException e) {
                NamingException ne = new NamingException(parentPrefix);
                ne.initCause(e);
                throw ne;
            }
            finally {
                if (childLoader instanceof Closeable) {
                    try {
                        ((Closeable)((Object)childLoader)).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        this.childCache = new LinkedHashMap(this.loaderURLs.size() + 1);
        for (URL url : this.loaderURLs) {
            Hashtable<?, ?> childEnv = this.getEnvironment();
            childEnv.remove("oracle.adf.share.services.providerLoader");
            childEnv.put("java.naming.provider.url", url);
            String childName = this.getJarName(url);
            Binding b = new Binding(childName, CLASS_NAME, new DescriptorJndiContext(childEnv));
            b.setNameInNamespace(parentPrefix + childName);
            this.childCache.put(childName, b);
        }
    }

    private String getJarName(URL url) {
        String path = url.getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        } else if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int x = path.lastIndexOf(47);
        return x == -1 ? path : path.substring(x + 1);
    }

    private URL cleanupURL(Object providerURLObj) throws NamingException {
        URL provider;
        if (providerURLObj == null) {
            return null;
        }
        if (providerURLObj instanceof URL && (provider = (URL)providerURLObj).getPath().lastIndexOf("!/") != -1) {
            String proto = provider.getProtocol();
            if (ADFJarUtil.isJarProtocol(provider) || ZIP.equals(proto)) {
                return provider;
            }
        }
        Object urlStr = providerURLObj.toString();
        try {
            int x = ((String)urlStr).lastIndexOf(33);
            if (x == -1 && (x = ((String)urlStr).lastIndexOf(47)) != -1) {
                String lastPart = ((String)urlStr).substring(x + 1);
                if ((x = lastPart.lastIndexOf(46)) == -1) {
                    return null;
                }
                String ext = lastPart.substring(x + 1);
                if (ext.equalsIgnoreCase(JAR) || ext.equalsIgnoreCase(ZIP)) {
                    x = ((String)urlStr).indexOf(58);
                    if (x != -1) {
                        urlStr = ((String)urlStr).substring(0, x).equalsIgnoreCase(CODE_SOURCE) ? JAR_FILE + ((String)urlStr).substring(x) + "!/" : "jar:" + (String)urlStr + "!/";
                    }
                } else {
                    x = ((String)urlStr).indexOf(58);
                    if (x != -1 && ((String)urlStr).substring(0, x).equalsIgnoreCase(CODE_SOURCE)) {
                        urlStr = FILE + ((String)urlStr).substring(x);
                    }
                }
            }
            return new URL((String)urlStr);
        }
        catch (MalformedURLException mue) {
            NamingException ne = new NamingException();
            ne.initCause(mue);
            throw ne;
        }
    }

    private ClassLoaderHelper initClassLoaderHelper() {
        if (dontTryDTAgain) {
            return null;
        }
        try {
            return (ClassLoaderHelper)ClassUtils.forName(DT_CLASS_NAME, this.getClass()).newInstance();
        }
        catch (Exception e) {
            dontTryDTAgain = true;
            if (!(e instanceof ClassNotFoundException)) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, DT_CLASS_NAME, e);
            }
            return null;
        }
    }

    private void setLoaderURLs(ClassLoader lookup) {
        try {
            List<ServiceRef> refs = ServicesFactory.findServiceRefs("oracle.adf.common.services.ResourceService", lookup);
            if (refs.size() == 0) {
                this.getLogger().fine("No ADF libraries in: " + lookup.toString());
                this.loaderURLs = Collections.emptyList();
                return;
            }
            URL[] urls = new URL[refs.size()];
            int i = 0;
            for (ServiceRef ref : refs) {
                String refStr = ref.getServiceURL().toString();
                URL url = new URL(refStr = refStr.substring(0, refStr.length() - SIGNATURE_SUB_LEN));
                if (CODE_SOURCE.equalsIgnoreCase(url.getProtocol())) {
                    String fileStr = url.toString().substring(CODE_SOURCE_LEN);
                    url = fileStr.lastIndexOf(33) != -1 ? new URL(JAR_FILE + fileStr) : new URL(FILE + fileStr);
                }
                this.getLogger().fine("Loader adding: " + url);
                urls[i++] = url;
            }
            this.loaderURLs = new ArrayList<URL>(Arrays.asList(urls));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Logger getLogger() {
        return logger;
    }

    private static class MyEnum
    implements NamingEnumeration<Binding> {
        private Iterator<Binding> iter;

        public MyEnum(DescriptorJndiContext ctx, String name) throws NamingException {
            ArrayList<Binding> ncp;
            ctx.populateChildCache();
            if (name.length() == 0) {
                ncp = new ArrayList(ctx.childCache.size() + 1);
                ncp.addAll(ctx.childCache.values());
            } else {
                ncp = new ArrayList<Binding>(1);
                Binding test = ctx.childCache.get(name);
                ncp.add(test);
            }
            this.iter = ncp.iterator();
        }

        @Override
        public Binding next() throws NamingException {
            return this.iter.next();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.iter.hasNext();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Binding nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

