/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.lifecycle;

import java.util.concurrent.atomic.AtomicInteger;

public class LifecycleContext {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final ClassLoader classLoader;
    private final String appId;
    private final EventType eventType;
    private final int eventSequence;
    private final Object addlEnvInfo;
    private final boolean undeploying;

    public LifecycleContext(ClassLoader classLoader, String appId, EventType eventType, Object addlEnvInfo, boolean undeploying) {
        this.classLoader = classLoader;
        this.appId = appId;
        this.eventType = eventType;
        this.eventSequence = counter.getAndIncrement();
        this.addlEnvInfo = addlEnvInfo;
        this.undeploying = undeploying;
    }

    public boolean isUndeploying() {
        return this.undeploying;
    }

    public Object getAddlEnvInfo() {
        return this.addlEnvInfo;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public int getEventSequence() {
        return this.eventSequence;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getAppId() {
        return this.appId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName() + "[ ");
        buf.append("EventType=" + this.eventType);
        buf.append(", eventSequence=" + this.eventSequence);
        buf.append(", AppId=" + this.appId);
        buf.append(", ClassLoader=" + this.classLoader);
        buf.append(", addlEnvInfo=" + this.addlEnvInfo);
        buf.append(", undeploying=" + this.undeploying);
        buf.append(" ]");
        return buf.toString();
    }

    public static enum EventType {
        PRE_START,
        STARTED,
        PRE_STOP,
        STOPPED,
        UNDEPLOYED;

    }
}

