/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class CopyInSD_RelatedObjectsWrapper
extends PropertyWrapper {
    private static final Logger LOGGER = new Logger(CopyInSD_RelatedObjectsWrapper.class);
    Map map = null;
    List properties = new ArrayList();
    List collections = new ArrayList();
    List additionalProperties = new ArrayList();
    String objectsGetter;
    StorageObject stob;
    String ownerSetter;
    Class setterParam;
    NameSpaceController nameSpace;
    boolean uniqueNames = false;

    public CopyInSD_RelatedObjectsWrapper(String name, Object obj, String getter, String setter, Class parameter, String objectsGetter, String ownerSetter, Class setterParam) {
        super(name, obj, getter, setter, parameter);
        this.objectsGetter = objectsGetter;
        if (obj instanceof StorageObject) {
            this.stob = (StorageObject)obj;
            this.ownerSetter = ownerSetter;
            this.setterParam = setterParam;
        }
    }

    public CopyInSD_RelatedObjectsWrapper(String name, Object obj, String objectsGetter, String ownerSetter, Class setterParam) {
        this(name, obj, null, null, null, objectsGetter, ownerSetter, setterParam);
    }

    public static void main(String[] args) {
    }

    @Override
    public Object getValue() {
        try {
            if (this.stob != null) {
                Method method = this.stob.getClass().getMethod(this.objectsGetter, new Class[0]);
                Object res = method.invoke((Object)this.stob, new Object[0]);
                Object result = "";
                if (res instanceof StorageObject) {
                    result = res.toString();
                } else if (res instanceof Collection) {
                    Iterator it = ((Collection)res).iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        Object ob = it.next();
                        if (!(ob instanceof StorageObject)) continue;
                        StorageObject sto = (StorageObject)ob;
                        if (first) {
                            result = sto.getName();
                            first = false;
                            continue;
                        }
                        result = (String)result + "; " + sto.getName();
                    }
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object toObj) {
        block32: {
            try {
                if (this.stob != null) {
                    StorageDesign sd = this.stob.getStorageDesign();
                    Method method = this.stob.getClass().getMethod(this.objectsGetter, new Class[0]);
                    Object res = null;
                    Object toColl = null;
                    try {
                        res = method.invoke((Object)this.stob, new Object[0]);
                        toColl = method.invoke(toObj, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOGGER.warn(e.getMessage(), e);
                    }
                    if (res != null && res instanceof Collection) {
                        for (Object ob : (Collection)res) {
                            StorageObject sto;
                            Method setter;
                            if (!(ob instanceof StorageObject) || (setter = (sto = (StorageObject)ob).getClass().getMethod(this.ownerSetter, this.setterParam)) == null) continue;
                            StorageObjectSet set = sd.getStorageObjectSetForType(sto.getObjectTypeName());
                            StorageObject nsto = null;
                            if (toColl != null && toColl instanceof Collection) {
                                nsto = this.getExistingByGeneratorID((Collection)toColl, sto.getObjectID());
                            }
                            if (set == null && nsto == null) continue;
                            if (this.uniqueNames && this.nameSpace == null) {
                                this.nameSpace = new NameSpaceController();
                                this.nameSpace.addElementSet(set);
                            }
                            boolean newObject = false;
                            if (set != null && nsto == null) {
                                nsto = (StorageObject)set.createElement(null);
                                newObject = true;
                            }
                            if (nsto == null) continue;
                            boolean loading = sd.isLoading();
                            try {
                                String oldName = nsto.getName();
                                MDTransformer.includeID = false;
                                sd.setLoading(true);
                                Map map = this.stob.getAppView().getXMLTransformationManager().transformFromObjectToMap(sto, null, null);
                                if (map != null) {
                                    this.stob.getAppView().getXMLTransformationManager().transformFromMapToObject(nsto, map);
                                    nsto.setObjectID(new GUID().toString());
                                    for (AdditionalProperty ap : this.additionalProperties) {
                                        Method addSetterM = null;
                                        Method addGetterM = null;
                                        try {
                                            addSetterM = sto.getClass().getMethod(ap.addSetter, ap.addSetterParam);
                                            addGetterM = sto.getClass().getMethod(ap.addGetter, new Class[0]);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            LOGGER.warn(e.getMessage(), e);
                                        }
                                        if (addSetterM == null || addGetterM == null) continue;
                                        Object prop = addGetterM.invoke((Object)sto, new Object[0]);
                                        addSetterM.invoke((Object)nsto, prop);
                                    }
                                    setter.invoke((Object)nsto, toObj);
                                    if (this.uniqueNames) {
                                        Owner owner;
                                        if (newObject) {
                                            oldName = nsto.getName();
                                        }
                                        String schema = null;
                                        if (nsto instanceof OwnedObjectOracle) {
                                            UserOracle user = ((OwnedObjectOracle)((Object)nsto)).getUser();
                                            if (user != null) {
                                                schema = user.getName();
                                            }
                                        } else if (nsto instanceof OwnedObject && (owner = ((OwnedObject)((Object)nsto)).getOwner()) != null) {
                                            schema = owner.getName();
                                        }
                                        String newName = this.nameSpace.getValidName(nsto, schema, oldName);
                                        if (!nsto.getName().equals(newName)) {
                                            nsto.setName(newName);
                                        }
                                    }
                                    nsto.setGeneratorID(sto.getObjectID());
                                    continue;
                                }
                                nsto.remove();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                LOGGER.warn(e.getMessage(), e);
                                nsto.remove();
                            }
                            finally {
                                MDTransformer.includeID = true;
                                sd.setLoading(loading);
                            }
                        }
                    }
                }
                if (this.map == null) {
                    this.init();
                }
                if (this.map == null) break block32;
                try {
                    MDTransformer.includeID = false;
                    ApplicationView.getInstance().getXMLTransformationManager().transformFromMapToObject(toObj, this.map, this.properties, this.collections);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.warn(e.getMessage(), e);
                }
                finally {
                    MDTransformer.includeID = true;
                }
            }
            catch (Exception e1) {
                LOGGER.warn(e1.getMessage(), e1);
            }
        }
    }

    private StorageObject getExistingByName(Collection col, String name) {
        for (Object obj : col) {
            StorageObject sto;
            if (!(obj instanceof StorageObject) || !name.equalsIgnoreCase((sto = (StorageObject)obj).getName())) continue;
            return sto;
        }
        return null;
    }

    private StorageObject getExistingByGeneratorID(Collection col, String id) {
        for (Object obj : col) {
            StorageObject sto;
            if (!(obj instanceof StorageObject) || !id.equalsIgnoreCase((sto = (StorageObject)obj).getGeneratorID())) continue;
            return sto;
        }
        return null;
    }

    public void addPropertyName(String name) {
        this.properties.add(name);
    }

    public void addCollectionName(String name) {
        this.collections.add(name);
    }

    public void addAdditionalProperty(String getter, String setter, Class param) {
        this.additionalProperties.add(new AdditionalProperty(getter, setter, param));
    }

    @Override
    public void init() {
        super.init();
        this.nameSpace = null;
    }

    public void setUniqueNames(boolean uniqueNames) {
        this.uniqueNames = uniqueNames;
    }

    class AdditionalProperty {
        String addGetter;
        String addSetter;
        Class addSetterParam;

        AdditionalProperty(String getter, String setter, Class setterParam) {
            this.addGetter = getter;
            this.addSetter = setter;
            this.addSetterParam = setterParam;
        }
    }
}

