/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import oracle.dbtools.crest.util.gui.swing.JCloseTabbedPane;
import oracle.dbtools.crest.util.logging.Logger;

public class CloseTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Logger LOGGER = new Logger(CloseTabbedPaneUI.class);
    private ContainerListener containerListener;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    protected ScrollableTabSupport tabScroller;
    private int tabCount;
    protected MyMouseMotionListener motionListener;
    private static final int INACTIVE = 0;
    private static final int OVER = 1;
    private static final int PRESSED = 2;
    protected static final int BUTTONSIZE = 14;
    protected static final int WIDTHDELTA = 5;
    private BufferedImage closeImgI = new BufferedImage(14, 14, 6);
    private BufferedImage closeImgOver = new BufferedImage(14, 14, 6);
    private BufferedImage closeImgPress = new BufferedImage(14, 14, 6);
    private int overTabIndex = -1;
    private int closeIndexStatus = 0;
    private boolean mousePressed = false;
    private boolean isCloseButtonEnabled = true;

    public CloseTabbedPaneUI() {
        ImageIcon icon = new ImageIcon(CloseTabbedPaneUI.class.getResource("/oracle/javatools/images/lookandfeel/CloseTab.png"));
        ImageIcon iconOver = new ImageIcon(CloseTabbedPaneUI.class.getResource("/oracle/javatools/images/lookandfeel/CloseTabOver.png"));
        ImageIcon iconPress = new ImageIcon(CloseTabbedPaneUI.class.getResource("/oracle/javatools/images/lookandfeel/CloseTabPress.png"));
        icon.paintIcon(null, this.closeImgI.createGraphics(), 0, 0);
        iconOver.paintIcon(null, this.closeImgOver.createGraphics(), 0, 0);
        iconPress.paintIcon(null, this.closeImgPress.createGraphics(), 0, 0);
    }

    public boolean isCloseEnabled() {
        return this.isCloseButtonEnabled;
    }

    public void setCloseIcon(boolean b) {
        this.isCloseButtonEnabled = b;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int delta = 2;
        if (!this.isCloseEnabled()) {
            delta += 6;
        } else if (this.isCloseEnabled()) {
            delta += 19;
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + delta;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) + 5;
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 2, 0, 0, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        iconRect.x = tabRect.x + 8;
        textRect.x = iconRect.x + iconRect.width + this.textIconGap;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    protected ScrollableTabButton createScrollableTabButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    protected Rectangle newCloseRect(Rectangle rect) {
        int dx = rect.x + rect.width;
        int dy = (rect.y + rect.height) / 2 - 6;
        return new Rectangle(dx - 14 - 5, dy, 14, 14);
    }

    protected void updateOverTab(int x, int y) {
        this.overTabIndex = this.getTabAtLocation(x, y);
        if (this.overTabIndex != this.overTabIndex) {
            this.tabScroller.tabPanel.repaint();
        }
    }

    protected void updateCloseIcon(int x, int y) {
        if (this.overTabIndex != -1) {
            int newCloseIndexStatus = 0;
            Rectangle closeRect = this.newCloseRect(this.rects[this.overTabIndex]);
            if (closeRect.contains(x, y)) {
                int n = newCloseIndexStatus = this.mousePressed ? 2 : 1;
            }
            if ((this.closeIndexStatus = newCloseIndexStatus) != this.closeIndexStatus) {
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private void setTabIcons(int x, int y) {
        if (!this.mousePressed) {
            this.updateOverTab(x, y);
        }
        if (this.isCloseButtonEnabled) {
            this.updateCloseIcon(x, y);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new CloseTabbedPaneUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new TabbedPaneScrollLayout();
    }

    @Override
    protected void installComponents() {
        if (this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    @Override
    protected void uninstallComponents() {
        this.tabPane.remove(this.tabScroller.viewport);
        this.tabPane.remove(this.tabScroller.scrollForwardButton);
        this.tabPane.remove(this.tabScroller.scrollBackwardButton);
        this.tabScroller = null;
    }

    @Override
    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if ((this.motionListener = new MyMouseMotionListener()) != null) {
            this.tabScroller.tabPanel.addMouseMotionListener(this.motionListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.motionListener != null) {
            this.tabScroller.tabPanel.removeMouseMotionListener(this.motionListener);
            this.motionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    @Override
    protected void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getMyInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.createMyActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
        this.tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
        this.tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return map;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        boolean isOver = this.overTabIndex == tabIndex;
        Graphics2D g2 = null;
        Shape save = null;
        boolean cropShape = false;
        int cropx = 0;
        int cropy = 0;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            int cropline = viewRect.x + viewRect.width;
            if (tabRect.x < cropline && tabRect.x + tabRect.width > cropline) {
                cropx = cropline - 1;
                cropy = tabRect.y;
                cropShape = true;
            }
            if (cropShape) {
                save = g2.getClip();
                g2.clipRect(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            }
        }
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
        if (cropShape) {
            this.paintCroppedTabEdge(g, tabPlacement, tabIndex, isSelected, cropx, cropy);
            g2.setClip(save);
        } else if (isOver || isSelected) {
            int dx = tabRect.x + tabRect.width - 14 - 5;
            int dy = (tabRect.y + tabRect.height) / 2 - 6;
            if (this.isCloseButtonEnabled) {
                this.paintCloseIcon(g2, dx, dy, isOver);
            }
        }
    }

    protected void paintCloseIcon(Graphics g, int dx, int dy, boolean isOver) {
        if (isOver) {
            switch (this.closeIndexStatus) {
                case 1: {
                    g.drawImage(this.closeImgOver, dx, dy + 2, null);
                    break;
                }
                case 2: {
                    g.drawImage(this.closeImgPress, dx, dy + 2, null);
                    break;
                }
                default: {
                    g.drawImage(this.closeImgI, dx, dy + 2, null);
                    break;
                }
            }
        } else {
            g.drawImage(this.closeImgI, dx, dy + 2, null);
        }
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + this.rects[tabIndex].height);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        try {
            dest.width = this.rects[tabIndex].width;
            dest.height = this.rects[tabIndex].height;
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dest;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    private int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    boolean requestMyFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(CloseTabbedPaneUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (CloseTabbedPaneUI.this.closeIndexStatus == 1) {
                CloseTabbedPaneUI.this.closeIndexStatus = 2;
                CloseTabbedPaneUI.this.tabScroller.tabPanel.repaint();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CloseTabbedPaneUI.this.updateOverTab(e.getX(), e.getY());
            if (CloseTabbedPaneUI.this.overTabIndex == -1) {
                return;
            }
            if (CloseTabbedPaneUI.this.isCloseEnabled() && SwingUtilities.isRightMouseButton(e)) {
                super.mousePressed(e);
                CloseTabbedPaneUI.this.closeIndexStatus = 0;
                ((JCloseTabbedPane)CloseTabbedPaneUI.this.tabPane).fireRightPopupTabEvent(e);
                return;
            }
            if (CloseTabbedPaneUI.this.closeIndexStatus == 2) {
                CloseTabbedPaneUI.this.closeIndexStatus = 1;
                CloseTabbedPaneUI.this.tabPane.setSelectedIndex(CloseTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY()));
                CloseTabbedPaneUI.this.tabScroller.tabPanel.repaint();
                ((JCloseTabbedPane)CloseTabbedPaneUI.this.tabPane).fireCloseTabEvent(e, CloseTabbedPaneUI.this.overTabIndex);
                return;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!CloseTabbedPaneUI.this.mousePressed) {
                CloseTabbedPaneUI.this.overTabIndex = -1;
                CloseTabbedPaneUI.this.tabScroller.tabPanel.repaint();
            }
        }
    }

    protected class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = CloseTabbedPaneUI.this.createScrollableTabButton(3);
            this.scrollBackwardButton = CloseTabbedPaneUI.this.createScrollableTabButton(7);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[this.leadingTabIndex].x;
            if (viewSize.width - this.tabViewPosition.x < viewRect.width) {
                Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                this.viewport.setExtentSize(extentSize);
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            int tabPlacement = CloseTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = CloseTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            this.leadingTabIndex = CloseTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount && ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[this.leadingTabIndex].x < viewRect.x) {
                ++this.leadingTabIndex;
            }
            Insets contentInsets = CloseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            CloseTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
            this.scrollBackwardButton.setEnabled(viewRect.x > 0);
            this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\nviewport.viewRectangle=" + this.viewport.getViewRect() + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + this.tabViewPosition);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                CloseTabbedPaneUI.this.paintTabArea(g, CloseTabbedPaneUI.this.tabPane.getTabPlacement(), CloseTabbedPaneUI.this.tabPane.getSelectedIndex());
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
            super(CloseTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return CloseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return CloseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = CloseTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = CloseTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = CloseTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = CloseTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = CloseTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    CloseTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = CloseTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    CloseTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = CloseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = CloseTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = CloseTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int tw = bounds.width - insets.left - insets.right;
                    int th = CloseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, CloseTabbedPaneUI.this.runCount, CloseTabbedPaneUI.this.maxTabHeight);
                    int tx = insets.left;
                    int ty = insets.top;
                    int cx = tx + contentInsets.left;
                    int cy = ty + th + contentInsets.top;
                    int cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    int ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = CloseTabbedPaneUI.this.tabPane.getComponent(i);
                        if (child instanceof ScrollableTabViewport) {
                            JViewport viewport = (JViewport)child;
                            Rectangle viewRect = viewport.getViewRect();
                            int vw = tw;
                            int vh = th;
                            int totalTabWidth = ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[tabCount - 1].x + ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw && totalTabWidth - viewRect.x <= (vw = Math.max(tw - 61, 61))) {
                                vw = totalTabWidth - viewRect.x;
                            }
                            child.setBounds(tx, ty, vw, vh);
                            continue;
                        }
                        if (child instanceof ScrollableTabButton) {
                            ScrollableTabButton scrollbutton = (ScrollableTabButton)child;
                            Dimension bsize = new Dimension(30, 23);
                            int bx = 0;
                            int by = 0;
                            int bw = bsize.width;
                            int bh = bsize.height;
                            boolean visible = false;
                            int totalTabWidth = ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[tabCount - 1].x + ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw) {
                                int dir = scrollbutton.scrollsForward() ? 3 : 7;
                                scrollbutton.setDirection(dir);
                                visible = true;
                                bx = dir == 3 ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                            child.setVisible(visible);
                            if (!visible) continue;
                            child.setBounds(bx, by, bw, bh);
                            continue;
                        }
                        child.setBounds(cx, cy, cw, ch);
                    }
                    if (shouldChangeFocus && !CloseTabbedPaneUI.this.requestMyFocusForVisibleComponent()) {
                        CloseTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            try {
                FontMetrics metrics = CloseTabbedPaneUI.this.getFontMetrics();
                Insets tabAreaInsets = CloseTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
                int x = tabAreaInsets.left - 2;
                int y = tabAreaInsets.top;
                int totalWidth = 0;
                int totalHeight = 0;
                CloseTabbedPaneUI.this.maxTabHeight = CloseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                CloseTabbedPaneUI.this.runCount = 0;
                CloseTabbedPaneUI.this.selectedRun = -1;
                if (tabCount == 0) {
                    return;
                }
                CloseTabbedPaneUI.this.selectedRun = 0;
                CloseTabbedPaneUI.this.runCount = 1;
                for (int i = 0; i < tabCount; ++i) {
                    Rectangle rect = CloseTabbedPaneUI.this.rects[i];
                    if (i > 0) {
                        rect.x = ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[i - 1].x + ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).rects[i - 1].width - 1;
                    } else {
                        ((CloseTabbedPaneUI)CloseTabbedPaneUI.this).tabRuns[0] = 0;
                        CloseTabbedPaneUI.this.maxTabWidth = 0;
                        totalHeight += CloseTabbedPaneUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = CloseTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    rect.y = y;
                    rect.height = CloseTabbedPaneUI.this.maxTabHeight;
                }
                CloseTabbedPaneUI.this.tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (CloseTabbedPaneUI.this.htmlViews == null) {
                    CloseTabbedPaneUI.this.htmlViews = CloseTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    CloseTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (CloseTabbedPaneUI.this.htmlViews != null) {
                CloseTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (CloseTabbedPaneUI.this.htmlViews != null && CloseTabbedPaneUI.this.htmlViews.size() >= index) {
                    CloseTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
            }
        }
    }

    class MyMouseMotionListener
    implements MouseMotionListener {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            CloseTabbedPaneUI.this.mousePressed = false;
            CloseTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            CloseTabbedPaneUI.this.mousePressed = true;
            CloseTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            int index;
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            if (tabPane.getTabLayoutPolicy() == 1 && (index = tabPane.getSelectedIndex()) < CloseTabbedPaneUI.this.rects.length && index != -1) {
                CloseTabbedPaneUI.this.tabScroller.tabPanel.scrollRectToVisible(CloseTabbedPaneUI.this.rects[index]);
            }
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.requestMyFocusForVisibleComponent();
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof CloseTabbedPaneUI) {
                CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollForward(pane.getTabPlacement());
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            CloseTabbedPaneUI ui = (CloseTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollBackward(pane.getTabPlacement());
        }
    }
}

