/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.AbstractExporter;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFilter;

public class ImageExporter
extends AbstractExporter {
    private static final Logger LOGGER = new Logger(ImageExporter.class);

    public ImageExporter(ApplicationView appView) {
        super(appView);
        this.getFilterList().add(new PNGFileFilter());
        this.getFilterList().add(new JPEGFileFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToImage(Diagram diagram, Dimension size, int imageType, String fileName, String type) throws Exception {
        System.gc();
        BufferedImage image = new BufferedImage(size.width + 10, size.height + 10, imageType);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(diagram.getBackground());
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        diagram.paint(g2d);
        g2d.dispose();
        FileOutputStream out = new FileOutputStream(fileName);
        try {
            ImageIO.write((RenderedImage)image, type, out);
        }
        finally {
            out.flush();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Diagram diagram) {
        block8: {
            try {
                File file = this.getFile();
                if (file == null) break block8;
                String fileName = this.getFileName(file);
                TimeLog.log("Export Started");
                RepaintManager currentManager = RepaintManager.currentManager(diagram);
                currentManager.setDoubleBufferingEnabled(false);
                ProgressDialog monitor = new ProgressDialog(this.getAppView(), "", 0, 100, true, false);
                try {
                    monitor.setNote(Messages.getString("ImageExporter.SavingFileWait"));
                    monitor.setProgress(1);
                    Dimension size = diagram.getPreferredScrollableViewportSize();
                    String type = "png";
                    if (this.isImageType(fileName, ".jpg")) {
                        type = "jpg";
                    }
                    try {
                        this.exportToImage(diagram, size, 9, fileName, type);
                    }
                    catch (OutOfMemoryError ome) {
                        this.exportToImage(diagram, size, 13, fileName, type);
                    }
                    TimeLog.log("Export End");
                }
                finally {
                    currentManager.setDoubleBufferingEnabled(true);
                    monitor.close();
                }
            }
            catch (Exception e) {
                LOGGER.error(Messages.getString("ImageExporter.11"), e);
                MessageDialogs.showErrorMessage("Error occures while saving image file.", true);
            }
        }
    }

    protected String getDefaultExtension() {
        return ".png";
    }

    @Override
    protected String getTitle() {
        return Messages.getString("ImageExporter.SaveAsImageFile");
    }

    @Override
    protected boolean isSupportedExtension(String ext) {
        return ext.equals("png") || ext.equals("jpg");
    }

    private boolean isImageType(String fileName, String ext) {
        return fileName.toLowerCase().endsWith(ext.toLowerCase());
    }

    private class PNGFileFilter
    implements URLFilter {
        private PNGFileFilter() {
        }

        public boolean accept(URL url) {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String extension = AbstractExporter.getExtension(file);
            if (extension != null) {
                return extension.equals("png");
            }
            return false;
        }

        public String toString() {
            return Messages.getString("ImageExporter.PNGImages");
        }
    }

    private class JPEGFileFilter
    implements URLFilter {
        private JPEGFileFilter() {
        }

        public boolean accept(URL url) {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String extension = AbstractExporter.getExtension(file);
            if (extension != null) {
                return extension.equals("jpg");
            }
            return false;
        }

        public String toString() {
            return Messages.getString("ImageExporter.JPGImages");
        }
    }
}

