/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableSpacePropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private BufferPoolUDBv81 bufferPool;
    private JIntegerField ifSize;
    private JTextField tfDBPartitionsWithDiffSize;
    private JComboBox cbCreateImmediate;
    private JComboBox cbPageSize;
    private JComboBox cbExtendedStorage;
    private JPanel scope;
    private DefaultListModel allDBPartitionsModel;
    private DefaultListModel selectedDBPartitionsModel;
    private JList allDBPartitionsList;
    private JList selectedDBPartitionsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;

    public BufferPoolPropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.bufferPool = (BufferPoolUDBv81)object;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogUDBv81.BufferPoolProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.cbCreateImmediate.setSelectedItem(BufferPoolPropertyDialogUDBv81.translateYesNoForDisplay(this.bufferPool.getCreateImmediate()));
        this.ifSize.setValue((long)this.bufferPool.getSize());
        this.tfDBPartitionsWithDiffSize.setText(this.bufferPool.getNodesWithDiffSize());
        this.cbPageSize.setSelectedItem(new Integer(this.bufferPool.getPageSize()));
        if (this.bufferPool.getExtendedStorage()) {
            this.cbExtendedStorage.setSelectedItem(YES);
        } else {
            this.cbExtendedStorage.setSelectedItem(NO);
        }
        Object[] volumesSet = this.getStorageDesign().getNodeGroupSet().toArray();
        for (int i = 0; i < volumesSet.length; ++i) {
            DBPartitionGroupUDBv81 vol = (DBPartitionGroupUDBv81)volumesSet[i];
            if (this.bufferPool.getScopeSet().contains(vol.getName())) {
                this.selectedDBPartitionsModel.addElement(vol);
                continue;
            }
            this.allDBPartitionsModel.addElement(vol);
        }
        Object[] tss = this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            if (((TableSpaceUDBv81)tss[i]).getBufferPool() != this.bufferPool) continue;
            this.tsListModel.addElement(tss[i]);
        }
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setCreateImmediate(BufferPoolPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCreateImmediate.getSelectedItem()));
            this.bufferPool.setSize(this.ifSize.getIntValue());
            this.bufferPool.setNodesWithDiffSize(this.tfDBPartitionsWithDiffSize.getText());
            Object selected = this.cbPageSize.getSelectedItem();
            if (selected instanceof Integer) {
                this.bufferPool.setPageSize((Integer)selected);
            }
            selected = this.cbExtendedStorage.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.bufferPool.setExtendedStorage(result);
            Object[] nodesSet = this.selectedDBPartitionsModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < nodesSet.length; ++i) {
                Object ob = nodesSet[i];
                if (!(ob instanceof DBPartitionGroupUDBv81)) continue;
                this.bufferPool.setScope(((DBPartitionGroupUDBv81)ob).getName());
            }
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initCreateImmediate();
        this.initSize();
        this.initDBPartitionsWithDiffSize();
        this.initPageSize();
        this.initExtendedStorage();
    }

    private void initCreateImmediate() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.CreateImmediate"));
        this.general.add(label);
        this.cbCreateImmediate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCreateImmediate);
        this.cbCreateImmediate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCreateImmediate);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbCreateImmediate, 50);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.Size"));
        this.general.add(label);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifSize, 80);
    }

    private void initDBPartitionsWithDiffSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.DiffSizePartitions"));
        this.general.add(label);
        this.tfDBPartitionsWithDiffSize = new JTextField("", 26);
        this.general.add(this.tfDBPartitionsWithDiffSize);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfDBPartitionsWithDiffSize, 110);
    }

    private void initPageSize() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.PageSize"));
        this.general.add(label);
        this.cbPageSize = new JComboBox<Object>(BufferPoolUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbPageSize, 140);
    }

    private void initExtendedStorage() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.ExtendedStorage"));
        this.general.add(label);
        this.cbExtendedStorage = new JComboBox<String>(YES_NO);
        this.setBG(this.cbExtendedStorage);
        this.cbExtendedStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtendedStorage);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbExtendedStorage, 170);
    }

    @Override
    protected void addTabs() {
        this.initScopeView();
        this.initTableSpacesView();
    }

    private void initScopeView() {
        this.scope = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDBv81.Scope"), this.scope);
        this.initScope();
    }

    private void initScope() {
        this.initAllVolumesList();
        this.initSelectedVolumesList();
        this.initButtons();
    }

    protected SpringLayout getScopeLayout() {
        return (SpringLayout)this.scope.getLayout();
    }

    private void initAllVolumesList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.AllDBPartitions"));
        this.scope.add(label);
        this.allDBPartitionsModel = new DefaultListModel();
        this.allDBPartitionsList = new JList(this.allDBPartitionsModel);
        ListSelectionModel listSelectionModel = this.allDBPartitionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allDBPartitionsList);
        sp.setPreferredSize(new Dimension(144, 170));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(sp);
        this.setLabelConstraints(this.getScopeLayout(), label, 12, 4);
        this.setObjectConstraints(this.getScopeLayout(), sp, 10, 22);
    }

    private void initSelectedVolumesList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.SelectedDBPartitions"));
        this.scope.add(label);
        this.selectedDBPartitionsModel = new DefaultListModel();
        this.selectedDBPartitionsList = new JList(this.selectedDBPartitionsModel);
        ListSelectionModel listSelectionModel = this.selectedDBPartitionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedDBPartitionsList);
        sp.setPreferredSize(new Dimension(145, 170));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(sp);
        this.setLabelConstraints(this.getScopeLayout(), label, 292, 4);
        this.setObjectConstraints(this.getScopeLayout(), sp, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogUDBv81.Add"));
        this.bnAdd.addActionListener(new AddNodesActionListener());
        this.bnAdd.setEnabled(false);
        this.scope.add(this.bnAdd);
        this.setObjectConstraints(this.getScopeLayout(), this.bnAdd, 175, 80);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogUDBv81.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveNodesActionListener());
        this.scope.add(this.bnRemove);
        this.setObjectConstraints(this.getScopeLayout(), this.bnRemove, 175, 110);
        BufferPoolPropertyDialogUDBv81.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDBv81.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new ListMouseListenerTS());
        JScrollPane spTS = new JScrollPane(this.tsList);
        spTS.setPreferredSize(new Dimension(395, 180));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(spTS);
        this.setObjectConstraints(this.getTSLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDBv81.this.allDBPartitionsList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDBv81.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDBv81.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDBv81.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDBv81.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddNodesActionListener
    implements ActionListener {
        private AddNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogUDBv81.this.allDBPartitionsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.contains(ob)) continue;
                    BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.addElement(ob);
                    BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveNodesActionListener
    implements ActionListener {
        private RemoveNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.contains(ob)) continue;
                    BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.addElement(ob);
                    BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.removeElement(ob);
                }
            }
        }
    }

    private class ListMouseListenerTS
    extends MouseAdapter {
        private ListMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceUDBv81)BufferPoolPropertyDialogUDBv81.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogUDBv81 dialog = new TableSpacePropertyDialogUDBv81(BufferPoolPropertyDialogUDBv81.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

