/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.FunctionPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.SchemaPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TriggerPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserAndGroupPermissionsDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OwnerPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final long serialVersionUID = -8699917883424195446L;
    private OwnerUDB owner;
    private JPanel schemas;
    private DefaultListModel schemaListModel;
    private JList schemaList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JPanel functions;
    private DefaultListModel funcListModel;
    private JList funcList;
    private JButton bnPermissions;
    private UserAndGroupPermissionsDialogUDB dialog;

    public OwnerPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.owner = (OwnerUDB)object;
        this.setHeight(150);
        this.initCommentsView(80);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("OwnerPropertyDialogUDB.OwnerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPermissionsButton();
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("OwnerPropertyDialogUDB.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 75);
    }

    @Override
    protected void addTabs() {
        this.initSchemasView();
        this.initTablesView();
        this.initTriggersView();
        this.initViewsView();
        this.initStoredProceduresView();
        this.initFunctionsView();
    }

    private void initSchemasView() {
        this.schemas = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Schemas"), this.schemas);
        this.initSchemas();
    }

    private void initSchemas() {
        this.schemaListModel = new DefaultListModel();
        this.schemaList = new JList(this.schemaListModel);
        this.schemaList.addMouseListener(new SchemaListMouseListener());
        JScrollPane spTS = new JScrollPane(this.schemaList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.schemas.add(spTS);
        this.setObjectConstraints(this.getSchemaLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSchemaLayout() {
        return (SpringLayout)this.schemas.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane spTS = new JScrollPane(this.triggerList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(spTS);
        this.setObjectConstraints(this.getTriggerLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane spTS = new JScrollPane(this.viewList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(spTS);
        this.setObjectConstraints(this.getViewLayout(), spTS, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initStoredProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.StoredProcedures"), this.procedures);
        this.initProcedures();
    }

    private void initFunctionsView() {
        this.functions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Functions"), this.functions);
        this.initFunctions();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProcListMouseListener());
        JScrollPane spTS = new JScrollPane(this.procList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(spTS);
        this.setObjectConstraints(this.getProcedureLayout(), spTS, 10, 12);
    }

    protected SpringLayout getProcedureLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    private void initFunctions() {
        this.funcListModel = new DefaultListModel();
        this.funcList = new JList(this.funcListModel);
        this.funcList.addMouseListener(new FuncListMouseListener());
        JScrollPane spTS = new JScrollPane(this.funcList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.functions.add(spTS);
        this.setObjectConstraints(this.getFunctionLayout(), spTS, 10, 12);
    }

    protected SpringLayout getFunctionLayout() {
        return (SpringLayout)this.functions.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.owner.getName());
        this.tfName.setText(this.owner.getName());
        this.getCommentsList().insert(this.owner.getComment(), 0);
        if (this.owner.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] schema = this.getStorageDesign().getSchemaSet().toArray();
        SchemaUDB s = null;
        for (int i = 0; i < schema.length; ++i) {
            s = (SchemaUDB)schema[i];
            if (s.getOwner() != this.owner) continue;
            this.schemaListModel.addElement(s);
        }
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        TableProxyUDB t = null;
        for (int i = 0; i < table.length; ++i) {
            t = (TableProxyUDB)table[i];
            if (t.getOwner() != this.owner && (t.getSchema() == null || t.getSchema().getOwner() != this.owner)) continue;
            this.tableListModel.addElement(t);
        }
        Object[] tr = this.getStorageDesign().getTriggerSet().toArray();
        TriggerUDB trigger = null;
        for (int i = 0; i < tr.length; ++i) {
            trigger = (TriggerUDB)tr[i];
            if (trigger.getOwner() != this.owner) continue;
            this.triggerListModel.addElement(trigger);
        }
        Object[] view = this.getStorageDesign().getTableViewProxySet().toArray();
        TableViewProxyUDB v = null;
        for (int i = 0; i < view.length; ++i) {
            v = (TableViewProxyUDB)view[i];
            if (v.getOwner() != this.owner && (v.getSchema() == null || v.getSchema().getOwner() != this.owner)) continue;
            this.viewListModel.addElement(view[i]);
        }
        Object[] proc = this.getStorageDesign().getStoredProcedureSet().toArray();
        StoredProcedureUDB p = null;
        for (int i = 0; i < proc.length; ++i) {
            p = (StoredProcedureUDB)proc[i];
            if (p.getOwner() != this.owner) continue;
            this.procListModel.addElement(proc[i]);
        }
        Object[] func = this.getStorageDesign().getFunctionSet().toArray();
        FunctionUDB f = null;
        for (int i = 0; i < func.length; ++i) {
            f = (FunctionUDB)func[i];
            if (f.getOwner() != this.owner) continue;
            this.funcListModel.addElement(func[i]);
        }
    }

    @Override
    protected void setProperties() {
        if (this.owner != null && !this.owner.isNullInstance()) {
            String oldName = this.owner.getName();
            this.owner.setName(this.tfName.getText());
            this.owner.setComment(this.getCommentsList().getText());
            if (!this.tfName.getText().equals(oldName)) {
                this.owner.setNameChanged(true);
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OwnerPropertyDialogUDB.this.dialog == null) {
                OwnerPropertyDialogUDB.this.dialog = new UserAndGroupPermissionsDialogUDB(OwnerPropertyDialogUDB.this.getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), OwnerPropertyDialogUDB.this.owner);
            }
            OwnerPropertyDialogUDB.this.dialog.showDialog();
        }
    }

    private class SchemaListMouseListener
    extends MouseAdapter {
        private SchemaListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SchemaUDB selected;
            if (e.getClickCount() == 2 && (selected = (SchemaUDB)OwnerPropertyDialogUDB.this.schemaList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                SchemaPropertyDialogUDB dialog = new SchemaPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDB)OwnerPropertyDialogUDB.this.tableList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TablePropertyDialogUDB dialog = new TablePropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TriggerUDB selected;
            if (e.getClickCount() == 2 && (selected = (TriggerUDB)OwnerPropertyDialogUDB.this.triggerList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TriggerPropertyDialogUDB dialog = new TriggerPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyUDB selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyUDB)OwnerPropertyDialogUDB.this.viewList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableViewPropertyDialogUDB dialog = new TableViewPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ProcListMouseListener
    extends MouseAdapter {
        private ProcListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StoredProcedureUDB selected;
            if (e.getClickCount() == 2 && (selected = (StoredProcedureUDB)OwnerPropertyDialogUDB.this.procList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                StoredProcedurePropertyDialogUDB dialog = new StoredProcedurePropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class FuncListMouseListener
    extends MouseAdapter {
        private FuncListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FunctionUDB selected;
            if (e.getClickCount() == 2 && (selected = (FunctionUDB)OwnerPropertyDialogUDB.this.funcList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                FunctionPropertyDialogUDB dialog = new FunctionPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

