/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private IndexProxyUDB index;
    private JTextField tfTable;
    private JComboBox cbScheme;
    private JTextField tfOwner;
    private JTextField tfUnique;
    private JComboBox cbCluster;
    private JIntegerField ifPCtFree;
    private JIntegerField ifMinPercentUsed;
    private JComboBox cbReverseScan;
    private JPanel columns;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private String comment;
    private String commentInRDBMS;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected DefaultListModel allGroupsModel;
    protected DefaultListModel selectedGroupsModel;
    private JList allGroupsList;
    private JList selectedGroupsList;
    private JButton bnAddGroup;
    private JButton bnRemoveGroup;

    public IndexPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (IndexProxyUDB)object;
        this.setHeight(380);
        this.initCommentsView(125);
        this.initCommentsInRDBMS(125);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogUDB.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initScheme();
        this.initOwner();
        this.initUnique();
        this.initCluster();
        this.initPctFree();
        this.initMinPercentageUsed();
        this.initReverseScan();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initUnique() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.Unique"));
        this.general.add(label);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfUnique, 140);
    }

    private void initCluster() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.Cluster"));
        this.general.add(label);
        this.cbCluster = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCluster);
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initPctFree() {
        JLabel label = new JLabel("PCTFREE:");
        this.general.add(label);
        this.ifPCtFree = new JIntegerField(0, 26);
        this.general.add(this.ifPCtFree);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifPCtFree, 200);
    }

    private void initMinPercentageUsed() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.MinUsed"));
        this.general.add(label);
        this.ifMinPercentUsed = new JIntegerField(0, 26);
        this.general.add(this.ifMinPercentUsed);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifMinPercentUsed, 230);
    }

    private void initReverseScan() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.ReverseScan"));
        this.general.add(label);
        this.cbReverseScan = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReverseScan);
        this.cbReverseScan.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReverseScan);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbReverseScan, 260);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogUDB.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(IndexPropertyDialogUDB.this.getStorageDesign().getIndexProxySet().getElements());
                list.remove(IndexPropertyDialogUDB.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogUDB.this.getAppView(), IndexPropertyDialogUDB.this.index, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 300);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initUsePrivilegesView();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDB.IndexPrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initToUserGroups();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(144, 110));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 4);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 22);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(145, 110));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 292, 4);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 290, 22);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("IndexPropertyDialogUDB.Add"));
        this.bnAddUser.addActionListener(new AddUsersActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 175, 50);
        this.bnRemoveUser = new JButton(Messages.getString("IndexPropertyDialogUDB.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveUsersActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 175, 80);
        IndexPropertyDialogUDB.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    private void initToUserGroups() {
        this.initAllUserGroupsList();
        this.initSelectedUserGroupsList();
        this.initGroupsButtons();
    }

    private void initAllUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.AllUsersGroups"));
        this.usePrivilegesPanel.add(label);
        this.allGroupsModel = new DefaultListModel();
        this.allGroupsList = new JList(this.allGroupsModel);
        ListSelectionModel listSelectionModel = this.allGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allGroupsList);
        sp.setPreferredSize(new Dimension(144, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 144);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 162);
    }

    private void initSelectedUserGroupsList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.SelectedUserGroups"));
        this.usePrivilegesPanel.add(label);
        this.selectedGroupsModel = new DefaultListModel();
        this.selectedGroupsList = new JList(this.selectedGroupsModel);
        ListSelectionModel listSelectionModel = this.selectedGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedGroupListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedGroupsList);
        sp.setPreferredSize(new Dimension(145, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 292, 144);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 290, 162);
    }

    private void initGroupsButtons() {
        this.bnAddGroup = new JButton(Messages.getString("IndexPropertyDialogUDB.Add"));
        this.bnAddGroup.addActionListener(new AddGroupsActionListener());
        this.bnAddGroup.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddGroup, 175, 190);
        this.bnRemoveGroup = new JButton(Messages.getString("IndexPropertyDialogUDB.Remove"));
        this.bnRemoveGroup.setEnabled(false);
        this.bnRemoveGroup.addActionListener(new RemoveGroupsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveGroup, 175, 220);
        IndexPropertyDialogUDB.equalizeButtonSizes(this.bnAddGroup, this.bnRemoveGroup);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDB.IncludeColumns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.AllColumns"));
        this.columns.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 260));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 4);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 22);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogUDB.SelectedColumns"));
        this.columns.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 260));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("IndexPropertyDialogUDB.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.columns.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 120);
        this.bnRemove = new JButton(Messages.getString("IndexPropertyDialogUDB.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.columns.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 150);
        IndexPropertyDialogUDB.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.tfTable.setText(this.index.getTable().getName());
        this.selectObject(this.cbScheme, this.index.getSchema());
        this.tfUnique.setText(this.index.isUnique() ? YES_NO[0] : YES_NO[1]);
        this.cbCluster.setSelectedItem(this.index.getCluster() ? YES_NO[0] : YES_NO[1]);
        this.ifPCtFree.setValue((long)this.index.getPercentageFree());
        this.ifMinPercentUsed.setValue((long)this.index.getMinimumPercentageUsed());
        this.cbReverseScan.setSelectedItem(this.index.getReverseScanSupport() ? YES_NO[0] : YES_NO[1]);
        if (this.index.isUnique()) {
            this.selectedColumnsList.setEnabled(true);
            this.allColumnsList.setEnabled(true);
        } else {
            this.selectedColumnsList.setEnabled(false);
            this.allColumnsList.setEnabled(false);
            this.bnAdd.setEnabled(false);
            this.bnRemove.setEnabled(false);
        }
        RelationalObjectProxy[] columnSet = (RelationalObjectProxy[])this.getStorageDesign().getColumnProxySet().toArray();
        for (int i = 0; i < columnSet.length; ++i) {
            RelationalObjectProxy col = columnSet[i];
            ColumnProxy[] cols = this.index.getColumnProxies();
            boolean contains = false;
            for (int j = 0; j < cols.length; ++j) {
                if (cols[j] != col) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            if (this.index.getColumnSet().contains(col.getName())) {
                this.selectedColumnsModel.addElement(col);
                continue;
            }
            this.allColumnsModel.addElement(col);
        }
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (this.index.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        Object[] userGroupSet = this.getStorageDesign().getUserGroupSet().toArray();
        for (int i = 0; i < userGroupSet.length; ++i) {
            UserGroupUDB group = (UserGroupUDB)userGroupSet[i];
            if (this.index.getUserGroupSet().contains(group.getName())) {
                this.selectedGroupsModel.addElement(group);
                continue;
            }
            this.allGroupsModel.addElement(group);
        }
        this.comment = ((Index)this.index.getObject()).getComment();
        this.commentInRDBMS = ((Index)this.index.getObject()).getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setName(this.tfName.getText());
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.index.setSchema((SchemaUDB)selected);
                this.index.setOwner(((SchemaUDB)selected).getOwner());
            } else {
                this.index.setSchema(null);
                this.index.setSchema(null);
            }
            selected = this.cbCluster.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setCluster(result);
            this.index.setPercentageFree(this.ifPCtFree.getIntValue());
            this.index.setMinimumPercentageUsed(this.ifMinPercentUsed.getIntValue());
            selected = this.cbReverseScan.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setReverseScanSupport(result);
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.index.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof RelationalObjectProxy)) continue;
                this.index.setColumnList(((RelationalObjectProxy)ob).getName());
            }
            Object[] userSet = this.selectedUsersModel.toArray();
            this.index.clearUsers();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.index.setUsers(((Owner)ob).getName());
            }
            Object[] userGroupsSet = this.selectedGroupsModel.toArray();
            for (int i = 0; i < userGroupsSet.length; ++i) {
                Object ob = userGroupsSet[i];
                if (!(ob instanceof UserGroupUDB)) continue;
                this.index.setGroups(((UserGroupUDB)ob).getName());
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.index.setComment(commentText);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.index.setCommentInRDBMS(commentInRDBMSText);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
            this.applyColumnsSortOrder();
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDB.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.index.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)IndexPropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    IndexPropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                }
            }
            catch (NullPointerException e1) {
                IndexPropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.allUsersList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnAddUser.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.selectedUsersList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnRemoveUser.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.selectedUsersModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.selectedUsersModel.addElement(ob);
                    IndexPropertyDialogUDB.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.allUsersModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.allUsersModel.addElement(ob);
                    IndexPropertyDialogUDB.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AllGroupListSelectionHandler
    implements ListSelectionListener {
        private AllGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.allGroupsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnAddGroup.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnAddGroup.setEnabled(true);
                }
            }
        }
    }

    private class SelectedGroupListSelectionHandler
    implements ListSelectionListener {
        private SelectedGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.selectedGroupsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnRemoveGroup.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnRemoveGroup.setEnabled(true);
                }
            }
        }
    }

    private class AddGroupsActionListener
    implements ActionListener {
        private AddGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.allGroupsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.allGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.selectedGroupsModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.selectedGroupsModel.addElement(ob);
                    IndexPropertyDialogUDB.this.allGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveGroupsActionListener
    implements ActionListener {
        private RemoveGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.selectedGroupsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.selectedGroupsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.allGroupsModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.allGroupsModel.addElement(ob);
                    IndexPropertyDialogUDB.this.selectedGroupsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnAdd.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDB.this.selectedColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDB.this.bnRemove.setEnabled(false);
                } else {
                    IndexPropertyDialogUDB.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.selectedColumnsModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.selectedColumnsModel.addElement(ob);
                    IndexPropertyDialogUDB.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogUDB.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogUDB.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogUDB.this.allColumnsModel.contains(ob)) continue;
                    IndexPropertyDialogUDB.this.allColumnsModel.addElement(ob);
                    IndexPropertyDialogUDB.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

