/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FunctionPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private FunctionUDB func;
    private JTextField tfOwner;
    private JTextArea bodyArea;
    private JComboBox cbSchema;
    private JTextField tfSpecificName;

    public FunctionPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.func = (FunctionUDB)object;
        this.setHeight(350);
        this.initCommentsView(105);
        this.initCommentsInRDBMS(105);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FunctionPropertyDialogUDB.FunctionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSpecificName();
        this.initSchema();
        this.initOwner();
        this.initBody();
    }

    private void initSpecificName() {
        JLabel label = new JLabel(Messages.getString("FunctionPropertyDialogUDB.SpecificName"));
        this.general.add(label);
        this.tfSpecificName = new JTextField("", 26);
        this.tfSpecificName.setEditable(false);
        this.general.add(this.tfSpecificName);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfSpecificName, 50);
    }

    private void initSchema() {
        JLabel label = new JLabel(Messages.getString("FunctionPropertyDialogUDB.Schema"));
        this.general.add(label);
        this.cbSchema = new JComboBox();
        this.setBG(this.cbSchema);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbSchema);
        }
        this.cbSchema.addActionListener(new SchemaListener());
        this.cbSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchema);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbSchema, 80);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("FunctionPropertyDialogUDB.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initBody() {
        JLabel bodyLabel = new JLabel(Messages.getString("FunctionPropertyDialogUDB.Body"));
        this.general.add(bodyLabel);
        this.setLabelConstraints(bodyLabel, 140);
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        sp.setPreferredSize(new Dimension(395, 160));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(sp);
        this.setObjectConstraints(sp, 10, 160);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.func.getName());
        this.tfName.setText(this.func.getName());
        this.tfSpecificName.setText(this.func.getSpecificName());
        this.cbSchema.setSelectedItem(this.func.getSchema());
        this.bodyArea.setText(this.func.getBody());
        this.getCommentsList().insert(this.func.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.func.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.func != null) {
            Object selected = this.cbSchema.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.func.setOwner(((SchemaUDB)selected).getOwner());
                this.func.setSchema((SchemaUDB)selected);
            } else {
                this.func.setOwner(null);
                this.func.setSchema(null);
            }
            this.func.setName(this.tfName.getText());
            String specName = this.func.getSpecificNameFromBody(this.bodyArea.getText());
            this.tfSpecificName.setText(specName);
            this.func.setSpecificName(specName);
            this.func.setBody(this.bodyArea.getText());
            this.func.setComment(this.getCommentsList().getText());
            this.func.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbSchema.getSelectedItem();
        if (selectedSchema instanceof SchemaUDB) {
            newName = ((SchemaUDB)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)FunctionPropertyDialogUDB.this.cbSchema.getSelectedItem();
            try {
                if (schema != null) {
                    FunctionPropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                } else {
                    FunctionPropertyDialogUDB.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException e1) {
                FunctionPropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

