/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogSqlServerv2k12
extends AbstractSqlServerPropertyDialog {
    private SequenceSqlServerv2k12 sequence;
    private JComboBox cbDatabase;
    private JComboBox cbSchema;
    private JComboBox cbIntegerType;
    private JIntegerField ifIntegerPrecision;
    private JIntegerField ifStartWith;
    private JIntegerField ifIncrementBy;
    private JIntegerField ifMaxValue;
    private JIntegerField ifMinValue;
    private JComboBox cbCycle;
    private JComboBox cbNoCache;
    private JIntegerField ifCache;
    private static final int SEQ_VALUE_MAX_DIGITS = 28;

    public SequencePropertyDialogSqlServerv2k12(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.sequence = (SequenceSqlServerv2k12)object;
        int height = 460;
        this.setHeight(height);
        this.initCommentsView(height - 50);
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogSqlServerv2k12.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initSchema();
        this.initIntegerTypeAndPrecision();
        this.initStartWith();
        this.initIncrementBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        int yCoord = 390;
        if (this.isEditable()) {
            this.initPropagatePropsButton(yCoord);
        }
    }

    private void initDatabase() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.Database"));
        this.general.add(label);
        this.cbDatabase = new JComboBox();
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
        this.cbDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseSqlServer selDB = (DataBaseSqlServer)SequencePropertyDialogSqlServerv2k12.this.cbDatabase.getSelectedItem();
                if (selDB != null) {
                    SequencePropertyDialogSqlServerv2k12.this.cbSchema.removeAllItems();
                    SequencePropertyDialogSqlServerv2k12.this.fillComboItems(selDB.getSchemas().toArray(), SequencePropertyDialogSqlServerv2k12.this.cbSchema);
                }
                SequencePropertyDialogSqlServerv2k12.this.selectObject(SequencePropertyDialogSqlServerv2k12.this.cbSchema, SequencePropertyDialogSqlServerv2k12.this.sequence.getSchema());
            }
        });
    }

    private void initSchema() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.Schema"));
        this.general.add(label);
        this.cbSchema = new JComboBox();
        this.setBG(this.cbSchema);
        this.cbSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchema);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbSchema, 80);
    }

    private void initIntegerTypeAndPrecision() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.IntegerType"));
        this.general.add(label);
        this.cbIntegerType = new JComboBox();
        this.setBG(this.cbIntegerType);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(SequenceSqlServerv2k12.INTEGER_TYPES_LIST.toArray(), this.cbIntegerType);
        }
        this.cbIntegerType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIntegerType);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbIntegerType, 110);
        label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.Precision"));
        this.general.add(label);
        this.ifIntegerPrecision = new JIntegerField();
        this.ifIntegerPrecision.setColumns(26);
        this.ifIntegerPrecision.setLargeIntegerDocument(28);
        this.general.add(this.ifIntegerPrecision);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifIntegerPrecision, 140);
    }

    private void initStartWith() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.StartWith"));
        this.general.add(label);
        this.ifStartWith = new JIntegerField();
        this.ifStartWith.setColumns(26);
        this.ifStartWith.setLargeIntegerDocument(28);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifStartWith, 170);
    }

    private void initIncrementBy() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.IncrementBy"));
        this.general.add(label);
        this.ifIncrementBy = new JIntegerField();
        this.ifIncrementBy.setColumns(26);
        this.ifIncrementBy.setLargeIntegerDocument(28);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifIncrementBy, 200);
    }

    private void initMinValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.MinValue"));
        this.general.add(label);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifMinValue, 230);
    }

    private void initMaxValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.MaxValue"));
        this.general.add(label);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifMaxValue, 260);
    }

    private void initCycle() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.Cycle"));
        this.general.add(label);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbCycle, 290);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.NoCache"));
        this.general.add(label);
        this.cbNoCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNoCache);
        this.cbNoCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNoCache);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbNoCache, 320);
        this.cbNoCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractPropertyDialog.YES.equals(SequencePropertyDialogSqlServerv2k12.this.cbNoCache.getSelectedItem())) {
                    SequencePropertyDialogSqlServerv2k12.this.ifCache.setValue(null);
                    SequencePropertyDialogSqlServerv2k12.this.ifCache.setEditable(false);
                    SequencePropertyDialogSqlServerv2k12.this.ifCache.setFocusable(false);
                } else {
                    try {
                        SequencePropertyDialogSqlServerv2k12.this.ifCache.setValue(Integer.valueOf(SequencePropertyDialogSqlServerv2k12.this.sequence.getCache()));
                    }
                    catch (NumberFormatException nfe) {
                        SequencePropertyDialogSqlServerv2k12.this.ifCache.setValue(null);
                    }
                    SequencePropertyDialogSqlServerv2k12.this.ifCache.setEditable(true);
                    SequencePropertyDialogSqlServerv2k12.this.ifCache.setFocusable(true);
                }
            }
        });
        label = new JLabel(Messages.getString("SequencePropertyDialogSqlServerv2k12.Cache"));
        this.general.add(label);
        this.ifCache = new JIntegerField();
        this.ifCache.setColumns(26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.ifCache, 350);
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("SequencePropertyDialogSqlServerv2k12.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(((StorageDesignSqlServerv2k12)SequencePropertyDialogSqlServerv2k12.this.getStorageDesign()).getSequenceSet().getElementsList());
                list.remove(SequencePropertyDialogSqlServerv2k12.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogSqlServerv2k12.this.getAppView(), SequencePropertyDialogSqlServerv2k12.this.sequence, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    @Override
    public void initProperties() {
        double i;
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.cbDatabase.setModel(new DefaultComboBoxModel<Object>(((StorageDesignSqlServer)this.sequence.getStorageDesign()).getDataBaseSet().getElementsList().toArray()));
        DataBaseSqlServer initDB = this.sequence.getDatabase();
        if (initDB == null && this.getStorageDesign() != null) {
            initDB = (DataBaseSqlServer)this.getStorageDesign().getDataBaseSet().getNullInstance();
        }
        this.selectObject(this.cbDatabase, initDB);
        this.cbSchema.removeAllItems();
        if (initDB != null) {
            this.fillComboItems(initDB.getSchemas().toArray(), this.cbSchema);
        }
        this.selectObject(this.cbSchema, this.sequence.getSchema());
        this.cbIntegerType.setSelectedItem(this.sequence.getIntegerType());
        try {
            i = Double.parseDouble(this.sequence.getIntegerPrecision());
            this.ifIntegerPrecision.setText(this.sequence.getIntegerPrecision());
        }
        catch (NumberFormatException nfe) {
            this.ifIntegerPrecision.setText("");
        }
        try {
            i = Double.parseDouble(this.sequence.getStartWith());
            this.ifStartWith.setText(this.sequence.getStartWith());
        }
        catch (NumberFormatException nfe) {
            this.ifStartWith.setText("");
        }
        try {
            double i2 = Double.parseDouble(this.sequence.getIncrementBy());
            this.ifIncrementBy.setText(this.sequence.getIncrementBy());
        }
        catch (NumberFormatException nfe) {
            this.ifIncrementBy.setText("");
        }
        try {
            double i3 = Double.parseDouble(this.sequence.getMinValue());
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMinValue.setText("");
        }
        try {
            double i4 = Double.parseDouble(this.sequence.getMaxValue());
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMaxValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogSqlServerv2k12.translateYesNoForDisplay(this.sequence.getCycle()));
        this.cbNoCache.setSelectedItem(SequencePropertyDialogSqlServerv2k12.translateYesNoForDisplay(this.sequence.getNoCache()));
        try {
            this.ifCache.setValue(Integer.valueOf(this.sequence.getCache()));
        }
        catch (NumberFormatException nfe) {
            this.ifCache.setValue(null);
        }
        this.getCommentsList().insert(this.sequence.getComment(), 0);
        this.taNotes.setText(this.sequence.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            double i;
            this.sequence.setName(this.tfName.getText());
            Object selected = this.cbDatabase.getSelectedItem();
            if (selected instanceof DataBaseSqlServer) {
                this.sequence.changeDatabase((DataBaseSqlServer)selected);
            } else {
                this.sequence.changeDatabase(null);
            }
            selected = this.cbSchema.getSelectedItem();
            if (selected instanceof SchemaSqlServer) {
                this.sequence.setSchema((SchemaSqlServer)selected);
                if (this.sequence.getDatabase() == null) {
                    this.sequence.setDatabase(((SchemaSqlServer)selected).getDatabase());
                }
            } else {
                this.sequence.setSchema(null);
            }
            if (this.cbIntegerType.getSelectedItem() != null) {
                this.sequence.setIntegerType((String)this.cbIntegerType.getSelectedItem());
            } else {
                this.sequence.setIntegerType("");
            }
            try {
                i = Double.parseDouble(this.ifIntegerPrecision.getText());
                this.sequence.setIntegerPrecision(this.ifIntegerPrecision.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setIntegerPrecision("");
            }
            try {
                i = Double.parseDouble(this.ifStartWith.getText());
                this.sequence.setStartWith(this.ifStartWith.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setStartWith("");
            }
            try {
                double i2 = Double.parseDouble(this.ifIncrementBy.getText());
                this.sequence.setIncrementBy(this.ifIncrementBy.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setIncrementBy("");
            }
            try {
                double i3 = Double.parseDouble(this.ifMinValue.getText());
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMinValue("");
            }
            try {
                double i4 = Double.parseDouble(this.ifMaxValue.getText());
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMaxValue("");
            }
            String sel = (String)this.cbCycle.getSelectedItem();
            this.sequence.setCycle(SequencePropertyDialogSqlServerv2k12.translateYesNoForStorage(sel));
            sel = (String)this.cbNoCache.getSelectedItem();
            this.sequence.setNoCache(SequencePropertyDialogSqlServerv2k12.translateYesNoForStorage(sel));
            if (sel.equals(NO)) {
                try {
                    int i5 = Integer.parseInt(this.ifCache.getText());
                    this.sequence.setCache(this.ifCache.getText());
                }
                catch (NumberFormatException nfe) {
                    this.sequence.setCache("");
                }
            }
            this.sequence.setComment(this.getCommentsList().getText());
            this.sequence.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbSchema.getSelectedItem();
        if (selectedSchema instanceof SchemaSqlServer) {
            newName = ((SchemaSqlServer)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }
}

