/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class AbstractStorageObjectPropertiesDialog
extends JDialog
implements AbstractEditorConstants {
    protected static final String ADD_CAPTION = Messages.getString("AbstractPropertyDialog.Add");
    protected static final String REMOVE_CAPTION = Messages.getString("AbstractPropertyDialog.Remove");
    private static final Logger LOGGER = new Logger(AbstractStorageObjectPropertiesDialog.class);
    private ApplicationView appView;
    private int minHeight = 460;
    private int minWidth = 750;
    private String treePath = "";
    private JPanel pnMain;
    private CardLayout cardLayout = new CardLayout(10, 10);
    private JTree tree;
    protected JPanel pnGeneral;
    private JPanel pnGeneralML;
    protected JPanel pnButtons;
    private JPanel pnComments;
    private JPanel pnCommentsInRDBMS;
    protected JPanel comments;
    protected JPanel notes;
    protected JLabel lbName;
    protected JTextField tfName;
    protected RSyntaxTextArea taComments;
    protected RSyntaxTextArea taCommentsInRDBMS;
    protected JScrollPane spComments;
    protected JScrollPane spCommentsInRDBMS;
    public static final String YES = Messages.getString("AbstractPropertyDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertyDialog.NO");
    public static final String NONE = Messages.getString("AbstractPropertyDialog.NONE");
    public static final String[] YES_NO = new String[]{YES, NO};
    public static final String[] EMPTY_YES_NO = new String[]{"", YES, NO};
    public static final String[] NONE_YES_NO = new String[]{NONE, YES, NO};
    protected static final int FIELD_WIDTH = 26;
    protected static final int RIGHT_MARGIN_WIDTH = 15;
    private int dialogWidth = this.getDialogWidth();
    protected StorageDesign storageDesign;
    protected StorageObject storageObject;
    protected String oldObjectStatus;
    private JButton bnCancel;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractStorageObjectPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public AbstractStorageObjectPropertiesDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.storageObject = object;
        this.oldObjectStatus = view.getXMLTransformationManager().getFilteredXMLString(object);
        this.appView = view;
        this.storageDesign = storageDesign;
        this.init();
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.comments = new JPanel(new SpringLayout());
    }

    private void init() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = AbstractStorageObjectPropertiesDialog.this.getWidth();
                int h = AbstractStorageObjectPropertiesDialog.this.getHeight();
                w = Math.max(AbstractStorageObjectPropertiesDialog.this.getMinimumWidth(), w);
                h = Math.max(AbstractStorageObjectPropertiesDialog.this.getMinimumHeight(), h);
                AbstractStorageObjectPropertiesDialog.this.setSize(w, h);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractStorageObjectPropertiesDialog.this.onCancel();
                AbstractStorageObjectPropertiesDialog.this.storageObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractStorageObjectPropertiesDialog.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.initLayout();
        this.pack();
        Settings.DialogSettings ds = this.getAppView().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = Math.max(this.getMinimumWidth(), this.minWidth);
            int h = Math.max(this.getMinimumHeight(), this.minHeight);
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
            this.treePath = ds.treePath;
        }
    }

    protected int getDialogWidth() {
        return 450;
    }

    public static void equalizeButtonSizes(JButton button1, JButton button2) {
        Dimension dimension1 = button1.getPreferredSize();
        Dimension dimension2 = button2.getPreferredSize();
        if (dimension1.getWidth() < dimension2.getWidth()) {
            button1.setPreferredSize(dimension2);
        } else {
            button2.setPreferredSize(dimension1);
        }
    }

    public String getCaption() {
        return Messages.getString("AbstractPropertyDialog.Properties");
    }

    public abstract void initProperties();

    protected abstract void setProperties();

    protected boolean canExit() {
        String newName = this.tfName.getText().trim();
        if ("".equalsIgnoreCase(newName)) {
            MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertyDialog.NameCanNotBeEmpty"));
            this.tfName.requestFocus();
            return false;
        }
        if (this.storageObject.isTopLevelObject() && !this.allowName(newName)) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("AbstractPropertyDialog.NameNotUnique"), newName));
            this.tfName.requestFocus();
            return false;
        }
        return true;
    }

    protected boolean allowName(String newName) {
        return this.storageObject.allowName(newName, true);
    }

    protected void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    protected abstract void initTree(DefaultMutableTreeNode var1);

    public ApplicationView getAppView() {
        return this.appView;
    }

    public JTextArea getCommentsList() {
        return this.taComments;
    }

    public JTextArea getCommentsInRDBMSList() {
        return this.taCommentsInRDBMS;
    }

    public void fillComboItems(Object[] items, JComboBox comboBox) {
        comboBox.addItem(null);
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    public void fillComboItems(Object[] items, JComboBox comboBox, Object exclude) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object.equals(exclude)) continue;
            comboBox.addItem(items[i]);
        }
    }

    public void fillComboItems(Object[] items, JComboBox comboBox, ArrayList exclude) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (exclude.contains(object)) continue;
            comboBox.addItem(items[i]);
        }
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    public StorageObject getStorageObject() {
        return this.storageObject;
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.storageObject.showModal || this.storageObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
        }
        if (!this.storageObject.showForFirstTime() && this.treePath.length() > 0) {
            String[] names = this.treePath.split("/");
            TreePath tp = TreeUtils.findByName(this.getTree(), names);
            if (tp != null) {
                this.getTree().setSelectionPath(tp);
            }
        }
        super.show();
        this.storageObject.setDialogVisible(true, this);
    }

    private void disableControls(Container container) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c instanceof JTable || c instanceof JButton || c instanceof JList) continue;
            if (!(c instanceof JTabbedPane) && !(c instanceof JLabel)) {
                c.setEnabled(false);
            }
            if (!(c instanceof Container)) continue;
            this.disableControls((Container)c);
        }
    }

    protected void clearOnDispose() {
    }

    protected void onCancel() {
        if (this.storageObject.showForFirstTime()) {
            this.storageObject.remove();
        }
    }

    protected void postProcessingInApply() {
    }

    protected boolean isEditable() {
        if (this.getStorageObject().isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected boolean notEquals(Integer value, JIntegerField integerField) {
        int integerFieldValue = integerField.getIntValue();
        return value == null && integerFieldValue > 0 || value != null && value != integerFieldValue;
    }

    protected boolean notEquals(String value, JTextField textField) {
        String text = textField.getText();
        return StringUtilities.isNotEmpty(value) && !StringUtilities.isNotEmpty(text) || !StringUtilities.isNotEmpty(value) && StringUtilities.isNotEmpty(text) || value != null && !value.equals(text);
    }

    protected boolean notEquals(boolean value, JComboBox comboBox, Object valueWhenTrue, Object valueWhenFalse) {
        Object comboBoxValue = comboBox.getSelectedItem();
        return value && valueWhenFalse.equals(comboBoxValue) || !value && valueWhenTrue.equals(comboBoxValue);
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public static String translateYesNoForDisplay(String internalValue) {
        if ("YES".equals(internalValue)) {
            return YES;
        }
        if ("NO".equals(internalValue)) {
            return NO;
        }
        return internalValue;
    }

    public static String translateYesNoForStorage(String displayValue) {
        if (YES.equals(displayValue)) {
            return "YES";
        }
        if (NO.equals(displayValue)) {
            return "NO";
        }
        return displayValue;
    }

    public static String translateNoneYesNoForDisplay(String internalValue) {
        if ("NONE".equals(internalValue)) {
            return NONE;
        }
        return AbstractStorageObjectPropertiesDialog.translateYesNoForDisplay(internalValue);
    }

    public static String translateNoneYesNoForStorage(String displayValue) {
        if (NONE.equals(displayValue)) {
            return "NONE";
        }
        return AbstractStorageObjectPropertiesDialog.translateYesNoForStorage(displayValue);
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        AbstractStorageObjectPropertiesDialog.this.bnCancel.doClick();
                    } else if (e.getKeyCode() == 112) {
                        AbstractStorageObjectPropertiesDialog.this.showHelp();
                    }
                }
            });
        }
        return this.tree;
    }

    protected void showComponent(Component component) {
        String componentName = component.getName();
        this.cardLayout.show(this.getMainPanel(), componentName);
    }

    protected JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected DefaultMutableTreeNode addToTree(DefaultMutableTreeNode node, JPanel panel) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(panel);
        node.add(newNode);
        this.getMainPanel().add((Component)panel, panel.getName());
        return newNode;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage("General");
            this.pnGeneralML = new JPanel((LayoutManager)new MigLayout("", "0[120!][grow, 120:120:]10[120!][grow, 120:120:]0", "0[]10[]0"));
            this.lbName = new JLabel(LB_NAME);
            this.tfName = new JTextField();
            this.pnGeneralML.add(this.lbName);
            this.pnGeneralML.add((Component)this.tfName, new CC().growX());
            this.pnGeneral.add((Component)this.pnGeneralML, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage("Comments");
            this.taComments = new RSyntaxTextArea();
            this.taComments.setEditable(this.isEditable());
            this.taComments.setLineWrap(true);
            this.taComments.setWrapStyleWord(true);
            this.taComments.setBorder(null);
            this.taComments.setAntiAliasingEnabled(true);
            this.taComments.setFont(this.tfName.getFont());
            this.pnComments.add(new JScrollPane((Component)this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getCommentsInRDBMSPanel() {
        if (this.pnCommentsInRDBMS == null) {
            this.pnCommentsInRDBMS = this.createPage("Comments in RDBMS");
            this.taCommentsInRDBMS = new RSyntaxTextArea();
            this.taCommentsInRDBMS.setEditable(this.isEditable());
            this.taCommentsInRDBMS.setLineWrap(true);
            this.taCommentsInRDBMS.setWrapStyleWord(true);
            this.taCommentsInRDBMS.setBorder(null);
            this.taCommentsInRDBMS.setAntiAliasingEnabled(true);
            this.taCommentsInRDBMS.setFont(this.tfName.getFont());
            this.pnCommentsInRDBMS.add(new JScrollPane((Component)this.taCommentsInRDBMS));
        }
        return this.pnCommentsInRDBMS;
    }

    protected JPanel createPage(String title) {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel(title);
        lb.setPreferredSize(new Dimension((int)lb.getPreferredSize().getWidth(), 22));
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    protected void addItemToGeneralPanel(Component component) {
        this.pnGeneralML.add(component);
    }

    protected void addItemToGeneralPanel(Component component, Object constraints) {
        this.pnGeneralML.add(component, constraints);
    }

    protected void initLayout() {
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(this.getMinimumTreeWidth(), 0));
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        splitPane.setDividerLocation(this.getMinimumTreeWidth());
        splitPane.setDividerSize(3);
        JPanel buttonsPanel = new JPanel();
        if (this.isEditable()) {
            JButton bnOK = new JButton("OK");
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            buttonsPanel.add(bnOK);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton("Apply");
            bnApply.addActionListener(new ApplyAction());
            bnApply.setMnemonic(65);
            buttonsPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? "Cancel" : "Close");
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        buttonsPanel.add(this.bnCancel);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
    }

    protected int getMinimumWidth() {
        return this.minWidth;
    }

    protected int getMinimumHeight() {
        return this.minHeight;
    }

    protected int getMinimumTreeWidth() {
        return 150;
    }

    protected void showHelp() {
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AbstractStorageObjectPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                AbstractStorageObjectPropertiesDialog.this.showComponent((Component)obj);
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AbstractStorageObjectPropertiesDialog.this.canExit()) {
                    AbstractStorageObjectPropertiesDialog.this.setProperties();
                    String status = AbstractStorageObjectPropertiesDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractStorageObjectPropertiesDialog.this.storageObject);
                    if (AbstractStorageObjectPropertiesDialog.this.oldObjectStatus != null) {
                        if (!AbstractStorageObjectPropertiesDialog.this.oldObjectStatus.equals(status)) {
                            AbstractStorageObjectPropertiesDialog.this.storageObject.setDirty(true);
                            AbstractStorageObjectPropertiesDialog.this.oldObjectStatus = status;
                        }
                    } else {
                        AbstractStorageObjectPropertiesDialog.this.storageObject.setDirty(true);
                    }
                    AbstractStorageObjectPropertiesDialog.this.storageObject.setShowForFirstTime(false);
                    AbstractStorageObjectPropertiesDialog.this.clearOnDispose();
                    AbstractStorageObjectPropertiesDialog.this.close();
                }
            }
            catch (Exception exc) {
                LOGGER.error("Set properties failed", exc);
            }
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AbstractStorageObjectPropertiesDialog.this.canExit()) {
                    AbstractStorageObjectPropertiesDialog.this.setProperties();
                    AbstractStorageObjectPropertiesDialog.this.postProcessingInApply();
                    String status = AbstractStorageObjectPropertiesDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractStorageObjectPropertiesDialog.this.storageObject);
                    if (AbstractStorageObjectPropertiesDialog.this.oldObjectStatus != null) {
                        if (!AbstractStorageObjectPropertiesDialog.this.oldObjectStatus.equals(status)) {
                            AbstractStorageObjectPropertiesDialog.this.storageObject.setDirty(true);
                            AbstractStorageObjectPropertiesDialog.this.oldObjectStatus = status;
                        }
                    } else {
                        AbstractStorageObjectPropertiesDialog.this.storageObject.setDirty(true);
                    }
                    AbstractStorageObjectPropertiesDialog.this.storageObject.setShowForFirstTime(false);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(AbstractStorageObjectPropertiesDialog.this.getCaption()).append(" - ").append(AbstractStorageObjectPropertiesDialog.this.tfName.getText());
                    AbstractStorageObjectPropertiesDialog.this.setTitle(buffer.toString());
                }
            }
            catch (Exception exc) {
                LOGGER.error("Apply properties failed", exc);
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractStorageObjectPropertiesDialog.this.clearOnDispose();
            AbstractStorageObjectPropertiesDialog.this.onCancel();
            AbstractStorageObjectPropertiesDialog.this.dispose();
        }
    }
}

