/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.admin.DesignLevelSettingsPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.SearchablePanel;
import oracle.dbtools.crest.swingui.editor.SearchableTreeHelper;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class DesignPropertiesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private JDialog dialog;
    private JPanel pnGeneral;
    private JPanel buttonPanel;
    private final Design design;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected JTextArea taNotes;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    private Dimension defaultSize = new Dimension(150, 20);
    private JPanel pnMain;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnComments;
    private JPanel pnNotes;
    private JPanel pnSummary;
    private JTree tree;
    private DefaultMutableTreeNode root;
    private TreeModel _savedModel;
    private JComboBox cbModelPersistence;
    private String oldObjectStatus;
    private String treePath = "";
    private DesignLevelSettingsPropertiesDialog designLevelSettingsPropertiesDialog;
    private static final Logger LOGGER = new Logger(DesignPropertiesDialog.class);

    public DesignPropertiesDialog(ApplicationView appView, Design design) {
        super(appView);
        this.design = design;
        this.designLevelSettingsPropertiesDialog = new DesignLevelSettingsPropertiesDialog(appView, design);
        CommonUtil.centerOnScreen(this.getDialog());
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(170, 0));
        JPanel jpanel = new JPanel(new BorderLayout());
        SearchField searchField = new SearchField();
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                String text = se.isFromClear() ? "" : se.getSearchText();
                DesignPropertiesDialog.this._savedModel = SearchableTreeHelper.applyTreeFilter(DesignPropertiesDialog.this.tree, DesignPropertiesDialog.this._savedModel, DesignPropertiesDialog.this.root, text);
            }

            public void searchCategoryChanged(SearchEvent arg0) {
            }
        });
        searchField.setKeyEventTargetComponent((Component)this.tree);
        jpanel.add((Component)searchField, "North");
        jpanel.add((Component)scrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(1, jpanel, this.getMainPanel());
        splitPane.setDividerLocation(150);
        splitPane.setDividerSize(3);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        String treePath = TreeUtils.createFilePath(this.getTree().getSelectionPath());
        this.design.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle, treePath);
        this.design.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    protected int getMinimumWidth() {
        return 650;
    }

    protected int getMinimumHeight() {
        return 550;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), MessageFormat.format(Messages.getString("DesignPropertiesDialog.DesignProperties"), this.design.getName()));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DesignPropertiesDialog.this.dialog.getWidth();
                    int h = DesignPropertiesDialog.this.dialog.getHeight();
                    w = Math.max(DesignPropertiesDialog.this.getMinimumWidth(), w);
                    h = Math.max(DesignPropertiesDialog.this.getMinimumHeight(), h);
                    DesignPropertiesDialog.this.dialog.setSize(w, h);
                }
            });
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            Settings.DialogSettings ds = this.design.getAppView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(ds.rec.getSize());
                this.dialog.setLocation(ds.rec.getLocation());
                this.treePath = ds.treePath;
            }
        }
        return this.dialog;
    }

    public void showDialog() {
        this.getDialog();
        if (this.treePath.length() > 0) {
            String[] names = this.treePath.split("/");
            TreePath tp = TreeUtils.findByName(this.getTree(), names);
            if (tp != null) {
                this.getTree().setSelectionPath(tp);
            }
        }
        this.design.setDialogVisible(true, (JDialog)this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_PROPERTIES_DIALOG";
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected JTree getTree() {
        if (this.tree == null) {
            this.root = new DefaultMutableTreeNode("");
            this.tree = new JTree(this.root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(this.root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    protected DefaultMutableTreeNode addToTree(DefaultMutableTreeNode node, JPanel panel) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(panel);
        node.add(child);
        this.getMainPanel().add((Component)panel, panel.getName());
        if (panel instanceof SearchablePanel) {
            ((SearchablePanel)panel).initSearchTags(panel.getName());
        }
        return child;
    }

    protected void initTree(DefaultMutableTreeNode root) {
        try {
            this.addToTree(root, this.getGeneralPanel());
            DefaultMutableTreeNode settingsNode = this.addToTree(root, this.designLevelSettingsPropertiesDialog.getSettingsPanel());
            this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getCompareMappingsPanel());
            DefaultMutableTreeNode diagramNode = this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getDiagramPanel());
            this.addToTree(diagramNode, this.designLevelSettingsPropertiesDialog.getDiagramClassificationTypesPanel());
            this.addToTree(diagramNode, this.designLevelSettingsPropertiesDialog.getDiagramFormatPanel());
            this.addToTree(diagramNode, this.designLevelSettingsPropertiesDialog.getDiagramLogicalPanel());
            DefaultMutableTreeNode settingsDDLNode = this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getDDLPanel());
            this.addToTree(settingsDDLNode, this.designLevelSettingsPropertiesDialog.getDDLMIgrationPanel());
            DefaultMutableTreeNode nsNode = this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardPanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardAttributePanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardColumnPanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardDomainPanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardEntityPanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardTablePanel());
            this.addToTree(nsNode, this.designLevelSettingsPropertiesDialog.getNamingStandardTemplatesPanel());
            this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getDynamicPropertiesPanel());
            this.addToTree(settingsNode, this.designLevelSettingsPropertiesDialog.getUserDefinedPropertiesPanel());
            this.addToTree(root, this.getCommentsPanel());
            this.addToTree(root, this.getNotesPanel());
            this.addToTree(root, this.getSummaryPanel());
            this.taComments.setText(this.design.getComment());
            this.taNotes.setText(this.design.getNotes());
            this.tfObjectID.setText(this.design.getDesignID());
            this.tfCreationTime.setText(this.design.getCreationTime());
            this.tfCreator.setText(this.design.getCreator().getName());
            this.tfLastChangedBy.setText(this.design.getChanger().getName());
            this.tfLastChangedTime.setText(this.design.getChangeTime());
        }
        catch (Exception e) {
            LOGGER.error("DesignPropertiesDialog. Unable to init tree: ", e);
        }
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("DesignPropertiesDialog.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("DesignPropertiesDialog.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("DesignPropertiesDialog.Summary"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbObjectID = new JLabel(LB_OBJECT_ID);
            lbObjectID.setPreferredSize(this.defaultSize);
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.defaultSize);
            this.tfObjectID.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbObjectID, this.tfObjectID));
            JLabel lbCreator = new JLabel(LB_CREATOR);
            lbCreator.setPreferredSize(this.defaultSize);
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.defaultSize);
            this.tfCreator.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbCreator, this.tfCreator));
            JLabel lbCreationTime = new JLabel(LB_CREATION_TIME);
            lbCreationTime.setPreferredSize(this.defaultSize);
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.defaultSize);
            this.tfCreationTime.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbCreationTime, this.tfCreationTime));
            JLabel lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
            lbLastChangedBy.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbLastChangedBy, this.tfLastChangedBy));
            JLabel lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
            lbLastChangedTime.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbLastChangedTime, this.tfLastChangedTime));
            jpanel.add((Component)pnSummaryGrid, "North");
            this.pnSummary.add((Component)jpanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createPage(String title) {
        SearchablePanel panel = new SearchablePanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel("<html><body><b>" + title + "</b></body></html>");
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    @Override
    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("DesignPropertiesDialog.General"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(false);
            pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            lbName = new JLabel(LB_MODEL_PERSISTENCE);
            lbName.setPreferredSize(this.defaultSize);
            this.cbModelPersistence = this.design.isVersioned() ? new JComboBox<String>(Design.PESITENCE_CHOICES_VERSIONED) : new JComboBox<String>(Design.PESITENCE_CHOICES);
            this.cbModelPersistence.setPreferredSize(this.defaultSize);
            pnGeneralGrid.add(this.createRow(lbName, this.cbModelPersistence));
            jpanel.add((Component)pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            if (this.isEditable()) {
                JButton ok = new JButton(Messages.getString("DesignPropertiesDialog.OK"));
                ok.setMnemonic(79);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            DesignPropertiesDialog.this.onApply_OK();
                            DesignPropertiesDialog.this.close();
                        }
                        catch (Exception exp) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, exp.getMessage(), "", 0);
                        }
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
                JButton apply = new JButton(Messages.getString("DesignPropertiesDialog.Apply"));
                apply.setMnemonic(65);
                apply.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            DesignPropertiesDialog.this.onApply_OK();
                        }
                        catch (Exception exp) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, exp.getMessage(), "", 0);
                        }
                    }
                });
                apply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(apply);
            }
            JButton cancel = new JButton(this.isEditable() ? Messages.getString("DesignPropertiesDialog.Cancel") : Messages.getString("DesignPropertiesDialog.Close"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            this.buttonPanel.add(cancel);
            this.buttonPanel.add(btnHelp);
        }
        return this.buttonPanel;
    }

    public void initProperties(boolean manualInit) {
        try {
            this.oldObjectStatus = this.design.getAppView().getXMLTransformationManager().getFilteredXMLString(this.design);
            this.tfName.setText(this.design.getName());
            this.cbModelPersistence.setSelectedItem(this.design.getModelPersistenceChoice());
            this.designLevelSettingsPropertiesDialog.initProperties(false, this.design);
        }
        catch (Exception e) {
            LOGGER.error("Unable to init design properties: ", e);
        }
    }

    private void setProperties() {
        try {
            if ("".equalsIgnoreCase(this.tfName.getText())) {
                this.tfName.requestFocus();
                throw new EmptyFieldException("Name can not be empty!");
            }
            this.design.setName(this.tfName.getText());
            this.design.setModelPersistenceChoice((String)this.cbModelPersistence.getSelectedItem());
            this.designLevelSettingsPropertiesDialog.setProperties();
            this.design.setComment(this.taComments.getText());
            this.design.setNotes(this.taNotes.getText());
            for (DesignPartView dpv : this.design.getAllDPVs()) {
                dpv.updateLegendSize();
            }
            this.designLevelSettingsPropertiesDialog.setProperties();
        }
        catch (Exception e) {
            LOGGER.error("Unable to set design properties: ", e);
        }
    }

    @Override
    protected boolean isEditable() {
        if (this.design.isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER;
    }

    public final int getPreferredIconSize() {
        return 16;
    }

    private void onApply_OK() {
        this.setProperties();
        String status = this.design.getAppView().getXMLTransformationManager().getFilteredXMLString(this.design);
        if (this.oldObjectStatus != null) {
            if (!this.oldObjectStatus.equals(status)) {
                this.design.setDirty(true);
                this.oldObjectStatus = status;
            }
        } else {
            this.design.setDirty(true);
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)DesignPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                DesignPropertiesDialog.this.cardLayout.show(DesignPropertiesDialog.this.getMainPanel(), ((Component)obj).getName());
            }
        }
    }

    class PNameCellEditor
    extends DefaultCellEditor {
        public PNameCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }
}

