/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.logical.ArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.ArcView;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class ArcRenderer
extends JComponent
implements CellViewRenderer {
    private Arc arc;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient ArcView view;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof ArcView) {
            ArcDiagramCell arcCell = (ArcDiagramCell)view.getCell();
            this.arc = arcCell.getArc();
            this.view = (ArcView)view;
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            if (view.isLeaf()) {
                this.installAttributes(view);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            return this;
        }
        return null;
    }

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    void setView(CellView value) {
        if (value instanceof ArcView) {
            this.view = (ArcView)value;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        Color foreground = DiagramConstants.getLineColor(map);
        this.setForeground(foreground != null ? foreground : this.defaultForeground);
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics g) {
        try {
            Dimension dim = this.getSize();
            int width = dim.width;
            int height = dim.height;
            Point location = this.getLocation();
            if (this.selected) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.BLACK);
            }
            Rectangle bounds = new Rectangle(location.x + 3, location.y + 3, width - 7, height - 7);
            if (this.view != null) {
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                for (Relation relation : this.arc.getRelations()) {
                    Point2D p2;
                    TVRelation tv = (TVRelation)relation.getViewFor(this.getDesignPartView());
                    if (tv == null) continue;
                    EdgeView edgeView = (EdgeView)tv.getCellView();
                    Point2D p1 = edgeView.getPoint(0);
                    if (bounds.contains(p1)) {
                        p2 = edgeView.getPoint(1);
                    } else {
                        int j = edgeView.getPointCount();
                        p1 = edgeView.getPoint(j - 1);
                        p2 = edgeView.getPoint(j - 2);
                    }
                    Point2D p = this.getRelationPoint(bounds, p1, p2);
                    if (p == null && edgeView.getPointCount() > 2) {
                        if (bounds.contains(edgeView.getPoint(0))) {
                            p1 = edgeView.getPoint(1);
                            p2 = edgeView.getPoint(2);
                        } else {
                            int j = edgeView.getPointCount();
                            p1 = edgeView.getPoint(j - 2);
                            p2 = edgeView.getPoint(j - 3);
                        }
                        p = this.getRelationPoint(bounds, p1, p2);
                    }
                    if (p == null) continue;
                    points.add(p);
                    double x = 0.0;
                    double y = 0.0;
                    x = p.getX() - (double)location.x - 2.0;
                    y = p.getY() - (double)location.y - 2.0;
                    g.fillOval((int)x, (int)y, 5, 5);
                }
                this.drawArc((Graphics2D)g, points, bounds);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    private void drawArc(Graphics2D g2, List points, Rectangle bounds) {
        Point location = this.getLocation();
        GeneralPath path = new GeneralPath();
        Rectangle r = this.getBounds();
        Line2D line = this.getFirstAndLastPoints(points, r);
        Point2D first = line.getP1();
        Point2D last = line.getP2();
        float p1x = (float)first.getX() - (float)location.x;
        float p1y = (float)first.getY() - (float)location.y;
        float pnx = (float)last.getX() - (float)location.x;
        float pny = (float)last.getY() - (float)location.y;
        int angleSize = 14;
        int arcSize = 10;
        float x = bounds.width + 3;
        float y = bounds.height + 3;
        int p1Side = this.getPointSide(bounds, first);
        int pnSide = this.getPointSide(bounds, last);
        if (p1Side == 2) {
            path.moveTo(p1x - (float)arcSize, p1y - (float)(arcSize * 2));
            path.curveTo(p1x - (float)arcSize, p1y - (float)(arcSize * 2), p1x, p1y - (float)(arcSize * 2), p1x, p1y - (float)arcSize);
            if (p1Side == pnSide) {
                path.lineTo(pnx, pny + (float)arcSize);
                path.curveTo(pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
            } else {
                path.lineTo(p1x, y - (float)angleSize);
                path.curveTo(p1x, y - (float)angleSize, p1x, y, p1x - (float)angleSize, y);
                if (pnSide == 3) {
                    path.lineTo(pnx - (float)arcSize, pny);
                    path.curveTo(pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else if (pnSide == 0) {
                    path.lineTo(pnx + (float)angleSize, y);
                    path.curveTo(pnx + (float)angleSize, y, pnx, y, pnx, y - (float)angleSize);
                    path.lineTo(pnx, pny - (float)arcSize);
                    path.curveTo(pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else {
                    path.lineTo(3 + angleSize, y);
                    path.curveTo(3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    path.lineTo(3.0f, 3 + angleSize);
                    path.curveTo(3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    path.lineTo(pnx + (float)arcSize, pny);
                    path.curveTo(pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                }
            }
        } else if (p1Side == 3) {
            path.moveTo(p1x + (float)(arcSize * 2), p1y - (float)arcSize);
            path.curveTo(p1x + (float)(arcSize * 2), p1y - (float)arcSize, p1x + (float)(arcSize * 2), p1y, p1x + (float)arcSize, p1y);
            if (p1Side == pnSide) {
                path.lineTo(pnx - (float)arcSize, pny);
                path.curveTo(pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
            } else {
                path.lineTo(angleSize + 3, y);
                path.curveTo(angleSize + 3, y, 3.0f, y, 3.0f, y - (float)angleSize);
                if (pnSide == 0) {
                    path.lineTo(pnx, pny - (float)arcSize);
                    path.curveTo(pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else if (pnSide == 1) {
                    path.lineTo(3.0f, pny + (float)angleSize);
                    path.curveTo(3.0f, pny + (float)angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    path.lineTo(pnx + (float)arcSize, pny);
                    path.curveTo(pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else {
                    path.lineTo(3.0f, 3 + angleSize);
                    path.curveTo(3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    path.lineTo(x - (float)angleSize, 3.0f);
                    path.curveTo(x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    path.lineTo(pnx, pny + (float)arcSize);
                    path.curveTo(pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                }
            }
        } else if (p1Side == 0) {
            path.moveTo(p1x + (float)arcSize, p1y + (float)(arcSize * 2));
            path.curveTo(p1x + (float)arcSize, p1y + (float)(arcSize * 2), p1x, p1y + (float)(arcSize * 2), p1x, p1y + (float)arcSize);
            if (p1Side == pnSide) {
                path.lineTo(pnx, pny - (float)arcSize);
                path.curveTo(pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
            } else {
                path.lineTo(3.0f, angleSize);
                path.curveTo(3.0f, angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                if (pnSide == 1) {
                    path.lineTo(pnx + (float)arcSize, pny);
                    path.curveTo(pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else if (pnSide == 2) {
                    path.lineTo(x - (float)angleSize, 3.0f);
                    path.curveTo(x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    path.lineTo(pnx, pny + (float)arcSize);
                    path.curveTo(pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else {
                    path.lineTo(x - (float)angleSize, 3.0f);
                    path.curveTo(x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    path.lineTo(x, y - (float)angleSize);
                    path.curveTo(x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    path.lineTo(pnx - (float)arcSize, pny);
                    path.curveTo(pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                }
            }
        } else {
            path.moveTo(p1x - (float)(arcSize * 2), 3 + arcSize);
            path.curveTo(p1x - (float)(arcSize * 2), 3 + arcSize, p1x - (float)(arcSize * 2), 3.0f, p1x - (float)arcSize, 3.0f);
            if (p1Side == pnSide) {
                path.lineTo(pnx + (float)arcSize, pny);
                path.curveTo(pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
            } else {
                path.lineTo(x - (float)angleSize, 3.0f);
                path.curveTo(x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                if (pnSide == 2) {
                    path.lineTo(pnx, pny + (float)arcSize);
                    path.curveTo(pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else if (pnSide == 3) {
                    path.lineTo(x, y - (float)angleSize);
                    path.curveTo(x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    path.lineTo(pnx - (float)arcSize, pny);
                    path.curveTo(pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else {
                    path.lineTo(x, y - (float)angleSize);
                    path.curveTo(x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    path.lineTo(3 + angleSize, y);
                    path.curveTo(3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    path.lineTo(pnx, pny - (float)arcSize);
                    path.curveTo(pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                }
            }
        }
        g2.draw(path);
    }

    private Line2D getFirstAndLastPoints(List points, Rectangle bounds) {
        TreeMap<Double, Point2D.Double> map = new TreeMap<Double, Point2D.Double>();
        for (Point2D.Double p : points) {
            double degree = this.getDegree(p, bounds);
            map.put(new Double(degree), p);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<Object> it = map.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        int f = 0;
        int l = list.size() - 1;
        Double fd = (Double)list.get(f);
        Double ld = (Double)list.get(l);
        double d1 = fd;
        double d2 = ld;
        int w = 361;
        while (d2 - d1 > 180.0) {
            ++l;
            if (++f >= list.size()) {
                f = 0;
                --w;
            }
            if (l >= list.size()) {
                l = 0;
            }
            fd = (Double)list.get(f);
            ld = (Double)list.get(l);
            d1 = fd;
            if (!(d1 > (d2 = ld.doubleValue()))) continue;
            d2 += (double)w;
        }
        Point2D first = (Point2D)map.get(fd);
        Point2D last = (Point2D)map.get(ld);
        return new Line2D.Float(first, last);
    }

    private double getDegree(Point2D p, Rectangle bounds) {
        double dx = p.getX() - bounds.getCenterX();
        double dy = p.getY() - bounds.getCenterY();
        double alpha = Math.atan2(dy, dx);
        double d = Math.toDegrees(alpha);
        if (d < 0.0) {
            return d + 360.0;
        }
        return d;
    }

    private int getPointSide(Rectangle bounds, Point2D p) {
        double t;
        double pi;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        if (alpha < -(pi = Math.PI) + (t = Math.atan2(height, width)) || alpha > pi - t) {
            return 0;
        }
        if (alpha < -t) {
            return 1;
        }
        if (alpha < t) {
            return 2;
        }
        return 3;
    }

    public Point2D getRelationPoint(Rectangle bounds, Point2D p1, Point2D p2) {
        double sy;
        Line2D.Double relationLine;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Line2D.Double line = new Line2D.Double(x, y, x, y + height);
        if (!(line.intersectsLine(relationLine = new Line2D.Double(p1, p2)) || (line = new Line2D.Double(x, y, x + width, y)).intersectsLine(relationLine) || (line = new Line2D.Double(x + width, y, x + width, y + height)).intersectsLine(relationLine) || (line = new Line2D.Double(x, y + height, x + width, y + height)).intersectsLine(relationLine))) {
            return null;
        }
        double px = line.getX1();
        double py = line.getY1();
        double rx = line.getX2() - px;
        double ry = line.getY2() - py;
        double qx = relationLine.getX1();
        double qy = relationLine.getY1();
        double sx = relationLine.getX2() - qx;
        double det = sx * ry - (sy = relationLine.getY2() - qy) * rx;
        if (det == 0.0) {
            return null;
        }
        double z = (sx * (qy - py) + sy * (px - qx)) / det;
        if (z == 0.0 || z == 1.0) {
            return null;
        }
        return new Point2D.Double(px + z * rx, py + z * ry);
    }

    public Point2D getPerimeterPoint(ArcView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public Arc getArc() {
        return this.arc;
    }
}

