/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient AbstractDiagram diagram;
    protected transient PortView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof PortView && diagram != null) {
            this.diagram = diagram;
            this.view = (PortView)view;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            return this;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.diagram.getBackground());
        g.setXORMode(this.diagram.getBackground());
        if (this.preview) {
            g.setColor(this.getBackground());
            g.drawRect(1, 1, d.width - 3, d.height - 3);
            g.drawRect(2, 2, d.width - 5, d.height - 5);
        }
        boolean offset = DiagramConstants.getOffset(this.view.getAllAttributes()) != null;
        g.setColor(this.getForeground());
        if (offset) {
            g.fillRect(2, 2, d.width - 3, d.height - 3);
        } else if (!this.preview) {
            g.drawRect(1, 1, d.width - 4, d.height - 4);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

