/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.CompositeRuleHandler;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.domains.RHDomain;
import oracle.dbtools.crest.model.designrules.logical.RHAttribute;
import oracle.dbtools.crest.model.designrules.logical.RHEntity;
import oracle.dbtools.crest.model.designrules.logical.RHEntityView;
import oracle.dbtools.crest.model.designrules.logical.RHKey;
import oracle.dbtools.crest.model.designrules.process.RHAgent;
import oracle.dbtools.crest.model.designrules.process.RHFlow;
import oracle.dbtools.crest.model.designrules.process.RHProcess;
import oracle.dbtools.crest.model.designrules.process.RHStore;
import oracle.dbtools.crest.model.designrules.process.RHTransformation;
import oracle.dbtools.crest.model.designrules.process.RHTransformationTask;
import oracle.dbtools.crest.model.designrules.relational.RHColumn;
import oracle.dbtools.crest.model.designrules.relational.RHIndex;
import oracle.dbtools.crest.model.designrules.relational.RHTable;
import oracle.dbtools.crest.model.designrules.relational.RHTableLevelConstraint;
import oracle.dbtools.crest.model.designrules.relational.RHView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.designrules.CheckResultComponent;
import oracle.dbtools.crest.swingui.designrules.DRMCellRenderer;
import oracle.dbtools.crest.swingui.designrules.DesignRuleManagerTreeModel;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSetPropertiesDialog;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class DesignRuleView
extends CustomDialog
implements ActionListener {
    private static final long serialVersionUID = 8407946894969410152L;
    private static final String RULESET_NAME = "RuleSet";
    private CheckResultComponent checkResultComponent;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private DesignRuleManagerTreeModel treeModel;
    private JTree jtree;
    private JDialog dialog;
    private RelationalDesign relationalModel;
    private LogicalDesign logicalModel;
    private ProcessModel processModel;
    private Action applySelectedAction;
    private JPanel mainPanel;
    private JPanel designRulesPanel;
    private int cgCounter = 0;
    public List<DesignRuleSet> ruleSetsContainerList;
    private JTable ruleSetsTable;
    private RuleSetTableModel rstm;
    private JButton btnAddRuleSet;
    private JButton btnRemoveRuleSet;
    private JButton btnProperties;
    private JSearchTextField ruleSetNamefilter;
    private TableRowSorter ruleSetSorter;
    private DesignRuleSet currentRuleSet;
    protected static Settings settings;
    private JButton bnApplySelectedRuleSets;
    private JButton bnApplyAllRuleSets;
    private JButton bnApplySelected;
    public JButton bnSaveRuleSets;
    private ApplicationView appView;
    private JSplitPane splitPane;
    private JTabbedPane tpane;
    private JPanel buttonPanel;
    public boolean ruleSetsSaved = true;
    private JButton bnApplyAll;
    private List objectsList;
    private ArrayList<DRCustomScript> tempListCustomDR = new ArrayList();
    private TreeMap<String, Object> objects = new TreeMap();

    public DesignRuleView(ApplicationView appView, ModelIDObject model, List objectsList) {
        super(appView);
        this.appView = appView;
        this.objectsList = objectsList;
        if (model instanceof RelationalDesign) {
            this.relationalModel = (RelationalDesign)model;
        } else if (model instanceof LogicalDesign) {
            this.logicalModel = (LogicalDesign)model;
        } else if (model instanceof ProcessModel) {
            this.processModel = (ProcessModel)model;
        }
        appView.loadCustomDRScripts();
        this.setLayout(new BorderLayout());
        if (settings == null) {
            settings = this.getApplicationView().getSettings();
        }
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    public void close(Window dialog) {
        this.getDesign().getDesignLevelSettings().getNamingStandardRule().clearGlossaries();
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        settings.setDialogSettings(this.getClass().getName(), rectangle);
        this.nullifyDesignRuleManager();
        dialog.dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_RULES_DIALOG";
    }

    public DesignRuleManager getRuleManager() {
        if (this.relationalModel != null) {
            return this.getDesign().getAppView().getDesignRuleManager(this.relationalModel, this.objectsList);
        }
        if (this.logicalModel != null) {
            return this.getDesign().getAppView().getDesignRuleManager(this.logicalModel, this.objectsList);
        }
        if (this.processModel != null) {
            return this.getDesign().getAppView().getDesignRuleManager(this.processModel, this.objectsList);
        }
        return null;
    }

    public CheckResultComponent getCheckResultComponent() {
        if (this.checkResultComponent == null) {
            this.checkResultComponent = new CheckResultComponent(this.appView);
        }
        return this.checkResultComponent;
    }

    public DesignRuleManagerTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new DesignRuleManagerTreeModel(this.getRuleManager());
            this.getRuleManager().addUpdateListener(this.treeModel);
        }
        return this.treeModel;
    }

    public JTree getJTree() {
        if (this.jtree == null) {
            this.jtree = new JTree(this.getTreeModel());
            this.jtree.setRootVisible(true);
            this.jtree.addTreeSelectionListener(new TreeListener());
            this.jtree.setCellRenderer(new DRMCellRenderer());
        }
        return this.jtree;
    }

    public Action createExpandAll() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ExpandAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row = 0; row < DesignRuleView.this.getJTree().getRowCount(); ++row) {
                    DesignRuleView.this.getJTree().expandRow(row);
                }
            }
        };
        return action;
    }

    public Action createCollapseAll() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.CollapseAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row = DesignRuleView.this.getJTree().getRowCount(); row >= 1; --row) {
                    DesignRuleView.this.getJTree().collapseRow(row);
                }
            }
        };
        return action;
    }

    public Action createApplyAllRules() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplyAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignRuleView.this.setCheckResults(DesignRuleView.this.getRuleManager().applyRulesToSubject(), DesignRuleView.this.getRuleManager().res);
            }
        };
        return action;
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DesignRuleView.this.canClose()) {
                    DesignRuleView.this.close();
                }
            }
        };
        return action;
    }

    public Action createApplySelectedRules() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplySelected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                List ruleHandlers = DesignRuleView.this.getSelectedRuleHandlers();
                if (ruleHandlers.size() > 0) {
                    ArrayList checkResults = new ArrayList();
                    for (Object obj : ruleHandlers) {
                        if (obj instanceof RuleHandler) {
                            RuleHandler rh = (RuleHandler)obj;
                            rh.hasEvalErr = false;
                            rh.applyRulesToSubject(checkResults);
                            if (!rh.hasEvalErr) continue;
                            res = true;
                            break;
                        }
                        if (!(obj instanceof DesignRule)) continue;
                        DesignRule rule = (DesignRule)obj;
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        break;
                    }
                    DesignRuleView.this.setCheckResults(checkResults, res);
                }
            }
        };
        action.setEnabled(false);
        return action;
    }

    public Action createApplySelectedRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplySelecteRuleSet")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                ArrayList checkResults = new ArrayList();
                int[] selectedRows = DesignRuleView.this.ruleSetsTable.getSelectedRows();
                block0: for (int i = 0; i < selectedRows.length; ++i) {
                    int sel = selectedRows[i];
                    DesignRuleSet current = DesignRuleView.this.ruleSetsContainerList.get(DesignRuleView.this.ruleSetsTable.convertRowIndexToModel(sel));
                    for (DesignRule rule : current.getDesignRules()) {
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(checkResults, res);
            }
        };
        action.setEnabled(false);
        return action;
    }

    public Action createApplyAllRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.ApplyAllRS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean res = false;
                ArrayList checkResults = new ArrayList();
                block0: for (DesignRuleSet drs : DesignRuleView.this.ruleSetsContainerList) {
                    for (DesignRule rule : drs.getDesignRules()) {
                        RuleHandler rh = rule.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, rule);
                        if (!rh.hasEvalErr) continue;
                        res = true;
                        continue block0;
                    }
                }
                DesignRuleView.this.setCheckResults(checkResults, res);
            }
        };
        action.setEnabled(false);
        return action;
    }

    public void setCheckResults(Collection checkResults, boolean hasExecutionErr) {
        this.getCheckResultComponent().clearCheckResults();
        if (checkResults.size() > 0) {
            this.getCheckResultComponent().add(checkResults.toArray(new CheckResult[0]));
            this.getCheckResultComponent().bnSaveCSV.setEnabled(true);
            this.getCheckResultComponent().bnClearAll.setEnabled(true);
        } else if (!hasExecutionErr) {
            JOptionPane.showMessageDialog(this, Messages.getString("DesignRuleView.CheckDesignOK"));
        }
    }

    public List getSelectedRuleHandlers() {
        ArrayList<Object> result = new ArrayList<Object>();
        TreePath[] paths = this.getJTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object item = paths[i].getLastPathComponent();
                if (!(item instanceof RuleHandler) && !(item instanceof DesignRule)) continue;
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.setDefaultActions(this.dialog);
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                this.dialog.setSize(800, 800);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(ds.rec.getSize());
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    public Window getDialog(Dialog parent) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, Messages.getString("DesignRuleView.DesignRules"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 800);
            this.dialog.setModal(true);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.mainPanel);
            this.tpane = new JTabbedPane();
            this.tpane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DesignRuleView.this.showHideButtons();
                }
            });
            this.designRulesPanel = new JPanel();
            this.designRulesPanel.setLayout(new BorderLayout());
            this.designRulesPanel.add((Component)this.tpane, "East");
            this.mainPanel.add((Component)this.designRulesPanel, "Center");
            this.initTreeDesignRules();
            this.initCustomDesignRuleSets();
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DesignRuleView.this.close();
                }
            });
            this.setDefaultActions(this.dialog);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public RelationalDesign getRelDesign() {
        return this.relationalModel;
    }

    private void initCustomDesignRuleSets() {
        this.initRuleSets();
        Iterator<DesignRuleSet> it = settings.getDesignRuleSets().iterator();
        while (it.hasNext()) {
            DesignRuleSet drs = it.next().copy();
            this.ruleSetsContainerList.add(drs);
        }
        if (this.ruleSetsContainerList.size() > 0) {
            this.ruleSetSorter = new TableRowSorter<TableModel>(this.ruleSetsTable.getModel());
            this.ruleSetSorter.setSortsOnUpdates(true);
            this.ruleSetsTable.setRowSorter(this.ruleSetSorter);
            this.ruleSetsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.ruleSetsTable, 0);
        }
        this.bnApplyAllRuleSets.setEnabled(this.ruleSetsContainerList.size() > 0);
    }

    private void initRuleSets() {
        JPanel rsPanel = new JPanel(new BorderLayout());
        this.ruleSetsContainerList = new ArrayList<DesignRuleSet>();
        this.rstm = new RuleSetTableModel();
        this.ruleSetsTable = new JTable(this.rstm);
        this.ruleSetsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.ruleSetsTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.ruleSetsTable.getColumnModel().getColumn(1);
        col1.setWidth(300);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DesignRuleView.this.ruleSetsSaved = false;
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
            }
        });
        this.ruleSetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleView.this.ruleSetsTable.getSelectedRow() == -1) {
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                    DesignRuleView.this.btnProperties.setEnabled(false);
                } else {
                    DesignRuleView.this.currentRuleSet = DesignRuleView.this.ruleSetsContainerList.get(DesignRuleView.this.ruleSetsTable.convertRowIndexToModel(DesignRuleView.this.ruleSetsTable.getSelectedRow()));
                    DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                    DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                    DesignRuleView.this.btnProperties.setEnabled(true);
                }
            }
        });
        this.ruleSetsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignRuleView.this.stopCellediting();
                    DesignRuleSetPropertiesDialog dialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this);
                    dialog.showDialog();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.ruleSetsTable);
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnSaveRuleSets = new JButton(this.createSaveRuleSets());
        this.bnSaveRuleSets.setToolTipText(Messages.getString("DesignRuleView.SaveRuleSets"));
        this.bnSaveRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnSaveRuleSets);
        rsPanel.add((Component)this.createRuleSetToolbarPanel(this.ruleSetsTable), "North");
        rsPanel.add((Component)scrollPane, "Center");
        rsPanel.add((Component)btnPanel, "South");
        this.tpane.addTab(Messages.getString("DesignRuleView.RuleSets"), rsPanel);
    }

    private void initTreeDesignRules() {
        JPanel treePanel = new JPanel(new BorderLayout());
        JPanel treeButtons = new JPanel(new FlowLayout(0));
        JButton expandAll = new JButton(this.createExpandAll());
        expandAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        expandAll.setToolTipText(Messages.getString("DesignRuleView.ExpandAllT"));
        expandAll.setMnemonic(69);
        JButton collapseAll = new JButton(this.createCollapseAll());
        collapseAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        collapseAll.setToolTipText(Messages.getString("DesignRuleView.CollapseAllT"));
        collapseAll.setMnemonic(79);
        treeButtons.add(expandAll);
        treeButtons.add(collapseAll);
        treePanel.add((Component)treeButtons, "North");
        treePanel.add(new JScrollPane(this.getJTree()));
        this.splitPane = new JSplitPane(1, this.tpane, this.getCheckResultComponent());
        this.splitPane.setDividerLocation(350);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.bnApplyAll = new JButton(this.createApplyAllRules());
        this.bnApplyAll.setToolTipText(Messages.getString("DesignRuleView.ApplyAllDesignRules"));
        this.bnApplyAll.setMnemonic(65);
        this.applySelectedAction = this.createApplySelectedRules();
        this.bnApplySelected = new JButton(this.applySelectedAction);
        this.bnApplySelected.setToolTipText(Messages.getString("DesignRuleView.ApplyTreeSelectedDesignRules"));
        this.bnApplySelected.setMnemonic(83);
        this.bnApplySelectedRuleSets = new JButton(this.createApplySelectedRuleSets());
        this.bnApplySelectedRuleSets.setMnemonic(69);
        this.bnApplySelectedRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplySelectedRuleSets"));
        this.bnApplyAllRuleSets = new JButton(this.createApplyAllRuleSets());
        this.bnApplyAllRuleSets.setMnemonic(80);
        this.bnApplyAllRuleSets.setToolTipText(Messages.getString("DesignRuleView.ApplyAllRuleSets"));
        JButton bnClose = new JButton(this.closeAction());
        bnClose.setToolTipText(Messages.getString("DesignRuleView.CloseDialog"));
        bnClose.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("DesignRuleView.Help"));
        bnHelp.setMnemonic(72);
        this.bnApplyAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnApplySelected.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplySelectedRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.bnApplyAllRuleSets.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonPanel.add(this.bnApplyAll);
        this.buttonPanel.add(this.bnApplyAllRuleSets);
        this.buttonPanel.add(this.bnApplySelected);
        this.buttonPanel.add(this.bnApplySelectedRuleSets);
        this.buttonPanel.add(bnClose);
        this.buttonPanel.add(bnHelp);
        this.designRulesPanel.add((Component)this.buttonPanel, "South");
        this.designRulesPanel.add((Component)this.splitPane, "Center");
        this.tpane.addTab(Messages.getString("DesignRuleView.DesignRules"), treePanel);
        this.getDesign().getDesignLevelSettings().getNamingStandardRule().clearGlossaries();
    }

    protected JPanel createRuleSetToolbarPanel(JTable jTable) {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddRuleSet = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddRuleSet.setToolTipText(Messages.getString("DesignRuleView.AddRuleSet"));
        this.btnAddRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DesignRuleView.this.ruleSetNamefilter.setText("");
                if (DesignRuleView.this.ruleSetSorter != null) {
                    DesignRuleView.this.ruleSetSorter.setSortKeys(null);
                    DesignRuleView.this.ruleSetsTable.setRowSorter(null);
                }
                DesignRuleSet rs = new DesignRuleSet(DesignRuleView.this.generateRuleSetName(), null);
                DesignRuleView.this.ruleSetsContainerList.add(rs);
                DesignRuleView.this.ruleSetsTable.updateUI();
                if (DesignRuleView.this.ruleSetSorter != null) {
                    DesignRuleView.this.ruleSetsTable.setRowSorter(DesignRuleView.this.ruleSetSorter);
                    DesignRuleView.this.ruleSetsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(DesignRuleView.this.ruleSetsTable, 0);
                } else {
                    DesignRuleView.this.ruleSetSorter = new TableRowSorter<TableModel>(DesignRuleView.this.ruleSetsTable.getModel());
                    DesignRuleView.this.ruleSetSorter.setSortsOnUpdates(true);
                    DesignRuleView.this.ruleSetsTable.setRowSorter(DesignRuleView.this.ruleSetSorter);
                    DesignRuleView.this.ruleSetsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(DesignRuleView.this.ruleSetsTable, 0);
                }
                DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(DesignRuleView.this.ruleSetsTable.getRowCount() - 1, DesignRuleView.this.ruleSetsTable.getRowCount() - 1);
                DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                DesignRuleView.this.ruleSetsSaved = false;
            }
        });
        this.btnRemoveRuleSet = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveRuleSet.setToolTipText(Messages.getString("DesignRuleView.RemoveRuleSet"));
        this.btnRemoveRuleSet.setEnabled(false);
        this.btnRemoveRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(DesignRuleView.this, Messages.getString("DesignRuleView.AreUSureUWantToDelete"), Messages.getString("DesignRuleView.SelectAnOption"), 0);
                if (result == 0) {
                    int[] selectedRows = DesignRuleView.this.ruleSetsTable.getSelectedRows();
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        int sel = selectedRows[i];
                        DesignRuleView.this.rstm.deleteRuleSet(DesignRuleView.this.ruleSetsTable.convertRowIndexToModel(sel));
                    }
                    if (DesignRuleView.this.ruleSetsContainerList.size() > 0) {
                        DesignRuleView.this.btnRemoveRuleSet.setEnabled(true);
                        DesignRuleView.this.ruleSetsTable.getSelectionModel().setSelectionInterval(0, 0);
                        DesignRuleView.this.bnApplyAllRuleSets.setEnabled(true);
                        DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(true);
                    } else {
                        DesignRuleView.this.ruleSetsTable.setAutoCreateRowSorter(false);
                        DesignRuleView.this.ruleSetsTable.setRowSorter(null);
                        DesignRuleView.this.btnRemoveRuleSet.setEnabled(false);
                        DesignRuleView.this.btnProperties.setEnabled(false);
                        DesignRuleView.this.bnApplyAllRuleSets.setEnabled(false);
                        DesignRuleView.this.bnApplySelectedRuleSets.setEnabled(false);
                    }
                    DesignRuleView.this.bnSaveRuleSets.setEnabled(true);
                    DesignRuleView.this.ruleSetsSaved = false;
                    DesignRuleView.this.ruleSetsTable.updateUI();
                }
            }
        });
        this.btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", 16));
        this.btnProperties.setToolTipText(Messages.getString("DesignRuleView.RuleSetProperties"));
        this.btnProperties.setEnabled(false);
        this.btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignRuleView.this.stopCellediting();
                DesignRuleSetPropertiesDialog dialog = new DesignRuleSetPropertiesDialog(DesignRuleView.this.appView, DesignRuleView.this.currentRuleSet, DesignRuleView.this);
                dialog.showDialog();
            }
        });
        if (ApplicationView.IS_VIEWER) {
            this.btnAddRuleSet.setEnabled(false);
            this.btnRemoveRuleSet.setEnabled(false);
        }
        this.ruleSetNamefilter = new JSearchTextField(true, true, "Name");
        this.ruleSetNamefilter.setPreferredSize(new Dimension(200, 20));
        this.ruleSetNamefilter.setMinimumSize(new Dimension(200, 20));
        this.ruleSetNamefilter.setMaximumSize(new Dimension(200, 20));
        this.ruleSetNamefilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                DesignRuleView.this.ruleSetFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                DesignRuleView.this.ruleSetFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                DesignRuleView.this.ruleSetFilter();
            }
        });
        toolBar.add(this.btnAddRuleSet);
        toolBar.add(this.btnRemoveRuleSet);
        toolBar.add(this.btnProperties);
        toolBar.addSeparator();
        toolBar.add(this.ruleSetNamefilter);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    private void stopCellediting() {
        TableCellEditor cellEditor = this.ruleSetsTable.getCellEditor();
        if (cellEditor != null) {
            this.ruleSetsTable.getCellEditor().stopCellEditing();
        }
    }

    protected String generateRuleSetName() {
        String name = RULESET_NAME;
        int newNumber = 0;
        int lastNumber = this.ruleSetsContainerList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String ruleSetName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.ruleSetExists(ruleSetName)) {
            newNumber = ++this.cgCounter;
            ruleSetName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return ruleSetName;
    }

    private boolean ruleSetExists(String name) {
        for (int i = 0; i < this.ruleSetsContainerList.size(); ++i) {
            DesignRuleSet ruleSet = this.ruleSetsContainerList.get(i);
            if (!name.equalsIgnoreCase(ruleSet.getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<DesignRule> getAllDesignRules() {
        DesignRule dr;
        ArrayList<DesignRule> rulesList = new ArrayList<DesignRule>();
        CompositeRuleHandler rhGeneral = new CompositeRuleHandler();
        rhGeneral.setLabel(RuleHandler.GENERAL_PATH);
        RHDomain domainRH = new RHDomain();
        domainRH.setRuleSubjectSet(this.getDesign().getDomainSet());
        rhGeneral.add(domainRH);
        for (int i = 0; i <= rhGeneral.size() - 1; ++i) {
            RuleHandler rh = (RuleHandler)rhGeneral.getElement(i);
            for (int n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                rulesList.add(dr);
            }
        }
        this.addObject(domainRH, "Domain");
        CompositeRuleHandler rhRelational = new CompositeRuleHandler();
        rhRelational.setLabel(RuleHandler.RELATIONAL_PATH);
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        if (this.objectsList.size() == 0) {
            if (this.relationalModel != null) {
                Iterator it = this.relationalModel.getTableSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
            }
        } else if (this.objectsList.size() > 0) {
            for (DesignObject obj : this.objectsList) {
                if (!(obj instanceof Table)) continue;
                list.add(obj);
            }
        }
        RHTable tableRH = new RHTable();
        tableRH.setRuleSubjectSet(list);
        rhRelational.add(tableRH);
        RHColumn columnRH = new RHColumn();
        columnRH.setRuleSubjectSet(list);
        rhRelational.add(columnRH);
        RHIndex indexRH = new RHIndex();
        indexRH.setRuleSubjectSet(list);
        rhRelational.add(indexRH);
        RHTableLevelConstraint constrRH = new RHTableLevelConstraint();
        constrRH.setRuleSubjectSet(list);
        rhRelational.add(constrRH);
        RHView viewRH = new RHView();
        viewRH.setRuleSubjectSet(list);
        rhRelational.add(viewRH);
        for (int i = 0; i <= rhRelational.size() - 1; ++i) {
            RuleHandler rh = (RuleHandler)rhRelational.getElement(i);
            for (int n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                rulesList.add(dr);
            }
        }
        this.addObject(viewRH, "View");
        this.addObject(columnRH, "Column");
        this.addObject(indexRH, "Index/Constraint");
        this.addObject(constrRH, "Table Level Constraint");
        this.addObject(tableRH, "Table");
        CompositeRuleHandler rhLogical = new CompositeRuleHandler();
        rhLogical.setLabel(RuleHandler.LOGICAL_PATH);
        list = new ArrayList();
        if (this.objectsList.size() == 0) {
            if (this.logicalModel != null) {
                Iterator it = this.logicalModel.getEntitySet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
            }
        } else if (this.objectsList.size() > 0) {
            for (DesignObject obj : this.objectsList) {
                if (!(obj instanceof Entity)) continue;
                list.add(obj);
            }
        }
        RHEntity entityRH = new RHEntity();
        entityRH.setRuleSubjectSet(list);
        rhLogical.add(entityRH);
        RHAttribute attributeRH = new RHAttribute();
        attributeRH.setRuleSubjectSet(list);
        rhLogical.add(attributeRH);
        RHKey keyRH = new RHKey();
        keyRH.setRuleSubjectSet(list);
        rhLogical.add(keyRH);
        RHEntityView entityViewRH = new RHEntityView();
        entityViewRH.setRuleSubjectSet(list);
        rhLogical.add(entityViewRH);
        for (int i = 0; i <= rhLogical.size() - 1; ++i) {
            RuleHandler rh = (RuleHandler)rhLogical.getElement(i);
            for (int n = 0; n <= rh.size() - 1; ++n) {
                dr = (DesignRule)rh.getElement(n);
                rulesList.add(dr);
            }
        }
        this.addObject(attributeRH, "Attribute");
        this.addObject(entityRH, "Entity");
        this.addObject(keyRH, "Key");
        CompositeRuleHandler rhProcess = new CompositeRuleHandler();
        rhProcess.setLabel(RuleHandler.PROCESSMODEL_PATH);
        list = new ArrayList();
        if (this.objectsList.size() == 0) {
            if (this.processModel != null) {
                for (DataFlowDesign dfd : this.processModel.getDataFlowDesigns()) {
                    Iterator it1 = dfd.getProcessSet().iterator();
                    while (it1.hasNext()) {
                        DesignObject obj = (DesignObject)it1.next();
                        list.add(obj);
                    }
                }
            }
        } else if (this.objectsList.size() > 0) {
            for (DesignObject obj : this.objectsList) {
                if (!(obj instanceof Process)) continue;
                list.add(obj);
            }
        }
        RHProcess processRH = new RHProcess();
        processRH.setRuleSubjectSet(list);
        rhProcess.add(processRH);
        RHFlow flowRH = new RHFlow();
        flowRH.setRuleSubjectSet(list);
        rhProcess.add(flowRH);
        RHStore storeRH = new RHStore();
        storeRH.setRuleSubjectSet(list);
        rhProcess.add(storeRH);
        RHAgent agentRH = new RHAgent();
        agentRH.setRuleSubjectSet(list);
        rhProcess.add(agentRH);
        RHTransformation transformationRH = new RHTransformation();
        transformationRH.setRuleSubjectSet(list);
        rhProcess.add(transformationRH);
        RHTransformationTask trTaskRH = new RHTransformationTask();
        trTaskRH.setRuleSubjectSet(list);
        rhProcess.add(trTaskRH);
        for (int i = 0; i <= rhProcess.size() - 1; ++i) {
            RuleHandler rh = (RuleHandler)rhProcess.getElement(i);
            for (int j = 0; j <= rh.size() - 1; ++j) {
                dr = (DesignRule)rh.getElement(j);
                rulesList.add(dr);
            }
        }
        this.addObject(agentRH, "External Agent");
        this.addObject(flowRH, "Information Flow");
        this.addObject(storeRH, "Information Store");
        this.addObject(processRH, "Process");
        this.addObject(trTaskRH, "Transformation Task");
        this.addObject(transformationRH, "Transformation");
        ArrayList<DRCustomValidationScript> currentCustomValidationRules = this.appView.getCustomValidationRules();
        for (DRCustomValidationScript dRCustomValidationScript : new ArrayList<DRCustomScript>(this.tempListCustomDR)) {
            boolean found = false;
            for (DRCustomValidationScript cs1 : currentCustomValidationRules) {
                if (!cs1.getRuleId().equals(dRCustomValidationScript.getRuleId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            RuleHandler rh1 = dRCustomValidationScript.getRuleHandler();
            rh1.removeRule(dRCustomValidationScript);
            dRCustomValidationScript.setRuleHandler(null);
            this.tempListCustomDR.remove(dRCustomValidationScript);
        }
        for (DRCustomValidationScript cs0 : currentCustomValidationRules) {
            boolean found = false;
            for (DRCustomValidationScript dRCustomValidationScript : this.tempListCustomDR) {
                if (!dRCustomValidationScript.getRuleId().equals(cs0.getRuleId())) continue;
                found = true;
                rulesList.add(cs0);
                break;
            }
            if (found) continue;
            cs0.setRuleHandler((RuleHandler)this.objects.get(cs0.getObject()));
            RuleHandler ruleHandler = cs0.getRuleHandler();
            if (ruleHandler != null) {
                ruleHandler.addRule(cs0);
                rulesList.add(cs0);
            }
            this.tempListCustomDR.add(cs0);
        }
        return rulesList;
    }

    public ArrayList<DesignRule> getAvailableDesignRules() {
        DesignRule dr;
        int n;
        RuleHandler rh;
        int i;
        ArrayList<DesignRule> rulesList = new ArrayList<DesignRule>();
        DesignRuleManager drm = this.getRuleManager();
        RuleHandler generalRuleHandler = drm.getGeneralRuleHandler();
        RuleHandler relationalRuleHandler = drm.getRelationalRuleHandler();
        RuleHandler logicalRuleHandler = drm.getLogicalRuleHandler();
        RuleHandler processRuleHandler = drm.getProcessModelRuleHandler();
        if (generalRuleHandler != null) {
            for (i = 0; i <= generalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)generalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    rulesList.add(dr);
                }
            }
        }
        if (generalRuleHandler != null && this.relationalModel != null) {
            for (i = 0; i <= relationalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)relationalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    rulesList.add(dr);
                }
            }
        }
        if (logicalRuleHandler != null) {
            for (i = 0; i <= logicalRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)logicalRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    rulesList.add(dr);
                }
            }
        }
        if (processRuleHandler != null) {
            for (i = 0; i <= processRuleHandler.size() - 1; ++i) {
                rh = (RuleHandler)processRuleHandler.getElement(i);
                for (n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    rulesList.add(dr);
                }
            }
        }
        return rulesList;
    }

    private void showHideButtons() {
        if (this.tpane.getSelectedIndex() == 0) {
            this.bnApplySelected.setVisible(true);
            this.bnApplySelectedRuleSets.setVisible(false);
            this.bnApplyAllRuleSets.setVisible(false);
            this.bnApplyAll.setVisible(true);
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.bnApplySelected.setVisible(false);
            this.bnApplySelectedRuleSets.setVisible(true);
            this.bnApplyAllRuleSets.setVisible(true);
            this.bnApplyAll.setVisible(false);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.ruleSetsSaved) {
            String s1 = Messages.getString("DesignRuleView.Yes");
            String s2 = Messages.getString("DesignRuleView.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("DesignRuleView.RuleSetsNotSaved"), Messages.getString("DesignRuleView.CloseConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public Action createSaveRuleSets() {
        AbstractAction action = new AbstractAction(Messages.getString("DesignRuleView.Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignRuleView.this.stopCellediting();
                settings.getDesignRuleSets().clear();
                settings.getDesignRuleSets().addAll(DesignRuleView.this.ruleSetsContainerList);
                DesignRuleView.this.bnSaveRuleSets.setEnabled(false);
                DesignRuleView.this.ruleSetsSaved = true;
                DesignRuleView.this.appView.saveCustomDRScripts();
            }
        };
        action.setEnabled(false);
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void nullifyDesignRuleManager() {
        this.getDesign().getAppView().nullifyDesignRuleManager();
    }

    private void ruleSetFilter() {
        RowFilter rf = null;
        if (this.ruleSetsTable != null) {
            if (!"".equals(this.ruleSetNamefilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.ruleSetNamefilter.getText(), this.ruleSetsTable.convertColumnIndexToModel(1));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.ruleSetsTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.ruleSetsTable.getRowSorter()).setRowFilter(null);
                this.ruleSetsTable.clearSelection();
            }
        }
    }

    public TreeMap<String, Object> getObjects() {
        return this.objects;
    }

    public void addObject(Object obj, String name) {
        this.getObjects().put(name, obj);
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DesignRuleView.this.applySelectedAction.setEnabled(e.getPath() != null);
        }
    }

    private class RuleSetTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2214015596642439352L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleView.DesignRuleView.Name")};

        private RuleSetTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleView.this.ruleSetsContainerList.size();
        }

        public List<DesignRuleSet> getRuleSetList() {
            return DesignRuleView.this.ruleSetsContainerList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void deleteRuleSet(int rowIndex) {
            DesignRuleView.this.ruleSetsContainerList.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRuleSet rs = DesignRuleView.this.ruleSetsContainerList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return rs.getName();
            }
            return row + 1;
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DesignRuleSet rs = DesignRuleView.this.ruleSetsContainerList.get(rowIndex);
            if (columnIndex == 1) {
                rs.setName(obj.toString());
                this.fireTableDataChanged();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            if (newValue.length() == 0) {
                JOptionPane.showMessageDialog(DesignRuleView.this, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            TableModel obj = this.tab.getModel();
            for (DesignRuleSet dr : ((RuleSetTableModel)obj).getRuleSetList()) {
                if (!dr.getName().equals(newValue) || newValue.equals(this.val)) continue;
                JOptionPane.showMessageDialog(DesignRuleView.this, Messages.getString("DesignRuleView.NameExists"), Messages.getString("DesignRuleView.DesignRuleView.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class RuleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 6102267778062841713L;

        RuleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DesignRule dr = (DesignRule)value;
            this.setText(dr.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

