/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CRAdapter;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class CheckResultComponent
extends JPanel {
    private static final long serialVersionUID = -4575436576944253090L;
    private JList jlist;
    private JTextField counterField;
    private CRListModel listModel;
    public JButton bnSaveCSV;
    public JButton bnClearAll;
    private ApplicationView appView;
    private File file;
    private List checkResults = new ArrayList();
    private static final Logger LOGGER;
    private static File lastFolder;

    public CheckResultComponent(ApplicationView appView) {
        this.appView = appView;
        this.init();
    }

    protected void init() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CheckResultComponent.Results")));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.getCounterField(), "North");
        northPanel.add((Component)new JScrollPane(this.getJList()), "Center");
        mainPanel.add((Component)northPanel, "Center");
        JPanel southPanel = new JPanel(new FlowLayout(1));
        this.bnClearAll = new JButton(this.createClearAllAction());
        this.bnClearAll.setEnabled(false);
        this.bnClearAll.setToolTipText(Messages.getString("CheckResultComponent.ClearTooltip"));
        this.bnClearAll.setMnemonic(76);
        this.bnClearAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        southPanel.add(this.bnClearAll);
        this.bnSaveCSV = new JButton(Messages.getString("CheckResultComponent.SaveCSV"));
        this.bnSaveCSV.setToolTipText(Messages.getString("CheckResultComponent.SaveCSVFile"));
        this.bnSaveCSV.setEnabled(false);
        this.bnSaveCSV.addActionListener(new SaveAction());
        this.bnSaveCSV.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnSaveCSV.setMnemonic(83);
        southPanel.add(this.bnSaveCSV);
        mainPanel.add((Component)southPanel, "South");
        jp.add(mainPanel);
        this.add(jp);
    }

    protected JList getJList() {
        if (this.jlist == null) {
            this.jlist = new JList(this.getListModel());
            this.jlist.setCellRenderer(new CRRenderer());
            this.jlist.addMouseListener(this.createDoubleClickMouseAdapter());
            this.jlist.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int index = e.getFirstIndex();
                        CheckResult checkResult = (CheckResult)CheckResultComponent.this.getListModel().getElementAt(index);
                    }
                }
            });
        }
        return this.jlist;
    }

    protected CRListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new CRListModel();
        }
        return this.listModel;
    }

    public Action createCheckAllAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RecheckAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckResultComponent.this.recheckAll();
            }
        };
    }

    public Action createCheckSelectedAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RecheckSelected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckResultComponent.this.recheckSelected();
            }
        };
    }

    public Action createClearAllAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.Clear")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckResultComponent.this.clearCheckResults();
                CheckResultComponent.this.bnSaveCSV.setEnabled(false);
            }
        };
    }

    public Action createClearOKAction() {
        return new AbstractAction(Messages.getString("CheckResultComponent.RemoveOK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckResultComponent.this.clearOKCheckResults();
            }
        };
    }

    protected MouseListener createDoubleClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = CheckResultComponent.this.getJList().locationToIndex(e.getPoint());
                    CheckResultComponent.this.getListModel().selectInModel(index);
                }
            }
        };
    }

    protected JTextField getCounterField() {
        if (this.counterField == null) {
            this.counterField = new JTextField();
            this.counterField.setEditable(false);
        }
        return this.counterField;
    }

    public void add(CheckResult checkResult) {
        this.getListModel().add(checkResult);
    }

    private void updateCounters(CheckResult[] checkResults) {
        int errors = 0;
        int warnings = 0;
        for (int i = 0; i < checkResults.length; ++i) {
            CheckResult chr = checkResults[i];
            if (chr.isWarning()) {
                ++warnings;
                continue;
            }
            if (chr.isOk()) continue;
            ++errors;
        }
        this.getCounterField().setText("ERRORS:" + errors + "WARNINGS:" + warnings);
    }

    public void add(Collection checkResults) {
        this.getListModel().add(checkResults.toArray(new CheckResult[0]));
    }

    public void add(CheckResult[] checkResults) {
        this.updateCounters(checkResults);
        this.getListModel().add(checkResults);
    }

    public void remove(CheckResult checkResult) {
        this.getListModel().remove(checkResult);
    }

    public void clearCheckResults() {
        this.getListModel().removeAll();
        this.getCounterField().setText("");
    }

    public void clearOKCheckResults() {
        this.getListModel().removeAllOK();
    }

    public void recheckAll() {
        this.getListModel().recheckAll();
    }

    public void recheckSelected() {
        this.getListModel().recheckSelected();
    }

    public void saveResults() {
        Writer writer = null;
        try {
            EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
            FileOutputStream outputStream = new FileOutputStream(this.file.toString());
            writer = new OutputStreamWriter((OutputStream)outputStream, environOptions.getEncoding());
            writer.append("Type,Object,Message,Object Type Name,Object ID");
            writer.append("\n");
            for (CRAdapter cra : this.checkResults) {
                if (!(cra.getAffected() instanceof ModelIDObject)) continue;
                DesignObject d = (DesignObject)cra.getAffected();
                writer.append((cra.toString().substring(0, cra.toString().lastIndexOf(":")) + ":\"" + cra.toString().substring(cra.toString().lastIndexOf(":") + 1, cra.toString().length()).trim() + "\":" + d.getObjectTypeName() + ":" + d.getObjectID()).replace(":", ","));
                writer.append("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save results: ", e);
            try {
                writer.close();
            }
            catch (IOException e1) {
                LOGGER.error("Unable to close weiter: ", e);
            }
        }
    }

    static {
        lastFolder = null;
        LOGGER = new Logger(CheckResultComponent.class);
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URLFilter fileFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("CheckResultComponent.CSVFiles");
                    }
                };
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(fileFilter);
                fileChooser.setPathContext("dataModeler_Systypes");
                if (lastFolder != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                } else {
                    String lastDir = CheckResultComponent.this.appView.getSettings().getDefaultSavePath();
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = CheckResultComponent.this.appView.getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CheckResultComponent.SaveResults"));
                if (status == 0) {
                    String path = fileChooser.getSelectedURL().getPath();
                    int dotPos = path.lastIndexOf(".");
                    CheckResultComponent.this.file = dotPos > -1 ? new File(path.substring(0, dotPos) + ".csv") : new File(path + ".csv");
                    if (CheckResultComponent.this.file != null) {
                        lastFolder = CheckResultComponent.this.file.getParentFile();
                        CheckResultComponent.this.saveResults();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error save results ", ex);
            }
        }
    }

    class CRListModel
    extends AbstractListModel
    implements UpdateListener {
        CRListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            if (index > -1 && index < CheckResultComponent.this.checkResults.size()) {
                return CheckResultComponent.this.checkResults.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return CheckResultComponent.this.checkResults.size();
        }

        protected void fireChangeAdded(int index) {
            this.fireChangeAdded(index, index);
        }

        protected void fireChangeAdded(int index0, int index1) {
            this.fireIntervalAdded(this, index0, index1);
        }

        protected void fireChangeRemoved(int index) {
            this.fireChangeRemoved(index, index);
        }

        protected void fireChangeRemoved(int index0, int index1) {
            this.fireIntervalRemoved(this, index0, index1);
        }

        protected void fireContentChange() {
            this.fireContentChange(0, this.getSize() - 1);
        }

        protected void fireContentChange(int index0, int index1) {
            this.fireContentsChanged(this, index0, index1);
        }

        public void add(CheckResult checkResult) {
            CheckResultComponent.this.checkResults.add(checkResult);
            checkResult.addUpdateListener(this);
            this.fireChangeAdded(CheckResultComponent.this.checkResults.indexOf(checkResult));
        }

        public void add(CheckResult[] checkResultArray) {
            int index0 = CheckResultComponent.this.checkResults.size();
            int index1 = index0 + checkResultArray.length;
            for (int i = 0; i < checkResultArray.length; ++i) {
                this.add(checkResultArray[i]);
            }
            this.fireChangeAdded(index0, index1);
        }

        public void remove(CheckResult checkResult) {
            int index = CheckResultComponent.this.checkResults.indexOf(checkResult);
            CheckResultComponent.this.checkResults.remove(index);
            checkResult.removeUpdateListener(this);
            this.fireChangeRemoved(index);
        }

        public void removeAll() {
            if (!CheckResultComponent.this.checkResults.isEmpty()) {
                int index1 = CheckResultComponent.this.checkResults.size() - 1;
                for (CheckResult item : CheckResultComponent.this.checkResults) {
                    item.removeUpdateListener(this);
                }
                CheckResultComponent.this.checkResults.clear();
                this.fireChangeRemoved(0, index1);
            }
        }

        public void removeAllOK() {
            Iterator it = CheckResultComponent.this.checkResults.iterator();
            while (it.hasNext()) {
                CheckResult item = (CheckResult)it.next();
                if (!item.isOk()) continue;
                it.remove();
            }
            this.fireContentChange();
        }

        public void selectInModel(int index) {
            CheckResult checkResult;
            if (index < CheckResultComponent.this.checkResults.size() && (checkResult = (CheckResult)CheckResultComponent.this.checkResults.get(index)) != null) {
                checkResult.selectInModel();
            }
        }

        public void recheck(int index) {
            CheckResult checkResult;
            if (index < CheckResultComponent.this.checkResults.size() && (checkResult = (CheckResult)CheckResultComponent.this.checkResults.get(index)) != null) {
                checkResult.reCheck();
            }
        }

        public void recheck(int[] indices) {
            for (int i = 0; i < indices.length; ++i) {
                this.recheck(indices[i]);
            }
        }

        public void recheckSelected() {
            int[] indices = CheckResultComponent.this.getJList().getSelectedIndices();
            this.recheck(indices);
        }

        public void recheckAll() {
            int max = CheckResultComponent.this.checkResults.size();
            for (int i = 0; i < max; ++i) {
                this.recheck(i);
            }
        }

        @Override
        public void update() {
            this.fireContentChange();
        }
    }

    static class CRRenderer
    extends DefaultListCellRenderer {
        private final Color COLOR_ERROR = new Color(255, 204, 204);
        private final Color COLOR_WARNING = new Color(204, 255, 255);
        private final Color COLOR_INFO = new Color(4380752);
        private final Color COLOR_CUSTOM = new Color(0xFFFF66);

        CRRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof CheckResult) {
                CheckResult checkResult = (CheckResult)value;
                label.setToolTipText(checkResult.getRule().getDescription());
                if (checkResult.isInfo()) {
                    label.setBackground(isSelected ? this.COLOR_INFO.darker() : this.COLOR_INFO);
                } else if (checkResult.isWarning()) {
                    label.setBackground(isSelected ? this.COLOR_WARNING.darker() : this.COLOR_WARNING);
                } else if (checkResult.isCustom()) {
                    label.setBackground(isSelected ? this.COLOR_CUSTOM.darker() : this.COLOR_CUSTOM);
                } else if (!checkResult.isOk()) {
                    label.setBackground(isSelected ? this.COLOR_ERROR.darker() : this.COLOR_ERROR);
                }
            }
            return label;
        }
    }
}

