/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionDockableWindow;

public class DMGitRelPathCellRenderer
extends DefaultTableCellRenderer {
    GITCommitVersionDockableWindow view = null;

    public DMGitRelPathCellRenderer(GITCommitVersionDockableWindow view) {
        this.view = view;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 1 && value instanceof String) {
            Icon icon = this.getIcon();
            String path = value.toString();
            this.setToolTipText(path);
            Design d = ApplicationView.getInstance().getDesignForRelativePath(path);
            if (d != null) {
                String commitid = (String)this.view.getContext().getProperty("commit-version-id");
                String oper = table.getValueAt(table.convertRowIndexToModel(row), 0).toString();
                Design.ObjectDescriptor od = d.getObjectDescriptor(path, oper, commitid);
                if (od != null) {
                    this.setText(od.name);
                    if (od.icon != null) {
                        this.setIcon(od.icon);
                    } else {
                        this.setIcon(icon);
                    }
                } else {
                    this.setIcon(null);
                }
            }
        }
        return this;
    }
}

