/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.mapping;

import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLExtendedMap
extends AbstractXMLReader {
    private static Logger LOGGER = new Logger(RXMLExtendedMap.class);

    public RXMLExtendedMap(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        if (design != null) {
            try {
                Element root = doc.getDocumentElement();
                XtdMapping object = this.parseMapping(root, design);
                return object;
            }
            catch (Exception e) {
                Design.openFailed();
                LOGGER.error("RXMLExtendedMap.recreateObject()", e);
            }
        }
        return null;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart designPart, boolean tryReadWriteLocking) {
        Design design = this.getDesign();
        if (design != null) {
            try {
                Element root = doc.getDocumentElement();
                NodeList mappings = RXMLExtendedMap.getFirstChildByTagName(root, "mappings").getElementsByTagName("extmapping");
                int length = mappings.getLength();
                for (int i = 0; i < length; ++i) {
                    Element mappingElement = (Element)mappings.item(i);
                    this.parseMapping(mappingElement, design);
                }
            }
            catch (Exception e) {
                Design.openFailed();
                LOGGER.error("RXMLExtendedMap.recreateDesign()", e);
            }
        } else {
            LOGGER.error("RXMLExtendedMap.recreateDesign(): Unable to get Design!");
        }
        return designPart;
    }

    private XtdMapping parseMapping(Element mappingElement, Design design) {
        XtdMapping mapping = null;
        TreeMap<String, String> map = new TreeMap<String, String>();
        NodeList propList = mappingElement.getElementsByTagName("parameter");
        int l = propList.getLength();
        for (int j = 0; j < l; ++j) {
            Element param = (Element)propList.item(j);
            map.put(param.getAttribute("name"), param.getAttribute("value"));
        }
        String deletedID = (String)map.get("deleted_id");
        DesignObject delObject = null;
        if (deletedID != null && !"".equals(deletedID)) {
            delObject = design.getDesignObject(deletedID);
        }
        if (delObject == null) {
            String ownerID = StringUtilities.decodeAttributeValue((String)map.get("owner.id"));
            String targetID = StringUtilities.decodeAttributeValue((String)map.get("target.id"));
            long creationTime = Long.parseLong((String)map.get("creationTime"));
            String type = StringUtilities.decodeAttributeValue((String)map.get("owner.type"));
            int otype = -1;
            if (type != null && !"".equals(type)) {
                try {
                    otype = Integer.parseInt(type);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            DesignObject owner = null;
            DesignObject target = null;
            if (10 == otype) {
                DesignPartView dpv = design.getDesignPartView(ownerID);
                if (dpv != null) {
                    owner = dpv.getPlaceHolder();
                    dpv = design.getDesignPartView(targetID);
                    if (dpv != null) {
                        target = dpv.getPlaceHolder();
                    }
                }
            } else {
                owner = design.getDesignObject(ownerID);
                target = design.getDesignObject(targetID);
            }
            String recreatedContainerID = StringUtilities.decodeAttributeValue((String)map.get("recreated_container_id"));
            if (owner != null && target != null && deletedID == null) {
                String realtentid;
                mapping = design.getExtendedMap().createMapping(owner, target);
                String inheritance_type = StringUtilities.decodeAttributeValue((String)map.get("inheritance_type"));
                if (inheritance_type == null) {
                    mapping.setInheritanceType(-1);
                } else {
                    mapping.setInheritanceType(Integer.valueOf(inheritance_type));
                }
                String realsentid = StringUtilities.decodeAttributeValue((String)map.get("real_source_entity_id"));
                if (realsentid != null) {
                    mapping.setRealSourceEntityID(realsentid);
                }
                if ((realtentid = StringUtilities.decodeAttributeValue((String)map.get("real_target_entity_id"))) != null) {
                    mapping.setRealTargetEntityID(realtentid);
                }
                if (recreatedContainerID != null) {
                    mapping.setRecreatedContainerID(recreatedContainerID);
                }
                String repOID = (String)map.get("rep_oid");
                String repOVID = (String)map.get("rep_ovid");
                if (repOID != null) {
                    mapping.setRepositoryOID(repOID);
                }
                if (repOVID != null) {
                    mapping.setRepositoryOVID(repOVID);
                }
                mapping.setCreationTime(creationTime);
            } else {
                String realtentid;
                int ownerType = Integer.parseInt((String)map.get("owner.type"));
                String ownerName = StringUtilities.decodeAttributeValue((String)map.get("owner.name"));
                String ownerDPID = StringUtilities.decodeAttributeValue((String)map.get("owner.design.id"));
                String ownerDPName = (String)map.get("owner.design.name");
                int targetType = Integer.parseInt((String)map.get("target.type"));
                String targetName = StringUtilities.decodeAttributeValue((String)map.get("target.name"));
                String targetDPID = StringUtilities.decodeAttributeValue((String)map.get("target.design.id"));
                String targetDPName = StringUtilities.decodeAttributeValue((String)map.get("target.design.name"));
                mapping = deletedID != null ? design.getExtendedMap().createMapping(ownerID, targetID, deletedID) : design.getExtendedMap().createMapping(ownerID, targetID);
                mapping.setDesign(design);
                mapping.setCreationTime(creationTime);
                mapping.setOwnerType(ownerType);
                mapping.setOwnerName(ownerName);
                mapping.setOwnerDesignPartID(ownerDPID);
                mapping.setOwnerDesignPartName(ownerDPName);
                mapping.setTargetType(targetType);
                mapping.setTargetName(targetName);
                mapping.setTargetDesignPartID(targetDPID);
                mapping.setTargetDesignPartName(targetDPName);
                String inheritance_type = StringUtilities.decodeAttributeValue((String)map.get("inheritance_type"));
                String realsentid = StringUtilities.decodeAttributeValue((String)map.get("real_source_entity_id"));
                String repOID = StringUtilities.decodeAttributeValue((String)map.get("rep_oid"));
                String repOVID = StringUtilities.decodeAttributeValue((String)map.get("rep_ovid"));
                String ownerRepOID = StringUtilities.decodeAttributeValue((String)map.get("owner.repoid"));
                String targetRepOID = StringUtilities.decodeAttributeValue((String)map.get("target.repoid"));
                if (realsentid != null) {
                    mapping.setRealSourceEntityID(realsentid);
                }
                if ((realtentid = StringUtilities.decodeAttributeValue((String)map.get("real_target_entity_id"))) != null) {
                    mapping.setRealTargetEntityID(realtentid);
                }
                if (recreatedContainerID != null) {
                    mapping.setRecreatedContainerID(recreatedContainerID);
                }
                if (inheritance_type == null) {
                    mapping.setInheritanceType(-1);
                } else {
                    mapping.setInheritanceType(Integer.valueOf(inheritance_type));
                }
                if (repOID != null) {
                    mapping.setRepositoryOID(repOID);
                }
                if (repOVID != null) {
                    mapping.setRepositoryOVID(repOVID);
                }
                if (ownerRepOID != null) {
                    mapping.setOwnerRepOID(ownerRepOID);
                }
                if (targetRepOID != null) {
                    mapping.setTargetRepOID(targetRepOID);
                }
            }
            if (mapping != null) {
                String ownerContID = StringUtilities.decodeAttributeValue((String)map.get("owner_container_id"));
                String targetContID = StringUtilities.decodeAttributeValue((String)map.get("target_container_id"));
                if (ownerContID != null && !"".equals(ownerContID)) {
                    mapping.setOwnerContainerID(ownerContID);
                }
                if (targetContID != null && !"".equals(targetContID)) {
                    mapping.setTargetContainerID(targetContID);
                }
                String fwEngineer = StringUtilities.decodeAttributeValue((String)map.get("fw_engineer"));
                String revEngineer = StringUtilities.decodeAttributeValue((String)map.get("rev_engineer"));
                if (fwEngineer != null && !"true".equalsIgnoreCase(fwEngineer)) {
                    mapping.setFwEngineer(false);
                }
                if (revEngineer != null && !"true".equalsIgnoreCase(revEngineer)) {
                    mapping.setFwEngineer(false);
                }
                if (design.getLoadedVersion() > 2.2f && (mapping.getOwnerType() == 0 || mapping.getTargetType() == 0)) {
                    this.readContainedMappings(mappingElement, mapping, "attributes", mapping.getAttributes());
                    this.readContainedMappings(mappingElement, mapping, "columns", mapping.getColumns());
                    this.readContainedMappings(mappingElement, mapping, "keys", mapping.getKeys());
                    this.readContainedMappings(mappingElement, mapping, "indexes", mapping.getIndexes());
                }
                mapping.setDirty(false);
            }
        }
        return mapping;
    }

    public Design getDesign() {
        if (this.getPersistenceManager().getAppView() != null) {
            return this.getPersistenceManager().getAppView().getCurrentDesign();
        }
        return null;
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("mapping");
            return buffer.toString();
        }
        return "mapping";
    }

    private void readContainedMappings(Element mappingElement, XtdMapping mapping, String id, List list) {
        Element node = RXMLExtendedMap.getFirstChildByTagName(mappingElement, id);
        if (node != null) {
            NodeList propList = node.getElementsByTagName("cont_id");
            int l = propList.getLength();
            for (int j = 0; j < l; ++j) {
                Element param = (Element)propList.item(j);
                String cid = param.getAttribute("value");
                list.add(cid);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == XtdMapping.class;
    }
}

