/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLInheritanceRelation
extends AbstractRXMLDesignObject {
    public RXMLInheritanceRelation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getLogicalDesign().recreateInheritanceRelation(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("inheritance id prefix");
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("inheritancePath"));
        return buffer.toString();
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof InheritanceRelation) {
            Design design = desObject.getDesign();
            InheritanceRelation relation = (InheritanceRelation)desObject;
            NodeList connections = objInfo.getElementsByTagName("inheritance");
            int length = connections.getLength();
            Entity sourceEntity = null;
            Entity targetEntity = null;
            for (int i = 0; i < length; ++i) {
                Element endP = (Element)connections.item(i);
                String entId = endP.getAttribute("entity");
                Entity entity = (Entity)design.getDesignObject(entId);
                if ("source".equals(endP.getAttribute("endpoint"))) {
                    sourceEntity = entity;
                    continue;
                }
                if (!"target".equals(endP.getAttribute("endpoint")) || entity == null) continue;
                relation.setTargetEntity(entity);
                relation.setTargetTV(relation.getTargetTVEntity());
                targetEntity = entity;
            }
            if (sourceEntity != null && targetEntity != null) {
                targetEntity.setHierarchicalParent(sourceEntity, relation);
            }
        }
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        InheritanceRelation relation = (InheritanceRelation)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(relation.getObjectID())).append(".dmd");
        relation.setFilePath(buffer.toString());
        return relation;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == InheritanceRelation.class;
    }
}

