/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12.IndexPropertyDialogSqlServerv2k12;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxySqlServerv2k12
extends IndexProxySqlServerv2k5 {
    public static final String COLUMNSTORE = "Columnstore";
    private boolean columnstoreIndex = false;

    public IndexProxySqlServerv2k12(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public IndexProxySqlServerv2k12(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogSqlServerv2k12 dialog = new IndexPropertyDialogSqlServerv2k12(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public boolean isColumnstoreIndex() {
        return this.columnstoreIndex;
    }

    public void setColumnstoreIndex(boolean columnstoreIndex) {
        this.columnstoreIndex = columnstoreIndex;
    }

    @Override
    public String getIndexType() {
        if (this.isColumnstoreIndex()) {
            return COLUMNSTORE;
        }
        return super.getIndexType();
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "isClustered", "setClustered", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Scheme", this, "getPartitionScheme", "setPartitionScheme", PartitionSchemeSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioning Column", this, "getPartitioningColumn", "setPartitioningColumn", ColumnProxy.class));
            this.propertyWrapperList.add(new PropertyWrapper("Pad Index", this, "getPadIndex", "setPadIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Fill Factor[0,100]", this, "getFillFactor", "setFillFactor", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Recompute Stat", this, "getRecomputeStatistics", "setRecomputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sort in temp DB", this, "getSortInTempDB", "setSortInTempDB", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Row Locks", this, "getAllowRowLocks", "setAllowRowLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Page Locks", this, "getAllowPageLocks", "setAllowPageLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("MaxDop[0,64]", this, "getMaxdop", "setMaxdop", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Online", this, "getOnlineChoise", "setOnlineChoise", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxySqlServerv2k12 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k12)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxySqlServerv2k12)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            for (SecondaryXmlIndexSqlServerv2k5 secIndex : this.getSecondaryXMLIndexs()) {
                SecondaryXmlIndexSqlServerv2k5 targetSecIndex = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getSecondaryXmlIndexSetv2k5().getByName(secIndex.getName());
                if (targetSecIndex == null) {
                    SecondaryXmlIndexSqlServerv2k5 newSecIndex = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getSecondaryXmlIndexSetv2k5().createXmlIndex();
                    newSecIndex.setName(secIndex.getName());
                    newSecIndex.setRawObject(true);
                    indexProxy.getSecondaryXMLIndexs().add(newSecIndex);
                    continue;
                }
                indexProxy.getSecondaryXMLIndexs().add(targetSecIndex);
            }
            indexProxy.setClustered(this.isClustered());
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (fileGroup == null) {
                    FileGroupSqlServerv2k5 newFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(this.getFilegroup().getName());
                    newFileGroup.setRawObject(true);
                    indexProxy.setFilegroup(newFileGroup);
                } else {
                    indexProxy.setFilegroup(fileGroup);
                }
            }
            if (this.getPartitionScheme() != null) {
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (partScheme == null) {
                    PartitionSchemeSqlServerv2k5 newPartScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getPartitionSchemeSet().createPartitionScheme();
                    newPartScheme.setName(this.getPartitionScheme().getName());
                    newPartScheme.setRawObject(true);
                    indexProxy.setPartitionScheme(newPartScheme);
                } else {
                    indexProxy.setPartitionScheme(partScheme);
                }
            }
            if (this.getPartitioningColumn() != null) {
                ColumnProxySqlServerv2k5 column = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (column == null) {
                    ColumnProxySqlServerv2k5 newColumn = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    newColumn.setName(this.getPartitioningColumn().getName());
                    newColumn.setRawObject(true);
                    indexProxy.setPartitioningColumn(newColumn);
                } else {
                    indexProxy.setPartitioningColumn(column);
                }
            }
            indexProxy.setPadIndex(this.getPadIndex());
            indexProxy.setFillFactor(this.getFillFactor());
            indexProxy.setRecomputeStatistics(this.getRecomputeStatistics());
            indexProxy.setSortInTempDB(this.getSortInTempDB());
            indexProxy.setIgnoreDupKey(this.getIgnoreDupKey());
            indexProxy.setAllowRowLocks(this.getAllowRowLocks());
            indexProxy.setAllowPageLocks(this.getAllowPageLocks());
            indexProxy.setMaxdop(this.getMaxdop());
            indexProxy.setOnlineChoise(this.getOnlineChoise());
            indexProxy.setDropExisting(this.getDropExisting());
            indexProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            indexProxy.recreateIncludeColumnsSet(this.getIncludeColumnsSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
            indexProxy.setColumnstoreIndex(this.isColumnstoreIndex());
        }
    }
}

