/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UserDefinedTypesPropertyDialog;

public class UserDefinedTypeSqlServer
extends AbstractStorageObjectSqlServer {
    protected String domain = "";
    protected String nullType;
    protected UserSqlServer owner;
    protected DataBaseSqlServer database;
    protected Domain domainObj;
    protected UsedUDDTSet usedUDDTSet;
    protected String usedUDDT = "";
    public static final String[] NULL_STATES = new String[]{"NULL", "NOT NULL"};
    private static Set nullSet = null;
    public static final String TYPE_NAME = "UDType";
    public static final String OLD_TYPE_NAME = "UserDefinedType";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UserDefinedTypesPropertyDialog dialog = new UserDefinedTypesPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Type";
    }

    protected boolean checkNullType(String value) {
        if (nullSet == null) {
            nullSet = new HashSet();
            nullSet.addAll(Arrays.asList(NULL_STATES));
        }
        return nullSet.contains(value);
    }

    public MDDataType getDataType() {
        Domain dom = (Domain)this.getStorageDesign().getDesign().getDomainSet().getByName(this.domain);
        if (dom != null) {
            return dom.getDataType();
        }
        return new MDUnknown();
    }

    public String getDomain() {
        if (this.domain.equals("")) {
            this.domain = "BigNumber";
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.fireDataFieldChange();
    }

    public Domain getDomainObj() {
        Domain dom = (Domain)this.getStorageDesign().getDesign().getDomainSet().getByName(this.getDomain());
        return dom;
    }

    public String getNullType() {
        return this.nullType;
    }

    public void setNullType(String nullType) {
        if (this.checkNullType(nullType)) {
            this.nullType = nullType;
            this.fireDataFieldChange();
        }
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer owner) {
        this.owner = owner;
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public UsedUDDTSet getUsedUDDTSet() {
        if (this.usedUDDTSet == null) {
            this.usedUDDTSet = new UsedUDDTSet();
        }
        return this.usedUDDTSet;
    }

    public void setUsedUDDTSet(UsedUDDTSet usedUDDT) {
        this.usedUDDTSet = usedUDDT;
    }

    public void setUsedUserDataType(String usedDistinctType) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUsedUserDataType(usedDistinctType);
        } else {
            this.addUsedUserDataType(usedDistinctType);
        }
        this.usedUDDT = this.getUsedUDDTSet().toString();
        this.fireDataFieldChange();
    }

    private void addUsedUserDataType(String usedUserDT) {
        String usedDTName = usedUserDT.substring(usedUserDT.lastIndexOf(46) + 1, usedUserDT.length());
        if (!this.getUsedUDDTSet().contains(usedDTName)) {
            this.getUsedUDDTSet().add(usedDTName);
        }
    }

    private void recreateUsedUserDataType(String usedDTName) {
        this.getUsedUDDTSet().clear();
        StringTokenizer st = new StringTokenizer(usedDTName, ",");
        while (st.hasMoreTokens()) {
            String usedUserDT = st.nextToken().trim();
            if (this.getUsedUDDTSet().contains(usedUserDT)) continue;
            this.getUsedUDDTSet().add(usedUserDT);
        }
    }

    public void clearFromDataBase(DataBaseSqlServer database) {
        UsedUserDefinedData[] usedDTSet = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedDTSet.length; ++i) {
            UsedUserDefinedData usedDT = usedDTSet[i];
            if (usedDT.getUserDefinedType() != this || usedDT.getDatabase() != database) continue;
            this.getUsedUDDTSet().remove(usedDT.getName());
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedDT);
        }
    }

    public String getUsedUDDT() {
        return this.usedUDDT;
    }

    public void setUsedUDDT(String usedUDDT) {
        this.usedUDDT = usedUDDT;
    }

    @Override
    public void remove() {
        UsedUserDefinedData[] usedDTSet = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedDTSet.length; ++i) {
            UsedUserDefinedData usedDT = usedDTSet[i];
            if (usedDT.getUserDefinedType() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedDT);
        }
        super.remove();
    }

    public class UsedUDDTSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

