/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.IndexPropertyDialogDB2v80;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyDB2v80
extends IndexProxyDB2 {
    protected String clustered = YES_NO_STATES[1];
    protected String partitioned = YES_NO_STATES[1];
    protected String padded = YES_NO_STATES[1];
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public IndexProxyDB2v80(Index index, StorageDesign storageDesign) {
        super(index, storageDesign, true);
    }

    public IndexProxyDB2v80(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign, true);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogDB2v80 dialog = new IndexPropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    public String getClusteredDB2() {
        return this.clustered;
    }

    public void setClusteredDB2(String clustered) {
        if (this.checkYesNo(clustered)) {
            this.clustered = clustered;
            this.fireDataFieldChange();
        }
    }

    public String getPadded() {
        return this.padded;
    }

    public void setPadded(String padded) {
        if (this.checkYesNo(padded)) {
            this.padded = padded;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        if (this.checkYesNo(partitioned)) {
            this.partitioned = partitioned;
            this.fireDataFieldChange();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("Where Not Null", this, "isWhereNotNull", "setWhereNotNull", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "getClustered", "setClustered", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Piece Size", this, "getPieceSize", "setPieceSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Defer", this, "isDefer", "setDefer", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Copy", this, "isCopy", "setCopy", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Padded", this, "getPadded", "setPadded", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyDB2v80 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v80)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyDB2v80)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            for (int i = 0; i < this.getPartitions().length; ++i) {
                IndexPartitionDB2 partition = this.getPartitions()[i];
                IndexPartitionDB2 targetPartition = (IndexPartitionDB2)((StorageDesignDB2v80)targetDesign).getIndexPartitionSet().getByName(partition.getName());
                if (targetPartition == null) {
                    IndexPartitionDB2 newPartition = ((StorageDesignDB2v80)targetDesign).getIndexPartitionSet().createIndexPartition();
                    newPartition.setName(partition.getName());
                    newPartition.setRawObject(true);
                    newPartition.setIndex(indexProxy);
                    ((StorageDesignDB2v80)targetDesign).getIndexPartitionSet().add(newPartition);
                    continue;
                }
                targetPartition.setIndex(indexProxy);
                ((StorageDesignDB2v80)targetDesign).getIndexPartitionSet().add(targetPartition);
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    indexProxy.setOwner(newOwner);
                } else {
                    indexProxy.setOwner(owner);
                }
            }
            indexProxy.setWhereNotNull(this.isWhereNotNull());
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 storageTempl = (StorageTemplateDB2)((StorageDesignDB2v80)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (storageTempl == null) {
                    StorageTemplateDB2 newStTempl = ((StorageDesignDB2v80)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newStTempl.setName(this.getStorageTemplate().getName());
                    newStTempl.setRawObject(true);
                    indexProxy.setStorageTemplate(newStTempl);
                } else {
                    indexProxy.setStorageTemplate(storageTempl);
                }
            }
            indexProxy.setClusterType(this.getClusterType());
            indexProxy.setPartitioned(this.isPartitioned());
            indexProxy.setPieceSize(this.getPieceSize());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 buffPool = (BufferPoolDB2)((StorageDesignDB2v80)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (buffPool == null) {
                    BufferPoolDB2 newBufferPool = (BufferPoolDB2)((StorageDesignDB2v80)targetDesign).getBufferPoolSet().createElement(null);
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    indexProxy.setBufferPool(newBufferPool);
                } else {
                    indexProxy.setBufferPool(buffPool);
                }
            }
            indexProxy.setClose(this.isClose());
            indexProxy.setDefer(this.isDefer());
            indexProxy.setCopy(this.isCopy());
            indexProxy.setPadded(this.getPadded());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }
}

