/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class FKIndexAssociation
extends DesignObject
implements ContainerObjectListener,
oracle.dbtools.crest.model.design.FKConnection {
    public static final String DELETE_RULE_CASCADE = "CASCADE";
    public static final String DELETE_RULE_SET_NULL = "SET NULL";
    public static final String DELETE_RULE_RESTRICT = "RESTRICT";
    public static final String DELETE_RULE_NOTHING = "NO ACTION";
    public static final String DELETE_RULE_SET_DEFAULT = "SET DEFAULT";
    public static final String[] DELETE_RULES = new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"};
    public static final String[] DELETE_RULES_ORACLE = new String[]{"NO ACTION", "CASCADE", "SET NULL"};
    public static final String[] OPTIONAL_CHILD_DELETE_RULES = new String[]{"RESTRICT", "NO ACTION", "SET NULL"};
    public static final String[] DELETE_RULES_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_WITHOUT_NULL_ORACLE = new String[]{"NO ACTION", "CASCADE"};
    public static final String[] DELETE_RULES_WITH_DEFAULT = new String[]{"NO ACTION", "CASCADE", "SET NULL", "SET DEFAULT"};
    public static final String[] DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "SET DEFAULT"};
    public static final String[] DELETE_RULES_RESTRICT_CASCADE = new String[]{"CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_NOACTION_CASCADE = new String[]{"CASCADE", "NO ACTION"};
    public static final String PROPERTY_ASSOCIATION_ID = "fkassociation.id";
    public static final String ID_PREFIX = "IDXFK";
    public static boolean RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
    private KeyObject fkIndex = null;
    Collection dpvCol = new ArrayList();
    DesignPartView dpvPhysical;
    protected KeyObject keyObject = null;
    protected ContainerWithKeyObject container = null;
    protected Map elementMap = new HashMap();
    protected String deleteRule = "NO ACTION";
    private boolean mandatory = true;
    private boolean transferable = true;
    private FKArc arc = null;
    public static float[] dashpattern = new float[]{8.0f, 8.0f};
    private FKIndexAssociation originatingFK;
    private ContainerView originatingSourceTVTable;
    private ContainerView originatingTargetTVTable;
    private boolean silentRemove = false;
    private String discriminatorValue = "";
    private String referredTableID;
    private String containerID;
    private String referredKeyID;
    private FKContainer referredTable;
    private boolean rely = false;
    private FKElement discriminatorColumn;
    private transient boolean refColumnsChanged = false;
    private boolean columnDependencyConstraintGenerateInDDL = true;
    private String columnDependencyConstraintGenerateName = "";
    private String referredColumnNames;
    private String referredTableLongName;
    public static final String TYPE_NAME = "FKIndexAssociation";
    ContainerView sourceTVT = null;
    ContainerView targetTVT = null;
    FKConnection fkConnection = null;

    public FKIndexAssociation(FKContainer table) {
        super(table.getDesignPart());
        this.id = new GUID().toString();
        this.setContainerWithKeyObject(table);
        this.setBackup(table.isBackup());
    }

    public FKIndexAssociation(DesignPart designPart) {
        super(designPart);
    }

    public FKIndexAssociation(DesignPart designPart, FKIndexAssociation originatingFK) {
        super(designPart);
        this.originatingFK = originatingFK;
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject container) {
        if (container != null) {
            container.addContainerListener(this);
        }
        this.container = container;
        if (container != null) {
            if (ApplicationView.isGUIMode()) {
                this.dpvPhysical = this.getDesign().getRelationalDesign().getMainView();
            }
            this.containerID = container.getObjectID();
        }
    }

    @Override
    public FKContainer getTable() {
        return (FKContainer)this.getContainerWithKeyObject();
    }

    public FKElement createElementFor(FKElement fkElement) {
        FKElement column = this.getTable().getFKColumn(this, fkElement);
        if (column == null) {
            FKElement columnFK = this.getTable().createColumnFK(fkElement, this);
            this.getLocalFKIndex().add(columnFK);
            return columnFK;
        }
        return column;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public FKElement[] getColumns() {
        return (FKElement[])this.getLocalFKIndex().getElements();
    }

    public boolean hasLocalFKIndex() {
        return this.fkIndex != null;
    }

    public boolean containsElement(FKElement element) {
        KeyObject key = this.getLocalFKIndex();
        return key != null && key.contains(element);
    }

    public void setLocalFKIndex(KeyObject index) {
        this.fkIndex = index;
        if (index != null) {
            this.initializeLocalIndex(this.fkIndex);
        }
    }

    public KeyObject getLocalFKIndex() {
        if (this.fkIndex == null) {
            this.fkIndex = this.createLocalFKIndex();
        } else if (this.fkIndex.getFKAssociation() == this && this.fkIndex.getContainerWithKeyObject() == null) {
            this.fkIndex.setContainerObject(this.getContainerWithKeyObject());
        }
        return this.fkIndex;
    }

    public KeyObject getRemoteIndex() {
        return this.getKeyObject();
    }

    @Override
    public FKContainer getRemoteTable() {
        if (this.keyObject != null) {
            return (FKContainer)this.keyObject.getContainerObject();
        }
        if (this.referredTableID != null) {
            if (this.referredTable != null && !this.referredTable.isRemoved() && this.referredTable.getObjectID().equals(this.referredTableID)) {
                return this.referredTable;
            }
            DesignObject obj = this.getDesign().getDesignObject(this.referredTableID);
            if (obj instanceof FKContainer) {
                this.referredTable = (FKContainer)obj;
                return this.referredTable;
            }
        }
        return null;
    }

    public KeyObject createLocalFKIndex() {
        this.fkIndex = this.getTable().createIndexFK(this);
        return this.initializeLocalIndex(this.fkIndex);
    }

    protected KeyObject initializeLocalIndex(KeyObject fkIndex) {
        fkIndex.setFKAssociation(this);
        FKElement[] columns = this.getTable().getAllFKColumns(this);
        for (int i = 0; i < columns.length; ++i) {
            fkIndex.add(columns[i]);
        }
        return fkIndex;
    }

    @Override
    public void remove() {
        this.getTable().removeContainerListener(this);
        this.getLocalFKIndex().remove();
        this.getTable().removeFKAssociationFromList(this);
        this.removeAllFKElements();
        super.remove();
        this.dpvCol.clear();
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (!this.isBackupFK() && !this.getDesign().isCleaning()) {
            if (container instanceof KeyObject && this.getDesign().isPropagatePKChahges()) {
                if (event.isType(0)) {
                    this.addFKElement((FKElement)event.getAffectedElement());
                } else if (event.isType(1)) {
                    if (event.getAffectedElement() instanceof Column) {
                        ArrayList<FKElement> cols = new ArrayList<FKElement>();
                        cols.add((FKElement)event.getAffectedElement());
                        this.removeFKElement(cols);
                    }
                } else if (event.isType(4)) {
                    System.out.println("FKAssociation.changed: DOES NOT HAPPEN ? or irrelevant ?");
                } else if (event.isType(7)) {
                    this.moveLocalColumn(container, (FKElement)event.getAffectedElement());
                }
            }
            if (event.isType(4) && this.hasLocalFKIndex() && this.getLocalFKIndex().equals(event.getAffectedElement())) {
                this.setLocalFKIndex(null);
            }
        }
    }

    public void synchronizeFKColumns() {
        if (this.keyObject != null) {
            int i;
            FKElement[] pkCols = (FKElement[])this.keyObject.getElements();
            FKContainer tab = (FKContainer)this.getContainerWithKeyObject();
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (i = 0; i < pkCols.length; ++i) {
                FKElement fkcol = tab.getFKColumn(this, pkCols[i]);
                if (fkcol == null) {
                    fkcol = tab.getColumnForDelegate(this, pkCols[i]);
                    if (fkcol != null) {
                        fkcol.addFKAssociation(pkCols[i], this);
                        this.getLocalFKIndex().add(fkcol);
                    } else {
                        fkcol = tab.createColumnFK(pkCols[i], this);
                        String name = ApplyNamingStandards.createFKColumnName(pkCols[i], this, this.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.getTable());
                        fkcol.setName(name);
                    }
                }
                list.add(fkcol);
                if (this.getLocalFKIndex().contains(fkcol)) continue;
                this.getLocalFKIndex().add(fkcol);
            }
            for (i = 0; i < list.size(); ++i) {
                this.getLocalFKIndex().moveToIndex((FKElement)list.get(i), i);
            }
        }
    }

    private FKElement getColumnForReferencedColumn(FKElement refcol) {
        for (FKElement col : this.getLocalFKIndex().getElementsCollection()) {
            if (!col.isReferingTo(this, refcol)) continue;
            return col;
        }
        return null;
    }

    private void moveLocalColumn(ContainerObject refContainer, FKElement refColumn) {
        int ind = refContainer.getIndexOf(refColumn);
        FKElement col = this.getColumnForReferencedColumn(refColumn);
        if (col != null) {
            this.getLocalFKIndex().moveToIndex(col, ind);
        }
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null && inf.tv != view) {
            throw new RuntimeException(Messages.getString("FKIndexAssociation.AssociationAlreadyExists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public void resetViewNumbers() {
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public List getAllTVRelations() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            list.add(dpi.tv);
        }
        return list;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    @Override
    public String getGeneratorID() {
        if (this.hasLocalFKIndex()) {
            return this.getLocalFKIndex().getGeneratorID();
        }
        return "";
    }

    @Override
    public void setGeneratorID(String value) {
        if (this.hasLocalFKIndex()) {
            this.getLocalFKIndex().setGeneratorID(value);
        }
    }

    public void setSourceTVTable(ContainerView source) {
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            boolean reassignConnection = false;
            if (dpi.sourceTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            if (!this.isBackupFK()) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    public void resetSourceTVTable(ContainerView source) {
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        boolean reassignConnection = false;
        if (dpi.sourceTV != null) {
            reassignConnection = true;
            if (dpi.tv != null && !this.isBackupFK()) {
                ((TVFKRelation)dpi.tv).removeConnection();
            }
            dpi.sourceTV.removeTopViewListener(this);
        }
        dpi.sourceTV = source;
        if (!this.isBackupFK()) {
            dpi.sourceTV.addTopViewListener(this);
            this.addTVFKRelation(dpi);
            if (reassignConnection && dpi.tv != null) {
                ((TVFKRelation)dpi.tv).addConnection(true);
                ((TVFKRelation)dpi.tv).resetEdgeParams();
            }
        }
    }

    public void setTargetTVTable(ContainerView target) {
        DesignPartView dpv = target.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            boolean reassignConnection = false;
            if (dpi.targetTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            if (!this.isBackupFK()) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    public void addTVFKRelation(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVFKRelation tvr = new TVFKRelation(this.getDesign().getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (dpi.tv != null && ((TVFKRelation)dpi.tv).getEdge() == null && dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
        }
        if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            dpi.dpv.registerTopView(dpi.tv);
        }
    }

    public void addTVFKRelation(TopView tv, ContainerView sourceTV, ContainerView targetTV, DesignPartView dpv) {
        if (tv == null && sourceTV != null && targetTV != null && dpv != null) {
            TVFKRelation tvr = new TVFKRelation(this.getDesign().getAppView(), dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpv.registerForTreemodel(tvr);
            if (dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
        }
    }

    public void changeKeyObject(KeyObject newKey, FKElement[] fkColumns) {
        KeyObject oldKey = this.getKeyObject();
        FKElement[] old_cols = (FKElement[])this.getLocalFKIndex().getColumns();
        if (oldKey != newKey) {
            this.setKeyObject(newKey);
            if (newKey != null) {
                if (this.getContainerWithKeyObject().isBST()) {
                    if (this.getOriginalContainer().isBST()) {
                        FKElement col = (FKElement)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        if (col == null) {
                            col = (FKElement)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        }
                        if (col != null) {
                            this.setRefFKColumn(col);
                        }
                    } else {
                        FKElement[] elements = (FKElement[])this.keyObject.getElements();
                        for (int i = 0; i < elements.length; ++i) {
                            FKElement keyColumn = elements[i];
                            FKElement[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                            if (compatibleColumns.length != 1) continue;
                            FKElement compatibleColumn = compatibleColumns[0];
                            compatibleColumn.addFKAssociation(keyColumn, this);
                            this.getLocalFKIndex().add(compatibleColumn);
                        }
                    }
                } else if (this.getOriginalContainer().isBST()) {
                    FKElement[] elements = (FKElement[])this.keyObject.getElements();
                    if (elements.length > 0 && !elements[0].isOid()) {
                        for (int i = 0; i < elements.length; ++i) {
                            this.addFKElement(elements[i]);
                        }
                    } else {
                        FKContainer table = (FKContainer)this.getContainerWithKeyObject();
                        table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
                    }
                }
            }
            this.callRemoveListeners();
            this.addToAllDPVs();
        }
        this.swapFKColumnsWithAskDelete(old_cols, fkColumns);
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        Collection targetDPVs = this.getContainerWithKeyObject().getAffectedDPVs();
        FKContainer remoteTable = this.getRemoteTable();
        Collection sourceDPVs = remoteTable != null ? remoteTable.getAffectedDPVs() : Collections.EMPTY_LIST;
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getTargetTV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getSourceTV(dpv);
        }
    }

    public ContainerView getSourceTVTable() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (dpv == null) {
            dpv = this.getDesignPart().getMainView();
        }
        return this.getSourceTV(dpv);
    }

    public ContainerView getTargetTVTable() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (dpv == null) {
            dpv = this.getDesignPart().getMainView();
        }
        return this.getTargetTV(dpv);
    }

    public boolean matchSourceTV(DesignPartView dpv, ContainerView cv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.sourceTV == cv;
    }

    public ContainerView getSourceTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getRemoteTable() != null && !(c = this.getRemoteTable().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.sourceTV = (ContainerView)it.next();
            if (!this.isBackupFK()) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
            }
        }
        return dpi.sourceTV;
    }

    public boolean matchTargetTV(DesignPartView dpv, ContainerView cv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.targetTV == cv;
    }

    public ContainerView getTargetTV(DesignPartView dpv) {
        Collection c;
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getContainerWithKeyObject() != null && !(c = this.getContainerWithKeyObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.targetTV = (ContainerView)it.next();
            if (!this.isBackupFK()) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpi);
            }
        }
        return dpi.targetTV;
    }

    public FKConnection getFKConnection() {
        if (this.fkConnection == null) {
            this.fkConnection = new FKConnection();
            this.fkConnection.setParentTable(this.getRemoteTable());
            this.fkConnection.setChildTable((FKContainer)this.getContainerWithKeyObject());
        }
        return this.fkConnection;
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
        }
    }

    public void repairSelfReference() {
        if (this.getContainerWithKeyObject() == this.getRemoteTable()) {
            Collection targetDPVs = this.getContainerWithKeyObject().getAffectedDPVs();
            for (DesignPartView dpv : targetDPVs) {
                ContainerView tv = this.getTargetTV(dpv);
                ((TVFKRelation)this.getViewFor(dpv)).repairSelfReference(tv);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public void swapAndRemoveFKColumn(FKElement fkColumn, FKElement compatibleColumn, FKElement delegateColumn) {
        if (fkColumn == compatibleColumn) {
            return;
        }
        if (fkColumn.getContainerWithKeyObject() != compatibleColumn.getContainerWithKeyObject() || fkColumn.getContainerWithKeyObject() != this.getContainerWithKeyObject()) {
            return;
        }
        if (FKUtilities.compatibleColumns(fkColumn, compatibleColumn)) {
            int posInIndex = this.getLocalFKIndex().getIndexOf(fkColumn);
            fkColumn.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(fkColumn);
            compatibleColumn.addFKAssociation(delegateColumn, this);
            this.getLocalFKIndex().add(compatibleColumn);
            this.getLocalFKIndex().moveToIndex(compatibleColumn, posInIndex);
            if (fkColumn.getAssociationsCount() == 0 && !fkColumn.isPreviousColumn()) {
                fkColumn.remove();
            }
        }
    }

    public void swapFKColumnsWith(FKElement[] fkColumns) {
        if (this.getKeyObject() != null) {
            FKElement col;
            int i;
            FKElement[] oldCols = (FKElement[])this.getLocalFKIndex().getElements();
            FKElement[] pkCols = (FKElement[])this.getKeyObject().getElements();
            int colnum = pkCols.length;
            if (fkColumns.length < colnum) {
                colnum = fkColumns.length;
            }
            this.changeMapping(oldCols, pkCols, fkColumns);
            for (i = 0; i < oldCols.length; ++i) {
                col = oldCols[i];
                col.removeFKAssociation(this.getObjectID());
                this.getLocalFKIndex().remove(col);
            }
            for (i = 0; i < colnum; ++i) {
                if (fkColumns[i] == null) continue;
                fkColumns[i].addFKAssociation(pkCols[i], this);
                this.getLocalFKIndex().add(fkColumns[i]);
            }
            for (i = 0; i < oldCols.length; ++i) {
                col = oldCols[i];
                if (col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
                col.remove();
            }
        }
    }

    public void swapFKColumnsWithAskDelete(FKElement[] oldCols, FKElement[] fkColumns) {
        if (this.getKeyObject() != null) {
            int i;
            int colnum;
            int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
            FKElement[] pkCols = new FKElement[]{};
            ContainedObject[] keyCols = this.getKeyObject().getElements();
            if (keyCols.length > 0) {
                pkCols = (FKElement[])keyCols;
            }
            if (fkColumns.length < (colnum = pkCols.length)) {
                colnum = fkColumns.length;
            }
            this.changeMapping(oldCols, pkCols, fkColumns);
            for (i = 0; i < oldCols.length; ++i) {
                FKElement col = oldCols[i];
                col.removeFKAssociation(this.getObjectID());
                this.getLocalFKIndex().remove(col);
            }
            for (i = 0; i < colnum; ++i) {
                if (fkColumns[i] == null) continue;
                fkColumns[i].addFKAssociation(pkCols[i], this);
                this.getLocalFKIndex().add(fkColumns[i]);
            }
            Object colNames = "";
            ArrayList<FKElement> colList = new ArrayList<FKElement>();
            for (int i2 = 0; i2 < oldCols.length; ++i2) {
                FKElement col = oldCols[i2];
                if (col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
                colNames = ((String)colNames).equals("") ? col.getName() : (String)colNames + ", " + col.getName();
                colList.add(col);
            }
            if (colList.size() > 0) {
                if (this.getDesign().isClosing() || this.isSilentRemove()) {
                    this.removeColumns(colList);
                } else if (deleteFKcolumns == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                    this.removeColumns(colList);
                } else if (deleteFKcolumns == 2) {
                    JOptionPane pane = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDeleteColumns"), colNames), 3, 0);
                    JDialog dialog = pane.createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                    dialog.setVisible(true);
                    Integer result = (Integer)pane.getValue();
                    if (result == 0) {
                        this.removeColumns(colList);
                    } else {
                        this.clearColumnsAutoFKColumn_flag(colList);
                    }
                }
            }
        }
    }

    private void changeMapping(FKElement[] oldCols, FKElement[] pkCols, FKElement[] fkColumns) {
        Entity ent;
        FKContainer tab;
        if (oldCols.length > 0 && (tab = (FKContainer)oldCols[0].getContainer()) instanceof Table && (ent = ((Table)tab).getEngEntity()) != null) {
            HashMap<FKElement, FKElement> dmap = new HashMap<FKElement, FKElement>();
            for (int i = 0; i < oldCols.length; ++i) {
                FKElement col = oldCols[i];
                FKElement delegate = col.getDelegate();
                if (delegate == null) continue;
                dmap.put(delegate, col);
            }
            int cnum = pkCols.length;
            if (fkColumns.length < cnum) {
                cnum = fkColumns.length;
            }
            for (int i = 0; i < cnum; ++i) {
                DesignObject obj;
                XtdMapping mapping;
                FKElement old;
                FKElement col = fkColumns[i];
                FKElement delegate = pkCols[i];
                if (delegate == null || (old = (FKElement)dmap.get(delegate)) == null || old == col || (mapping = old.getMappingFor(ent)) == null || !((obj = mapping.getObjectMappedTo(old)) instanceof Attribute)) continue;
                Attribute attr = (Attribute)obj;
                XtdMapping nmapping = col.getRMExtendedMap().createMapping(attr, col);
                nmapping.setInheritanceType(mapping.getInheritanceType());
                col.getDesign().getExtendedMap().removeMapping(mapping);
                attr.setEngineerTo(col.getDesignPart().getObjectID(), false);
            }
        }
    }

    private void removeColumns(List<FKElement> colList) {
        for (FKElement col : colList) {
            if (col.isPreviousColumn()) continue;
            col.remove();
            this.elementMap.remove(col);
        }
    }

    private void clearColumnsAutoFKColumn_flag(List<FKElement> colList) {
        for (FKElement col : colList) {
            if (col.isPreviousColumn() || !(col instanceof Column)) continue;
            ((Column)col).setPreviousColumn(true);
            col.setDirty(true);
        }
    }

    public FKElement[] getCompatibleColumns(FKElement column) {
        return FKUtilities.getCompatibleColumns((FKContainer)this.getContainerWithKeyObject(), column);
    }

    public FKElement getColumnForDelegate(FKElement delegate) {
        FKElement[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(this, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    public String getSubstitudeCaption() {
        return "Substitute FK Columns";
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet iset;
        DesignObject obj;
        RelationSet set = this.getDesign().getLogicalDesign().getRelationSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null || (obj = (iset = this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ApplicationView apv = this.getDesign().getAppView();
            DesignPartView dpv = apv.getCurrentDPV();
            if (dpv != null && this.getContainerWithKeyObject().getDesignPart() != dpv.getDesignPart() || dpv == null) {
                dpv = this.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            ForeignKeyPropertiesDialogEx dialog = new ForeignKeyPropertiesDialogEx(apv, this);
            dialog.initProperties(this.getFKMemento(dpv));
            dialog.show();
        }
    }

    public boolean showPropertyDialog(FKMemento mem, Dialog owner) {
        if (!this.isDialogVisible()) {
            ForeignKeyPropertiesDialogEx dialog = new ForeignKeyPropertiesDialogEx(owner, this.getDesign().getAppView(), this, mem);
            dialog.initProperties(mem);
            dialog.setModal(true);
            dialog.show();
            return dialog.changed();
        }
        return false;
    }

    public void addFKElementToView(String colName, FKElement fkElement, TableView view) {
        ColumnView columnView = view.getColumnViewByName(colName);
        if (columnView != null) {
            this.getLocalFKIndex().add(columnView);
            ((FKElement)columnView).addFKAssociation(fkElement, this);
            this.elementMap.put(fkElement, columnView);
            columnView.setNullsAllowed(!this.isMandatory());
        }
    }

    public void addFKElement(FKElement fkElement) {
        this.addFKElement(fkElement, this.getAppView().getSettings().getFkColumnOnNewFKOption() == Settings.ON_NEW_FK_EXIST_BY_TEMPLATE);
    }

    public void addFKElement(FKElement fkElement, boolean searchExisting) {
        ContainerObject originalContainer = this.getOriginalContainer();
        if (!this.getContainerWithKeyObject().isBST() && originalContainer != null) {
            FKContainer table = (FKContainer)this.getContainerWithKeyObject();
            FKElement columnFK = null;
            columnFK = table.getColumnForDelegate(this, fkElement);
            boolean matched = false;
            if (columnFK == null && searchExisting) {
                String fkColName = table.createFKColumnName(fkElement);
                columnFK = table.getEquivelentColumn(fkElement, fkColName, true);
                if (columnFK == null && table instanceof AbstractView) {
                    columnFK = table.getEquivelentColumn(fkElement, fkElement.getName(), true);
                }
                if (columnFK != null) {
                    matched = true;
                }
            }
            if (columnFK == null || !matched && !columnFK.getFKAssociationsForDelegate(fkElement.getObjectID()).contains(this)) {
                columnFK = this.doCreateElementFor(fkElement);
            } else {
                this.getLocalFKIndex().add(columnFK);
                columnFK.addFKAssociation(fkElement, this);
            }
            if (!matched) {
                columnFK.setNullsAllowed(!this.isMandatory());
            }
            this.elementMap.put(fkElement, columnFK);
        }
    }

    public FKElement getOrCreateFKElement(FKElement refColumn, boolean searchExisting) {
        ContainerObject originalContainer = this.getOriginalContainer();
        if (originalContainer == null) {
            originalContainer = refColumn.getContainerWithKeyObject();
        }
        if (!this.getContainerWithKeyObject().isBST() && originalContainer != null) {
            FKContainer table = (FKContainer)this.getContainerWithKeyObject();
            FKElement columnFK = null;
            columnFK = table.getColumnForDelegate(this, refColumn);
            boolean matched = false;
            if (columnFK == null && searchExisting) {
                String fkColName = table.createFKColumnName(refColumn);
                columnFK = table.getEquivelentColumn(refColumn, fkColName, true);
                if (columnFK == null && table instanceof AbstractView) {
                    columnFK = table.getEquivelentColumn(refColumn, refColumn.getName(), true);
                }
                if (columnFK != null) {
                    matched = true;
                }
            }
            if (columnFK == null || !matched && !columnFK.getFKAssociationsForDelegate(refColumn.getObjectID()).contains(this)) {
                columnFK = this.doCreateElementFor(refColumn);
            } else {
                columnFK.addFKAssociation(refColumn, this);
            }
            if (!matched) {
                columnFK.setNullsAllowed(!this.isMandatory());
            }
            return columnFK;
        }
        return null;
    }

    protected FKElement doCreateElementFor(FKElement fkElement) {
        FKElement element = this.createElementFor(fkElement);
        if (!element.isNameFixed()) {
            if (element instanceof ColumnView) {
                element.setName(fkElement.getName());
            } else {
                String generatedFKColumnName = ApplyNamingStandards.createFKColumnName(fkElement, this, this.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.getTable());
                element.setName(generatedFKColumnName != null ? generatedFKColumnName : fkElement.getName());
            }
        }
        this.elementMap.put(fkElement, element);
        return element;
    }

    public void removeAllFKElements() {
        if (this.keyObject != null) {
            ArrayList<FKElement> col = new ArrayList<FKElement>();
            FKElement[] elements = (FKElement[])this.keyObject.getElements();
            for (int i = 0; i < elements.length; ++i) {
                col.add(elements[i]);
            }
            if (this.keyObject.getElementsCollection().size() > 0) {
                this.removeFKElement(col);
            } else {
                this.removeAssociationFromColumns();
            }
        }
        this.elementMap.clear();
    }

    private void removeAssociationFromColumns() {
        for (FKElement col : this.getLocalFKIndex().getElementsCollection()) {
            col.removeFKAssociation(this.getObjectID());
        }
        this.getLocalFKIndex().getElementsCollection().clear();
    }

    public void removeFKElement(List<FKElement> fkColumns) {
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        String tableName = null;
        Object colNames = "";
        ArrayList<FKElement> colList = new ArrayList<FKElement>();
        Iterator<FKElement> it = fkColumns.iterator();
        while (it.hasNext()) {
            FKElement col = ((FKContainer)this.getContainerWithKeyObject()).getFKColumn(this, it.next());
            if (col == null) continue;
            tableName = col.getContainer().getName();
            this.getLocalFKIndex().remove(col);
            col.removeFKAssociation(this.getObjectID());
            if (this.isColumnUsedInConstraints(col) || col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            colNames = ((String)colNames).equals("") ? col.getName() : (String)colNames + ", " + col.getName();
            colList.add(col);
        }
        if (colList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 2) {
                JOptionPane pane = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDelete"), colNames, tableName), 3, 0);
                JDialog dialog = pane.createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                dialog.setVisible(true);
                Integer result = (Integer)pane.getValue();
                if (result == 0) {
                    this.removeColumns(colList);
                } else {
                    this.clearColumnsAutoFKColumn_flag(colList);
                }
            }
        }
    }

    public void setKeyObject(KeyObject keyObject) {
        if (this.keyObject != keyObject) {
            if (this.keyObject != null) {
                this.keyObject.removeContainerListener(this);
                this.keyObject.removeObjectListener(this.getContainerWithKeyObject());
            }
            this.keyObject = keyObject;
            if (this.keyObject != null) {
                keyObject.addContainerListener(this);
                keyObject.addObjectListener(this.getContainerWithKeyObject());
                this.referredKeyID = keyObject.getObjectID();
            } else {
                this.referredKeyID = null;
            }
        }
    }

    public KeyObject getKeyObject() {
        FKContainer rem;
        if (this.keyObject == null && this.referredKeyID != null && (rem = this.getRemoteTable()) != null && rem.isLoadedCompletely()) {
            this.keyObject = rem.getKeyObject(this.referredKeyID);
        }
        return this.keyObject;
    }

    public String[] getDeleteRuleChoices() {
        return DELETE_RULES;
    }

    public void setDeleteRule(String rule) {
        this.deleteRule = rule != null ? rule : DELETE_RULE_NOTHING;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public String getValidDeleteRule() {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getValidFKRule(this.deleteRule);
        }
        return this.deleteRule;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void addAllFKElements() {
        FKElement[] elements = (FKElement[])this.keyObject.getElements();
        if (!this.getContainerWithKeyObject().isBST() && !this.getOriginalContainer().isBST()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i], this.getAppView().getSettings().getFkColumnOnNewFKOption() == Settings.ON_NEW_FK_EXIST_BY_TEMPLATE);
            }
        } else if (this.getContainerWithKeyObject().isBST()) {
            if (this.getOriginalContainer().isBST()) {
                FKElement col = (FKElement)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                if (col == null) {
                    col = (FKElement)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                }
                if (col != null) {
                    this.setRefFKColumn(col);
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    FKElement keyColumn = elements[i];
                    FKElement[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                    if (compatibleColumns.length != 1) continue;
                    FKElement compatibleColumn = compatibleColumns[0];
                    compatibleColumn.addFKAssociation(keyColumn, this);
                    this.getLocalFKIndex().add(compatibleColumn);
                }
            }
        } else if (elements.length > 0 && !elements[0].isOid()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i]);
            }
        } else {
            FKContainer table = (FKContainer)this.getContainerWithKeyObject();
            table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
        }
    }

    private void setRefFKColumn(FKElement column) {
        FKElement col = (FKElement)this.getOriginalContainer().getOidElement();
        if (col != null) {
            column.addFKAssociation(col, this);
        }
        column.setScopeId(this.getOriginalContainer().getObjectID());
        this.getLocalFKIndex().add(column);
    }

    protected String longNameToName(String longName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(longName, ".", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals(".")) {
                buf.append('_');
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public ContainerObject getOriginalContainer() {
        if (this.getKeyObject() == null) {
            return null;
        }
        return this.getKeyObject().getContainerObject();
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        if (this.container == null && this.containerID != null) {
            this.container = (FKContainer)this.getDesign().getDesignObject(this.containerID);
        }
        return this.container;
    }

    @Override
    public String getLongName() {
        if (this.getTable() != null) {
            SchemaObject so = this.getTable().getSchemaObject();
            if (so != null) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
            return this.getName();
        }
        return this.getName();
    }

    @Override
    public String getVeryLongName() {
        if (this.container != null) {
            SchemaObject so = this.container.getSchemaObject();
            if (so != null) {
                StringBuffer buffer = new StringBuffer(so.getName());
                buffer.append(".").append(this.container.getName()).append(".").append(this.getName());
                return buffer.toString();
            }
            StringBuffer buffer = new StringBuffer(this.container.getName());
            buffer.append(".").append(this.getName());
            return buffer.toString();
        }
        return this.getName();
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getViewFor(dpv) != null;
    }

    public Relation getEngRelation() {
        XtdMapping mapping;
        DesignObject obj;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof Relation) {
            return (Relation)obj;
        }
        Relation relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (relation == null) {
            relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return relation;
    }

    public List<XtdMapping> getMappingsToRelations() {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping;
            DesignObject obj;
            ArrayList<XtdMapping> res = new ArrayList<XtdMapping>();
            if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof Relation) {
                res.add(mapping);
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    public Relation getEngRelation(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            Relation rel;
            XtdMapping mapping = (XtdMapping)list.get(i);
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof Relation) || (rel = (Relation)obj).getSourceEntity() != entity && rel.getTargetEntity() != entity) continue;
            return (Relation)obj;
        }
        Relation relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (relation == null) {
            relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return relation;
    }

    public InheritanceRelation getEngInheritanceRelation() {
        XtdMapping mapping;
        DesignObject obj;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof InheritanceRelation) {
            return (InheritanceRelation)obj;
        }
        return null;
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        FKIndexAssociation newAssociation = (FKIndexAssociation)desObject;
        newAssociation.setDeleteRule(this.getDeleteRule());
        newAssociation.setMandatory(this.isMandatory());
        newAssociation.setTransferable(this.isTransferable());
        newAssociation.setArc(this.getArc());
        FKContainer nt = newAssociation.getRemoteTable();
        FKElement col = this.getDiscriminatorColumn();
        if (col != null && nt != null) {
            FKElement dcol = null;
            if (nt.isRemoteObject()) {
                dcol = (FKElement)nt.getElementByRemoteObjectID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (FKElement)nt.getElementByID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (FKElement)nt.getElementByName(col.getName());
            }
            if (dcol != null) {
                newAssociation.setDiscriminatorColumn(dcol);
            }
        }
        newAssociation.setReferredColumnNames(this.getReferredColumnNames());
        newAssociation.setReferredTableLongName(this.getReferredTableLongName());
        newAssociation.setDiscriminatorValue(this.getDiscriminatorValue());
        newAssociation.setColumnDependencyConstraintGenerateName(this.getColumnDependencyConstraintGenerateName());
        newAssociation.setColumnDependencyConstraintGenerateInDDL(this.isColumnDependencyConstraintGenerateInDDL());
        newAssociation.setRely(this.isRely());
    }

    public void backupTo(FKIndexAssociation fk, DesignPartView dpv) {
        if (!fk.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.backupTo(...) can be used only for backup FK");
        }
        this.copy(fk);
        fk.setNameFixed(this.isNameFixed());
        fk.setObjectID(this.getObjectID());
        FKContainer table = (FKContainer)fk.getContainerWithKeyObject();
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKElement oldcol : this.getLocalFKIndex().getElementsCollection()) {
            FKElement newcol = (FKElement)table.getElementByID(oldcol.getObjectID());
            if (newcol == null) continue;
            list.add(newcol);
        }
        fk.swapFKColumnsWith(list.toArray(new FKElement[0]));
        fk.setReferredTableLongName(this.getReferredTableLongName());
        fk.setReferredColumnNames(this.getReferredColumnNames());
    }

    public void restoreTo(FKIndexAssociation fk, DesignPartView dpv) {
        if (!this.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.restoreTo(...) can be used only tp restore from backup FK");
        }
        this.copy(fk);
        FKContainer table = (FKContainer)fk.getContainerWithKeyObject();
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKElement oldcol : this.getLocalFKIndex().getElementsCollection()) {
            FKElement newcol = (FKElement)table.getElementByID(oldcol.getObjectID());
            if (newcol == null) continue;
            list.add(newcol);
        }
        fk.swapFKColumnsWith(list.toArray(new FKElement[0]));
    }

    public void restoreToCandidateOrigFK(FKIndexAssociation candidateOriginatingFK, DesignPartView dpv) {
        if (!this.getContainerWithKeyObject().isBackup() || this.originatingFK != null && this.originatingFK != candidateOriginatingFK) {
            throw new RuntimeException("FKIndexAssociation.restoreToCandidateOrigFK(...) can be used only when new FK on backup table is created in TablePropertiesDialogEx");
        }
        this.originatingFK = candidateOriginatingFK;
        this.restoreTo(candidateOriginatingFK, dpv);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTVTable((ContainerView)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTVTable((ContainerView)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getRemoteTable();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getContainerWithKeyObject();
    }

    public boolean hasColumnWithAllowNulls() {
        FKElement[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setName(String name) {
        KeyObject localFKIndex;
        boolean result = super.setName(name);
        if (ApplicationView.loading) {
            return result;
        }
        if (result && (localFKIndex = this.getLocalFKIndex()) != null) {
            localFKIndex.setName(this.getName());
        }
        return result;
    }

    @Override
    public void setMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
        if (this.getLocalFKIndex() != null) {
            this.getLocalFKIndex().synchronizeMarkedGenerate(markedGenerate);
        }
    }

    public void synchronizeMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        FKElement[] cols;
        if (this.getDesign().isLoading()) {
            this.mandatory = mandatory;
            return;
        }
        boolean hasOptional = false;
        for (FKElement co : cols = this.getColumns()) {
            boolean optional = co.getNullsAllowed();
            if (!optional) continue;
            hasOptional = true;
        }
        if (this.mandatory != mandatory) {
            this.mandatory = mandatory;
            this.setDirty(true);
        }
        KeyObject pk = this.getContainerWithKeyObject().getPK();
        if (!mandatory && !hasOptional) {
            for (int i = cols.length - 1; i >= 0; --i) {
                FKElement co = cols[i];
                if (pk != null && pk.contains(co) || co.isInMandatoryFK() || co.getNullsAllowed()) continue;
                co.setNullsAllowed(true);
                co.setDirty(true);
            }
        } else if (mandatory && hasOptional) {
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                boolean optional = co.getNullsAllowed();
                if (!optional) continue;
                co.setNullsAllowed(false);
                co.setDirty(true);
            }
        }
        if (mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
            this.setDeleteRule(DELETE_RULE_NOTHING);
            this.resetEdgeParams();
        }
        this.resetDependentColumns(mandatory);
    }

    private void resetDependentColumns(boolean mandatory) {
        List list = this.getTable().getColumnsDependinOn(this);
        for (FKElement col : list) {
            if (mandatory) {
                if (col.isMandatory()) continue;
                col.setMandatory(col.isDependOnFK_AsMandatory());
                continue;
            }
            if (!col.isMandatory()) continue;
            col.setDependOnFK_AsMandatory(true);
            col.setMandatory(false);
        }
    }

    public boolean canBeOptional() {
        KeyObject pk = this.getTable().getPK();
        if (pk != null) {
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                if (!pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    public FKArc getArc() {
        return this.arc;
    }

    public void setArc(FKArc arc) {
        this.arc = arc;
    }

    public boolean isInArc() {
        return this.arc != null;
    }

    public void resetEdgeParams() {
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.resetEdgeParams();
        }
    }

    public void createDefaultSelfReferencePoints() {
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.createDefaultSelfReferencePoints();
        }
    }

    public void resetMandatoryUsingColumns() {
        if (this.getLocalFKIndex() != null) {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                if (co.isPKElement()) {
                    // empty if block
                }
                if (co.getNullsAllowed()) {
                    hasNulls = true;
                    continue;
                }
                hasNotNulls = true;
            }
            boolean mand = false;
            if (hasNulls && hasNotNulls) {
                mand = false;
            } else if (hasNotNulls) {
                mand = true;
            }
            if (RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS) {
                this.setMandatory(mand);
            } else {
                this.mandatory = mand;
            }
            if (this.mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
                this.setDeleteRule(DELETE_RULE_NOTHING);
            }
            this.resetEdgeParams();
        }
    }

    @Override
    public List getAllViews() {
        return this.getAllTVRelations();
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (ContainerView)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (ContainerView)sourceTV;
            if (sourceTV != null) {
                dpi.sourceTV.addTopViewListener(this);
            }
        }
    }

    public boolean canRemoveColumnAutomaticaly(FKElement column) {
        FKContainer table = (FKContainer)column.getContainerWithKeyObject();
        KeyObject index = this.getLocalFKIndex();
        if (table != this.getContainerWithKeyObject()) {
            return false;
        }
        if (column.isPreviousColumn()) {
            return false;
        }
        if (this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
            return true;
        }
        int deleteFKcolumns = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        if (deleteFKcolumns == 1) {
            return false;
        }
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyObject key = keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return false;
        }
        return true;
    }

    public List getAutomaticallyRemovedcolumns() {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKElement column : this.getLocalFKIndex().getElementsCollection()) {
            if (!this.canRemoveColumnAutomaticaly(column)) continue;
            list.add(column);
        }
        return list;
    }

    private boolean isColumnUsedInConstraints(FKElement column) {
        FKContainer table = (FKContainer)this.getContainerWithKeyObject();
        KeyObject index = this.getLocalFKIndex();
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyObject key = keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public boolean isBackupFK() {
        return this.originatingFK != null;
    }

    public FKIndexAssociation getOriginatingFK() {
        return this.originatingFK;
    }

    public ContainerView getOriginatingSourceTVTable() {
        return this.originatingSourceTVTable;
    }

    public void setOriginatingSourceTVTable(ContainerView originatingSourceTVTable) {
        this.originatingSourceTVTable = originatingSourceTVTable;
    }

    public ContainerView getOriginatingTargetTVTable() {
        return this.originatingTargetTVTable;
    }

    public void setOriginatingTargetTVTable(ContainerView originatingTargetTVTable) {
        this.originatingTargetTVTable = originatingTargetTVTable;
    }

    public FKMemento getFKMemento(DesignPartView dpv) {
        FKMemento mem = new FKMemento(this);
        mem.name = this.getName();
        mem.comments = this.getComment();
        mem.notes = this.getNotes();
        mem.id = this.getObjectID();
        mem.index_id = this.getLocalFKIndex().getObjectID();
        mem.mandatory = this.isMandatory();
        mem.generate_in_DDL = this.isMarkedGenerate();
        mem.cdcDeprecated = this.isDeprecated();
        mem.transferable = this.isTransferable();
        mem.table = (FKContainer)this.getContainerWithKeyObject();
        mem.remoteTable = this.getRemoteTable();
        mem.remoteKey = this.getRemoteIndex();
        if (mem.remoteKey != null) {
            mem.remoteKeyID = this.getRemoteIndex().getObjectID();
        }
        mem.deleteRule = this.getDeleteRule();
        mem.arc = this.getArc();
        mem.dpv = dpv;
        mem.sourceTV = this.getSourceTV(dpv);
        mem.targetTV = this.getTargetTV(dpv);
        mem.discrColumn = this.getDiscriminatorColumn();
        mem.discrValue = this.getDiscriminatorValue();
        mem.name_fixed = this.isNameFixed();
        for (FKElement col : this.getLocalFKIndex().getElementsCollection()) {
            FKElement refcol = col.getReferencedColumn(this);
            if (col == null || refcol == null) continue;
            mem.columns.add(col.getObjectID());
        }
        mem.cdcName = this.getColumnDependencyConstraintGenerateName();
        mem.cdcGenerateInDDL = this.isColumnDependencyConstraintGenerateInDDL();
        mem.rely = this.isRely();
        return mem;
    }

    public void resetFromMemento(FKMemento mem) {
        if (mem.fk != this) {
            throw new RuntimeException("FKMemento object is for another Foreign key");
        }
        if (mem.dobj != null) {
            mem.dobj.copyDynamicProperties(this);
        }
        this.setNameFixed(mem.name_fixed);
        this.setName(mem.name);
        this.setComment(mem.comments);
        this.setNotes(mem.notes);
        this.setMarkedGenerate(mem.generate_in_DDL);
        this.setDeprecated(mem.cdcDeprecated);
        this.getLocalFKIndex().setMarkedGenerate(mem.generate_in_DDL);
        this.setDeleteRule(mem.deleteRule);
        this.setTransferable(mem.transferable);
        if (mem.remoteKey == null && this.getKeyObject() != null) {
            this.setReferredTableID(null);
        }
        FKElement[] fkColumns = FKUtilities.getFKColumnsFromTable(mem, (FKContainer)this.getContainerWithKeyObject());
        this.changeKeyObject(mem.remoteKey, fkColumns);
        if (mem.sourceTV != null && mem.targetTV != null) {
            this.setSourceTVTable(mem.sourceTV);
            this.setTargetTVTable(mem.targetTV);
        }
        this.setMandatory(mem.mandatory);
        this.setDiscriminatorColumn(mem.discrColumn);
        this.setDiscriminatorValue(mem.discrValue);
        this.setColumnDependencyConstraintGenerateName(mem.cdcName);
        this.setColumnDependencyConstraintGenerateInDDL(mem.cdcGenerateInDDL);
        this.setRely(mem.rely);
        this.getTable().setDirty(true);
        for (TVFKRelation tv : this.getAllTVRelations()) {
            tv.displayLabels();
        }
        this.resetEdgeParams();
    }

    public void setNewFK(FKIndexAssociation fk) {
        this.setName(fk.name);
        this.setComment(fk.getComment());
        this.setNotes(fk.getNotes());
        this.setMarkedGenerate(fk.isMarkedGenerate());
        this.setDeleteRule(fk.deleteRule);
        this.setTransferable(fk.transferable);
        this.setMandatory(fk.mandatory);
        this.setColumnDependencyConstraintGenerateName(fk.columnDependencyConstraintGenerateName);
        this.setColumnDependencyConstraintGenerateInDDL(fk.columnDependencyConstraintGenerateInDDL);
        if (fk.sourceTVT != null && fk.targetTVT != null) {
            this.setSourceTVTable(fk.sourceTVT);
            this.setTargetTVTable(fk.targetTVT);
        }
        this.getTable().setDirty(true);
        this.resetEdgeParams();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "foreignkey" + File.separatorChar + this.getObjectID() + ".xml").getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSilentRemove() {
        return this.silentRemove;
    }

    public void setSilentRemove(boolean silentRemove) {
        this.silentRemove = silentRemove;
    }

    public boolean isOneToOne() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique() && !"Unique Plain Index".equalsIgnoreCase(key.getIndexState()) || key.getElementsCollection().size() != cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentifyingForPK() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() || key.getElementsCollection().size() < cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTable() {
        FKContainer table = this.getTable();
        if (table != null && table.isLoadedCompletely() && !table.getFKAssociationsList().contains(this)) {
            boolean pk_prop = this.getDesign().isPropagatePKChahges();
            try {
                String segm_name = this.getDirectorySegmentName();
                this.getDesign().setPropagatePKChahges(false);
                table.addRecreateFKAssociation(this);
                this.setDirectorySegmentName(segm_name, true);
            }
            catch (Exception ex) {
                System.out.println("fk - " + this.getName() + "   - table " + this.getTable().getName());
            }
            finally {
                this.getDesign().setPropagatePKChahges(pk_prop);
            }
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public String toString() {
        return this.getVeryLongName();
    }

    @Override
    public Collection getAffectedDPVs() {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null || dpi.dpv == null) continue;
            list.add(dpi.dpv);
        }
        return list;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        if (this.discriminatorValue == null && discriminatorValue != null && !discriminatorValue.isEmpty()) {
            this.setDirty(true);
        } else if (this.discriminatorValue != null && !this.discriminatorValue.equals(discriminatorValue)) {
            this.setDirty(true);
        }
        this.discriminatorValue = discriminatorValue;
    }

    public FKElement getDiscriminatorColumn() {
        Column col;
        if (this.arc != null && (col = this.arc.getDiscriminatorColumn()) != null) {
            return col;
        }
        return this.discriminatorColumn;
    }

    public FKElement getDiscriminatorColumnToStore() {
        if (this.arc != null && this.arc.getDiscriminatorColumn() != null) {
            return null;
        }
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(FKElement discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public DesignObject getTempObject() {
        FKIndexAssociation dobj = new FKIndexAssociation(this.getDesignPart());
        dobj.setTempObject(true);
        return dobj;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject result = design.getDesignObject(id);
            if (result == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    result = map.get(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "containerWithKeyObject".equals(propertyName)) {
                    result = ((RelationalDesign)this.getDesignPart()).getTableSet().getObjectByRemoteObjectID(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "localFKIndex".equals(propertyName)) {
                    result = this.getTable().getKeySet().getObjectByRemoteObjectID(id);
                }
                return result;
            }
            return result;
        }
        return null;
    }

    public boolean isColumnDependencyConstraintGenerateInDDL() {
        return this.columnDependencyConstraintGenerateInDDL;
    }

    public void setColumnDependencyConstraintGenerateInDDL(boolean columnDependencyConstraintGenerateInDDL) {
        this.columnDependencyConstraintGenerateInDDL = columnDependencyConstraintGenerateInDDL;
    }

    public String getColumnDependencyConstraintGenerateName() {
        return this.columnDependencyConstraintGenerateName;
    }

    public void setColumnDependencyConstraintGenerateName(String columnDependencyConstraintGenerateName) {
        this.columnDependencyConstraintGenerateName = columnDependencyConstraintGenerateName;
    }

    public String getReferredTableID() {
        KeyObject key = this.getKeyObject();
        if (key != null && key.getContainerWithKeyObject() != null) {
            this.referredTableID = key.getContainerWithKeyObject().getObjectID();
        }
        return this.referredTableID;
    }

    public void setReferredTableID(String referredTableID) {
        this.referredTableID = referredTableID;
    }

    public String getContainerID() {
        FKContainer co = (FKContainer)this.getContainerWithKeyObject();
        if (!(co == null || co.isRemoved() && this.containerID != null)) {
            this.containerID = co.getObjectID();
        }
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public String getReferredKeyID() {
        KeyObject key = this.getKeyObject();
        if (key != null) {
            this.referredKeyID = key.getObjectID();
        }
        return this.referredKeyID;
    }

    public void setReferredKeyID(String referredKeyID) {
        this.referredKeyID = referredKeyID;
    }

    public String getReferredTableLongName() {
        FKContainer remoteContainer = this.getRemoteTable();
        if (remoteContainer != null) {
            return remoteContainer.getLongName();
        }
        if (this.referredTableLongName == null) {
            return "";
        }
        return this.referredTableLongName;
    }

    public void setReferredTableLongName(String name) {
        this.referredTableLongName = name;
    }

    public String getFormattedReferredTableLongName() {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        FKContainer remoteContainer = this.getRemoteTable();
        if (remoteContainer != null) {
            return sd.getFormatedLongNameDDL(remoteContainer);
        }
        if (this.referredTableLongName == null) {
            return "";
        }
        String name = this.referredTableLongName;
        if (!this.getAppView().getSettings().isIncludeSchemaInDDL()) {
            name = name.substring(name.indexOf(46));
        }
        return sd.getFormatedName(name);
    }

    public boolean isRely() {
        return this.rely;
    }

    public void setRely(boolean rely) {
        this.rely = rely;
    }

    public int getNumberOfColumns() {
        if (this.getLocalFKIndex() == null) {
            return 0;
        }
        return this.getLocalFKIndex().getElementsCollection().size();
    }

    public boolean isAllColumnGenerated() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        for (int i = 0; i < cols.length; ++i) {
            FKElement col = cols[i];
            if (!col.isPreviousColumn()) continue;
            return false;
        }
        return true;
    }

    public String getReferredColumnNames() {
        KeyObject remoteKey = this.getKeyObject();
        if (remoteKey != null && remoteKey.getElementsCollection().size() > 0) {
            boolean first = true;
            for (DesignObject dob : remoteKey.getElementsCollection()) {
                String colName = dob.getName();
                if (first) {
                    first = false;
                    this.referredColumnNames = colName;
                    continue;
                }
                this.referredColumnNames = this.referredColumnNames + "," + colName;
            }
        }
        if (this.referredColumnNames == null) {
            return "";
        }
        return this.referredColumnNames;
    }

    public String getUsedColumnNames() {
        Object res = null;
        for (FKElement fke : this.getLocalFKIndex().getElementsCollection()) {
            if (res == null) {
                res = fke.getName();
                continue;
            }
            res = (String)res + "," + fke.getName();
        }
        if (res == null) {
            return "";
        }
        return res;
    }

    public List getUsedColumnsList() {
        Collection cols = this.getLocalFKIndex().getElementsCollection();
        if (cols.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(cols);
    }

    public void setReferredColumnNames(String referredColumnNames) {
        this.referredColumnNames = referredColumnNames;
    }

    public boolean isRefColumnsChanged() {
        return this.refColumnsChanged;
    }

    public void setRefColumnsChanged(boolean refColumnsChanged) {
        this.refColumnsChanged = refColumnsChanged;
    }

    public String getJoinedColumns() {
        Object res = "";
        KeyObject fki = this.getLocalFKIndex();
        if (fki != null && fki.getElementsCollection().size() > 0) {
            boolean first = true;
            for (DesignObject dob : fki.getElementsCollection()) {
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + dob.getLongName();
            }
            res = (String)res + " - ";
            if (this.getRemoteIndex() != null) {
                first = true;
                for (DesignObject dob : this.getRemoteIndex().getElementsCollection()) {
                    if (!first) {
                        res = (String)res + ",";
                    } else {
                        first = false;
                    }
                    res = (String)res + dob.getLongName();
                }
            } else if (!this.getReferredColumnNames().isEmpty()) {
                String[] parts = this.getReferredColumnNames().split(",");
                Object t = "";
                for (String part : parts) {
                    if (!((String)t).isEmpty()) {
                        t = (String)t + ",";
                    }
                    t = (String)t + this.getReferredTableLongName() + "." + part;
                }
                res = (String)res + (String)t;
            }
        }
        return res;
    }

    public class FKConnection {
        FKContainer child;
        FKContainer parent;
        public int countAdded = 0;

        public void setChildTable(FKContainer table) {
            this.child = table;
        }

        public FKContainer getChildTable() {
            return this.child;
        }

        public ContainerView getSourceTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getSourceTV(dpv);
        }

        public ContainerView getTargetTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getTargetTV(dpv);
        }

        public void setParentTable(FKContainer table) {
            this.parent = table;
        }

        public FKContainer getParentTable() {
            return this.parent;
        }

        public String toString() {
            return FKIndexAssociation.this.getName();
        }

        public TopView getTopView() {
            return FKIndexAssociation.this.getTopView();
        }

        public TopView getViewFor(DesignPartView dpv) {
            return FKIndexAssociation.this.getViewFor(dpv);
        }

        public FKIndexAssociation getFKIndexAssociation() {
            return FKIndexAssociation.this;
        }
    }

    public class dpvInfo {
        public ContainerView sourceTV;
        public ContainerView targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class FKMemento {
        public FKIndexAssociation fk;
        public DesignObject.BackupDesignObject dobj;
        public DesignPartView dpv;
        public String comments = "";
        public String notes = "";
        public String name;
        public String id;
        public String index_id;
        public boolean mandatory;
        public boolean transferable;
        public boolean generate_in_DDL;
        public boolean name_fixed;
        public FKContainer table;
        public FKContainer remoteTable;
        public String remoteKeyID;
        public KeyObject remoteKey;
        public List<String> columns = new ArrayList<String>();
        public String deleteRule = "";
        public FKArc arc;
        public ContainerView sourceTV;
        public ContainerView targetTV;
        public FKElement discrColumn;
        public String discrValue = "";
        public String cdcName = "";
        public boolean cdcGenerateInDDL;
        public boolean cdcDeprecated;
        public boolean rely;

        public FKMemento(FKIndexAssociation fk) {
            this.fk = fk;
            this.dobj = new DesignObject.BackupDesignObject(fk.getDesignPart());
            fk.copyDynamicProperties(this.dobj);
        }

        public void copyTo(FKMemento mem) {
            if (this.dobj != null) {
                this.dobj.copyDynamicProperties(mem.dobj);
            }
            mem.comments = this.comments;
            mem.notes = this.notes;
            mem.name = this.name;
            mem.id = this.id;
            mem.index_id = this.index_id;
            mem.mandatory = this.mandatory;
            mem.transferable = this.transferable;
            mem.generate_in_DDL = this.generate_in_DDL;
            mem.table = this.table;
            mem.remoteTable = this.remoteTable;
            mem.remoteKeyID = this.remoteKeyID;
            mem.remoteKey = this.remoteKey;
            mem.columns.addAll(this.columns);
            mem.deleteRule = this.deleteRule;
            mem.sourceTV = this.sourceTV;
            mem.targetTV = this.targetTV;
            mem.arc = this.arc;
            mem.dpv = this.dpv;
            mem.discrColumn = this.discrColumn;
            mem.discrValue = this.discrValue;
            mem.name_fixed = this.name_fixed;
            mem.cdcName = this.cdcName;
            mem.cdcGenerateInDDL = this.cdcGenerateInDDL;
            mem.cdcDeprecated = this.cdcDeprecated;
            mem.rely = this.rely;
        }
    }
}

