/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class MappedVarsCollector
extends CustomDialog {
    private File logicalFile = null;
    private JTextField text;
    private JList list;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private URLChooser fileChooser;
    private static final Logger LOGGER = new Logger(MappedVarsCollector.class);

    public MappedVarsCollector(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        URLFilter fileFilter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                return file.getName().toLowerCase().endsWith(".var") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("MappedVarsCollector.VARFiles");
            }
        };
        this.fileChooser = new URLFileChooser();
        this.fileChooser.clearChooseableURLFilters();
        this.fileChooser.setSelectionScope(0);
        this.fileChooser.setSelectionMode(0);
        this.fileChooser.setShowJarsAsDirs(false);
        this.fileChooser.setURLFilter(fileFilter);
        ((URLFileChooser)this.fileChooser).setPathContext("dataModeler_Imports");
        String lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
        if (lastDir != null) {
            this.fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
        } else {
            URL url = this.getApplicationView().getUserHomeDirectory();
            if (url != null) {
                this.fileChooser.setSelectedURL(url);
            }
        }
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel logicalPanel = new JPanel();
        TitledBorder title = BorderFactory.createTitledBorder(Messages.getString("MappedVarsCollector.Logical"));
        logicalPanel.setBorder(title);
        this.text = new JTextField();
        this.text.setEditable(false);
        this.text.setPreferredSize(new Dimension(260, 20));
        logicalPanel.add(this.text);
        JButton selButton = new JButton(Messages.getString("MappedVarsCollector.Select"));
        selButton.setMnemonic(83);
        selButton.addActionListener(new SelListener());
        logicalPanel.add(selButton);
        jpanel.add((Component)logicalPanel, "North");
        JPanel relationalPanel = new JPanel();
        title = BorderFactory.createTitledBorder(Messages.getString("MappedVarsCollector.Relationals"));
        relationalPanel.setBorder(title);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        relationalPanel.add(new JScrollPane(this.list));
        JPanel buttons = new JPanel(new BorderLayout());
        JButton addButton = new JButton(Messages.getString("MappedVarsCollector.Add"));
        addButton.setMnemonic(65);
        addButton.addActionListener(new AddListener());
        buttons.add((Component)addButton, "North");
        JButton delButton = new JButton(Messages.getString("MappedVarsCollector.Remove"));
        delButton.setMnemonic(82);
        delButton.addActionListener(new RemoveListener());
        buttons.add((Component)new JPanel(), "Center");
        buttons.add((Component)delButton, "South");
        relationalPanel.add(buttons);
        jpanel.add((Component)relationalPanel, "Center");
        JPanel bottom = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(Messages.getString("MappedVarsCollector.OK"));
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappedVarsCollector.this.result = MappedVarsCollector.this.checkFiles();
                if (MappedVarsCollector.this.result) {
                    MappedVarsCollector.this.close();
                }
            }
        });
        bottom.add(okButton);
        JButton cancelButton = new JButton(Messages.getString("MappedVarsCollector.Cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappedVarsCollector.this.result = false;
                MappedVarsCollector.this.close();
            }
        });
        bottom.add(cancelButton);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bottom.add(bnHelp);
        okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottom, "South");
        this.add(jpanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("MappedVarsCollector.SelectMappedVarFiles"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_MAPPED_VAR_FILES_DIALOG";
    }

    public boolean showDialog(ApplicationView view) {
        this.result = false;
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkFiles() {
        if (this.logicalFile == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.YouMustSelectLogicalVARFile"), Messages.getString("MappedVarsCollector.Warning"), 2);
            return false;
        }
        if (this.getRelationalFiles().length == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.YouMustSelect1RelationalVARFile"), Messages.getString("MappedVarsCollector.Warning"), 2);
            return false;
        }
        return true;
    }

    private class SelListener
    implements ActionListener {
        private SelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File selected;
            int status = MappedVarsCollector.this.fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.SelectLogicalFile"));
            MappedVarsCollector.this.fileChooser.setFileNameURL("");
            if (status == 0 && (selected = new File(MappedVarsCollector.this.fileChooser.getSelectedURL().getPath())) != null) {
                MappedVarsCollector.this.logicalFile = selected;
                MappedVarsCollector.this.text.setText(MappedVarsCollector.this.logicalFile.getAbsolutePath());
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File selected;
                int status = MappedVarsCollector.this.fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.SelectRelationalFile"));
                MappedVarsCollector.this.fileChooser.setFileNameURL("");
                if (status == 0 && (selected = new File(MappedVarsCollector.this.fileChooser.getSelectedURL().getPath())) != null) {
                    MappedVarsCollector.this.listModel.addElement(selected);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error select relational File!", ex);
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = MappedVarsCollector.this.list.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                MappedVarsCollector.this.listModel.removeElement(selected[i]);
            }
        }
    }
}

