/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k12;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSequenceSqlServerv2k12
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceSqlServerv2k12.class);

    public MOHSequenceSqlServerv2k12(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbUser) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String uid = dbUser.getId();
        String db = dbUser.getDb();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.').append("NAME").append(' ');
            buffer.append("SEQUENCE_NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.').append("OBJECT_ID").append(' ');
            buffer.append("SEQUENCE_ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.').append("SCHEMA_ID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHSequenceSqlServerv2k12.getFormattedName(db)).append('.').append("sys.sequences o").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("o").append('.').append("SCHEMA_ID").append(' ');
            buffer.append('=').append(' ').append(uid).append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHSequenceSQLServerv2k12.extractByUser():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String seqName = rs.getString(1);
                DBObjectSqlServer dboSeq = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), seqName, OBJECT_TYPE, "");
                dboSeq.setDb(db);
                dboSeq.setSchema(dbUser.getName());
                list.add(dboSeq);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append("SCHEMA_NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append("SEQUENCE_NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("OBJECT_ID").append(' ');
                buffer.append("SEQUENCE_ID").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("START_VALUE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("INCREMENT").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("MINIMUM_VALUE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("MAXIMUM_VALUE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("IS_CYCLING").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("IS_CACHED").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("CACHE_SIZE").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("PRECISION").append(' ');
                buffer.append(',').append(' ');
                buffer.append("t").append('.').append("NAME").append(' ');
                buffer.append("DATATYPE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHSequenceSqlServerv2k12.getFormattedName(db)).append('.').append("sys.sequences o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHSequenceSqlServerv2k12.getFormattedName(db)).append('.').append("sys.schemas u").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHSequenceSqlServerv2k12.getFormattedName(db)).append('.').append("sys.types t").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("o").append('.').append("SCHEMA_ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("u").append('.').append("SCHEMA_ID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(name).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(dbo.getSchema()).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("USER_TYPE_ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("t").append('.').append("USER_TYPE_ID");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHSequenceSqlServerv2k12.generate():", e);
            }
            ArrayList<Properties> list = new ArrayList<Properties>();
            if (rs != null) {
                while (rs.next()) {
                    String username = rs.getString(1);
                    String seq_name = rs.getString(2);
                    String seq_id = rs.getString(3);
                    String start_val = rs.getString(4);
                    String incr_by = rs.getString(5);
                    String min_val = rs.getString(6);
                    String max_val = rs.getString(7);
                    String cycling = rs.getInt(8) == 0 ? "NO" : "YES";
                    String not_cached = rs.getInt(9) == 0 ? "YES" : "NO";
                    int cache_size = 0;
                    try {
                        cache_size = rs.getInt(10);
                    }
                    catch (NumberFormatException nfe) {
                        cache_size = 0;
                    }
                    int int_precision = 0;
                    try {
                        int_precision = rs.getInt(11);
                    }
                    catch (NumberFormatException nfe) {
                        int_precision = 0;
                    }
                    String integer_type = rs.getString(12);
                    Properties props = new Properties();
                    props.setProperty("username", username);
                    props.setProperty("seq_name", seq_name);
                    props.setProperty("seq_id", seq_id);
                    props.setProperty("start_with", start_val);
                    props.setProperty("increment_by", incr_by);
                    props.setProperty("min_value", min_val);
                    props.setProperty("max_value", max_val);
                    props.setProperty("cycle", cycling);
                    props.setProperty("no_cache", not_cached);
                    props.setProperty("cache_size", String.valueOf(cache_size));
                    props.setProperty("integer_precision", String.valueOf(int_precision));
                    props.setProperty("integer_type", integer_type);
                    list.add(props);
                }
            }
            if (statement != null) {
                statement.close();
            }
            if (this.getStorageDesign() == null || !(this.getStorageDesign() instanceof StorageDesignSqlServerv2k12)) continue;
            StorageDesignSqlServerv2k12 storageDesign = (StorageDesignSqlServerv2k12)this.getStorageDesign();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                SequenceSqlServerv2k12 seq = storageDesign.getSequenceSet().createSequence(null);
                this.setDatabase(seq, db);
                this.setSchema(seq, dbo.getSchema());
                seq.setName(name);
                this.stampModelObject(seq, dbo);
                Properties props = (Properties)it.next();
                String integer_type = props.getProperty("integer_type");
                String integer_precision = props.getProperty("integer_precision");
                String start_with = props.getProperty("start_with");
                String increment_by = props.getProperty("increment_by");
                String min_value = props.getProperty("min_value");
                String max_value = props.getProperty("max_value");
                String cycle = props.getProperty("cycle");
                String no_cache = props.getProperty("no_cache");
                String cache = props.getProperty("cache_size");
                seq.setIntegerType(integer_type);
                seq.setIntegerPrecision(integer_precision);
                seq.setStartWith(start_with);
                seq.setIncrementBy(increment_by);
                seq.setMinValue(min_value);
                seq.setMaxValue(max_value);
                seq.setCycle(cycle);
                seq.setNoCache(no_cache);
                if ("0".equals(cache)) continue;
                seq.setCache(cache);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setDatabase(SequenceSqlServerv2k12 seq, String databaseName) {
        DataBaseSqlServer database = (DataBaseSqlServer)((StorageDesignSqlServerv2k12)this.getStorageDesign()).getDataBaseSet().getByName(databaseName);
        if (database != null) {
            seq.setDatabase(database);
        }
    }

    private void setSchema(SequenceSqlServerv2k12 seq, String schemaName) {
        SchemaSqlServer schema;
        if (seq.getDatabase() != null && (schema = (SchemaSqlServer)seq.getDatabase().getSchemas().getByName(schemaName)) != null) {
            seq.setSchema(schema);
        }
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

