/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.TSDPSubPolicy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTSDPPolicyOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TSDP POLICY";
    protected boolean dbaUser;
    private static final Logger LOGGER = new Logger(MOHTSDPPolicyOracle.class);

    public MOHTSDPPolicyOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.dbaUser) {
            try {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignOraclev12c) {
                    boolean found = false;
                    Statement statement = sqlConnection.createStatement();
                    Statement property_statement = null;
                    Statement param_statement = null;
                    PreparedStatement sensitive_type_statement = null;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("POLICY_NAME").append(' ');
                    buffer.append("FROM").append(' ').append("DBA_TSDP_POLICY_FEATURE").append(' ');
                    buffer.append("WHERE").append(' ').append("SECURITY_FEATURE").append(' ').append('=').append('\'').append("REDACTION").append('\'');
                    String sql = buffer.toString();
                    ResultSet rs = statement.executeQuery(sql);
                    if (rs != null) {
                        while (rs.next()) {
                            String name = rs.getString(1);
                            System.out.println(name);
                            found = true;
                            TSDPPolicy policy = (TSDPPolicy)storageDesign.getAppView().getTSDPPolicySet().getByName(name);
                            if (policy == null) {
                                policy = storageDesign.getAppView().getTSDPPolicySet().createTSDPPolicy();
                                policy.setName(name);
                            }
                            Object[] subPolicies = policy.getElements().toArray();
                            for (int i = subPolicies.length - 1; i >= 0; --i) {
                                TSDPSubPolicy subPolicy = (TSDPSubPolicy)subPolicies[i];
                                subPolicy.remove();
                            }
                            policy.getSensitiveTypesList().clear();
                            if (property_statement == null) {
                                buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ').append("POLICY_NAME").append(',').append(' ');
                                buffer.append("SUB_POLICY").append(',').append(' ');
                                buffer.append("PROPERTY").append(',').append(' ');
                                buffer.append("VALUE").append(' ');
                                buffer.append("FROM").append(' ').append("DBA_TSDP_POLICY_CONDITION").append(' ');
                                buffer.append("WHERE").append(' ').append("POLICY_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                                buffer.append("ORDER BY").append(' ').append("POLICY_NAME").append(',').append(' ').append("SUB_POLICY");
                                String csql = buffer.toString();
                                property_statement = sqlConnection.prepareStatement(csql);
                            }
                            property_statement.setString(1, name);
                            ResultSet rsColumns = property_statement.executeQuery();
                            String subPolicyNumber = null;
                            TSDPSubPolicy subPolicy = null;
                            if (rsColumns != null) {
                                while (rsColumns.next()) {
                                    String index = rsColumns.getString(2);
                                    String property = rsColumns.getString(3);
                                    String value = rsColumns.getString(4);
                                    if (subPolicyNumber == null || !subPolicyNumber.equalsIgnoreCase(index)) {
                                        subPolicy = policy.createSubPolicy();
                                        subPolicyNumber = index;
                                        if (param_statement == null) {
                                            buffer = new StringBuffer();
                                            buffer.append("SELECT").append(' ').append("POLICY_NAME").append(',').append(' ');
                                            buffer.append("SUB_POLICY").append(',').append(' ');
                                            buffer.append("PARAMETER").append(',').append(' ');
                                            buffer.append("VALUE").append(' ');
                                            buffer.append("FROM").append(' ').append("DBA_TSDP_POLICY_PARAMETER").append(' ');
                                            buffer.append("WHERE").append(' ').append("POLICY_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                                            buffer.append("AND").append(' ').append("SUB_POLICY").append('=').append(' ').append('?');
                                            String psql = buffer.toString();
                                            param_statement = sqlConnection.prepareStatement(psql);
                                        }
                                        param_statement.setString(1, name);
                                        param_statement.setString(2, index);
                                        String datatype = null;
                                        if (property != null && value != null && property.equalsIgnoreCase("DATATYPE")) {
                                            datatype = value;
                                        }
                                        this.addSubPolicyParameters(subPolicy, (PreparedStatement)param_statement, datatype);
                                    }
                                    if (property == null || value == null) continue;
                                    if (property.equalsIgnoreCase("DATATYPE")) {
                                        subPolicy.setPropertyDatatype(value);
                                        continue;
                                    }
                                    if (property.equalsIgnoreCase("LENGTH")) {
                                        try {
                                            subPolicy.setPropertyLenght(Integer.parseInt(value));
                                        }
                                        catch (Exception exception) {}
                                        continue;
                                    }
                                    if (property.equalsIgnoreCase("PARENT_SCHEMA")) {
                                        subPolicy.setPropertyParentSchema(value);
                                        continue;
                                    }
                                    if (!property.equalsIgnoreCase("PARENT_TABLE")) continue;
                                    subPolicy.setPropertyParentTable(value);
                                }
                                rsColumns.close();
                            }
                            if (sensitive_type_statement == null) {
                                buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ').append("SENSITIVE_TYPE").append(' ');
                                buffer.append("FROM").append(' ').append("DBA_TSDP_POLICY_TYPE").append(' ');
                                buffer.append("WHERE").append(' ').append("POLICY_NAME").append(' ').append('=').append(' ').append('?');
                                String stsql = buffer.toString();
                                sensitive_type_statement = sqlConnection.prepareStatement(stsql);
                            }
                            sensitive_type_statement.setString(1, name);
                            this.associateWithSensitiveTypes(policy, sensitive_type_statement);
                        }
                        rs.close();
                    }
                    if (param_statement != null) {
                        param_statement.close();
                    }
                    if (property_statement != null) {
                        property_statement.close();
                    }
                    if (sensitive_type_statement != null) {
                        property_statement.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (found) {
                        storageDesign.getAppView().saveTSDPPolicies();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHTSDPPolicyOracle.generate():", e);
            }
        }
    }

    private void addSubPolicyParameters(TSDPSubPolicy subPolicy, PreparedStatement param_statement, String datatype) throws SQLException {
        ResultSet rs = null;
        rs = param_statement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                String param = rs.getString(3);
                String value = rs.getString(4);
                if (param == null || value == null) continue;
                if (param.equalsIgnoreCase("EXPRESSION")) {
                    subPolicy.setExpression(value);
                    continue;
                }
                if (!param.equalsIgnoreCase("FUNCTION_PARAMETERS")) continue;
                boolean found = false;
                for (MaskTemplate maskTemplate : this.getStorageDesign().getAppView().getMaskTemplateSet()) {
                    if (!value.trim().equalsIgnoreCase(maskTemplate.getFunctionParameters())) continue;
                    subPolicy.setMaskTemplate(maskTemplate);
                    found = true;
                    break;
                }
                if (found) continue;
                MaskTemplate mt = new MaskTemplate(this.getDesign().getAppView());
                mt.setFunctionType(0);
                if (datatype != null) {
                    mt.setDataType(this.getMaskTemplateDataType(datatype));
                }
                mt.parseFunctionParameters(value);
                this.getDesign().getAppView().getMaskTemplateSet().add(mt);
                subPolicy.setMaskTemplate(mt);
            }
            rs.close();
        }
    }

    private void associateWithSensitiveTypes(TSDPPolicy policy, PreparedStatement sensitive_type_statement) throws SQLException {
        ResultSet rs = null;
        rs = sensitive_type_statement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                SensitiveType sensitiveType;
                String sensitiveTypeName = rs.getString(1);
                if (sensitiveTypeName == null || (sensitiveType = (SensitiveType)this.getStorageDesign().getAppView().getSensitiveTypeSet().getByName(sensitiveTypeName)) == null) continue;
                policy.addSensitiveType(sensitiveType);
            }
            rs.close();
        }
    }

    private int getMaskTemplateDataType(String datatype) {
        if ("CHAR".equalsIgnoreCase(datatype) || "VARCHAR".equalsIgnoreCase(datatype) || "VARCHAR2".equalsIgnoreCase(datatype) || "NVARCHAR".equalsIgnoreCase(datatype) || "NVARCHAR2".equalsIgnoreCase(datatype)) {
            return 0;
        }
        if ("NUMBER".equalsIgnoreCase(datatype) || "INTEGER".equalsIgnoreCase(datatype)) {
            return 1;
        }
        if ("DATE".equalsIgnoreCase(datatype)) {
            return 2;
        }
        return 0;
    }
}

