/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPermissionsSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PermissionsSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsSqlServerv2k5
extends SHGrantPermissionsSqlServer {
    private PermissionsSqlServerv2k5 permissions;
    private StorageDesignSqlServerv2k5 storageDesign;
    private TableProxySqlServerv2k5 table = null;
    private TableViewProxySqlServerv2k5 view = null;
    private DataBaseSqlServerv2k5 db = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsSqlServerv2k5.class);

    public SHGrantPermissionsSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPermissionsSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "GRANT") && Token.hasToken(statement, "ON")) {
            try {
                this.grantPermissions(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHGrantPermissionsSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPermissions(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            RelationalObjectProxy proxy = this.initOn();
            ArrayList users = this.initUsersAndRoles();
            if (proxy != null) {
                for (int i = 0; i < users.size(); ++i) {
                    if (this.getPermissionForUser((StorageObject)users.get(i), proxy) != null) {
                        this.permissions = this.getPermissionForUser((StorageObject)users.get(i), proxy);
                    } else {
                        this.permissions = (PermissionsSqlServerv2k5)this.storageDesign.getPermissionsSet().createPermissions();
                        this.design.getRelationalDesign().stampModelObjectDDL(this.permissions);
                    }
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(proxy);
                    this.initTo(users.get(i));
                    this.initAs();
                }
            }
        }
    }

    private PermissionsSqlServerv2k5 getPermissionForUser(StorageObject user, RelationalObjectProxy proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        PermissionsSqlServerv2k5 perm = null;
        while (it.hasNext()) {
            perm = (PermissionsSqlServerv2k5)it.next();
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    private ArrayList initUsersAndRoles() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        String to = Token.getStringAfter(this.statement, "TO").trim();
        if (to.toLowerCase().indexOf(" as ") > -1) {
            to = Token.getStringBefore(to, "AS").trim();
        }
        if (to.toLowerCase().indexOf(" with ") > -1) {
            to = Token.getStringBefore(to, "WITH").trim();
        }
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            if (this.table != null) {
                this.db = (DataBaseSqlServerv2k5)this.table.getDatabase();
            } else if (this.view != null) {
                this.db = (DataBaseSqlServerv2k5)this.view.getDataBase();
            }
            if (this.db != null) {
                while (tokenizer.hasMoreTokens()) {
                    userOrRole = tokenizer.nextToken().trim();
                    userOrRole = Token.getValBetweenSquareBrackets(userOrRole);
                    StorageObjectCollection users = this.db.getUsers();
                    StorageObjectCollection roles = this.db.getRoles();
                    if (users.getByName(userOrRole) != null) {
                        list.add(users.getByName(userOrRole));
                        continue;
                    }
                    if (roles.getByName(userOrRole) == null) continue;
                    list.add(roles.getByName(userOrRole));
                }
            }
        }
        return list;
    }

    private void initPrivileges() {
        StringTokenizer tokenizer;
        String priv = Token.getStringAfter(this.statement.toUpperCase(), "GRANT");
        if (Token.hasCloseAndOpenBrackets(priv = Token.getStringBefore(priv, "ON").trim())) {
            String columns = Token.getValBetweenBrackets(priv).trim();
            priv = Token.getStringBefore(priv, "(").trim();
            this.initColumns(columns, priv);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(pr);
            }
        } else {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivileges(pr);
            }
        }
    }

    private void initColumns(String columns, String priv) {
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        Object column = null;
        while (tokenizer.hasMoreTokens()) {
            column = tokenizer.nextToken().trim();
            if ((((String)column).equalsIgnoreCase("") || this.table == null || this.table.getColumnProxyByName((String)column) == null) && (this.view == null || this.view.getColumnProxyByName((String)column) == null)) continue;
            column = (String)column + ", " + priv;
            this.permissions.setColumnList((String)column);
        }
    }

    private RelationalObjectProxy initOn() {
        String on = Token.getStringAfterToken(this.statement, "ON").trim();
        on = Token.getStringBefore(on, "TO").trim();
        if (!(on = Token.getValBetweenSquareBrackets(on)).equalsIgnoreCase("")) {
            this.table = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(on);
            if (this.table != null) {
                return this.table;
            }
            this.view = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)this.storageDesign.getTableViewProxySet()).getByName(on);
            if (this.view != null) {
                return this.view;
            }
        }
        LOGGER.error("SHGrantPermissionsSqlServer.initOn(): wrong syntax!");
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(RelationalObjectProxy proxy) {
        if (proxy instanceof TableProxySqlServerv2k5) {
            this.permissions.setTable((TableProxySqlServerv2k5)proxy);
        } else if (proxy instanceof TableViewProxySqlServerv2k5) {
            this.permissions.setView((TableViewProxySqlServerv2k5)proxy);
        }
    }

    private void initTo(Object object) {
        String to = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (to.toLowerCase().indexOf(" as ") > -1) {
            to = Token.getStringBefore(to, "AS").trim();
        }
        if (!to.equalsIgnoreCase("")) {
            if (this.table != null) {
                this.db = (DataBaseSqlServerv2k5)this.table.getDatabase();
            } else if (this.view != null) {
                this.db = (DataBaseSqlServerv2k5)this.view.getDataBase();
            }
            if (this.db != null) {
                if (object instanceof UserSqlServerv2k5) {
                    this.permissions.setUser((UserSqlServerv2k5)object);
                } else if (object instanceof RoleSqlServerv2k5) {
                    this.permissions.setRole((RoleSqlServerv2k5)object);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }

    private void initAs() {
        if (this.statement.toLowerCase().indexOf(" as ") > -1) {
            StorageObjectCollection roles;
            String role = Token.getStringAfter(this.statement.toUpperCase(), "AS").trim();
            role = Token.getValBetweenSquareBrackets(role);
            if (this.db != null && (roles = this.db.getRoles()).getByName(role) != null) {
                this.permissions.setAsRole((RoleSqlServerv2k5)roles.getByName(role));
            }
        }
    }
}

