/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterTableSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableSqlServerv2k5
extends SHAlterTableSqlServer {
    private Index index = null;
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignSqlServerv2k5 storageDesign = null;
    private String name = "";
    private TableViewProxySqlServerv2k5 viewProxy;
    private TableView view;
    private Design design;
    private List statemensList = new ArrayList();
    private static final Logger LOGGER = new Logger(SHAlterTableSqlServerv2k5.class);
    int count = 0;

    public SHAlterTableSqlServerv2k5(Design design) {
        super(design);
        this.design = design;
    }

    @Override
    public void handle(String line) {
        this.count = 0;
        String statement2 = SHAlterTableSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement2, "alter table")) {
            this.index = null;
            this.name = "";
            this.initTable(statement2);
            String[] splittedConstr = statement2.split("ADD");
            if (splittedConstr.length == 1) {
                splittedConstr = statement2.split("add");
            }
            for (String statement2 : Arrays.asList(splittedConstr)) {
                try {
                    if (this.isPK(statement2)) {
                        this.parsePK(statement2);
                        continue;
                    }
                    if (this.isUK(statement2)) {
                        this.parseUK(statement2);
                        continue;
                    }
                    if (this.isFK(statement2)) {
                        this.parseFK(statement2);
                        continue;
                    }
                    this.processTableLevelConstraints(statement2);
                }
                catch (Exception e) {
                    this.importLog.addFailedStatement(SHAlterTableSqlServerv2k5.FormatCR(line, "\n"));
                }
            }
            this.importLog.incrementImportedStatements();
        } else {
            this.nextHandler(line);
        }
    }

    private void initTable(String statement) {
        String temp = Token.getTokenAfter(statement, "TABLE", " ").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(statement, "TABLE", '[', ']').trim() : (temp.startsWith("\"") ? Token.getNameAfterToken(statement, "TABLE", '\"', '\"').trim() : temp);
        if (Token.hasString(name, ".")) {
            StringTokenizer st = new StringTokenizer(name, ".");
            while (st.hasMoreTokens()) {
                name = st.nextToken().trim();
            }
        }
        String tableName = this.getNameFor(name);
        this.table = this.getTableFor(tableName);
    }

    private String getNameFor(String name) {
        StringTokenizer token;
        if (name.indexOf(46) > -1 && (token = new StringTokenizer(name, ".")).countTokens() > 0) {
            for (int i = 0; i < token.countTokens() - 1; ++i) {
                token.nextToken();
            }
            name = token.nextToken();
        }
        name = Token.getValBetweenSquareBrackets(name);
        name = Token.removeQuotes(name);
        return name;
    }

    private Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private boolean isUK(String statement) {
        return Token.hasToken(statement, "UNIQUE");
    }

    private boolean isFK(String statement) {
        return Token.hasToken(statement, "FOREIGN");
    }

    private boolean isPK(String statement) {
        return Token.hasToken(statement, "PRIMARY");
    }

    private void parseUK(String statement) {
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        try {
            this.initUKName();
            this.constructIndex();
            String ukString = Token.getStringAfter(statement, "UNIQUE");
            if (ukString.endsWith(",")) {
                ukString = Token.getStringBefore(ukString, ",");
            }
            this.setColumnForIndex(ukString);
            if (this.table != null) {
                UniqueProxySqlServerv2k5 uk;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                this.index.setUnique(true);
                if (this.storageDesign != null && (uk = (UniqueProxySqlServerv2k5)this.storageDesign.getUniqueProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClusteredUK(uk);
                    this.initFillFactorUK(uk);
                    this.initFileGroupUK(uk);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            this.importLog.addError("Error parsing unique key statement " + statement);
            LOGGER.error("", e);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServerv2k5 uk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            if ((fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK)).endsWith(",")) {
                fileGroupUK = Token.getStringBefore(fileGroupUK, ",");
            }
            uk.setFilegroup((FileGroupSqlServerv2k5)this.storageDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServerv2k5 uk) {
        if (Token.hasToken(this.statement, "FILLFACTOR")) {
            try {
                String fillFactorString = Token.getTokenAfter(Token.getStringAfter(this.statement, "FILLFACTOR").trim(), "=").trim();
                if (fillFactorString.endsWith(",")) {
                    fillFactorString = Token.getStringBefore(fillFactorString, ",");
                }
                int fillFactorValue = Integer.parseInt(fillFactorString);
                uk.setFillFactor(fillFactorValue);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format:", e);
                this.importLog.addWarning("Unknown fill factor for unique key " + uk.getName());
            }
        }
    }

    private void initClusteredUK(UniqueProxySqlServerv2k5 uk) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            uk.setClustered(true);
        } else {
            uk.setClustered(false);
        }
    }

    @Override
    public void parsePK(String statement) {
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        try {
            this.initPKName();
            this.constructIndex();
            String pkString = Token.getStringAfter(statement, "PRIMARY KEY");
            if (pkString.endsWith(",")) {
                pkString = Token.getStringBefore(pkString, ",");
            }
            this.setColumnForIndex(pkString);
            if (this.table != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.storageDesign != null) {
                    this.index.makePK();
                    PKProxySqlServerv2k5 pk = (PKProxySqlServerv2k5)this.storageDesign.getPKProxySet().getProxy(this.index.getObjectID());
                    if (pk != null) {
                        this.initClusteredPK(pk);
                        this.initFillFactorPK(pk);
                        this.initFileGroupPK(pk);
                    }
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Error parsing primary key statement " + statement);
        }
    }

    private void initFileGroupPK(PKProxySqlServerv2k5 pk) {
        if (Token.hasToken(this.statement, "ON")) {
            String fileGroupUK = Token.getTokenAfter(this.statement, "ON");
            if ((fileGroupUK = Token.getValBetweenQuotationMarks(fileGroupUK)).endsWith(",")) {
                fileGroupUK = Token.getStringBefore(fileGroupUK, ",");
            }
            pk.setFilegroup((FileGroupSqlServerv2k5)this.storageDesign.getFileGroupSet().getByName(fileGroupUK));
        }
    }

    private void initFillFactorPK(PKProxySqlServerv2k5 pk) {
        if (Token.hasToken(this.statement, "FILLFACTOR")) {
            try {
                String fillFactorString = Token.getTokenAfter(Token.getStringAfter(this.statement, "FILLFACTOR").trim(), "=").trim();
                if (fillFactorString.endsWith(",")) {
                    fillFactorString = Token.getStringBefore(fillFactorString, ",");
                }
                int fillFactorValue = Integer.parseInt(fillFactorString);
                pk.setFillFactor(fillFactorValue);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format: ", e);
                this.importLog.addWarning("Unknown fill factor for primary key " + pk.getName());
            }
        }
    }

    private void initClusteredPK(PKProxySqlServerv2k5 pk) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            pk.setClustered(true);
        } else {
            pk.setClustered(false);
        }
    }

    private void initOnDeleteFK(FKProxySqlServerv2k5 fk, String fkString) {
        if (Token.hasString(fkString.toUpperCase(), "ON DELETE")) {
            String onDelete = (fkString = Token.getStringAfter(fkString, "DELETE")).toUpperCase().startsWith("SET NULL") ? "SET NULL" : (fkString.toUpperCase().startsWith("SET DEFAULT") ? "SET DEFAULT" : (fkString.toUpperCase().startsWith("NO ACTION") ? "NO ACTION" : (fkString.toUpperCase().startsWith("CASCADE") ? "CASCADE" : Token.getFirstToken(fkString))));
            FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
            fkass.setDeleteRule(onDelete);
        }
    }

    private void initOnUpdateFK(FKProxySqlServerv2k5 fk, String fkString) {
        if (Token.hasString(fkString.toUpperCase(), "ON UPDATE")) {
            String onUpdate = Token.startsWithString(fkString = Token.getStringAfter(fkString, "ON UPDATE"), "SET NULL") ? "SET NULL" : (Token.startsWithString(fkString, "SET DEFAULT") ? "SET DEFAULT" : Token.getTokenAfter(fkString, "UPDATE"));
            fk.setOnUpdate(onUpdate);
        }
    }

    private void initReplicationFK(FKProxySqlServerv2k5 fk, String fkString) {
        if (!Token.hasString(fkString.toUpperCase(), "NOT FOR REPLICATION")) {
            fk.setForReplication("YES");
        } else {
            fk.setForReplication("NO");
        }
    }

    private void initPKName() {
        if (Token.hasToken(this.statement, "PRIMARY")) {
            this.name = Token.getTokenBefore(this.statement, "PRIMARY");
            if (this.name.equalsIgnoreCase(",") || this.name.equalsIgnoreCase("ADD")) {
                this.name = "";
            } else {
                if (Token.hasString(this.name, ".")) {
                    StringTokenizer st = new StringTokenizer(this.name, ".");
                    this.name = st.nextToken().trim();
                    this.name = st.nextToken().trim();
                }
                this.name = Token.getValBetweenSquareBrackets(this.name);
                this.name = Token.getNamesOnly(this.name);
            }
        }
        if (this.name.equalsIgnoreCase("")) {
            String tableName = this.table.getName();
            if (tableName.length() > 125) {
                tableName = tableName.substring(0, 125);
            }
            this.name = tableName + "_PK";
        }
    }

    private void initUKName() {
        if (Token.hasToken(this.statement, "UNIQUE")) {
            this.name = Token.getTokenBefore(this.statement, "UNIQUE");
            if (this.name.equalsIgnoreCase(",") || this.name.equalsIgnoreCase("ADD")) {
                this.name = "";
            } else {
                if (Token.hasString(this.name, ".")) {
                    StringTokenizer st = new StringTokenizer(this.name, ".");
                    this.name = st.nextToken().trim();
                    this.name = st.nextToken().trim();
                }
                this.name = Token.getValBetweenSquareBrackets(this.name);
                this.name = Token.getNamesOnly(this.name);
            }
        }
        if (this.name.equalsIgnoreCase("")) {
            String tableName = this.table.getName();
            if (tableName.length() > 123) {
                tableName = tableName.substring(0, 123);
            }
            this.name = tableName + "_UK" + this.table.getUKeys().size();
        }
    }

    private void setColumnForIndex(String statement) throws ObjectDoesNotExistException {
        block10: {
            Map columnCollection;
            block9: {
                columnCollection = null;
                if (this.table == null) break block9;
                columnCollection = this.getColumnsForTable();
                if (columnCollection.size() <= 0) break block10;
                String columnString = Token.getValBetweenBrackets(statement, 1).trim();
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    Column column;
                    int posColumnSpace;
                    String columnName = columnToken.nextToken().trim();
                    if (Token.hasString(columnName = Token.getNamesOnly(columnName), "[") && Token.hasString(columnName, "]")) {
                        columnName = this.getValBetween(columnName);
                    }
                    if ((posColumnSpace = columnName.indexOf(" ")) > 0) {
                        columnName = columnName.substring(0, posColumnSpace);
                    }
                    if ((column = (Column)columnCollection.get(columnName)) != null) {
                        try {
                            this.index.add(column);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception occured while adding column to index!" + statement);
                            this.importLog.addError("Exception occured while adding column  " + columnName + " to index");
                        }
                        continue;
                    }
                    this.importLog.addError("Column " + columnName + " does not exist");
                    throw new ObjectDoesNotExistException("Column");
                }
                break block10;
            }
            if (this.viewProxy != null && (columnCollection = this.getColumnsForView()).size() > 0) {
                String columnString = Token.getValBetweenBrackets(statement, 1);
                StringTokenizer columnToken = new StringTokenizer(columnString, ",");
                while (columnToken.hasMoreTokens()) {
                    Column column;
                    String columnName = columnToken.nextToken().trim();
                    int posColumnSpace = columnName.indexOf(" ");
                    if (posColumnSpace > 0) {
                        columnName = columnName.substring(0, posColumnSpace);
                    }
                    if ((column = (Column)columnCollection.get(columnName)) != null) continue;
                    this.importLog.addError("View Column " + columnName + " does not exist");
                    throw new ObjectDoesNotExistException("Column");
                }
            }
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private Map getColumnsForView() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.viewProxy != null) {
            Column[] columns = (Column[])this.view.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private void constructIndex() {
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.name)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.name)) {
                this.index = this.table.createIndex();
                if (!"".equalsIgnoreCase(this.name)) {
                    this.index.setName(this.name);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        }
    }

    @Override
    public String getValBetween(String string) {
        if ((string = string.trim()) != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    private void initForeignKey(String fkString) {
        block12: {
            Table tableRef;
            ArrayList<Column> columnsRef;
            block13: {
                int positionBracket = fkString.indexOf(41);
                String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
                String columns = Token.getValBetweenBrackets(firstBrackets);
                List columnNames = this.getColumnNames(columns);
                columnsRef = new ArrayList<Column>();
                Column[] columnSet = (Column[])this.table.getElements();
                Iterator colIt = columnNames.iterator();
                while (colIt.hasNext()) {
                    String name = Token.getValBetweenSquareBrackets(((String)colIt.next()).trim());
                    name = Token.removeQuotes(name);
                    for (int ci = 0; ci < columnSet.length; ++ci) {
                        String colname = columnSet[ci].getName().trim();
                        if (!name.equalsIgnoreCase(colname)) continue;
                        columnsRef.add(columnSet[ci]);
                    }
                }
                int positionReference = fkString.toUpperCase().indexOf("REFERENCES");
                fkString = fkString.substring(positionReference);
                String nameReferenced = Token.getNameAfterToken(fkString, "REFERENCES", '[', ']');
                String nameRef = this.getNameFor(nameReferenced);
                int pos = (nameRef = Token.removeQuotes(nameRef)).indexOf(40);
                if (pos > -1) {
                    nameRef = nameRef.substring(0, pos);
                }
                if ((tableRef = this.getTableFor(nameRef)) == null) break block12;
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (!hasBrackets) break block13;
                String columnsReferenced = Token.getValBetweenBrackets(fkString, 1);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                FKIndexAssociationReference reference = this.design.getDesign().getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                if (index == null) break block12;
                FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                fkass.setName(this.name);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                fkass.getLocalFKIndex().setName(this.name);
                if (this.design.getDesign().isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                if (!hasOnDelete) break block12;
                String onDelete = Token.getStringAfter(fkString, "DELETE").trim();
                if (Token.hasToken(onDelete, "UPDATE")) {
                    onDelete = Token.getStringBefore(onDelete, "ON");
                }
                String[] choisesDelete = FKIndexAssociation.DELETE_RULES_WITH_DEFAULT;
                for (int choise = 0; choise < choisesDelete.length; ++choise) {
                    if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                    fkass.setDeleteRule(choisesDelete[choise]);
                    break block12;
                }
                break block12;
            }
            FKIndexAssociationReference reference = this.design.getDesign().getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)tableRef.getPK();
            if (index != null) {
                FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                fkass.setName(this.name);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                fkass.getLocalFKIndex().setName(this.name);
                if (this.design.getDesign().isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                if (hasOnDelete) {
                    String onDelete = Token.getStringAfter(fkString, "DELETE").trim();
                    String[] choisesDelete = FKIndexAssociation.DELETE_RULES_WITH_DEFAULT;
                    for (int choise = 0; choise < choisesDelete.length; ++choise) {
                        if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                        fkass.setDeleteRule(choisesDelete[choise]);
                        break;
                    }
                }
            }
        }
    }

    private void parseFK(String statement) {
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        if (this.table != null) {
            this.site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
            boolean hasForeignKey = false;
            String stringWithFK = statement;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
            while (hasForeignKey) {
                FKProxySqlServerv2k5 fk;
                int positionForeign = stringWithFK.toUpperCase().indexOf("FOREIGN");
                String fkString = stringWithFK.substring(positionForeign);
                Object nameFK = "FK_ASS";
                if (Token.hasToken(stringWithFK, "CONSTRAINT")) {
                    nameFK = Token.getTokenAfter(stringWithFK, "CONSTRAINT");
                } else {
                    String tableName = this.table.getName();
                    if (tableName.length() > 123) {
                        tableName = tableName.substring(0, 123);
                    }
                    nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
                }
                this.name = Token.getValBetweenSquareBrackets(((String)nameFK).trim());
                this.initForeignKey(fkString);
                fkString = fkString.substring(12);
                if (this.storageDesign != null && (fk = (FKProxySqlServerv2k5)this.storageDesign.getFKProxySet().getByName((String)nameFK)) != null) {
                    this.initOnDeleteFK(fk, fkString);
                    this.initOnUpdateFK(fk, fkString);
                    this.initReplicationFK(fk, fkString);
                }
                stringWithFK = fkString;
                hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
            }
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = Token.getValBetweenSquareBrackets(tokColumns.nextToken().trim());
            columns.add(token.trim());
        }
        return columns;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            System.out.println("Foreign key columns don't match Primary key columns\ntab_ch " + index.getContainerWithKeyObject().getName() + " index " + index.getName() + "  parent_tab " + pk.getContainerWithKeyObject().getName());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            LOGGER.error("Foreign key columns don't match Primary key columns\ntab_ch " + index.getContainerWithKeyObject().getName() + " index " + index.getName() + "  parent_tab " + pk.getContainerWithKeyObject().getName());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String alterStatement : this.statemensList) {
            this.parseFK(alterStatement);
        }
    }

    private void processTableLevelConstraints(String stDef) {
        this.statement = stDef;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String stUpper = stDef.toUpperCase();
        String def = stDef;
        int ind = stUpper.indexOf("WITH");
        if (ind > -1 && stUpper.indexOf("ADD", ind) > -1) {
            int start = stUpper.indexOf("ADD", ind);
            def = stDef.substring(start);
        }
        StringTokenizer tokenizer = new StringTokenizer(def, ",");
        while (tokenizer.hasMoreTokens()) {
            String constr = tokenizer.nextToken().trim();
            StringBuffer oneColumnPast = new StringBuffer(constr);
            while (Token.tokenNumber(constr, "(") > Token.tokenNumber(constr, ")") && tokenizer.hasMoreTokens()) {
                oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                constr = oneColumnPast.toString().trim();
            }
            if (Token.hasToken(constr, "PRIMARY") || Token.hasToken(constr, "UNIQUE") || Token.hasToken(constr, "FOREIGN")) continue;
            ++this.count;
            if (Token.hasToken(constr, "check")) {
                this.processCheck(constr);
                continue;
            }
            this.processColumnConstraint(constr);
        }
    }

    private void processCheck(String constr) {
        int ind = constr.toUpperCase().indexOf("REPLICATION");
        String constrName = Token.getTokenBefore(constr, "CHECK");
        if (constrName.equalsIgnoreCase(",") || constrName.equalsIgnoreCase("ADD")) {
            constrName = "";
        }
        String rule = "";
        rule = ind > -1 ? Token.getStringAfter(constr, "REPLICATION").trim() : Token.getStringAfter(constr, "CHECK").trim();
        if (rule.indexOf(40) > -1) {
            rule = Token.getValBetweenBrackets(rule);
        }
        TableLevelConstraint constraint = null;
        if (!"".equalsIgnoreCase(constrName)) {
            constraint = this.table.createCheckConstraint(constrName, rule);
            this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 123) {
                tableName = tableName.substring(0, 123);
            }
            constraint = this.table.createCheckConstraint(tableName + "_CK" + this.table.getCheckConstraints().size(), rule);
            this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        }
        this.table.addCheckConstraint(constraint);
    }

    private void processColumnConstraint(String constr) {
        String afterDefault = Token.getStringAfter(constr, "DEFAULT");
        if (!afterDefault.equalsIgnoreCase("")) {
            Column column;
            Object defaultValue = "";
            if (afterDefault.startsWith("'")) {
                defaultValue = Token.getFirstTextLiteral(afterDefault);
            } else if (afterDefault.startsWith("(")) {
                defaultValue = "(" + Token.getValBetweenBrackets(afterDefault, 1) + ")";
            } else {
                defaultValue = afterDefault.startsWith("[") ? "[" + Token.getFirstName(afterDefault, '[', ']') + "]" : (afterDefault.startsWith("\"") ? "\"" + Token.getFirstName(afterDefault, '\"', '\"') + "\"" : Token.getFirstToken(afterDefault));
                String strAfter = Token.getStringAfter(afterDefault, (String)defaultValue);
                if (strAfter.startsWith("(")) {
                    defaultValue = (String)defaultValue + "(" + Token.getValBetweenBrackets(strAfter, 1) + ")";
                }
            }
            String colName = Token.getStringAfter(constr, "FOR");
            if (!colName.equalsIgnoreCase("") && (column = (Column)this.table.getElementByName(colName = colName.startsWith("[") ? Token.getValBetweenSquareBrackets(colName) : (colName.startsWith("\"") ? Token.getValBetweenDoubleQuotes(colName) : Token.getFirstToken(colName)))) != null) {
                column.setUsesDefaultValue(true);
                column.setDefaultValue((String)defaultValue);
            }
        }
    }
}

