/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAddDataTypeSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String SP_ADDTYPE = "sp_addtype";
    private static final String TYPENAME = "@typename";
    private static final String PHYSTYPE = "@phystype";
    private static final String NULLTYPE = "@nulltype";
    private static final String OWNER = "@owner";
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHAddDataTypeSqlServer.class);
    private UserDefinedTypeSqlServer type;
    private LogicalDatatypeFactory factoryLogical;
    private String name = "";
    private String systype = "";
    private String nulltype = "";
    private String owner = "";

    public SHAddDataTypeSqlServer(Design design, LogicalDatatypeFactory factoryLogical) {
        super(design);
        this.factoryLogical = factoryLogical;
    }

    public SHAddDataTypeSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAddDataTypeSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "exec sp_addtype ")) {
            try {
                this.addDataType(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHAddDataTypeSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void addDataType(String statement) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer storageDesign = (StorageDesignSqlServer)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            this.type = storageDesign.getUserDefinedTypeSet().createType();
            if (this.type != null) {
                DesignObject dom;
                Iterator domains;
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String main = Token.getStringAfter(statement, SP_ADDTYPE).trim();
                StringTokenizer tokenizer = new StringTokenizer(main, ",");
                ArrayList<String> list = new ArrayList<String>(4);
                while (tokenizer.hasMoreTokens()) {
                    String element = tokenizer.nextToken().trim();
                    StringBuffer oneColumnPast = new StringBuffer(element);
                    while (Token.tokenNumber(element, "(") > Token.tokenNumber(element, ")") && tokenizer.hasMoreTokens()) {
                        oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                        element = oneColumnPast.toString().trim();
                    }
                    list.add(element);
                }
                if (list.size() == 2) {
                    this.name = ((String)list.get(0)).trim();
                    this.systype = ((String)list.get(1)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.type.setName(this.name);
                    domains = storageDesign.getDesign().getDomainSet().iterator();
                    Domain domain = null;
                    while (domains.hasNext() && !(domain = (Domain)domains.next()).getDataType().toString().equalsIgnoreCase(this.systype)) {
                    }
                    if (domain != null) {
                        this.type.setDomain(domain.getName());
                    } else {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                } else if (list.size() == 3) {
                    this.name = ((String)list.get(0)).trim();
                    this.systype = ((String)list.get(1)).trim();
                    this.nulltype = ((String)list.get(2)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.nulltype = this.formatValue(this.nulltype, NULLTYPE);
                    this.type.setName(this.name);
                    domains = storageDesign.getDesign().getDomainSet().iterator();
                    dom = null;
                    while (domains.hasNext()) {
                        Domain domain = (Domain)domains.next();
                        if (!domain.getName().equalsIgnoreCase(this.name) || !this.compareDataTypes(domain, this.systype)) continue;
                        dom = domain;
                        break;
                    }
                    if (dom != null) {
                        this.type.setDomain(dom.getName());
                    } else if (this.factoryLogical != null) {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    } else {
                        LOGGER.error("Could not create new domain " + this.name + "! Domain with this name already exists!");
                        this.importLog.addError("Could not create new domain " + this.name + ". Domain with this name already exists");
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                    this.type.setNullType(this.nulltype);
                } else if (list.size() == 4) {
                    this.name = ((String)list.get(0)).trim();
                    this.systype = ((String)list.get(1)).trim();
                    this.nulltype = ((String)list.get(2)).trim();
                    this.owner = ((String)list.get(3)).trim();
                    this.name = this.formatValue(this.name, TYPENAME);
                    this.systype = this.formatValue(this.systype, PHYSTYPE);
                    this.nulltype = this.formatValue(this.nulltype, NULLTYPE);
                    this.owner = this.formatValue(this.owner, OWNER);
                    this.type.setName(this.name);
                    domains = storageDesign.getDesign().getDomainSet().iterator();
                    dom = null;
                    while (domains.hasNext()) {
                        Domain domain = (Domain)domains.next();
                        if (!domain.getDataType().toString().equalsIgnoreCase(this.systype)) continue;
                        dom = domain;
                        break;
                    }
                    if (dom != null) {
                        this.type.setDomain(dom.getName());
                    } else {
                        this.createOneDomain(this.name, this.systype);
                        this.type.setDomain(this.name);
                    }
                    NotStandartDataTypeNames.addNotStandartDataType(this.name);
                    NotStandartDataTypeNames.addNotStandartSynonym(this.name, this.systype);
                    this.type.setNullType(this.nulltype);
                    this.type.setOwner((UserSqlServer)storageDesign.getUserSet().getByName(this.owner));
                } else {
                    LOGGER.error("Wrong syntax occured near " + statement);
                    this.importLog.addError("Wrong syntax occured near " + statement);
                }
            }
        }
    }

    private void createOneDomain(String domainName, String buildinType) {
        String typeForCheck = buildinType;
        int bracketPosition = typeForCheck.indexOf(40);
        if (bracketPosition > -1) {
            typeForCheck = typeForCheck.substring(0, bracketPosition).trim();
        }
        if (this.checkBuildinDatatype(typeForCheck)) {
            Map elements = this.parseBuildinDatatype(buildinType);
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("scale"), (String)elements.get("precision"), (String)elements.get("size")};
            if (datatype != null) {
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                DomainSet domSet = this.design.getDesign().getDomainSet();
                Domain newDomain = domSet.createDomain();
                newDomain.setName(domainName);
                this.design.getRelationalDesign().stampModelObjectDDL(newDomain);
                if (logicalDT != null) {
                    newDomain.setLogicalDatatype(logicalDT);
                } else {
                    LogicalDatatype newLogicDT = this.design.getDesign().getLogicalDatatypeSet().createLogicalDatatype(null);
                    this.design.getRelationalDesign().stampModelObjectDDL(newLogicDT);
                    newDomain.setLogicalDatatype(newLogicDT);
                }
                newDomain.setFileName(this.design.getDesign().getFileName());
                newDomain.setDataTypeParameter("size", parameters[2]);
                newDomain.setDataTypeParameter("scale", parameters[1]);
                newDomain.setDataTypeParameter("precision", parameters[0]);
            }
        }
    }

    private boolean checkBuildinDatatype(String buildinType) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2000");
        for (int number = 0; number < names.length; ++number) {
            if (!names[number].equalsIgnoreCase(buildinType)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String buildinType) {
        String datatype;
        HashMap<String, String> mapElementsColumn = new HashMap<String, String>();
        String beforeBracket = buildinType;
        int bracketPosition = buildinType.indexOf(40);
        if (bracketPosition > -1) {
            beforeBracket = buildinType.substring(0, bracketPosition).trim();
        }
        if ((datatype = StandardDatatypeNames.getUsedDatatypeName(beforeBracket)) != null) {
            String params = Token.cutTokenFromFront(buildinType, beforeBracket);
            mapElementsColumn.put("datatype", datatype);
            if (!params.equalsIgnoreCase("")) {
                boolean hasBrackets = Token.hasCloseAndOpenBrackets(params);
                if (hasBrackets) {
                    hasBrackets = Token.getValBeforeBrackets(params).trim().equalsIgnoreCase("");
                }
                if (hasBrackets) {
                    String parameters = Token.getValBetweenBrackets(params, 1);
                    int positionKomma = parameters.indexOf(",");
                    if (positionKomma != -1) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                        mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                    } else if (datatype.equals("DECIMAL")) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", parameters.trim());
                    } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                        if (positionKomma != -1) {
                            mapElementsColumn.put("size", ZERO);
                            mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                            mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                        } else {
                            mapElementsColumn.put("size", ZERO);
                            mapElementsColumn.put("precision", parameters.trim());
                            mapElementsColumn.put("scale", ZERO);
                        }
                    } else {
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", ZERO);
                        mapElementsColumn.put("size", parameters.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + buildinType + " is unknown!");
            this.importLog.addError("Datatype " + buildinType + " is unknown");
        }
        return mapElementsColumn;
    }

    private String formatValue(String string, String pattern) {
        if (string.startsWith(pattern)) {
            string = Token.getStringAfter(string, "=").trim();
        }
        if (string.toUpperCase().startsWith("N'")) {
            string = string.substring(1);
        }
        if (string.startsWith("'")) {
            string = Token.getValBetweenQuotationMarks(string);
        }
        string = this.getValBetweenQuotationMarks2(string);
        string = Token.getValBetweenSquareBrackets(string);
        return string;
    }

    private String getValBetweenQuotationMarks2(String string) {
        if (string != null && string.indexOf(34) == 0 && string.indexOf(34, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean compareDataTypes(Domain domain, String datatype) {
        String domainType;
        if (datatype.equalsIgnoreCase("INT")) {
            datatype = "INTEGER";
        }
        if (Token.hasCloseAndOpenBrackets(domainType = domain.getDataType().toString()) && Token.hasCloseAndOpenBrackets(datatype)) {
            String domainTypeParams = domainType.substring(domainType.indexOf(40)).trim();
            String domainMain = domainType.substring(0, domainType.indexOf(40)).trim();
            String stringTypeParams = domainType.substring(datatype.indexOf(40)).trim();
            String stringMain = domainType.substring(0, datatype.indexOf(40)).trim();
            return domainTypeParams.equalsIgnoreCase(stringTypeParams) && domainMain.equalsIgnoreCase(stringMain);
        }
        return domainType.equalsIgnoreCase(datatype);
    }
}

