/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cubeviews;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter_8_1;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter_8_2;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CubeViewsHandler {
    private ApplicationView appView;
    private Design design;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;

    public CubeViewsHandler(ApplicationView appView) {
        this.appView = appView;
        this.design = appView.getCurrentDesign();
    }

    public void parse(File file) {
        block18: {
            if (file.isFile()) {
                try {
                    FileInputStream is = new FileInputStream(file);
                    InputSource inputSource = new InputSource(new InputStreamReader((InputStream)is, "UTF-8"));
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = null;
                    try {
                        db = dbf.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        // empty catch block
                    }
                    if (db == null) break block18;
                    try {
                        Document doc;
                        Element root;
                        this.design.setDisableTreeUpdate(true);
                        String dname = file.getName();
                        int ind = dname.indexOf(".xml");
                        String noextname = dname.substring(0, ind);
                        if (!this.isImportToCurrent()) {
                            this.design.setName(noextname);
                            this.design.setFileName(noextname);
                        }
                        if ((root = (doc = db.parse(inputSource)).getDocumentElement()) != null) {
                            String xmlns;
                            String tagname;
                            String version = root.getAttribute("version");
                            if (this.checkForCV(version, tagname = root.getTagName(), xmlns = root.getAttribute("xmlns:olap"))) {
                                CubeViewsImporter cvi;
                                if (!this.design.getMultidimensionalDesign().isEmpty()) {
                                    MultidimensionalDesign mdm = this.design.addMultidimensionalDesign(noextname);
                                    this.design.setMultidimensionalDesign(mdm);
                                } else {
                                    this.design.getMultidimensionalDesign().setName(noextname);
                                }
                                if (version != null && version.startsWith("8.1")) {
                                    cvi = new CubeViewsImporter_8_1(this.design);
                                    cvi.parseXMLDocument(doc);
                                } else if (version != null && version.startsWith("8.2")) {
                                    cvi = new CubeViewsImporter_8_2(this.design);
                                    cvi.parseXMLDocument(doc);
                                }
                                this.rearrangeTables();
                                ((DPVMultidimensional)this.design.getMultidimensionalDesign().getMainView()).rearrangeDiagram(true);
                                if (version != null && version.startsWith("8.2")) {
                                    this.design.getMultidimensionalDesign().normalizeHierarchies();
                                }
                                this.design.setDisableTreeUpdate(false);
                                this.appView.clearTree();
                                this.design.getMultidimensionalDesign().getCompactDiagram().generateDiagram();
                                this.design.getMultidimensionalDesign().setMainViewVisible(true);
                            } else {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsHandler.ThisIsNotCubeViewsMetadataFile"), Messages.getString("CubeViewsHandler.Error"), 0);
                            }
                            break block18;
                        }
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsHandler.ThisIsNotCubeViewsMetadataFile"), Messages.getString("CubeViewsHandler.Error"), 0);
                    }
                    catch (SAXException sAXException) {
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean checkForCV(String version, String tagname, String xmlns) {
        if (version == null || !version.startsWith("8.1") && !version.startsWith("8.2")) {
            return false;
        }
        if (tagname == null || !tagname.equalsIgnoreCase("olap:metadata")) {
            return false;
        }
        return xmlns != null && xmlns.equalsIgnoreCase("http://www.ibm.com/olap");
    }

    private void rearrangeTables() {
        EntitySet tableSet = this.design.getLogicalDesign().getEntitySet();
        if (tableSet.size() > 0) {
            Iterator it = tableSet.iterator();
            float square = (float)Math.sqrt(tableSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                ContainerWithKeyObject table = (ContainerWithKeyObject)it.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getTableSize(table);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getTableSize(ContainerWithKeyObject table) {
        int w = 35;
        int h = 25;
        int colCount = table.getElements().length;
        h += colCount * 14;
        if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
            h += 4;
            for (int i = 0; i < table.getKeys().length; ++i) {
                if (table.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = 1;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            ContainedObjectWithDomain element = (ContainedObjectWithDomain)table.getElement(i);
            int cl = element.getName().length() * 7;
            int dtl = element.getDataType().toString().length() * 7;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = table.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isImportToCurrent() {
        return this.design.isImportToCurrent();
    }
}

