/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DDLPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;

final class DDLPP
extends AbstractPP {
    private static final long serialVersionUID = 6172138404481530709L;
    private static final String UNTITLED_DESIGN = oracle.dbtools.crest.model.Messages.getString("Design.Untitled");
    private JTextField db2TermChar;
    private JCheckBox cbSubstTrigger;
    private JCheckBox cbFKArcTriggers;
    private JCheckBox cbFKNoneTransferableTriggers;
    private JCheckBox cbShowByteCharInDDL;
    private JCheckBox cbExtendedSizeForChars;
    private JCheckBox cbNotNullShortForm;
    private JCheckBox cbUseQuotedIdentifiers;
    private JCheckBox cbReplaceSystemNamesDuringImport;
    private JCheckBox cbCreateDomainsDuringImport;
    private JCheckBox cbGenerateCommentsInRDBMS;
    private JCheckBox cbGenerateInlineColumnCC;
    private JCheckBox cbGenerateValidValueCC;
    private JCheckBox cbIncludeDefaultSettingsInDDL;
    private JCheckBox cbIncludeLoggingInDDL;
    private JCheckBox cbIncludeSchemaInDDL;
    private JCheckBox cbIncludeStorageInDDL;
    private JCheckBox cbIncludeTablespaceInDDL;
    private JCheckBox cbIncludeRedactionInDDL;
    private JCheckBox cbIncludeTSDPInDDL;
    private JCheckBox cbIncludePrompt;
    private JCheckBox cbUseSQLDevFormatting;
    private JCheckBox cbIncludeDesignNameInDDLPath;
    private JCheckBox cbCreateDateTimeSnapsot;
    private JTextField defaultDDLFilesPath;
    private JPanel pnMain;

    public DDLPP() {
        this.setHelpID("DDL_PREFS_PANEL");
        JPanel pnInner = new JPanel(new GridBagLayout());
        pnInner.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DDLOptions")));
        JPanel pnTop = new JPanel(new GridBagLayout());
        JPanel jp = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.StatementTerminationCharDB2UDB"));
        this.addItem(jp, label, 0, 0, 1, 1, 17, 100, 100);
        this.db2TermChar = new JTextField(2);
        this.addItem(jp, this.db2TermChar, 0, 1, 1, 1, 17, 100, 100);
        this.addItem(pnTop, jp, 0, 0, 1, 1, 17, 1, 100);
        this.cbSubstTrigger = new JCheckBox(Messages.getString("OptionsDialog.CreateTypeSubstitutionTriggersOracle"));
        this.addItem(pnTop, this.cbSubstTrigger, 0, 1, 1, 1, 17, 1, 100);
        this.cbFKArcTriggers = new JCheckBox(Messages.getString("OptionsDialog.CreateTriggersForFKArcConstraint"));
        this.addItem(pnTop, this.cbFKArcTriggers, 0, 2, 1, 1, 17, 1, 100);
        this.cbFKNoneTransferableTriggers = new JCheckBox(Messages.getString("OptionsDialog.CreateTriggersForNoneTransferableFK"));
        this.addItem(pnTop, this.cbFKNoneTransferableTriggers, 0, 3, 1, 1, 17, 1, 100);
        this.cbShowByteCharInDDL = new JCheckBox(Messages.getString("OptionsDialog.ShowCHARBYTEUnitforOracle"));
        this.addItem(pnTop, this.cbShowByteCharInDDL, 0, 4, 1, 1, 17, 1, 100);
        this.cbExtendedSizeForChars = new JCheckBox(Messages.getString("OptionsDialog.ExtendedSizeForCharactersOracle"));
        this.addItem(pnTop, this.cbExtendedSizeForChars, 0, 5, 1, 1, 17, 1, 100);
        this.cbNotNullShortForm = new JCheckBox(Messages.getString("OptionsDialog.NotNullShortForm"));
        this.cbNotNullShortForm.setSelected(true);
        this.addItem(pnTop, this.cbNotNullShortForm, 0, 6, 1, 1, 17, 1, 100);
        this.cbUseQuotedIdentifiers = new JCheckBox(Messages.getString("OptionsDialog.UseQuotedIdentifiers"));
        this.addItem(pnTop, this.cbUseQuotedIdentifiers, 0, 7, 1, 1, 17, 1, 100);
        this.cbReplaceSystemNamesDuringImport = new JCheckBox(Messages.getString("OptionsDialog.ReplaceSystemNamesDuringImport"));
        this.addItem(pnTop, this.cbReplaceSystemNamesDuringImport, 0, 8, 1, 1, 17, 1, 100);
        this.cbCreateDomainsDuringImport = new JCheckBox(Messages.getString("OptionsDialog.CreateDomainsDuringImport"));
        this.addItem(pnTop, this.cbCreateDomainsDuringImport, 0, 9, 1, 1, 17, 1, 100);
        this.cbGenerateCommentsInRDBMS = new JCheckBox(Messages.getString("DDLPP.GenerateCommentsInRDBMS"));
        this.addItem(pnTop, this.cbGenerateCommentsInRDBMS, 0, 10, 1, 1, 17, 1, 100);
        this.cbGenerateInlineColumnCC = new JCheckBox(Messages.getString("DDLPP.GenerateInlineColumnCC"));
        this.addItem(pnTop, this.cbGenerateInlineColumnCC, 0, 11, 1, 1, 17, 1, 100);
        this.cbGenerateValidValueCC = new JCheckBox(Messages.getString("DDLPP.GenerateValidValueCC"));
        this.addItem(pnTop, this.cbGenerateValidValueCC, 0, 12, 1, 1, 17, 1, 100);
        this.cbIncludeDefaultSettingsInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeDefaultSettingsInDDL"));
        this.addItem(pnTop, this.cbIncludeDefaultSettingsInDDL, 0, 13, 1, 1, 17, 1, 100);
        this.cbIncludeLoggingInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeLoggingInDDL"));
        this.addItem(pnTop, this.cbIncludeLoggingInDDL, 0, 14, 1, 1, 17, 1, 100);
        this.cbIncludeSchemaInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeSchemaInDDL"));
        this.addItem(pnTop, this.cbIncludeSchemaInDDL, 0, 15, 1, 1, 17, 1, 100);
        this.cbIncludeStorageInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeStorageInDDL"));
        this.addItem(pnTop, this.cbIncludeStorageInDDL, 0, 16, 1, 1, 17, 1, 100);
        this.cbIncludeTablespaceInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeTablespaceInDDL"));
        this.addItem(pnTop, this.cbIncludeTablespaceInDDL, 0, 17, 1, 1, 17, 1, 100);
        this.cbIncludeRedactionInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeRedactionInDDL"));
        this.addItem(pnTop, this.cbIncludeRedactionInDDL, 0, 18, 1, 1, 17, 1, 100);
        this.cbIncludeTSDPInDDL = new JCheckBox(Messages.getString("OptionsDialog.IncludeTSDPInDDL"));
        this.addItem(pnTop, this.cbIncludeTSDPInDDL, 0, 19, 1, 1, 17, 1, 100);
        this.cbIncludePrompt = new JCheckBox(Messages.getString("OptionsDialog.IncludePrompt"));
        this.addItem(pnTop, this.cbIncludePrompt, 0, 20, 1, 1, 17, 1, 100);
        JPanel pnSQLFormatting = new JPanel(new GridBagLayout());
        pnSQLFormatting.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.SQLFormatting")));
        this.cbUseSQLDevFormatting = new JCheckBox(Messages.getString("OptionsDialog.UseSQLDevFormatting"));
        this.addItem(pnSQLFormatting, this.cbUseSQLDevFormatting, 0, 0, 1, 1, 17, 1, 100);
        pnInner.add((Component)pnTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnInner.add((Component)pnSQLFormatting, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pnMain = new JPanel(new GridBagLayout());
        this.pnMain.add((Component)pnInner, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.createDefaultDDLFilesPathOption();
        this.add(this.pnMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.cbSubstTrigger.setSelected(settings.isGenerateTypeSubstTriggers());
        this.cbFKArcTriggers.setSelected(settings.isGenerateFKArcTriggers());
        this.cbFKNoneTransferableTriggers.setSelected(settings.isGenerateFKNoneTransferableTriggers());
        this.cbShowByteCharInDDL.setSelected(settings.isShowByteCharInDDL());
        this.cbExtendedSizeForChars.setSelected(settings.isExtendedSizeForCharacters());
        this.cbNotNullShortForm.setSelected(settings.notNullShortFormGeneration());
        this.cbUseQuotedIdentifiers.setSelected(settings.isUseQuotedIdentifiers());
        this.cbReplaceSystemNamesDuringImport.setSelected(settings.isReplaceSystemNamesDuringImport());
        this.cbCreateDomainsDuringImport.setSelected(settings.isCreateDomainsDuringImport());
        this.cbGenerateCommentsInRDBMS.setSelected(settings.isGenerateCommentsInRDBMS());
        this.cbGenerateInlineColumnCC.setSelected(settings.isGenerateInlineColumnCC());
        this.cbGenerateValidValueCC.setSelected(settings.isGenerateValidValueCC());
        this.cbIncludeDefaultSettingsInDDL.setSelected(settings.isIncludeDefaultSettingsInDDL());
        this.cbIncludeLoggingInDDL.setSelected(settings.isIncludeLoggingInDDL());
        this.cbIncludeSchemaInDDL.setSelected(settings.isIncludeSchemaInDDL());
        this.cbIncludeStorageInDDL.setSelected(settings.isIncludeStorageInDDL());
        this.cbIncludeTablespaceInDDL.setSelected(settings.isIncludeTablespaceInDDL());
        this.cbIncludeRedactionInDDL.setSelected(settings.isIncludeRedactionInDDL());
        this.cbIncludeTSDPInDDL.setSelected(settings.isIncludeTSDPInDDL());
        this.cbIncludePrompt.setSelected(settings.isIncludePromptInDDL());
        this.cbUseSQLDevFormatting.setSelected(settings.useSQLDevFormatting());
        this.db2TermChar.setText(String.valueOf(settings.getDB2TerminationCharacter()));
        this.defaultDDLFilesPath.setText(settings.getDefaultDDLFilesPath());
        this.cbIncludeDesignNameInDDLPath.setSelected(settings.isIncludeDesgnNameInDDLPath());
        this.cbCreateDateTimeSnapsot.setSelected(settings.isCreateDateTimeSnapshot());
        DDLPP.validateDirectory(this.defaultDDLFilesPath);
    }

    public void onExit(TraversableContext tc) {
        settings.setGenerateTypeSubstTriggers(this.cbSubstTrigger.isSelected());
        settings.setGenerateFKArcTriggers(this.cbFKArcTriggers.isSelected());
        settings.setGenerateFKNoneTransferableTriggers(this.cbFKNoneTransferableTriggers.isSelected());
        settings.setShowByteCharInDDL(this.cbShowByteCharInDDL.isSelected());
        settings.setExtendedSizeForCharacters(this.cbExtendedSizeForChars.isSelected());
        settings.setNotNullShortFormGeneration(this.cbNotNullShortForm.isSelected());
        settings.setUseQuotedIdentifiers(this.cbUseQuotedIdentifiers.isSelected());
        settings.setReplaceSystemNamesDuringImport(this.cbReplaceSystemNamesDuringImport.isSelected());
        settings.setCreateDomainsDuringImport(this.cbCreateDomainsDuringImport.isSelected());
        settings.setGenerateCommentsInRDBMS(this.cbGenerateCommentsInRDBMS.isSelected());
        settings.setGenerateInlineColumnCC(this.cbGenerateInlineColumnCC.isSelected());
        settings.setGenerateValidValueCC(this.cbGenerateValidValueCC.isSelected());
        settings.setIncludeDefaultSettingsInDDL(this.cbIncludeDefaultSettingsInDDL.isSelected());
        settings.setIncludeLoggingInDDL(this.cbIncludeLoggingInDDL.isSelected());
        settings.setIncludeSchemaInDDL(this.cbIncludeSchemaInDDL.isSelected());
        settings.setIncludeStorageInDDL(this.cbIncludeStorageInDDL.isSelected());
        settings.setIncludeTablespaceInDDL(this.cbIncludeTablespaceInDDL.isSelected());
        settings.setIncludeRedactionInDDL(this.cbIncludeRedactionInDDL.isSelected());
        settings.setIncludeTSDPInDDL(this.cbIncludeTSDPInDDL.isSelected());
        settings.setIncludePromptInDDL(this.cbIncludePrompt.isSelected());
        settings.setUseSQLDevFormatting(this.cbUseSQLDevFormatting.isSelected());
        settings.setDefaultDDLFilesPath(this.defaultDDLFilesPath.getText());
        settings.setIncludeDesgnNameInDDLPath(this.cbIncludeDesignNameInDDLPath.isSelected());
        settings.setCreateDateTimeSnapshot(this.cbCreateDateTimeSnapsot.isSelected());
        if ("".equalsIgnoreCase(this.db2TermChar.getText().trim())) {
            settings.setDB2TerminationCharacter(' ');
        } else {
            settings.setDB2TerminationCharacter(this.db2TermChar.getText().trim().charAt(0));
        }
        DDLPreferences preferences = this.getDDLPreferences(tc);
        preferences.setSubstTrigger(this.cbSubstTrigger.isSelected());
        preferences.setfKArcTriggers(this.cbFKArcTriggers.isSelected());
        preferences.setfKNoneTransferableTriggers(this.cbFKNoneTransferableTriggers.isSelected());
        preferences.setShowByteCharInDDL(this.cbShowByteCharInDDL.isSelected());
        preferences.setNotNullShortForm(this.cbNotNullShortForm.isSelected());
        preferences.setUseQuotedIdentifiers(this.cbUseQuotedIdentifiers.isSelected());
        preferences.setReplaceSystemNamesDuringImport(this.cbReplaceSystemNamesDuringImport.isSelected());
        preferences.setCreateDomainsDuringImport(this.cbCreateDomainsDuringImport.isSelected());
        preferences.setGenerateCommentsInRDBMS(this.cbGenerateCommentsInRDBMS.isSelected());
        preferences.setGenerateInlineColumnCC(this.cbGenerateInlineColumnCC.isSelected());
        preferences.setGenerateValidValueCC(this.cbGenerateValidValueCC.isSelected());
        preferences.setIncludeDefaultSettingsInDDL(this.cbIncludeDefaultSettingsInDDL.isSelected());
        preferences.setIncludeLoggingInDDL(this.cbIncludeLoggingInDDL.isSelected());
        preferences.setIncludeSchemaInDDL(this.cbIncludeSchemaInDDL.isSelected());
        preferences.setIncludeStorageInDDL(this.cbIncludeStorageInDDL.isSelected());
        preferences.setIncludeTablespaceInDDL(this.cbIncludeTablespaceInDDL.isSelected());
        preferences.setIncludeRedactionInDDL(this.cbIncludeRedactionInDDL.isSelected());
        preferences.setIncludeTSDPInDDL(this.cbIncludeTSDPInDDL.isSelected());
        preferences.setIncludePromptInDDL(this.cbIncludePrompt.isSelected());
        preferences.setUseSQLDevFormatting(this.cbUseSQLDevFormatting.isSelected());
        preferences.setDefaultDDLFilesPath(this.defaultDDLFilesPath.getText());
        if (this.getCurrentDesign().getName().equals(UNTITLED_DESIGN + "_1") && this.getApplicationView().getDesigns().size() == 1) {
            preferences.setDb2TermChar(String.valueOf(settings.getDB2TerminationCharacter()));
        }
    }

    private void createDefaultDDLFilesPathOption() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultDDLFilesDirectory")));
        this.defaultDDLFilesPath = new JTextField();
        this.defaultDDLFilesPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(DDLPP.this.defaultDDLFilesPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(DDLPP.this.defaultDDLFilesPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(DDLPP.this.defaultDDLFilesPath);
            }
        });
        JButton bnSelect = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)DDLPP.this.defaultDDLFilesPath.getText()));
                fileChooser.setPathContext("dataModeler_DDL");
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    DDLPP.this.defaultDDLFilesPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.cbIncludeDesignNameInDDLPath = new JCheckBox(Messages.getString("OptionsDialog.IncludeDesignNameInDDLPath"));
        this.cbCreateDateTimeSnapsot = new JCheckBox(Messages.getString("OptionsDialog.CreateDateTimeSnapshot"));
        this.addItem(panel, this.defaultDDLFilesPath, 0, 0, 1, 1, 17, 1, 100);
        this.addItem(panel, bnSelect, 1, 0, 1, 1, 17, 0, 100);
        this.addItem(panel, this.cbIncludeDesignNameInDDLPath, 0, 2, 1, 1, 17, 1, 100);
        this.addItem(panel, this.cbCreateDateTimeSnapsot, 0, 3, 1, 1, 17, 1, 100);
        this.pnMain.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    private DDLPreferences getDDLPreferences(TraversableContext tc) {
        return DDLPreferences.getInstance(tc.getPropertyStorage());
    }
}

