/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSChangeRequests;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSContacts;
import oracle.dbtools.crest.exports.reports.RSDocuments;
import oracle.dbtools.crest.exports.reports.RSEmails;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSLocations;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSResourceLocators;
import oracle.dbtools.crest.exports.reports.RSResponsibleParties;
import oracle.dbtools.crest.exports.reports.RSTelephones;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ProgressDialog;

public class RSBusinessInfo
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, ProgressDialog monitor) throws Exception {
        String query = "INSERT INTO DMRS_BUSINESS_INFO (Design_ID, Design_OVID, Design_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String infoOVID = RSBusinessInfo.getOrCreateOVID(map, info.getObjectID());
        stmt.setString(1, design.getObjectID());
        stmt.setString(2, (String)map.get(design.getObjectID()));
        stmt.setString(3, design.getName());
        stmt.setString(4, info.getObjectID());
        stmt.setString(5, infoOVID);
        stmt.setString(6, info.getName());
        stmt.executeUpdate();
        RSObjectNotes.export(map, connection, info);
        RSComments.export(map, connection, info);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingDocuments"));
        RSDocuments.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingResponsibleParties"));
        RSResponsibleParties.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingContacts"));
        RSContacts.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingEmails"));
        RSEmails.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingLocations"));
        RSLocations.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingTelephones"));
        RSTelephones.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingLocators"));
        RSResourceLocators.export(design, map, connection);
        monitor.setNote(Messages.getString("RSBusinessInfo.ExportingChangeRequests"));
        RSChangeRequests.export(design, map, connection);
        stmt.close();
        stmt = null;
    }
}

