/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;

public class SSBDropView
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableViewProxy && ((TableViewProxy)object).isDropEnabled();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StorageDesign storageDesign;
        StringBuffer buffer = new StringBuffer();
        ModelIDObject mdObject = null;
        if (object == null) {
            return;
        }
        mdObject = (ModelIDObject)object;
        TableView view = null;
        if (object instanceof TableViewProxy) {
            storageDesign = ((TableViewProxy)object).getStorageDesign();
            view = (TableView)((TableViewProxy)object).getObject();
        } else {
            storageDesign = this.getStorageDesign();
            view = (TableView)object;
        }
        this.appendBeforeDropScript(buffer, prettyPrint, view);
        this.appendDrop(buffer);
        SSBDropView.appendStringWithSpace(buffer, "VIEW");
        SSBDropView.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(mdObject));
        if (storageDesign instanceof StorageDesignOracle) {
            SSBDropView.appendStringWithSpace(buffer, "CASCADE CONSTRAINTS");
        }
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        SSBDropView.appendNewLine(buffer, prettyPrint, 0);
        if (object instanceof TableViewProxyDB2 || object instanceof TableViewProxyUDB) {
            AbstractSSBDB2.appendLineFinisherUDB(buffer, prettyPrint);
        } else {
            SSBDropView.appendLineFinisher(buffer, prettyPrint);
        }
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
    }
}

