/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.cubeviews;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.cubeviews.CVExportOptions;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class CubeViewsExporter {
    public static String EXPORT_FROM_LOGICAL = "Export From Logical";
    public static String EXPORT_FROM_RELATIONAL = "Export From Relational";
    public static String[] EXPORT_TYPE = new String[]{EXPORT_FROM_LOGICAL, EXPORT_FROM_RELATIONAL};
    private StringBuffer content = new StringBuffer();
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(CubeViewsExporter.class);
    private MultidimensionalDesign mdmDesign;
    private String schema = "CVSAMPLE";
    private String indent = "   ";
    private String exportType = EXPORT_FROM_LOGICAL;
    private Map processedAttributes = new TreeMap();
    private Map processedMeasures = new TreeMap();
    private Map attrMap = new TreeMap();
    private Map measuresMap = new TreeMap();
    private List sortedMeasures = new ArrayList();
    private List tracedMeasures = new ArrayList();
    private StorageDesign storDesign;
    private RelationalDesign physDesign;
    private Design design;
    List measureDependencies;
    boolean cyclicRef = false;

    public CubeViewsExporter(ApplicationView appView) {
        this.appView = appView;
        this.design = appView.getCurrentDesign();
    }

    public void export() {
        CVExportOptions cve = new CVExportOptions(this.getApplicationView());
        boolean result = cve.showDialog();
        if (result) {
            this.mdmDesign = cve.getMultidimensionalDesign();
            this.schema = cve.getSchema();
            this.storDesign = cve.getStorageDesign();
            this.physDesign = cve.getPhysicalDesign();
            if (this.mdmDesign != null) {
                this.prepareContent();
                this.saveOutput();
            }
        } else {
            ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
        }
    }

    private void prepareContent() {
        this.addXMLVersion(this.content);
        this.addDBA4ALL_Title(this.content);
        this.addOlapBegin(this.content);
        this.addAttributes(this.content);
        this.addJoins(this.content);
        this.addLevels(this.content);
        this.addHierarchies(this.content);
        this.addDimensions(this.content);
        this.addMeasures(this.content);
        this.addFacts(this.content);
        this.addCubeModels(this.content);
        this.addOlapEnd(this.content);
    }

    private void addDBA4ALL_Title(StringBuffer content) {
        content.append("\n");
        content.append("<!-- ************************************************************************************** -->\n");
        content.append("<!-- This file contains IBM Cube Views metadata generated by Oracle SQL Developer Modeler  -->\n");
        content.append("<!-- After creating the database objects and enabling them for Cube Views,  \t\t\t\t-->\n");
        content.append("<!-- you should then import this metadata XML file in IBM Cube Views v8.2   \t\t\t\t-->\n");
        content.append("<!-- ************************************************************************************** -->\n");
    }

    private void addXMLVersion(StringBuffer content) {
        content.append(MDConfiguration.getDefaultInstance().get("xml.documenttype")).append("\n");
    }

    private void addOlapBegin(StringBuffer content) {
        content.append("\n");
        content.append("<olap:metadata xmlns:olap=\"http://www.ibm.com/olap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" version=\"8.2.0.1.0\">\n");
    }

    private void addOlapEnd(StringBuffer content) {
        content.append("\n");
        content.append("</olap:metadata>\n");
    }

    private void addAttributes(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Attributes **************** -->\n");
        TreeMap<String, DesignObject> atMap = new TreeMap<String, DesignObject>();
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            Iterator ita = null;
            ContainerObject ent = level.getLevelEntity();
            ita = ent != null ? ent.getElementsCollection().iterator() : level.getAllAttributes().iterator();
            while (ita.hasNext()) {
                DesignObject dobj = (DesignObject)ita.next();
                Object ob = atMap.get(this.getObjectId(dobj));
                if (ob != null) continue;
                this.addAttribute(content, dobj);
                atMap.put(dobj.getObjectID(), dobj);
            }
        }
        it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            ContainerObject ent = cube.getFactEntity();
            if (ent == null) continue;
            for (DesignObject dobj : ent.getElementsCollection()) {
                this.addAttribute(content, dobj);
            }
        }
    }

    private void addAttribute(StringBuffer content, DesignObject attribute) {
        Object name = attribute.getName();
        if (this.isProcessed(attribute)) {
            name = attribute instanceof Attribute ? (String)name + " (" + ((Attribute)attribute).getContainerWithKeyObject().getName() + ")" : (String)name + " (" + ((CalculatedAttribute)attribute).getLevel().getName() + ")";
        }
        this.processedAttributes.put(attribute.getName(), name);
        this.attrMap.put(this.getObjectId(attribute), name);
        String sch = this.schema;
        content.append(this.indent + "<attribute name=\"" + (String)name + "\" schema=\"" + sch + "\" businessName=\"" + attribute.getName() + "\">\n");
        this.addDataType(content, attribute);
        this.addSQLExpression(content, attribute);
        content.append(this.indent + "</attribute>\n");
    }

    private void addJoins(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Joins **************** -->\n");
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            Dimension dim = (Dimension)it.next();
            for (Level level : dim.getAllLevels()) {
                for (Link link : level.getOutgoingLinks()) {
                    if (link.getRollupLink() == null || link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                    this.addJoin(content, link);
                }
            }
        }
        it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            for (Link link : cube.getOutgoingLinks()) {
                if (link.getRollupLink() == null || link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                this.addJoin(content, link);
            }
        }
    }

    private void addJoin(StringBuffer content, Link link) {
        String name = link.getName();
        String sch = this.getSchema(link);
        RollupLink rlink = link.getRollupLink();
        Level targetLevel = null;
        if (link.getTargetMDObject() instanceof Dimension) {
            targetLevel = ((Dimension)link.getTargetMDObject()).getBaseLevel();
        } else if (link.getTargetMDObject() instanceof Level) {
            targetLevel = (Level)link.getTargetMDObject();
        }
        if (targetLevel != null && targetLevel.getLevelKey().size() == rlink.getChildToParentAttributes().size()) {
            content.append(this.indent + "<join name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + name + "\" type=\"inner\" cardinality=\"n:1\">\n");
            List ch_attrs = rlink.getChildToParentAttributes();
            for (int i = 0; i < ch_attrs.size(); ++i) {
                DesignObject dobal = (DesignObject)ch_attrs.get(i);
                ModelIDObject dobcl = this.getCorrespondentObject(dobal);
                String lname = (String)this.attrMap.get(dobal.getObjectID());
                if (lname == null) {
                    lname = dobcl.getName();
                }
                DesignObject dobar = (DesignObject)targetLevel.getLevelKey().get(i);
                ModelIDObject dobcr = this.getCorrespondentObject(dobar);
                String rname = (String)this.attrMap.get(dobar.getObjectID());
                String schl = this.schema;
                String schr = this.schema;
                if (rname == null) {
                    rname = dobcr.getName();
                }
                if (rname == null || lname == null) continue;
                content.append(this.indent + this.indent + "<attributeJoin operator=\"=\">\n");
                content.append(this.indent + this.indent + this.indent + "<leftAttributeRef name=\"" + lname + "\" schema=\"" + schl + "\"/>\n");
                content.append(this.indent + this.indent + this.indent + "<rightAttributeRef name=\"" + rname + "\" schema=\"" + schr + "\"/>\n");
                content.append(this.indent + this.indent + "</attributeJoin>\n");
            }
            content.append(this.indent + "</join>\n");
        }
    }

    private String getObjectId(ModelIDObject object) {
        if (object instanceof CalculatedAttribute) {
            return ((CalculatedAttribute)object).getLevel().getName() + object.getObjectID();
        }
        return object.getObjectID();
    }

    private ContainerObject getEntity(DesignObject attribute) {
        if (attribute instanceof Attribute) {
            return ((ContainedObjectWithDomain)attribute).getContainerWithKeyObject();
        }
        if (attribute instanceof CalculatedAttribute) {
            return ((CalculatedAttribute)attribute).getLevel().getLevelEntity();
        }
        return null;
    }

    private void addSQLExpression(StringBuffer content, DesignObject attribute) {
        if (attribute instanceof Attribute) {
            content.append(this.indent + this.indent + "<sqlExpression template=\"{$$1}\">\n");
            ModelIDObject dobj = this.getCorrespondentObject(attribute);
            String sch = this.getSchema(attribute);
            String name = dobj.getName();
            String tableName = this.getCorrespondentObject(this.getEntity(attribute)).getName();
            content.append(this.indent + this.indent + this.indent + "<column name=\"" + name + "\" tableSchema=\"" + sch + "\" tableName=\"" + tableName + "\"/>\n");
        } else if (attribute instanceof CalculatedAttribute) {
            Level level = ((CalculatedAttribute)attribute).getLevel();
            String func = ((CalculatedAttribute)attribute).getFunction();
            List list = level.getAllAttributes();
            ArrayList<DesignObject> usedattr = new ArrayList<DesignObject>();
            int i = 0;
            for (DesignObject obj : list) {
                String obname;
                if (obj == attribute || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1) continue;
                String temp = "{$$" + Integer.toString(++i) + "}";
                usedattr.add(obj);
                func = this.replace(func, obname, temp);
            }
            if (i > 0) {
                func = StringUtilities.encodeAttributeValue(func);
                content.append(this.indent + this.indent + "<sqlExpression template=\"" + func + "\">\n");
                for (DesignObject obj : usedattr) {
                    if (!(obj instanceof Attribute)) continue;
                    ModelIDObject dobj = this.getCorrespondentObject(obj);
                    String sch = this.getSchema(obj);
                    String name = dobj.getName();
                    String tableName = this.getCorrespondentObject(this.getEntity(obj)).getName();
                    content.append(this.indent + this.indent + this.indent + "<column name=\"" + name + "\" tableSchema=\"" + sch + "\" tableName=\"" + tableName + "\"/>\n");
                }
            }
        }
        content.append(this.indent + this.indent + "</sqlExpression>\n");
    }

    private void addMeasureSQLExpression(StringBuffer content, Measure measure) {
        Collection list;
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject attr = measure.getMeasureFact();
                content.append(this.indent + this.indent + "<sqlExpression template=\"{$$1}\">\n");
                ModelIDObject dobj = this.getCorrespondentObject(attr);
                String sch = this.getSchema(attr);
                String name = dobj.getName();
                String tableName = this.getCorrespondentObject(this.getEntity(attr)).getName();
                content.append(this.indent + this.indent + this.indent + "<column name=\"" + name + "\" tableSchema=\"" + sch + "\" tableName=\"" + tableName + "\"/>\n");
                content.append(this.indent + this.indent + "</sqlExpression>\n");
            }
            return;
        }
        int i = 0;
        ArrayList<DesignObject> usedattr = new ArrayList<DesignObject>();
        if (cube.getFactEntity() != null) {
            list = cube.getFactEntity().getElementsCollection();
            for (DesignObject obj : list) {
                String string;
                if (obj == measure || func.indexOf(string = "\"" + obj.getName().trim() + "\"") <= -1) continue;
                String temp = "{$$" + Integer.toString(++i) + "}";
                usedattr.add(obj);
                func = this.replace(func, string, temp);
            }
        }
        list = cube.getMeasures();
        ArrayList<Measure> usedmeas = new ArrayList<Measure>();
        for (Measure measure2 : list) {
            String obname;
            if (measure2 == measure || func.indexOf(obname = "\"" + measure2.getName().trim() + "\"") <= -1) continue;
            String temp = "{$$" + Integer.toString(++i) + "}";
            usedmeas.add(measure2);
            func = this.replace(func, obname, temp);
        }
        if (i > 0) {
            func = StringUtilities.encodeAttributeValue(func);
            content.append(this.indent + this.indent + "<sqlExpression template=\"" + func + "\">\n");
            for (DesignObject designObject : usedattr) {
                if (!(designObject instanceof Attribute)) continue;
                ModelIDObject dobj = this.getCorrespondentObject(designObject);
                String sch = this.getSchema(designObject);
                String name = dobj.getName();
                String tableName = this.getCorrespondentObject(this.getEntity(designObject)).getName();
                content.append(this.indent + this.indent + this.indent + "<column name=\"" + name + "\" tableSchema=\"" + sch + "\" tableName=\"" + tableName + "\"/>\n");
            }
            for (Measure measure3 : usedmeas) {
                String sch = this.schema;
                String name = measure3.getName();
                content.append(this.indent + this.indent + this.indent + "<measureRef name=\"" + name + "\" schema=\"" + sch + "\"/>\n");
            }
        }
        content.append(this.indent + this.indent + "</sqlExpression>\n");
    }

    private String replace(String origin, String str1, String str2) {
        String temp = str1.trim();
        Object result = origin;
        int ind = ((String)result).indexOf(temp);
        int lstr1 = temp.length();
        while (ind > -1) {
            String tresult = ind == 0 ? "" : ((String)result).substring(0, ind);
            int k = tresult.length() + str2.length();
            result = tresult + str2 + ((String)result).substring(ind + lstr1);
            ind = ((String)result).indexOf(temp, k);
        }
        return result;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject object) {
        if (this.storDesign != null) {
            ContainedObject column;
            if (object instanceof Entity) {
                Table tab = ((Entity)object).getEngTable(this.physDesign);
                if (tab != null) {
                    TableProxy tp = (TableProxy)this.storDesign.getTableProxySet().getProxy(tab.getObjectID());
                    return tp;
                }
            } else if (object instanceof Attribute && (column = ((Attribute)object).getEngColumn(this.physDesign)) != null) {
                return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            }
        } else {
            if (object instanceof Entity) {
                Table tab = ((Entity)object).getEngTable(this.physDesign);
                if (tab == null) {
                    return object;
                }
                return tab;
            }
            if (object instanceof Attribute) {
                ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
                if (column == null) {
                    return object;
                }
                return column;
            }
        }
        return object;
    }

    private String getSchema(ModelIDObject object) {
        StorageObject sto;
        ModelIDObject cobj;
        if (object instanceof TableProxy) {
            StorageObject sto2 = ((TableProxy)object).getUserSchema();
            if (sto2 != null) {
                return sto2.getName();
            }
        } else if (object instanceof Entity) {
            StorageObject sto3;
            ModelIDObject cobj2 = this.getCorrespondentObject(object);
            if (cobj2 instanceof TableProxy && (sto3 = ((TableProxy)cobj2).getUserSchema()) != null) {
                return sto3.getName();
            }
        } else if (object instanceof Attribute) {
            StorageObject sto4;
            ModelIDObject cobj3 = this.getCorrespondentObject(((Attribute)object).getContainerWithKeyObject());
            if (cobj3 instanceof TableProxy && (sto4 = ((TableProxy)cobj3).getUserSchema()) != null) {
                return sto4.getName();
            }
        } else if (object instanceof CalculatedAttribute && (cobj = this.getCorrespondentObject(((CalculatedAttribute)object).getLevel().getLevelEntity())) instanceof TableProxy && (sto = ((TableProxy)cobj).getUserSchema()) != null) {
            return sto.getName();
        }
        return this.schema;
    }

    private boolean isProcessed(DesignObject attribute) {
        return this.processedAttributes.get(attribute.getName()) != null;
    }

    private void addLevels(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Levels **************** -->\n");
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            this.addLevel(content, level);
        }
    }

    private void addLevel(StringBuffer content, Level level) {
        String name = level.getName();
        String sch = this.getSchema(level);
        content.append(this.indent + "<level name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + level.getName() + "\" funcDep=\"no\" funcDepName=\"\">\n");
        List list = level.getLevelKey();
        this.addAttributeRefs(content, list, "levelKeyRef");
        DesignObject defattr = level.getDefaultAttribute();
        ArrayList descList = new ArrayList();
        descList.addAll(level.getDescriptiveAttributes());
        if (defattr != null) {
            descList.remove(defattr);
            ArrayList<DesignObject> dlist = new ArrayList<DesignObject>();
            dlist.add(defattr);
            this.addAttributeRefs(content, dlist, "defaultAttributeRef");
        } else if (descList.size() > 0) {
            defattr = (DesignObject)descList.get(0);
            descList.remove(defattr);
            ArrayList<DesignObject> dlist = new ArrayList<DesignObject>();
            dlist.add(defattr);
            this.addAttributeRefs(content, dlist, "defaultAttributeRef");
        } else if (level.getLevelKey().size() > 0) {
            defattr = (DesignObject)level.getLevelKey().get(0);
            ArrayList<DesignObject> dlist = new ArrayList<DesignObject>();
            dlist.add(defattr);
            this.addAttributeRefs(content, dlist, "defaultAttributeRef");
        }
        this.addAttributeRefs(content, descList, "relatedAttributeRef");
        content.append(this.indent + "</level>\n");
    }

    private void addAttributeRefs(StringBuffer content, List list, String type) {
        for (DesignObject object : list) {
            ModelIDObject dobj = this.getCorrespondentObject(object);
            String refname = (String)this.attrMap.get(this.getObjectId(object));
            if (refname == null) {
                refname = dobj.getName();
            }
            String sch = this.schema;
            content.append(this.indent + this.indent + "<" + type + " name=\"" + refname + "\" schema=\"" + sch + "\"/>\n");
        }
    }

    private void addObjectRefs(StringBuffer content, List list, String type) {
        for (DesignObject object : list) {
            String refname = object.getName();
            String sch = this.getSchema(object);
            content.append(this.indent + this.indent + "<" + type + " name=\"" + refname + "\" schema=\"" + sch + "\"/>\n");
        }
    }

    private void addHierarchies(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Hierarchies **************** -->\n");
        Iterator it = this.mdmDesign.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            this.addHierarchy(content, hier);
        }
    }

    private void addHierarchy(StringBuffer content, Hierarchy hierarchy) {
        String name = hierarchy.getName();
        String sch = this.getSchema(hierarchy);
        content.append(this.indent + "<hierarchy name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + hierarchy.getName() + "\" type=\"balanced\" deployment=\"standard\">\n");
        List list = hierarchy.getLevels();
        this.addObjectRefs(content, list, "levelRef");
        content.append(this.indent + "</hierarchy>\n");
    }

    private void addDimensions(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Dimensions **************** -->\n");
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            Dimension dim = (Dimension)it.next();
            this.addDimension(content, dim);
        }
    }

    private void addDimension(StringBuffer content, Dimension dimension) {
        String name = dimension.getName();
        String sch = this.getSchema(dimension);
        String dtype = "regular";
        if (dimension.isTimeDimension()) {
            dtype = "time";
        }
        content.append(this.indent + "<dimension name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + dimension.getName() + "\" type=\"" + dtype + "\">\n");
        List list = dimension.getAllAttributes();
        this.addAttributeRefs(content, list, "attributeRef");
        for (Level level : dimension.getAllLevels()) {
            for (Link link : level.getOutgoingLinks()) {
                if (link.getRollupLink() == null || link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                this.addJoinRef(content, link);
            }
        }
        list = new ArrayList();
        dimension.getHierarchies().addAllElementsTo(list);
        this.addObjectRefs(content, list, "hierarchyRef");
        list = dimension.getAllLevels();
        this.addObjectRefs(content, list, "levelRef");
        content.append(this.indent + "</dimension>\n");
    }

    private void addJoinRef(StringBuffer content, Link link) {
        String name = link.getName();
        String sch = this.getSchema(link);
        content.append(this.indent + this.indent + "<joinRef name=\"" + name + "\" schema=\"" + sch + "\"/>\n");
    }

    private void addMeasures(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Measures **************** -->\n");
        Iterator it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.sortMeasures(cube.getMeasures());
            for (Measure measure : this.sortedMeasures) {
                this.addMeasure(content, measure);
            }
        }
    }

    private void addMeasure(StringBuffer content, Measure measure) {
        Object name = measure.getName();
        if (this.processedMeasures.get(name) != null) {
            name = (String)name + " (" + measure.getCube().getName() + ")";
        }
        this.processedMeasures.put(measure.getName(), name);
        this.measuresMap.put(measure.getObjectID(), name);
        String sch = this.schema;
        content.append(this.indent + "<measure name=\"" + (String)name + "\" schema=\"" + sch + "\" businessName=\"" + measure.getName() + "\">\n");
        this.addMeasureSQLExpression(content, measure);
        this.addAggregations(content, measure);
        content.append(this.indent + "</measure>\n");
    }

    private void addAggregations(StringBuffer content, Measure measure) {
        for (Measure.AggregateFunction af : measure.getAggregateFunctions()) {
            if ("".equalsIgnoreCase(af.name)) continue;
            content.append(this.indent + this.indent + "<aggregation function=\"" + af.name + "\">\n");
            content.append(this.indent + this.indent + "</aggregation>\n");
        }
    }

    private void addFacts(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** Facts **************** -->\n");
        Iterator it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.addFact(content, cube);
        }
    }

    private void addFact(StringBuffer content, Cube cube) {
        String name = cube.getName();
        String sch = this.getSchema(cube);
        content.append(this.indent + "<facts name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + name + "\">\n");
        this.addMeasureRefs(content, cube);
        this.addAttributeRefs(content, this.getFKAttributes(cube), "attributeRef");
        content.append(this.indent + "</facts>\n");
    }

    private List getFKAttributes(Cube cube) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        if (cube.getFactEntity() != null) {
            for (Attribute attr : cube.getFactEntity().getElementsCollection()) {
                if (!attr.isFKAttribute()) continue;
                list.add(attr);
            }
        }
        return list;
    }

    private void addCubeModels(StringBuffer content) {
        content.append("\n");
        content.append("<!-- *********************** CubeModels **************** -->\n");
        Iterator it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.addCubeModel(content, cube);
        }
    }

    private void addCubeModel(StringBuffer content, Cube cube) {
        String name = cube.getName();
        String sch = this.getSchema(cube);
        content.append(this.indent + "<cubeModel name=\"" + name + "\" schema=\"" + sch + "\" businessName=\"" + name + "\">\n");
        content.append(this.indent + this.indent + "<factsRef name=\"" + name + "\" schema=\"" + sch + "\"/>\n");
        for (Dimension dim : cube.getDimensions()) {
            name = dim.getName();
            sch = this.getSchema(dim);
            content.append(this.indent + this.indent + "<dimensionInfo>\n");
            content.append(this.indent + this.indent + this.indent + "<dimensionRef name=\"" + name + "\" schema=\"" + sch + "\"/>\n");
            Link link = cube.getFirstLinkToTarget(dim);
            if (link != null && link.getRollupLink() != null && link.getRollupLink().getChildToParentAttributes().size() > 0) {
                this.addJoinRef(content, link);
            }
            content.append(this.indent + this.indent + "</dimensionInfo>\n");
        }
        content.append(this.indent + "</cubeModel>\n");
    }

    private void addMeasureRefs(StringBuffer content, Cube cube) {
        for (Measure measure : cube.getMeasures()) {
            String name = measure.getName();
            if (this.measuresMap.get(measure.getObjectID()) != null) {
                name = (String)this.measuresMap.get(measure.getObjectID());
            }
            String sch = this.schema;
            content.append(this.indent + this.indent + "<measureRef name=\"" + name + "\" schema=\"" + sch + "\"/>\n");
        }
    }

    private void addDataType(StringBuffer content, DesignObject object) {
        MDDataType type = null;
        String nulls = "no";
        if (!(object instanceof Measure)) {
            if (object instanceof Attribute) {
                type = (MDDataType)((Attribute)object).getDataType("DB2/UDB 8.1");
                if (((Attribute)object).getNullsAllowed()) {
                    nulls = "yes";
                }
            } else if (object instanceof CalculatedAttribute) {
                // empty if block
            }
        }
        if (type != null) {
            String size = "0";
            String scale = "0";
            String sch = "SYSIBM";
            String name = type.getName();
            if (type.isPacked()) {
                size = String.valueOf(type.getPrecision());
                scale = String.valueOf(type.getScale());
            } else {
                size = type.getSize();
            }
            content.append(this.indent + this.indent + "<datatype schema=\"" + sch + "\" name=\"" + name + "\" length=\"" + size + "\" scale=\"" + scale + "\" nullable=\"" + nulls + "\"/>\n");
        }
    }

    public void saveOutput() {
        try {
            URLFilter fileFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("CubeViewsExporter.XMLFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(fileFilter);
            fileChooser.setPathContext("dataModeler_Exports");
            String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
            if (lastDir != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
            } else {
                URL url = this.getApplicationView().getUserHomeDirectory();
                if (url != null) {
                    fileChooser.setSelectedURL(url);
                }
            }
            String fileName = this.design.getName() + ".xml";
            fileChooser.setFileNameURL(fileName);
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsExporter.SaveToXMLFile"));
            if (status == 0) {
                File selectedFolder = new File(fileChooser.getSelectedURL().getPath());
                if (selectedFolder != null && this.saveOutput(selectedFolder)) {
                    ApplicationView.log(Messages.getString("CubeViewsExporter.ExportedOk"));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsExporter.ExportedOk"));
                    FileOpenHistory.getInstance().updateFileHistory(selectedFolder.getParentFile().toURI().toURL());
                } else {
                    ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
                }
            } else {
                ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
            }
        }
        catch (IOException ioe) {
            LOGGER.error("", ioe);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("CubeViewsExporter.CanNotWriteToFile"), ioe.getMessage()}, Messages.getString("CubeViewsExporter.WriteError"), 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("CubeViewsExporter.UnexpectedError"), t.getMessage()}, Messages.getString("CubeViewsExporter.WriteError"), 0);
        }
    }

    private ApplicationView getApplicationView() {
        return this.appView;
    }

    protected boolean saveOutput(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CubeViewsExporter.FileExists"), file.getAbsolutePath()), Messages.getString("CubeViewsExporter.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        osw.write(this.content.toString());
        osw.close();
        return true;
    }

    public void setTempStatusMessage(String message) {
        this.appView.setTempStatusMessage(message);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    private List getMeasureDependencies(List measures) {
        ArrayList<MeasureDependence> list = new ArrayList<MeasureDependence>();
        for (Measure measure : measures) {
            MeasureDependence md = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                list.add(md);
                continue;
            }
            String formula = measure.getFormula();
            for (Measure measn : measures) {
                String namedq;
                if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().trim() + "\"") <= -1) continue;
                md.dependOn.add(measn);
            }
            list.add(md);
        }
        return list;
    }

    private void sortMeasures(List measures) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(measures);
        for (Measure measure : measures) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence md = this.getMeasureDependence(measure, this.measureDependencies);
        if (md == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (md.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (Measure meas : md.dependOn) {
            if (this.tracedMeasures.contains(meas) && !this.sortedMeasures.contains(meas)) {
                this.cyclicRef = true;
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CubeViewsExporter.CyclicReferenceForMeasure"), meas.getCube().getName(), meas.getName()), Messages.getString("CubeViewsExporter.TheListOfMeasuresWillNotBeComplete"), 0, 0, null, new String[]{Messages.getString("CubeViewsExporter.Ok")}, Messages.getString("CubeViewsExporter.Ok"));
                return;
            }
            if (this.sortedMeasures.contains(meas)) continue;
            this.addToSorted(meas);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(Measure measure, List measureDependencies) {
        for (MeasureDependence md : measureDependencies) {
            if (md.measure != measure) continue;
            return md;
        }
        return null;
    }

    class MeasureDependence {
        Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(Measure measure) {
            this.measure = measure;
        }
    }
}

