/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLInsightPlugin;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLListDataItem;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.ListInsightData;

public class SPARQLInsightData
implements ListInsightData {
    ArrayList<SPARQLListDataItem> keywords = new ArrayList(5);
    private DefaultListModel listModel;
    BasicEditorPane editor;
    SPARQLInsightPlugin insight;
    JList jl;

    public SPARQLInsightData() {
        this.keywords.add(new SPARQLListDataItem("BASE"));
        this.keywords.add(new SPARQLListDataItem("PREFIX"));
        this.keywords.add(new SPARQLListDataItem("SELECT"));
        this.keywords.add(new SPARQLListDataItem("CONSTRUCT"));
        this.keywords.add(new SPARQLListDataItem("DESCRIBE"));
        this.keywords.add(new SPARQLListDataItem("ASK"));
        this.keywords.add(new SPARQLListDataItem("ORDER BY"));
        this.keywords.add(new SPARQLListDataItem("LIMIT"));
        this.keywords.add(new SPARQLListDataItem("OFFSET"));
        this.keywords.add(new SPARQLListDataItem("DISTINCT"));
        this.keywords.add(new SPARQLListDataItem("REDUCED"));
        this.keywords.add(new SPARQLListDataItem("FROM"));
        this.keywords.add(new SPARQLListDataItem("FROM NAMED"));
        this.keywords.add(new SPARQLListDataItem("NAMED"));
        this.keywords.add(new SPARQLListDataItem("WHERE"));
        this.keywords.add(new SPARQLListDataItem("GRAPH"));
        this.keywords.add(new SPARQLListDataItem("GROUP BY"));
        this.keywords.add(new SPARQLListDataItem("OPTIONAL"));
        this.keywords.add(new SPARQLListDataItem("UNION"));
        this.keywords.add(new SPARQLListDataItem("FILTER(  )"));
        this.keywords.add(new SPARQLListDataItem("STR"));
        this.keywords.add(new SPARQLListDataItem("LANG"));
        this.keywords.add(new SPARQLListDataItem("LANGMATCHES"));
        this.keywords.add(new SPARQLListDataItem("DATATYPE"));
        this.keywords.add(new SPARQLListDataItem("BOUND"));
        this.keywords.add(new SPARQLListDataItem("sameTERM"));
        this.keywords.add(new SPARQLListDataItem("isURI(?x)"));
        this.keywords.add(new SPARQLListDataItem("isIRI(?x)"));
        this.keywords.add(new SPARQLListDataItem("isLITERAL(?x)"));
        this.keywords.add(new SPARQLListDataItem("REGEX"));
        this.keywords.add(new SPARQLListDataItem("true"));
        this.keywords.add(new SPARQLListDataItem("false"));
        this.keywords.add(new SPARQLListDataItem("COUNT"));
        this.keywords.add(new SPARQLListDataItem("ABS(<rdf_term>)"));
        this.keywords.add(new SPARQLListDataItem("BNODE()"));
        this.keywords.add(new SPARQLListDataItem("BNODE(<literal>)"));
        this.keywords.add(new SPARQLListDataItem("BOUND(<var>)"));
        this.keywords.add(new SPARQLListDataItem("CEIL(<var>)"));
        this.keywords.add(new SPARQLListDataItem("CONCAT(<rdf_term_1>, <rdf_term2>, ...)"));
        this.keywords.add(new SPARQLListDataItem("CONTAINS(<literal>, \"pattern\")"));
        this.keywords.add(new SPARQLListDataItem("DATATYPE(<literal>)"));
        this.keywords.add(new SPARQLListDataItem("DAY(<argument>)"));
        this.keywords.add(new SPARQLListDataItem("ENCODE_FOR_URI(<literal>)"));
        this.keywords.add(new SPARQLListDataItem("EXISTS({<pattern>})"));
        this.keywords.add(new SPARQLListDataItem("FLOOR(<rdf_term>)"));
        this.listModel = new DefaultListModel();
        for (SPARQLListDataItem sPARQLListDataItem : this.keywords) {
            this.listModel.addElement(sPARQLListDataItem);
        }
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public Object[] getData() {
        return this.keywords.toArray();
    }

    public Object[] getMatchingData() {
        String string = this.getTypedWord();
        Object[] objectArray = this.keywords.stream().filter(sPARQLListDataItem -> sPARQLListDataItem.getName().toUpperCase().startsWith(string)).toArray();
        return objectArray;
    }

    public int getMatchingDataCount() {
        String string = this.getTypedWord();
        Object[] objectArray = this.keywords.stream().filter(sPARQLListDataItem -> sPARQLListDataItem.getName().toUpperCase().startsWith(string)).toArray();
        return objectArray.length;
    }

    public Object getDefault() {
        return this.keywords.stream().findFirst();
    }

    public boolean complete(Object object) {
        int n = this.insight.getCaretPosition();
        SPARQLListDataItem sPARQLListDataItem = (SPARQLListDataItem)((Object)object);
        String string = this.getTypedWord();
        String string2 = sPARQLListDataItem.getDisplayText();
        String string3 = string2.substring(string.length());
        try {
            this.insight.getDocument().insertString(n, string3, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return false;
    }

    public void partialComplete() {
    }

    protected String getTypedWord() {
        int n;
        if (this.insight == null) {
            return "";
        }
        if (this.insight.getEditorPane() == null) {
            return "";
        }
        int n2 = this.insight.getCaretPosition();
        String string = null;
        try {
            string = this.insight.getDocument().getText(0, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        for (n = n2 - 1; n >= 0 && Character.isLetter(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1);
        return string2.toUpperCase();
    }

    void setInsight(SPARQLInsightPlugin sPARQLInsightPlugin) {
        this.insight = sPARQLInsightPlugin;
    }
}

