/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.palette2.Palette;
import oracle.ide.palette2.PaletteConsumer;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePageProvider;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.palette2.res.Bundle;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.palette2.MyComponentsPageProvider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockableFactory;
import oracle.ideimpl.palette2.PaletteHook;
import oracle.ideimpl.palette2.PaletteManagerImpl;
import oracle.ideimpl.palette2.PalettePageSelectionStrategy;
import oracle.ideimpl.palette2.PaletteSelectionElement;
import oracle.ideimpl.palette2.PaletteWindowUI;
import oracle.ideimpl.palette2.SearchThread;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.patterns.Operator;

public class PaletteWindowImpl
extends PaletteWindow
implements EditorListener,
ViewListener,
Dockable,
DockableListener {
    private static final String USE_LARGE_ICONS = "USE_LARGE_ICONS";
    private static final PaletteWindow SINGLETON = new PaletteWindowImpl();
    private static final PaletteControllerUI PALETTE_CONTROLLER = PaletteControllerUI.getInstance();
    private static boolean OPENED = false;
    private static boolean _dockableHidden = true;
    private static boolean editorListenerAdded = false;
    private static boolean _isView = false;
    private static final HelpInfo HELP_INFO = new HelpInfo("f1_idecomponentpalette_html");
    protected CopyOnWriteArrayList<WeakReference<PaletteListener>> listeners;
    private Collection<PaletteConsumer> _consumers = null;
    private Editor _currentEditor = null;
    private View _currentView = null;
    private PropertyChangeListener _editorReadyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("DELAY_PALETTE_LOAD".equals(evt.getPropertyName()) && Boolean.FALSE == evt.getNewValue() && evt.getSource() instanceof Editor) {
                Editor ed = (Editor)evt.getSource();
                ed.removePropertyChangeListener((PropertyChangeListener)this);
                if (ed == PaletteWindowImpl.this.getEditor()) {
                    PaletteWindowImpl.this.synchronizeWithEditor(ed, true);
                }
            }
        }
    };
    private ProjectChangeListener _projectListener = new ProjectChangeListener(){

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            PaletteWindowImpl.this._synchronizePalette(PaletteWindowImpl.this.getEditor(), true);
        }
    };
    private boolean useLargeIcons = true;
    private JPanel palettesPanel;
    private Map<PaletteWindowUI, List<View>> viewsByPalette = new HashMap<PaletteWindowUI, List<View>>();
    private Map<View, PaletteWindowUI> palettesByView = new HashMap<View, PaletteWindowUI>();
    private PaletteWindowUI activePalette;
    private ViewListener viewClosedListener = new ViewListener(){

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            PaletteWindowImpl _this = PaletteWindowImpl.this;
            View view = e.getView();
            _this.removeView(view);
        }
    };
    private List<String> palette1PageExclusions = new ArrayList<String>();
    private Map<String, Dockable> inactiveDockablesByType = new HashMap<String, Dockable>();
    private String savedPageName;
    private NodeListener workspaceListener = new NodeListener(){

        public void nodeClosed(NodeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowImpl.this.refresh();
                }
            });
        }
    };
    private boolean m_selectionChangedEventWasFired = false;
    private boolean showTypeInProgress = false;

    public PaletteWindowImpl() {
        super(PaletteWindowImpl.viewId());
        DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        PaletteHook hook = (PaletteHook)ExtensionRegistry.getExtensionRegistry().getHook(PaletteHook.NAME);
        hook.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                PaletteWindowImpl _this = PaletteWindowImpl.this;
                _this.registerPageProviders((PaletteHook)e.getHashStructureHook(), e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                PaletteWindowImpl _this = PaletteWindowImpl.this;
                _this.registerPageProviders((PaletteHook)e.getHashStructureHook(), e.getCombinedHashStructure());
            }
        });
    }

    private void registerPageProviders(PaletteHook hook, HashStructure hashStructure) {
        List<Class> providersToRegister;
        hook.processData(hashStructure);
        List<Class> providers = hook.getProviderClasses();
        if (providers != null && providers.size() > 0 && (providersToRegister = this.eliminateRegisteredProviders(providers)).size() > 0) {
            this.registerPageProviders(providersToRegister);
        }
        this.palette1PageExclusions.addAll(hook.getPalette1PageExclusions());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaletteWindowImpl.this.refresh();
            }
        });
    }

    private List<Class> eliminateRegisteredProviders(List<Class> list) {
        List<PalettePageProvider> existingProviders;
        ArrayList<Class> returnList = new ArrayList<Class>(list);
        Palette palette = Palette.getInstance();
        if (palette != null && (existingProviders = palette.getPalettePageProviders()) != null && existingProviders.size() > 0) {
            for (Class c : list) {
                boolean add = true;
                for (PalettePageProvider provider : existingProviders) {
                    if (!provider.getClass().getName().equals(c.getName())) continue;
                    add = false;
                    break;
                }
                if (add) continue;
                returnList.remove(c);
            }
        }
        return returnList;
    }

    private void registerPageProviders(List<Class> providers) {
        PalettePageProvider declaredPalette1PageProvider = null;
        String declaredPalette1PageProviderClassName = PaletteArb.getString(2);
        for (Class provider : providers) {
            try {
                PalettePageProvider declaredPageProvider = (PalettePageProvider)provider.newInstance();
                if (provider.getName().equals(declaredPalette1PageProviderClassName)) {
                    declaredPalette1PageProvider = declaredPageProvider;
                    continue;
                }
                this.addPageProvider(declaredPageProvider);
            }
            catch (Exception e) {
                FeedbackManager.reportException((String)("Failed to instantiate " + provider), (Throwable)e);
            }
        }
        if (declaredPalette1PageProvider != null) {
            this.addPageProvider(declaredPalette1PageProvider);
        }
    }

    @Override
    public boolean getUseLargeIcons() {
        return this.useLargeIcons;
    }

    public Controller getController() {
        if (null != this.activePalette) {
            return this.activePalette.getController();
        }
        return PaletteControllerUI.getInstance();
    }

    private void initConsumerListeners() {
        PaletteManager manager = PaletteManager.getPaletteManager();
        if (!(manager instanceof PaletteManagerImpl)) {
            return;
        }
        this._consumers = ((PaletteManagerImpl)manager).getPaletteConsumers();
        if (null == this._consumers) {
            return;
        }
        for (PaletteConsumer consumer : this._consumers) {
            consumer.getConsumerView().addViewListener((ViewListener)this);
        }
    }

    public Component getGUI() {
        if (null == this._consumers) {
            this.initConsumerListeners();
        }
        Container gui = this._getGUI();
        if (this.m_selectionChangedEventWasFired || this._synchronizePalette(this.getEditor(), false)) {
            return gui;
        }
        return null;
    }

    private Container _getGUI() {
        if (null == this.palettesPanel) {
            this.palettesPanel = new JPanel(new CardLayout());
        }
        return this.palettesPanel;
    }

    private void addPageProvider(PalettePageProvider declaredPageProvider) {
        Palette.getInstance().addPalettePageProvider(declaredPageProvider);
    }

    public static PaletteWindow getInstance() {
        return SINGLETON;
    }

    public void dockableShown(DockableEvent e) {
        if (!_dockableHidden) {
            return;
        }
        _dockableHidden = false;
        super.dockableShown(e);
        Project.addProjectChangeListener((String)TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY, (ProjectChangeListener)this._projectListener);
        Node.addNodeListenerForType(Workspace.class, (NodeListener)this.workspaceListener);
        this._synchronizePalette(this.getEditor(), true);
    }

    public void dockableHidden(DockableEvent e) {
        _dockableHidden = true;
        this._currentEditor = null;
        super.dockableHidden(e);
        Project.removeProjectChangeListener((String)TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY, (ProjectChangeListener)this._projectListener);
        Node.removeNodeListenerForType(Workspace.class, (NodeListener)this.workspaceListener);
        EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
        editorListenerAdded = false;
    }

    @Override
    public PaletteItem getFocusedItem() {
        return PALETTE_CONTROLLER.getCurrentlyFocusedPaletteItem();
    }

    public PaletteItem getSelectedItem() {
        return PALETTE_CONTROLLER.getSelectedItem();
    }

    @Override
    public void unSelectSelectedItem() {
        PALETTE_CONTROLLER.unSelectSelectedItem(false);
    }

    @Override
    public void markRecentUsage() {
        PALETTE_CONTROLLER.markRecentUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged() {
        if (this.m_selectionChangedEventWasFired || null == this.activePalette) {
            return;
        }
        try {
            PalettePageSelectionStrategy strategy;
            PalettePage page;
            this.m_selectionChangedEventWasFired = true;
            String pageName = this.activePalette.getSelectedPageName();
            if (null != pageName) {
                this.activePalette.showPage(pageName);
            }
            if ((page = this.activePalette.getSelectedPage()) != null) {
                this.fireSelectionChanged(new PaletteEvent(page, "PALETTE2_SELECTION_CHANGED"));
            }
            if (null != (strategy = this.activePalette.getPageSelectionStrategy()) && !this.showTypeInProgress) {
                strategy.setLRUPage(this.getEditor(), pageName);
            }
        }
        finally {
            this.m_selectionChangedEventWasFired = false;
        }
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 1: {
                if (OPENED || !(OPENED = this._synchronizePalette(this.getEditor(), false))) break;
                this.firePaletteOpened();
                break;
            }
            case 2: {
                EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
                editorListenerAdded = false;
                break;
            }
            case 3: {
                if (OPENED) {
                    this.firePaletteClosed();
                }
                this.clearSavedViews();
            }
        }
        super.stateChange(newState);
        for (PaletteWindowUI palette : this.viewsByPalette.keySet()) {
            if (null == palette) continue;
            palette.stateChange(newState);
        }
    }

    public View getEditor() {
        if (_isView) {
            return this._currentView;
        }
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            editor = null;
        }
        return editor;
    }

    private boolean _synchronizePalette(View view, boolean forceShowType) {
        if (!editorListenerAdded) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            editorListenerAdded = true;
        }
        if (view instanceof Editor) {
            return this.synchronizeWithEditor((Editor)view, forceShowType);
        }
        return this.synchronizeWithView(view);
    }

    private boolean synchronizeWithEditor(Editor editor) {
        return this.synchronizeWithEditor(editor, false);
    }

    private boolean synchronizeWithEditor(Editor editor, boolean forceShowType) {
        boolean sameEditor;
        boolean bl = sameEditor = this._currentEditor == editor;
        if (this._currentEditor != null) {
            this._currentEditor.removePropertyChangeListener(this._editorReadyListener);
        }
        if (editor == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowImpl.this.showPageInactive();
                }
            });
        }
        this._currentEditor = editor;
        if (null != editor && Boolean.TRUE == editor.getEditorAttribute("DELAY_PALETTE_LOAD")) {
            editor.addPropertyChangeListener(this._editorReadyListener);
            this.showPageLoading();
            return true;
        }
        if (!sameEditor || forceShowType || null == this.activePalette) {
            this.showType(true, (View)editor);
        }
        return true;
    }

    private boolean synchronizeWithView(View view) {
        this._currentView = view;
        this.showType(true, view);
        return true;
    }

    public List<PalettePages> getProviderPages() {
        if (null != this.activePalette) {
            return this.activePalette.getProviderPages();
        }
        return Collections.emptyList();
    }

    public List<String> getPageList() {
        if (null != this.activePalette) {
            return this.activePalette.getPageList();
        }
        return Collections.emptyList();
    }

    public PalettePages getPalette1ProviderPages() {
        if (null != this.activePalette) {
            return this.activePalette.getPalette1ProviderPages();
        }
        return null;
    }

    public List<String> getPalette1PageExclusions() {
        return this.palette1PageExclusions;
    }

    @Deprecated
    public void doSearch() {
        if (null != this.activePalette) {
            this.activePalette.doSearch();
        }
    }

    @Deprecated
    public void stopSearch() {
        if (null != this.activePalette) {
            this.activePalette.stopSearch();
        }
    }

    public String getSelectedPageName() {
        if (null != this.activePalette) {
            return this.activePalette.getSelectedPageName();
        }
        return null;
    }

    void expand(View view) {
        if (null != this.activePalette) {
            this.activePalette.expand(view);
        }
    }

    void setSearchThread(SearchThread thread) {
        if (null != this.activePalette) {
            this.activePalette.setSearchThread(thread);
        }
    }

    void showSearchResults(Collection<PaletteAugmentedItem> results) {
        if (null != this.activePalette) {
            this.activePalette.showSearchResults(results);
        }
    }

    void removeSearchResults() {
        if (null != this.activePalette) {
            this.activePalette.removeSearchResults();
        }
    }

    void addCloseableDrawer(DockableWindow window, int i) {
        if (null != this.activePalette) {
            this.activePalette.addCloseableDrawer(window, i);
        }
    }

    void updateDrawerHandlesVisibility() {
        if (null != this.activePalette) {
            this.activePalette.updateDrawerHandlesVisibility();
        }
    }

    @Override
    public synchronized void setUseLargeIcons(boolean useLargeIcons) {
        this.useLargeIcons = useLargeIcons;
        for (PaletteWindowUI palette : this.viewsByPalette.keySet()) {
            if (null == palette) continue;
            palette.setUseLargeIcons(useLargeIcons);
        }
    }

    public synchronized void showType(final boolean refresh, final View editor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowImpl.this.showType(refresh, editor);
                }
            });
            return;
        }
        List<PalettePages> pageSets = this.getPalettePages(editor);
        this.activePalette = this.findPaletteWith(pageSets);
        if (null == this.activePalette) {
            if (null == pageSets || PaletteWindowImpl.isEmpty(pageSets)) {
                this.showPageInactive();
                return;
            }
            this.activePalette = new PaletteWindowUI();
            this.activePalette.setPageSets(pageSets);
            this.activePalette.setUseLargeIcons(this.getUseLargeIcons());
            this.activePalette.setSavedPageName(this.savedPageName);
        }
        this.saveViewAndPalette(editor, this.activePalette);
        Container ui = this._getGUI();
        if (ui != this.activePalette.getGUI().getParent()) {
            ui.add(this.activePalette.getGUI(), this.activePalette.getId());
        }
        ((CardLayout)ui.getLayout()).show(ui, this.activePalette.getId());
    }

    private synchronized void saveViewAndPalette(View view, PaletteWindowUI palette) {
        if (null == view) {
            return;
        }
        List<View> paletteViews = this.viewsByPalette.get(palette);
        if (null == paletteViews) {
            paletteViews = new ArrayList<View>();
            this.viewsByPalette.put(palette, paletteViews);
        }
        if (!paletteViews.contains(view)) {
            paletteViews.add(view);
        }
        this.palettesByView.put(view, palette);
        view.addViewListener(this.viewClosedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeView(View view) {
        if (null == view) {
            return;
        }
        try {
            final PaletteWindowUI palette = this.palettesByView.remove(view);
            if (null == palette) {
                return;
            }
            List<View> views = this.viewsByPalette.get(palette);
            if (null == views) {
                return;
            }
            views.remove(view);
            if (views.isEmpty()) {
                this.viewsByPalette.remove(palette);
                palette.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaletteWindowImpl.this._getGUI().remove(palette.getGUI());
                    }
                });
            }
        }
        finally {
            view.removeViewListener(this.viewClosedListener);
        }
    }

    private synchronized void clearSavedViews() {
        ArrayList<View> views = new ArrayList<View>(this.palettesByView.keySet());
        for (View view : views) {
            this.removeView(view);
        }
    }

    private List<PalettePages> getPalettePages(View editor) {
        PalettePages myCompsPageSet;
        Context context;
        List<PalettePageProvider> providerList = Palette.getInstance().getPalettePageProviders();
        if (null == providerList || providerList.isEmpty()) {
            return Collections.emptyList();
        }
        Context context2 = context = null != editor ? editor.getContext() : Context.newIdeContext((View)editor);
        if (null == context) {
            context = Context.newIdeContext();
        }
        ArrayList<PalettePages> pageSets = new ArrayList<PalettePages>();
        MyComponentsPageProvider myComps = null;
        for (PalettePageProvider provider : providerList) {
            if (provider instanceof MyComponentsPageProvider) {
                myComps = (MyComponentsPageProvider)provider;
                continue;
            }
            PalettePages pageSet = provider.createPalettePages(context);
            if (null == pageSet) continue;
            pageSets.add(pageSet);
        }
        if (null != myComps && null != (myCompsPageSet = myComps.createPalettePages(context))) {
            pageSets.add(myCompsPageSet);
        }
        return pageSets;
    }

    private synchronized PaletteWindowUI findPaletteWith(List<PalettePages> pageSets) {
        for (PaletteWindowUI palette : this.viewsByPalette.keySet()) {
            List<PalettePages> palettePageSets;
            if (null == palette || !(palettePageSets = palette.getProviderPages()).equals(pageSets)) continue;
            return palette;
        }
        return null;
    }

    void hide(View view) {
        if (null != this.activePalette) {
            this.activePalette.hide(view);
        }
    }

    private void showPageLoading() {
        this.showPageInactive(PaletteArb.getString(62));
    }

    private void showPageInactive() {
        this.showPageInactive(PaletteArb.getString(52));
    }

    private void showPageInactive(String type) {
        Dockable inactive = this.inactiveDockablesByType.get(type);
        if (null == inactive) {
            ViewId viewId = new ViewId("PALETTEFACTORY", type);
            inactive = PaletteDockableFactory.getInstance().getDockable(viewId);
            this.inactiveDockablesByType.put(type, inactive);
        }
        Container ui = this._getGUI();
        JComponent inactiveComp = inactive.getHostedComponent();
        if (inactiveComp.getParent() != ui) {
            ui.add((Component)inactiveComp, type);
        }
        ((CardLayout)ui.getLayout()).show(ui, type);
    }

    @Override
    public void addPaletteListener(PaletteListener paletteListener) {
        if (null == this.listeners) {
            this.listeners = new CopyOnWriteArrayList();
        }
        this.listeners.add(new WeakReference<PaletteListener>(paletteListener));
    }

    @Override
    public void removePaletteListener(PaletteListener paletteListener) {
        if (null == this.listeners) {
            return;
        }
        for (WeakReference<PaletteListener> weak : this.listeners) {
            PaletteListener l = (PaletteListener)weak.get();
            if (null != l && paletteListener != l) continue;
            this.listeners.remove(weak);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public void firePaletteOpened(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.paletteOpened(event);
                return null;
            }
        });
    }

    private void firePaletteOpened() {
        this.firePaletteOpened(new PaletteEvent(PaletteManager.getPaletteManager(), "PALETTE2_OPENED"));
    }

    public void firePaletteClosed(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.paletteClosed(event);
                return null;
            }
        });
    }

    public void firePaletteClosed() {
        this.firePaletteClosed(new PaletteEvent(PaletteManager.getPaletteManager(), "PALETTE2_CLOSED"));
    }

    public void fireSelectionChanged(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.selectionChanged(event);
                return null;
            }
        });
    }

    public void fireItemSelected(final PaletteEvent event) {
        this.updateSelection();
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.itemSelected(event);
                return null;
            }
        });
    }

    public void fireItemUnselected(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.itemUnselected(event);
                return null;
            }
        });
    }

    public void fireStickyModeActivated(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.stickyModeActivated(event);
                return null;
            }
        });
    }

    public void fireStickyModeDeactivated(final PaletteEvent event) {
        this.fireEvent(new Operator<PaletteListener, Void>(){

            public Void operate(PaletteListener l) {
                l.stickyModeDeactivated(event);
                return null;
            }
        });
    }

    private void fireEvent(Operator<PaletteListener, Void> operator) {
        if (null == this.listeners) {
            return;
        }
        for (WeakReference<PaletteListener> weak : this.listeners) {
            PaletteListener l = (PaletteListener)weak.get();
            if (null == l) {
                this.listeners.remove(weak);
                continue;
            }
            operator.operate((Object)l);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    View undecorateIfNecessary(Dockable dockable) {
        if (null != this.activePalette && dockable instanceof DockableWindow) {
            return this.activePalette.undecorateIfNecessary((DockableWindow)dockable);
        }
        return null;
    }

    private synchronized void refresh() {
        for (PaletteWindowUI palette : this.viewsByPalette.keySet()) {
            if (null == palette) continue;
            palette.dispose();
        }
        this.viewsByPalette.clear();
        this.palettesByView.clear();
        Container ui = this._getGUI();
        if (null != ui) {
            ui.removeAll();
            this._synchronizePalette(this.getEditor(), true);
        }
    }

    private static boolean isEmpty(List<PalettePages> pageSets) {
        if (null == pageSets || pageSets.isEmpty()) {
            return true;
        }
        for (PalettePages pageSet : pageSets) {
            Collection<PalettePage> pages = pageSet.getPages();
            if (pages.isEmpty()) continue;
            for (PalettePage page : pages) {
                if (PaletteWindowUI.palettePageIsEmpty(page)) continue;
                return false;
            }
        }
        return true;
    }

    public void editorOpened(Editor editor) {
        this.editorActivated(editor);
    }

    public void editorActivated(Editor editor) {
        _isView = false;
        if (!_dockableHidden) {
            this.synchronizeWithEditor(editor);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor newEditor = EditorManager.getEditorManager().getCurrentEditor();
                PaletteWindowImpl.this.synchronizeWithEditor(newEditor);
            }
        });
    }

    public void viewActivated(ViewEvent e) {
        _isView = true;
        View view = e.getView();
        if (!_dockableHidden) {
            this.synchronizeWithView(view);
        }
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        View view = e.getView();
        if (view != null && view == this._currentView) {
            this._currentView = null;
            this._currentEditor = null;
            _isView = false;
            this.showPageInactive();
        }
    }

    public PaletteItem getItem(String providerId, String itemId) {
        if (null != this.activePalette) {
            return this.activePalette.getItem(providerId, itemId);
        }
        return null;
    }

    public int getDefaultVisibility(Layout layout) {
        String showPaletteProperty = layout.getProperty("Layout.ShowPalette", null);
        boolean showPalette1 = Boolean.valueOf(showPaletteProperty);
        String raisePaletteProperty = layout.getProperty("Layout.RaisePalette", showPalette1 ? "true" : "false");
        boolean raisePalette1 = Boolean.valueOf(raisePaletteProperty);
        String showPalette2Property = layout.getProperty("Layout.ShowPalette2", null);
        boolean showPalette2 = Boolean.valueOf(showPalette2Property);
        String raisePalette2Property = layout.getProperty("Layout.RaisePalette2", showPalette2 ? "true" : "false");
        boolean raisePalette2 = Boolean.valueOf(raisePalette2Property);
        boolean showPalette = showPalette1 | showPalette2;
        boolean raisePalette = raisePalette1 | raisePalette2;
        return (showPalette ? 1 : 0) | (raisePalette ? 4 : 0);
    }

    public String getTabName() {
        return Bundle.get("COMPONENT_PALETTE");
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"component.png");
    }

    public String getTitleName() {
        return Bundle.get("COMPONENT_PALETTE");
    }

    public String getUniqueName() {
        return "PALETTEFACTORY.PALETTE";
    }

    public void loadLayout(PropertyAccess p) {
        if (Ide.isStarting()) {
            this.savedPageName = p.getProperty("pageSelection", "");
        }
        String useLargeIcons = p.getProperty(USE_LARGE_ICONS, String.valueOf(true));
        this.setUseLargeIcons(Boolean.valueOf(useLargeIcons));
    }

    public void saveLayout(PropertyAccess p) {
        this.removeSearchResults();
        p.setProperty("pageSelection", this.getSelectedPageName());
        p.setProperty(USE_LARGE_ICONS, String.valueOf(this.getUseLargeIcons()));
    }

    public String getMenuTitle() {
        return this.getTabName();
    }

    @Override
    public ContextMenu getContextMenu() {
        return PALETTE_CONTROLLER.getContextMenu();
    }

    protected Element[] getSelectionFromUI() {
        PaletteItem paletteItem = this.getSelectedItem();
        if (paletteItem == null) {
            return new Element[0];
        }
        PaletteSelectionElement element = new PaletteSelectionElement(paletteItem);
        return new Element[]{element};
    }

    public HelpInfo getHelpInfo() {
        return HELP_INFO;
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<PaletteWindowImpl, PaletteWindowUI>(){

            public PaletteWindowUI adapt(PaletteWindowImpl obj) {
                return obj.activePalette;
            }
        });
    }
}

