/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Color;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.model.ColorProvider;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteItemUIColorProvider;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class PaletteGroupUIColorProvider
implements ColorProvider<PaletteGroupUI>,
AdapterFactory<PaletteGroupUI, ColorProvider> {
    private final ColorProvider<PaletteGroupUI> behavior = Themes.isThemed() ? new ThemedBehavior(Themes.getActiveTheme()) : new DefaultBehavior();

    public Color backgroundFor(PaletteGroupUI obj, String key) {
        return this.behavior.backgroundFor((Object)obj, key);
    }

    public Color foregroundFor(PaletteGroupUI obj, String key) {
        return this.foregroundFor(obj, key);
    }

    public ColorProvider adapt(PaletteGroupUI obj) {
        return this;
    }

    private static class ThemedBehavior
    implements ColorProvider<PaletteGroupUI> {
        private static final String BACKGROUND = "background";
        private static final String PALETTE_WINDOW = "palettewindow";
        private final Theme activeTheme;

        private ThemedBehavior(Theme theme) {
            this.activeTheme = theme;
        }

        public Color backgroundFor(PaletteGroupUI obj, String key) {
            ThemeProperties properties = this.activeTheme.getStateProperties(PALETTE_WINDOW, key);
            if (null == properties) {
                return null;
            }
            return properties.getColor(BACKGROUND);
        }

        public Color foregroundFor(PaletteGroupUI obj, String key) {
            return null;
        }
    }

    private static class DefaultBehavior
    implements ColorProvider<PaletteGroupUI> {
        private final ColorProvider<PaletteItemUI> itemColorProvider = new PaletteItemUIColorProvider.DefaultBehavior();

        private DefaultBehavior() {
        }

        public Color backgroundFor(PaletteGroupUI obj, String key) {
            return this.itemColorProvider.backgroundFor(null, key);
        }

        public Color foregroundFor(PaletteGroupUI obj, String key) {
            return this.itemColorProvider.foregroundFor(null, key);
        }
    }
}

