/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.AbstractTransformationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NormalizationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutlierPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.UseExistingColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class ApplyTransformWizardStepOne
extends AbstractTransformationWizardPage {
    private static final Logger theLogger = Logger.getLogger(ApplyTransformWizardStepOne.class.getName());
    private JComboBox jComboBox1;
    private JLabel jLabelTitle;
    private JLabel jLabelTransforms;
    private JPanel jPanelXformDetails;
    private JSeparator jSeparator1;

    public ApplyTransformWizardStepOne() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jLabelTransforms = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanelXformDetails = new JPanel();
        this.jLabelTitle.setText("Create New Transforms for Selected Source");
        this.jLabelTransforms.setText("Transforms:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Binning", "Missing Values", "Normalization", "Outlier", "<Use Existing Column>"}));
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder("Binning"));
        GroupLayout groupLayout = new GroupLayout(this.jPanelXformDetails);
        this.jPanelXformDetails.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 179, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jPanelXformDetails, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 390, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelTransforms, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox1, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 122, Short.MAX_VALUE))).addGap(0, 0, 0)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jSeparator1, -1, 368, Short.MAX_VALUE).addGap(22, 22, 22)))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTransforms).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelXformDetails, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelTransforms, (Component)this.jComboBox1, (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_ONE_TRANSFORMS"));
        this.jLabelTitle.setText(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_ONE_HEADER"));
    }

    @Override
    public String getPageDirtyKey() {
        return "transformationsDirty";
    }

    @Override
    protected String getValidationMessage() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_XFORMS_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected String getValidationTitle() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    @Override
    public void initUI() {
        this.jPanelXformDetails.setLayout(new CardLayout());
        ApplyTransformWizardModel applyTransformWizardModel = this.getModel(this.getTraversableContext());
        this.fillTransformationTypeCombo(applyTransformWizardModel);
    }

    private TransformationSourceAttribute getSourceColumn(ApplyTransformWizardModel applyTransformWizardModel, MapTransformedSource mapTransformedSource) {
        TransformationSourceAttribute transformationSourceAttribute = null;
        StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
        if (stringCollection.getValue().isEmpty()) {
            return transformationSourceAttribute;
        }
        String string = (String)stringCollection.getValue().get(0);
        TransformationSourceAttributes transformationSourceAttributes = applyTransformWizardModel.getNodeType().getTransformationSourceAttributes();
        List list = transformationSourceAttributes.getTransformationSourceAttributeType();
        for (TransformationSourceAttribute transformationSourceAttribute2 : list) {
            if (!transformationSourceAttribute2.getName().equals(string)) continue;
            transformationSourceAttribute = transformationSourceAttribute2;
            break;
        }
        return transformationSourceAttribute;
    }

    private void fillTransformationTypeCombo(final ApplyTransformWizardModel applyTransformWizardModel) {
        Object object;
        Object object22;
        TransformationSourceAttribute transformationSourceAttribute = !applyTransformWizardModel.getSelectedSourceColumns().isEmpty() ? applyTransformWizardModel.getSelectedSourceColumns().get(0) : null;
        ArrayList<MapTransformedSource> arrayList = null;
        ArrayList<MapTransformedSource> arrayList2 = null;
        ArrayList<MapTransformedSource> arrayList3 = null;
        ArrayList<MapTransformedSource> arrayList4 = null;
        List list = applyTransformWizardModel.getNodeType().getTransformedAttributes().getMapTransformedSourceType();
        if (list != null && !list.isEmpty()) {
            for (Object object22 : list) {
                TransformationSourceAttribute transformationSourceAttribute2;
                object = object22.getKey();
                if (null == object || null == (transformationSourceAttribute2 = this.getSourceColumn(applyTransformWizardModel, (MapTransformedSource)object22))) continue;
                if (("NUMBER".equals(transformationSourceAttribute2.getDataType()) || "FLOAT".equals(transformationSourceAttribute2.getDataType()) || "BINARY_DOUBLE".equals(transformationSourceAttribute2.getDataType()) || "BINARY_FLOAT".equals(transformationSourceAttribute2.getDataType())) && !TransformationTypes.isCustomNumericBinning(object22.getKey().getTransformationElementType())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<MapTransformedSource>();
                    }
                    arrayList.add((MapTransformedSource)object22);
                }
                if (("VARCHAR2".equals(transformationSourceAttribute2.getDataType()) || "CHAR".equals(transformationSourceAttribute2.getDataType())) && !TransformationTypes.isCustomCategoricalBinning(object22.getKey().getTransformationElementType())) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<MapTransformedSource>();
                    }
                    arrayList2.add((MapTransformedSource)object22);
                }
                if (("DATE".equals(transformationSourceAttribute2.getDataType()) || DatabaseMetadataUtils.isTimestamp(transformationSourceAttribute2.getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(transformationSourceAttribute2.getDataType())) && !TransformationTypes.isCustomDateBinning(object22.getKey().getTransformationElementType())) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<MapTransformedSource>();
                    }
                    arrayList3.add((MapTransformedSource)object22);
                }
                if (!DatabaseMetadataUtils.isTimestampWithTimeZone(transformationSourceAttribute2.getDataType()) || TransformationTypes.isCustomTimestampBinning(object22.getKey().getTransformationElementType())) continue;
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<MapTransformedSource>();
                }
                arrayList4.add((MapTransformedSource)object22);
            }
        }
        int n = 0;
        object22 = null;
        if (transformationSourceAttribute != null) {
            if ("NUMBER".equals(transformationSourceAttribute.getDataType()) || "FLOAT".equals(transformationSourceAttribute.getDataType()) || "BINARY_DOUBLE".equals(transformationSourceAttribute.getDataType()) || "BINARY_FLOAT".equals(transformationSourceAttribute.getDataType())) {
                object22 = new DefaultComboBoxModel<String>(TransformationTypes.numericWizardTransformationValues(arrayList != null));
                n = 1;
            } else if ("VARCHAR2".equals(transformationSourceAttribute.getDataType()) || "CHAR".equals(transformationSourceAttribute.getDataType())) {
                object22 = new DefaultComboBoxModel<String>(TransformationTypes.categoricWizardTransformationValues(arrayList2 != null));
                n = 2;
            } else if ("DATE".equals(transformationSourceAttribute.getDataType()) || DatabaseMetadataUtils.isTimestamp(transformationSourceAttribute.getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(transformationSourceAttribute.getDataType())) {
                object22 = new DefaultComboBoxModel<String>(TransformationTypes.dateWizardTransformationValues(arrayList3 != null));
                n = 3;
            } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(transformationSourceAttribute.getDataType())) {
                object22 = new DefaultComboBoxModel<String>(TransformationTypes.dateWizardTransformationValues(arrayList4 != null));
                n = 6;
            }
        }
        if (object22 == null) {
            object22 = new DefaultComboBoxModel<String>(TransformationTypes.numericWizardTransformationValues(arrayList != null));
            n = 1;
        }
        applyTransformWizardModel.setSelectedTransformation(TransformationTypes.getTRANSFORMATION_TYPE_BINNING());
        applyTransformWizardModel.setBinningPanel(new BinningPanel(applyTransformWizardModel.getContext(), applyTransformWizardModel.getState(), n));
        this.jComboBox1.setModel(object22);
        this.jComboBox1.setSelectedItem(applyTransformWizardModel.getSelectedTransformation());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                applyTransformWizardModel.setSelectedTransformation((String)ApplyTransformWizardStepOne.this.jComboBox1.getSelectedItem());
                ApplyTransformWizardStepOne.this.showPanel(applyTransformWizardModel);
            }
        });
        this.jPanelXformDetails.add(TransformationTypes.BINNING_PANEL, applyTransformWizardModel.getBinningPanel());
        applyTransformWizardModel.setMissValuesPanel(new MissingValuesPanel(applyTransformWizardModel.getContext(), n));
        this.jPanelXformDetails.add(TransformationTypes.MISS_VALUES_PANEL, applyTransformWizardModel.getMissValuesPanel());
        applyTransformWizardModel.setOutlierPanel(new OutlierPanel());
        this.jPanelXformDetails.add(TransformationTypes.OUTLIER_PANEL, applyTransformWizardModel.getOutlierPanel());
        applyTransformWizardModel.setNormalizationPanel(new NormalizationPanel());
        this.jPanelXformDetails.add(TransformationTypes.NORMALIZATION_PANEL, applyTransformWizardModel.getNormalizationPanel());
        object = null;
        if (n == 1) {
            object = arrayList;
        } else if (n == 2) {
            object = arrayList2;
        } else if (n == 3) {
            object = arrayList3;
        } else if (n == 6) {
            object = arrayList4;
        }
        if (object != null && !object.isEmpty()) {
            applyTransformWizardModel.setUseExistingColumnPanel(new UseExistingColumnPanel(applyTransformWizardModel.getContext(), applyTransformWizardModel.getSelectedSourceColumns(), (List<MapTransformedSource>)object, applyTransformWizardModel.getState()));
            this.jPanelXformDetails.add(TransformationTypes.EXISTING_PANEL, applyTransformWizardModel.getUseExistingColumnPanel());
        }
        this.showPanel(applyTransformWizardModel);
    }

    private void showPanel(ApplyTransformWizardModel applyTransformWizardModel) {
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder(applyTransformWizardModel.getSelectedTransformation()));
        CardLayout cardLayout = (CardLayout)this.jPanelXformDetails.getLayout();
        cardLayout.show(this.jPanelXformDetails, applyTransformWizardModel.getSelectedTransformation());
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        boolean bl = true;
        TransformationType transformationType = null;
        ApplyTransformWizardModel applyTransformWizardModel = this.getModel(this.getTraversableContext());
        String string = (String)this.jComboBox1.getSelectedItem();
        applyTransformWizardModel.setSelectedTransformation(string);
        if (TransformationTypes.isBinning(string)) {
            BinningPanel binningPanel = applyTransformWizardModel.getBinningPanel();
            String string2 = binningPanel.getSelectedBinngType();
            transformationType = string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) ? TransformationTypes.initCustomBinning(string2, binningPanel.getCustomBinning(), binningPanel.getTransformNulls()) : TransformationTypes.initBinning(string2, binningPanel.getBincount(), binningPanel.isAuto(), binningPanel.isLabels(), binningPanel.getTransformNulls());
            bl = true;
        } else if (TransformationTypes.isMissingValues(string)) {
            MissingValuesPanel missingValuesPanel = applyTransformWizardModel.getMissValuesPanel();
            try {
                transformationType = missingValuesPanel.getResultTransformationType();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (TransformationTypes.isNormalization(string)) {
            transformationType = new TransformationType();
            NormalizationPanel normalizationPanel = applyTransformWizardModel.getNormalizationPanel();
            try {
                TransformationType.Normalization normalization = normalizationPanel.getResults();
                transformationType.setNormalization(normalization);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (TransformationTypes.isOutlier(string)) {
            transformationType = new TransformationType();
            OutlierPanel outlierPanel = applyTransformWizardModel.getOutlierPanel();
            try {
                TransformationType.Outlier outlier = outlierPanel.getResults();
                transformationType.setOutlier(outlier);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (TransformationTypes.isExistingColumn(string)) {
            transformationType = applyTransformWizardModel.getUseExistingColumnPanel().getResultTransformatonType(applyTransformWizardModel.getUseExistingColumnPanel().getSelectedTransformedColumn().getKey().getName());
            bl = transformationType != null;
        }
        applyTransformWizardModel.setResultTransformationType(transformationType);
        return bl;
    }
}

