/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.models.AttributeItem;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.dialog.text.BuildTextRowDetail;
import oracle.dmt.dataminer.workflow.dialog.text.SelectNodePanel;
import oracle.dmt.dataminer.workflow.dialog.text.SelectNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.text.TextDialogLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.text.WorkflowTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeReference;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class TextPanel
extends DialogDisplayer<BuildTextNodeRef>
implements SearchListener {
    private WorkflowTextNodePropertyProxyModel _propertyModel;
    private BuildTextNodeRefType _copyNodeType;
    private NodeReference _nodeReference;
    private TransformationSourceAttributes _transformationSourceAttributes;
    private TransformedAttributesType _transformedAttributes;
    private TextTransformationOutputAttributeType _selectedTextTransformationOutputAttribute = null;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private AttributeType _caseAttribute;
    private AttrsTableModel _models;
    private GenericTable _attributeTable = new DataMinerTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<AttrsTableModel, Integer> _nodeFilter;
    private boolean _bShowAllRows;
    private boolean _isAdjusting;
    private boolean _dirty;
    private JButton _editBtn;
    private AttributeItem SELECT_CASEID_NONE;
    private BuildTextOutputPanel _outputPanel;
    private static String THEMES_TAB = DialogsLrb.get("BUILDTEXT_THEMES_TAB");
    private static String TOKENS_TAB = DialogsLrb.get("BUILDTEXT_TOKENS_TAB");
    private String[] _columnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"), DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"), DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"), DialogsLrb.get("BUILDTEXT_COLUMN_OUTPUT")};
    private int[] _columnWidths = new int[]{220, 140, 220, 83, 60};
    private int[] _columnWidthsForPI = new int[]{170, 140, 160, 65, 50};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int SOURCE = 2;
    private static final int TRANSFORM = 3;
    private static final int OUTPUT = 4;
    private static final int ATTR_STATUS = 99;
    private ComponentWithTitlebar<JComponent> columnComponentWithTitlebar;
    private JPanel jBottomPanel;
    private DataMinerCombBox jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JButton jEditStoplistsButton;
    private JLabel jRefPathLabel;
    private JTextField jRefPathValue;
    private JButton jRefreshRefButton;
    private JButton jSelectNodeButton;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPane;
    private JPanel jTopPanel;
    private JComboBox jColumnTypeComboBox;

    public TextPanel(Context context, BuildTextNodeRef buildTextNodeRef) {
        super(context, buildTextNodeRef);
        this._copyNodeType = (BuildTextNodeRefType)MetaDataHelper.copyMetadataObject(((BuildTextNodeRef)this._data).getData());
        this.init((BuildTextNodeRef)this._data, null);
    }

    public TextPanel(PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._copyNodeType = (BuildTextNodeRefType)MetaDataHelper.copyMetadataObject(((BuildTextNodeRef)this._data).getData());
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((BuildTextNodeRef)this._data, propertyModel);
    }

    private void init(BuildTextNodeRef buildTextNodeRef, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this.initSettings((BuildTextNodeRefType)buildTextNodeRef.getData());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jRefPathLabel, (Component)this.jRefPathValue, (String)DialogsLrb.get("TEXT_REFERENCE"));
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, (Component)this.jCaseIdComboBox, (String)DialogsLrb.get("BUILDTEXT_CASEID"));
        ResourceUtils.resButton((AbstractButton)this.jEditStoplistsButton, (String)DialogsLrb.get("BUILDTEXT_VIEW_STOPLIST"));
    }

    @Override
    public void initUI() {
        Object object;
        this._isAdjusting = true;
        boolean bl = this.isWritable();
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.initCaseAttribute();
        this.jCaseIdComboBox.setEnabled(false);
        this.initNodeReference();
        this.jRefPathValue.setOpaque(false);
        this.buildAttrList();
        this.jEditStoplistsButton.setEnabled(bl);
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        JScrollPane jScrollPane = new JScrollPane((Component)this._attributeTable);
        this.columnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.columnComponentWithTitlebar.setControlBar(controlBar);
        this.installItemFilterActions(controlBar);
        this._attributeTable.setModel((TableModel)((Object)this._models));
        this._models.setWritable(false);
        this._attributeTable.setResizeColumnOnDoubleClick(true);
        this._attributeTable.getSelectionModel().setSelectionMode(1);
        this._attributeTable.setAutoResizeMode(0);
        this._attributeTable.setSelectionMode(2);
        this._attributeTable.setColumnSelectorAvailable(true);
        this._attributeTable.setShowToolTips(true);
        this._attributeTable.setUpdateSelectionOnSort(true);
        this._attributeTable.setRowSelectionAllowed(true);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2;
                int n3 = TextPanel.this._attributeTable.convertRowIndexToModel(n);
                GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)TextPanel.this._attributeTable.getModel();
                AttributeStatus attributeStatus = AttributeStatus.VALID;
                if (genericBaseTableModel instanceof AttrsTableModel && (object2 = genericBaseTableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                    attributeStatus = (AttributeStatus)object2;
                }
                return attributeStatus.equals((Object)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : DataMinerIcons.get(Icons.ERROR_STATUS);
            }
        });
        TableColumn tableColumn = this._attributeTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this._attributeTable.getColumnModel().getColumn(4);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        this._nodeFilter = new RowFilter<AttrsTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends AttrsTableModel, ? extends Integer> entry) {
                String string;
                String string2;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = TextPanel.this._searchText != null && TextPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                AttrsTableModel attrsTableModel = entry.getModel();
                if (!TextPanel.this._bShowAllRows) {
                    bl2 = false;
                    string2 = (String)attrsTableModel.getValueAt(n, 1);
                    if (DatabaseMetadataUtils.isTypeSupportedAsText(string2)) {
                        bl2 = true;
                    }
                    if (!bl2 && (string = (String)attrsTableModel.getValueAt(n, 2)) != null) {
                        bl2 = true;
                    }
                }
                String string3 = string2 = TextPanel.this._searchText != null ? TextPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && TextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 0);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && TextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 1);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && TextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"))) {
                    String string4 = string = (String)attrsTableModel.getValueAt(n, 2) != null ? ((String)attrsTableModel.getValueAt(n, 2)).toLowerCase() : "";
                    if (string.startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && TextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))) {
                    string = (String)attrsTableModel.getValueAt(n, 3);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        int[] nArray = this.isPIMode() ? this._columnWidthsForPI : this._columnWidths;
        for (int n2 : nArray) {
            this._attributeTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._attributeTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(this));
        if (this.isPIMode()) {
            this.jSplitPane.setRightComponent(null);
            this.jSplitPane.setDividerSize(0);
        } else {
            object = (TextNodeType)((BuildTextNodeRef)this.getData()).getData();
            this._outputPanel = new BuildTextOutputPanel(this._context, (AbstractTextNode)this._data, (TextNodeType)this._copyNodeType);
            int n3 = 0;
            if (!object.getTransformedAttributes().getMapTextTransformedSource().isEmpty()) {
                n3 = ((MapTextTransformedSourceType)object.getTransformedAttributes().getMapTextTransformedSource().get(0)).getKey().getTransformationElement().getTheme() != null ? 1 : 0;
            }
            this.jTabbedPane.add(n3 != 0 ? THEMES_TAB : TOKENS_TAB, this._outputPanel);
        }
        this._isAdjusting = false;
        this.jRefreshRefButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this.jRefreshRefButton.setEnabled(bl);
        this.jRefreshRefButton.setToolTipText(TextDialogLrb.get("REFRESH_NODE_REF_BUTTON_TOOLTIP"));
        this.jRefreshRefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.jRefreshButtonActionPerformed(actionEvent);
            }
        });
        this.jSelectNodeButton.setToolTipText(TextDialogLrb.get("SELECT_NODE_REF_BUTTON_TOOLTIP"));
        this.jSelectNodeButton.setText(TextDialogLrb.get("SELECT_NODE_REF_BUTTON"));
        this.jSelectNodeButton.setEnabled(bl);
        this.jSelectNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.jSelectNodeButtonActionPerformed(actionEvent);
            }
        });
        this.enableControls();
        if (!this.isPIMode()) {
            object = new CheckReferenceExistence();
            ((SwingWorker)object).execute();
        }
    }

    private void initCaseAttribute() {
        Object object;
        if (this.SELECT_CASEID_NONE == null) {
            object = new AttributeType();
            object.setName(DialogsLrb.get("BUILDTEXT_SELECT_CASEID_NONE"));
            object.setDataType("String");
            this.SELECT_CASEID_NONE = new AttributeItem((AttributeType)object);
        }
        object = this._copyNodeType.getCaseAttributes().getAttribute();
        Collections.sort(object, AttributeTypeComparator.getComparator());
        this.jCaseIdComboBox.removeAllItems();
        this.jCaseIdComboBox.addItem(this.SELECT_CASEID_NONE);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType = (AttributeType)iterator.next();
            this.jCaseIdComboBox.addItem(new AttributeItem(attributeType));
        }
        this.jCaseIdComboBox.setSelectedItem(this.SELECT_CASEID_NONE);
        if (this._caseAttribute != null) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseIdComboBox.getItemCount(); ++i) {
                AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getItemAt(i);
                if (!this._caseAttribute.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
                bl = true;
                break;
            }
            if (!bl) {
                AttributeItem attributeItem = new AttributeItem(this._caseAttribute);
                this.jCaseIdComboBox.addItem(attributeItem);
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
            }
        }
        this.jCaseIdComboBox.setRenderer(new ToolTipComboBoxRenderer());
    }

    private void initNodeReference() {
        if (this._nodeReference == null) {
            String string = TextDialogLrb.get("SELECT_NODE_INSTRUCTION");
            this.jRefPathValue.setText(string);
            this.jRefPathLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            String string2 = TextDialogLrb.get("SELECT_NODE_INSTRUCTION");
            this.jRefPathValue.setToolTipText(string2);
        } else {
            String string = "\\" + this._nodeReference.getProjectName() + "\\" + this._nodeReference.getWorkflowName() + "\\" + this._nodeReference.getNodeName();
            this.jRefPathValue.setText(string);
            this.jRefPathLabel.setIcon(null);
            String string3 = TextDialogLrb.get("SELECT_NODE_COLUMN_PROJ_NAME") + ": " + this._nodeReference.getProjectName() + ";   " + TextDialogLrb.get("SELECT_NODE_COLUMN_WK_NAME") + ": " + this._nodeReference.getWorkflowName() + ";   " + TextDialogLrb.get("SELECT_NODE_COLUMN_NODE_NAME") + ": " + this._nodeReference.getNodeName();
            this.jRefPathValue.setToolTipText(string3);
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        this.jColumnTypeComboBox = new JComboBox();
        this.jColumnTypeComboBox.removeAllItems();
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_TEXT_AND_TRANSFORMED"));
        this.jColumnTypeComboBox.setSelectedItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this._bShowAllRows = true;
        this.jColumnTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)TextPanel.this.jColumnTypeComboBox.getSelectedItem();
                TextPanel.this._bShowAllRows = string.equals(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
                TextPanel.this.configureSorting();
            }
        });
        controlBar.add((Component)this.jColumnTypeComboBox);
        this._editBtn = new JButton(OracleIcons.getIcon((String)"viewObject.png"));
        String string = TextDialogLrb.get("VIEW_TEXT_COLUMN_SPECIFICATION");
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(string);
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._editBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    public void configureSorting() {
        TableRowSorter<AttrsTableModel> tableRowSorter = (TableRowSorter<AttrsTableModel>)this._attributeTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<AttrsTableModel>(this._models);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._nodeFilter);
        this._attributeTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void initSettings(BuildTextNodeRefType buildTextNodeRefType) {
        this._caseAttribute = buildTextNodeRefType.getCaseAttributes().getAttribute().size() > 0 ? (AttributeType)buildTextNodeRefType.getCaseAttributes().getAttribute().get(0) : null;
        this._nodeReference = buildTextNodeRefType.getNodeReference();
        this._transformationSourceAttributes = new TransformationSourceAttributes();
        TransformationSourceAttributes transformationSourceAttributes = buildTextNodeRefType.getTransformationSourceAttributes();
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            TransformationSourceAttribute transformationSourceAttribute2 = new TransformationSourceAttribute();
            transformationSourceAttribute2.setAlias(transformationSourceAttribute.getAlias());
            transformationSourceAttribute2.setAnnotation(transformationSourceAttribute.getAnnotation());
            transformationSourceAttribute2.setDataType(transformationSourceAttribute.getDataType());
            transformationSourceAttribute2.setDataTypeQualifier(transformationSourceAttribute.getDataTypeQualifier());
            transformationSourceAttribute2.setIsOutput(transformationSourceAttribute.isIsOutput());
            transformationSourceAttribute2.setName(transformationSourceAttribute.getName());
            transformationSourceAttribute2.setStatus(transformationSourceAttribute.getStatus());
            this._transformationSourceAttributes.getTransformationSourceAttributeType().add(transformationSourceAttribute2);
        }
        this._transformedAttributes = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeRefType.getTransformedAttributes());
    }

    private void buildAttrList() {
        List list;
        this._combinedAttrList.clear();
        if (this._transformationSourceAttributes != null && (list = this._transformationSourceAttributes.getTransformationSourceAttributeType()) != null && !list.isEmpty()) {
            this._combinedAttrList.addAll(list);
        }
        if (this._transformedAttributes != null && (list = this._transformedAttributes.getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTextTransformedSourceType.getKey());
            }
        }
    }

    private void processAddOrEdit() {
        BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)this.getData();
        TextTransColumnSettingPanel textTransColumnSettingPanel = null;
        if (this.isPIMode()) {
            textTransColumnSettingPanel = new TextTransColumnSettingPanel((PropertyModel)this._propertyModel, this.getTransformationSourceAttributes(), this.getTransformedAttributes(), this.getSelectedAttributes());
            textTransColumnSettingPanel.showAsDialog(this);
        } else {
            textTransColumnSettingPanel = new TextTransColumnSettingPanel(this.getContext(), buildTextNodeRef, (TextNodeType)this._copyNodeType, this.getTransformationSourceAttributes(), this.getTransformedAttributes(), this.getSelectedAttributes());
            if (textTransColumnSettingPanel.showAsDialog(this)) {
                this._transformedAttributes = textTransColumnSettingPanel.getTransformedAttributes();
                this.refreshUI(false);
            }
        }
    }

    private void enableControls() {
        if (this.isWritable()) {
            this.jRefreshRefButton.setEnabled(this._models.getRowCount() > 0);
        } else {
            this.jRefreshRefButton.setEnabled(false);
        }
        boolean bl = false;
        int n = this._attributeTable.getSelectedRowCount();
        if (n == 0) {
            bl = false;
        } else {
            int[] nArray;
            bl = true;
            for (int n2 : nArray = this._attributeTable.getSelectedRowsInModel()) {
                TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(n2);
                if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) continue;
                bl = false;
            }
        }
        if (this.isWritable()) {
            this._editBtn.setEnabled(bl);
        } else {
            this._editBtn.setEnabled(false);
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
        Context context = workflowTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)workflowNodeInspectorElement.getNode();
        if (buildTextNodeRef == null) {
            return;
        }
        this._propertyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = buildTextNodeRef;
        this._dirty = false;
        this.initSettings((BuildTextNodeRefType)buildTextNodeRef.getData());
        this.refreshUI(true);
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
        Context context = workflowTextNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private BuildTextNodeRef getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
        Context context = workflowTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildTextNodeRefType) {
            return (BuildTextNodeRef)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    public void refreshUI(boolean bl) {
        this._isAdjusting = true;
        if (bl) {
            this._copyNodeType = (BuildTextNodeRefType)MetaDataHelper.copyMetadataObject(((BuildTextNodeRef)this._data).getData());
        }
        this.buildAttrList();
        this.initNodeReference();
        this.initCaseAttribute();
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        this._attributeTable.clearSelection();
        this.configureSorting();
        this._isAdjusting = false;
        this.enableControls();
    }

    @Override
    public boolean doWork() {
        this.updateNode();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)this.getData();
        CaseAttributes caseAttributes = new CaseAttributes();
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        if (attributeItem.equals(this.SELECT_CASEID_NONE)) {
            this._caseAttribute = null;
        } else {
            this._caseAttribute = attributeItem.getAttribute();
            caseAttributes.getAttribute().add(this._caseAttribute);
        }
        CommandProcessor.getInstance().beginTrans(TextDialogLrb.get("TEXT_NODE_EDIT_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("caseAttribute", null, caseAttributes, null, null));
            arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(this._transformedAttributes, this._transformationSourceAttributes), null, null));
            arrayList.add(new Property("nodeReference", null, this._nodeReference, null, null));
            arrayList.add(new Property("addAllStoplists", null, this._copyNodeType.getStoplists(), null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)buildTextNodeRef.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(buildTextNodeRef, this._context, arrayList);
            buildTextNodeRef.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new DataMinerCombBox();
        this.jEditStoplistsButton = new JButton();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jRefPathLabel = new JLabel();
        this.jSelectNodeButton = new JButton();
        this.jRefPathValue = new JTextField();
        this.jRefreshRefButton = new JButton();
        this.jBottomPanel = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.setOpaque(false);
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerLocation(240);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setOpaque(false);
        this.jTopPanel.setOpaque(false);
        this.jCaseIdLabel.setText("CaseId:");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"012345678901234567890123456789", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistsButton.setText("Edit Stoplist...");
        this.jEditStoplistsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.jEditStoplistsButtonActionPerformed(actionEvent);
            }
        });
        this.jRefPathLabel.setText("Reference:");
        this.jSelectNodeButton.setText("Edit...");
        this.jRefPathValue.setEditable(false);
        this.jRefPathValue.setText("Project1/Workrflow1/BuidText1");
        this.jRefPathValue.setBorder(null);
        this.jRefPathValue.setFocusable(false);
        this.jRefPathValue.setRequestFocusEnabled(false);
        this.jRefreshRefButton.setRequestFocusEnabled(false);
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 601, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdLabel).addGap(34, 34, 34).addComponent(this.jCaseIdComboBox, -2, 222, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRefPathLabel).addGap(18, 18, 18).addComponent(this.jRefPathValue, -1, 345, Short.MAX_VALUE).addGap(83, 83, 83))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jRefreshRefButton, 0, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectNodeButton)).addComponent(this.jEditStoplistsButton, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRefPathLabel).addComponent(this.jRefPathValue, -2, -1, -2).addComponent(this.jSelectNodeButton).addComponent(this.jRefreshRefButton, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jEditStoplistsButton).addComponent(this.jCaseIdComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnComponentWithTitlebar, -1, 160, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jTopPanel);
        this.jBottomPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 601, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 310, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jEditStoplistsButtonActionPerformed(ActionEvent actionEvent) {
        StoplistPanel stoplistPanel = null;
        if (this.isPIMode()) {
            stoplistPanel = new StoplistPanel((PropertyModel)this._propertyModel, this);
            stoplistPanel.showAsDialog(this);
        } else {
            stoplistPanel = new StoplistPanel(this.getContext(), this._copyNodeType, this);
            if (stoplistPanel.showAsDialog(this)) {
                this.refreshUI(false);
            }
        }
    }

    private List<TransformationSourceAttribute> getSelectedAttributes() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        for (int i = 0; i < nArray.length; ++i) {
            TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(nArray[i]);
            arrayList.add(transformationSourceAttribute);
        }
        return arrayList;
    }

    private TransformedAttributesType getTransformedAttributes() {
        return this._transformedAttributes;
    }

    private TransformationSourceAttributes getTransformationSourceAttributes() {
        return this._transformationSourceAttributes;
    }

    public boolean isCurrentWorkflow(int n) {
        Workflow workflow = this.getWorkflow();
        return workflow.getId().intValue() == n;
    }

    private Workflow getWorkflow() {
        WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        return workflow;
    }

    private boolean doesReferencedNodeExist() {
        BuildTextNodeType buildTextNodeType = null;
        boolean bl = false;
        bl = this._copyNodeType.getNodeReference() == null ? false : (this.isCurrentWorkflow(this._copyNodeType.getNodeReference().getWorkflowId().intValue()) ? (buildTextNodeType = this.getBuildTextNodeFromCurrentWorkflow(this._copyNodeType.getNodeReference())) != null : this.loadNodeFromServer(this._copyNodeType.getNodeReference(), false, false));
        return bl;
    }

    private void jRefreshButtonActionPerformed(ActionEvent actionEvent) {
        BuildTextNodeType buildTextNodeType = null;
        boolean bl = false;
        if (this.isCurrentWorkflow(this._copyNodeType.getNodeReference().getWorkflowId().intValue())) {
            buildTextNodeType = this.getBuildTextNodeFromCurrentWorkflow(this._copyNodeType.getNodeReference());
            if (buildTextNodeType != null) {
                BuildTextNodeRef.copyNodeDetails(buildTextNodeType, this._copyNodeType);
                this.updateNodeReferenceNames(buildTextNodeType, this._copyNodeType);
                bl = true;
            }
        } else {
            bl = this.loadNodeFromServer(this._copyNodeType.getNodeReference(), true, true);
        }
        if (!bl) {
            MessageDialog.error((Component)this, (Object)TextDialogLrb.get("REFRESHING_NODE_NOT_FOUND"), (String)TextDialogLrb.get("REFRESHING_NODE_NAMES_TITLE"), null);
        }
        this.initSettings(this._copyNodeType);
        if (this.isPIMode()) {
            this.doWork();
            this.refreshUI(false);
        } else {
            this.refreshUI(false);
        }
        if (!this.isPIMode()) {
            if (bl) {
                this.jRefPathLabel.setIcon(null);
            } else {
                this.jRefPathLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
        }
    }

    private void updateNodeReferenceNames(BuildTextNodeType buildTextNodeType, BuildTextNodeRefType buildTextNodeRefType) {
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        nodeReference.setNodeName(buildTextNodeType.getName());
        RefreshNames refreshNames = new RefreshNames(nodeReference);
        refreshNames.setTitle(TextDialogLrb.get("REFRESHING_NODE_NAMES_TITLE"));
        refreshNames.setMessage(TextDialogLrb.get("REFRESHING_NODE_NAMES_MESSAGE"));
        try {
            refreshNames.start(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
        }
        if (refreshNames.isCanceled()) {
            return;
        }
        if (!refreshNames.isSuccessful().booleanValue()) {
            if (refreshNames.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)refreshNames.getException(), (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            }
            return;
        }
        this._copyNodeType.setNodeReference(refreshNames.getNodeRef());
    }

    private boolean loadNodeFromServer(NodeReference nodeReference, boolean bl, boolean bl2) {
        LoadNode loadNode = new LoadNode(nodeReference);
        loadNode.setTitle(TextDialogLrb.get("RETRIEVING_NODE_CONTENTS_TITLE"));
        loadNode.setMessage(TextDialogLrb.get("RETRIEVING_NODE_CONTENTS_MESSAGE"));
        try {
            loadNode.start(bl);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
        }
        if (loadNode.isCanceled()) {
            return false;
        }
        if (loadNode.isSuccessful().booleanValue()) {
            if (bl2) {
                BuildTextNodeRef.copyNodeDetails(loadNode.getBuildTextNodeType(), this._copyNodeType);
                this.updateNodeReferenceNames(loadNode.getBuildTextNodeType(), this._copyNodeType);
                this._copyNodeType.setNodeReference(nodeReference);
            }
        } else {
            if (loadNode.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)loadNode.getException(), (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            }
            return false;
        }
        return true;
    }

    private NodeReference refreshProjectWorkflowNames(NodeReference nodeReference) throws SQLException {
        String string = "select PROJECT_NAME, WORKFLOW_NAME from ODMR_USER_PROJECT_WORKFLOW\nwhere project_id = ?\nAND workflow_id = ?";
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = "";
        String string3 = "";
        try {
            sQLHelper.conn = ConnectionFolder.getConnection(this._context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setInt(1, nodeReference.getProjectId().intValue());
            sQLHelper.pstmt.setInt(2, nodeReference.getWorkflowId().intValue());
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            if (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("PROJECT_NAME");
                string3 = sQLHelper.rs.getString("WORKFLOW_NAME");
                nodeReference.setProjectName(string2);
                nodeReference.setWorkflowName(string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return nodeReference;
    }

    private BuildTextNodeType getBuildTextNodeFromServer(NodeReference nodeReference) throws Exception {
        BuildTextNodeType buildTextNodeType = null;
        BuildTextRowDetail buildTextRowDetail = new BuildTextRowDetail();
        buildTextRowDetail.setProjectId(nodeReference.getProjectId().intValue());
        buildTextRowDetail.setWorkflowId(nodeReference.getWorkflowId().intValue());
        buildTextRowDetail.setNodeId(nodeReference.getNodeId().intValue());
        buildTextNodeType = SelectNodeTableModel.loadNodeFromServer(buildTextRowDetail, this._context);
        return buildTextNodeType;
    }

    private BuildTextNodeType getBuildTextNodeFromCurrentWorkflow(NodeReference nodeReference) {
        BuildTextNodeType buildTextNodeType = null;
        WorkflowProcess workflowProcess = ((BuildTextNodeRef)this._data).getModel().getDocumentObject();
        List list = workflowProcess.getNodes().getBuildText();
        WorkflowProject workflowProject = ProjectFolder.getWorkflowProject(this._context);
        for (BuildTextNodeType buildTextNodeType2 : list) {
            if (buildTextNodeType2.getId().compareTo(nodeReference.getNodeId().toString()) != 0 || workflowProject.getId().intValue() != nodeReference.getProjectId().intValue()) continue;
            buildTextNodeType = buildTextNodeType2;
            break;
        }
        return buildTextNodeType;
    }

    private void jSelectNodeButtonActionPerformed(ActionEvent actionEvent) {
        BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)this.getData();
        SelectNodePanel selectNodePanel = new SelectNodePanel(this.getContext(), buildTextNodeRef, this._copyNodeType);
        if (selectNodePanel.showAsDialog(this)) {
            this.initSettings(this._copyNodeType);
            if (this.isPIMode()) {
                this.doWork();
                this.refreshUI(false);
            } else {
                this.refreshUI(false);
            }
        }
    }

    public TextTransformationOutputAttributeType getSelectedTextTransformationOutputAttribute() {
        return this._selectedTextTransformationOutputAttribute;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("TEXT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "textReferenceEditor";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMaximumInitialSize(new Dimension(800, 700));
        jEWTDialog.setMinimumSize(new Dimension(800, 700));
    }

    private class AttrsTableModel
    extends SimpleBaseTableModel {
        private boolean _writable = true;

        public AttrsTableModel() {
            this.setColumnIdentifiers(TextPanel.this._columnNames);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return TextPanel.this._combinedAttrList.size();
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                if (n == 4) {
                    return ImageIcon.class;
                }
                return object.getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                return this._writable;
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (TextPanel.this._combinedAttrList.size() == 0) {
                return "Loading...";
            }
            TransformationSourceAttribute transformationSourceAttribute = TextPanel.this._combinedAttrList.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = transformationSourceAttribute.getName();
                    break;
                }
                case 1: {
                    object = DatabaseMetadataUtils.getJSONDataType(transformationSourceAttribute.getDataType(), transformationSourceAttribute.getDataTypeQualifier());
                    break;
                }
                case 2: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getSource();
                    }
                    object = string;
                    break;
                }
                case 3: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getTransformationElement().getToken() != null ? DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN") : DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
                    }
                    object = string;
                    break;
                }
                case 4: {
                    object = transformationSourceAttribute.isIsOutput();
                    break;
                }
                case 99: {
                    object = transformationSourceAttribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public TransformationSourceAttribute getAttribute(int n) {
            return TextPanel.this._combinedAttrList.get(n);
        }
    }

    private class SelectedItemSelectionHandler
    implements ListSelectionListener {
        AbstractPanel _parent;

        public SelectedItemSelectionHandler(AbstractPanel abstractPanel) {
            this._parent = abstractPanel;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TransformationSourceAttribute transformationSourceAttribute;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                return;
            }
            TextPanel.this.enableControls();
            int[] nArray = TextPanel.this._attributeTable.getSelectedRowsInModel();
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = null;
            if (nArray.length == 1 && (transformationSourceAttribute = TextPanel.this._models.getAttribute(nArray[0])) instanceof TextTransformationOutputAttributeType) {
                textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
            }
            if (TextPanel.this._selectedTextTransformationOutputAttribute != null && textTransformationOutputAttributeType != null && textTransformationOutputAttributeType.getName().compareTo(TextPanel.this._selectedTextTransformationOutputAttribute.getName()) == 0) {
                return;
            }
            TextPanel.this._selectedTextTransformationOutputAttribute = textTransformationOutputAttributeType;
            if (TextPanel.this._outputPanel != null) {
                TextPanel.this._outputPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
        }
    }

    private class CheckReferenceExistence
    extends SwingWorker {
        Exception _ex = null;
        Boolean _success = Boolean.FALSE;

        private CheckReferenceExistence() {
        }

        protected Object doInBackground() throws Exception {
            try {
                this._success = TextPanel.this.doesReferencedNodeExist();
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            return this._success;
        }

        @Override
        protected void done() {
            super.done();
            if (this._ex != null || !this._success.booleanValue()) {
                TextPanel.this.jRefPathLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                TextPanel.this.jRefPathLabel.setIcon(null);
            }
        }
    }

    private class RefreshNames
    extends ProgressRunnable {
        private boolean _canceled = false;
        private Exception _ex = null;
        private Boolean _success = false;
        private NodeReference _nodeRef = null;

        public RefreshNames(NodeReference nodeReference) {
            this._nodeRef = nodeReference;
        }

        public NodeReference getNodeRef() {
            return this._nodeRef;
        }

        public Boolean isSuccessful() {
            return this._success;
        }

        public Object doWork() {
            try {
                NodeReference nodeReference = TextPanel.this.refreshProjectWorkflowNames(this._nodeRef);
                this._nodeRef = nodeReference instanceof NodeReference ? nodeReference : null;
                this._success = this._nodeRef != null;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._nodeRef;
        }

        public Exception getException() {
            return this._ex;
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    private class LoadNode
    extends ProgressRunnable {
        private boolean _canceled = false;
        private Exception _ex = null;
        private Boolean _success = false;
        private NodeReference _nodeRef = null;
        private BuildTextNodeType _node = null;

        public LoadNode(NodeReference nodeReference) {
            this._nodeRef = nodeReference;
        }

        public BuildTextNodeType getBuildTextNodeType() {
            return this._node;
        }

        public Boolean isSuccessful() {
            return this._success;
        }

        public Object doWork() {
            try {
                BuildTextNodeType buildTextNodeType = TextPanel.this.getBuildTextNodeFromServer(this._nodeRef);
                this._node = buildTextNodeType instanceof BuildTextNodeType ? buildTextNodeType : null;
                this._success = this._node != null;
            }
            catch (SQLException sQLException) {
                this._success = false;
                if (sQLException.getErrorCode() != 1403 && sQLException.getErrorCode() != 100) {
                    this._ex = sQLException;
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._node;
        }

        public Exception getException() {
            return this._ex;
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

