/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.CallSite;
import java.sql.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.data.CreateTableStorageSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesBase;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableCreateNewTableAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableOptionsType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

public class UpdateTableNodeCreateTablePanel
extends DataConsumerAttributesBase<UpdateTableNode> {
    private static final Logger theLogger = Logger.getLogger(UpdateTableNodeCreateTablePanel.class.getName());
    private Vector<AttributeType> allDataProviderAttributes = new Vector();
    private JButton _removeBtn;
    private JButton _editBtn;
    private String _originalTableName;
    private DBAttributes dbAttributes = new DBAttributes();
    private Table tablePropertyValue;
    private static Icon _editIcon;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private static final int ISKEY = 2;
    private static final int ISINDEX = 3;
    private static final int ALIAS_TABLE = 4;
    private static int MAX_LENGTH;
    private static int MAX_LENGTH_EX;
    private String[] _columnNames_table = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_KEY_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_INDEX_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
    protected CreateTableOptionsType cachedTableOptions;
    protected CreateTableOptionsType newTableOptions = MetaDataHelper.createDefaultTableOptions();
    private GenericTable _jAttributesTable = new GenericTableTooltipCustom();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JLabel jLabelName;
    private JLabel jStorageSettings;
    private JTextField jTextFieldName;

    public UpdateTableNodeCreateTablePanel(Context context, UpdateTableNode updateTableNode) {
        super(context, updateTableNode);
        AbstractNode abstractNode = updateTableNode.findParentNode();
        assert (abstractNode instanceof AbstractDataNode);
        List<AttributeType> list = this.getAvailableAttributes((AbstractDataNode)abstractNode);
        if (list != null) {
            this.allDataProviderAttributes.addAll(list);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jStorageSettings = new JLabel();
        this.jLabelName.setText("Name:");
        this.jStorageSettings.setText("<html><u><bold>Storage Settings</u></bold></html>");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, 404, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName).addGap(18, 18, 18).addComponent(this.jTextFieldName, -2, 185, -2)).addComponent(this.jStorageSettings, -2, 242, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jStorageSettings, -2, -1, -2).addGap(9, 9, 9).addComponent((Component)this.jAttributesComponent, -1, 224, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        boolean bl;
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jTextFieldName, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
        this.jTextFieldName.setDocument(new TextFieldLimit((bl = SQLHelper.isExpandedObjNameEnabled(this._context)) ? MAX_LENGTH_EX : MAX_LENGTH));
        this.jStorageSettings.setText(DataDialogsLrb.get("CREATE_TABLE_STORAGE_SETTINGS_LABEL"));
        this.jStorageSettings.setForeground(Color.blue);
    }

    @Override
    public void initUI() {
        DBColumnType dBColumnType;
        Object object2;
        for (Object object2 : this.allDataProviderAttributes) {
            dBColumnType = new DBColumnType();
            dBColumnType.setAlias(object2.getAlias());
            dBColumnType.setAnnotation(object2.getAnnotation());
            dBColumnType.setDataType(object2.getDataType());
            dBColumnType.setDataTypeQualifier(object2.getDataTypeQualifier());
            dBColumnType.setName(object2.getName());
            dBColumnType.setStatus(object2.getStatus());
            if (object2 instanceof DBColumnType) {
                dBColumnType.setKey(((DBColumnType)object2).getKey());
                dBColumnType.setIndex(((DBColumnType)object2).getIndex());
            } else {
                dBColumnType.setKey("No");
                dBColumnType.setIndex("No");
            }
            this.dbAttributes.getDBAttribute().add(dBColumnType);
        }
        Object object3 = new TableAttributes(this.dbAttributes.getDBAttribute());
        this.setupItemsTable((GeneralAttributesTableModel)((Object)object3));
        object2 = new JScrollPane((Component)this._jAttributesTable);
        this.jAttributesComponent.setComponent((JComponent)object2);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        dBColumnType = new ControlBar();
        this.installItemFilterActions((ControlBar)dBColumnType);
        this._editBtn.setEnabled(true);
        this._removeBtn.setEnabled(true);
        this.jAttributesComponent.setControlBar((ControlBar)dBColumnType);
        this._jAttributesTable.setFillsViewportHeight(true);
        try {
            this._originalTableName = WorkflowUtils.getNewOutputTableNameWfid(this.getContext());
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this._originalTableName = null;
        }
        this.jTextFieldName.setText(this._originalTableName);
        this.jStorageSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String string = DataDialogsLrb.get("STORAGE_SETTINGS_DIALOG_TITLE");
                final CreateTableStorageSettingsPanel createTableStorageSettingsPanel = new CreateTableStorageSettingsPanel(string, UpdateTableNodeCreateTablePanel.this.cachedTableOptions);
                DialogHelper dialogHelper = new DialogHelper(createTableStorageSettingsPanel);
                dialogHelper.setDialogOkExecutor(new DialogOkExecutor(){

                    @Override
                    public void onOK() throws DialogExecutionException {
                        UpdateTableNodeCreateTablePanel.this.newTableOptions = createTableStorageSettingsPanel.getTableOptions();
                    }
                });
                dialogHelper.showAsDialog(UpdateTableNodeCreateTablePanel.this);
            }
        });
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateTableCreateNewTableAttributesDialog updateTableCreateNewTableAttributesDialog;
                DialogHelper dialogHelper;
                boolean bl;
                UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeCreateTablePanel.this.getData();
                AbstractNode abstractNode = updateTableNode.findParentNode();
                if (abstractNode instanceof AbstractDataNode && (bl = (dialogHelper = new DialogHelper(updateTableCreateNewTableAttributesDialog = new UpdateTableCreateNewTableAttributesDialog(UpdateTableNodeCreateTablePanel.this._context, updateTableNode, (AbstractDataNode)abstractNode, UpdateTableNodeCreateTablePanel.this.dbAttributes))).showAsDialog(UpdateTableNodeCreateTablePanel.this))) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeCreateTablePanel.this._jAttributesTable.getModel());
                    generalAttributesTableModel.fireTableDataChanged();
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = UpdateTableNodeCreateTablePanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeCreateTablePanel.this._jAttributesTable.getModel());
                    ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        DBColumnType dBColumnType = (DBColumnType)generalAttributesTableModel.getSrcData().get(nArray[i]);
                        if (!UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute().contains(dBColumnType)) continue;
                        arrayList.add(dBColumnType);
                    }
                    if (!arrayList.isEmpty()) {
                        UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute().removeAll(arrayList);
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        TableColumn tableColumn2 = this._jAttributesTable.getColumnModel().getColumn(4);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("UPDATE_NEW_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "createtable_node_edit";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        Object object;
        Object object22;
        String string;
        boolean bl = true;
        String string2 = this.jTextFieldName.getText().trim();
        if (string2.length() == 0) {
            MessageDialog.error((Component)this, (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.isDoubleQuotedString(string2)) {
            string2 = string2.toUpperCase();
        }
        if (!TableNameValidator.validateTableName(string2, null, this._context, true)) {
            return false;
        }
        if (StringUtils.checkDataLossWithMsg(this._context, string2, DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"))) {
            return false;
        }
        string2 = StringUtils.trimDoubleQuotes(string2);
        if (this._originalTableName != null && !this._originalTableName.equals(string2) && !TableNameValidator.isTableNameUnique(this._context, string2)) {
            string = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string2);
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                return false;
            }
        }
        string = StringUtils.isDoubleQuotedString(string = ConnectionFolder.getUserAccountName(this._context)) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        HashMap<String, DBColumnType> hashMap = new HashMap<String, DBColumnType>();
        if (this.dbAttributes.getDBAttribute().isEmpty()) {
            return false;
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
        String[] stringArray = new String[this.dbAttributes.getDBAttribute().size()];
        String[] stringArray2 = new String[this.dbAttributes.getDBAttribute().size()];
        String[] stringArray3 = new String[this.dbAttributes.getDBAttribute().size()];
        int n = 0;
        for (Object object22 : this.dbAttributes.getDBAttribute()) {
            hashMap.put(object22.getName(), (DBColumnType)object22);
            stringArray2[n] = object22.getDataType();
            object = "\"" + object22.getName() + "\"";
            String string3 = "\"" + (object22.getAlias() != null && !object22.getAlias().isEmpty() ? object22.getAlias() : object22.getName()) + "\"";
            stringArray[n] = object;
            stringArray3[n++] = string3;
            if ("Yes".equals(object22.getKey())) {
                arrayList.add((CallSite)((Object)string3));
            }
            if (!"Yes".equals(object22.getIndex())) continue;
            arrayList2.add((CallSite)((Object)string3));
        }
        this.tablePropertyValue = new Table(string, string2, hashMap);
        UpdateTableNode updateTableNode = (UpdateTableNode)this.getData();
        object22 = updateTableNode.findParentNode();
        assert (object22 instanceof AbstractDataNode);
        object = ((AbstractDataNode)object22).getInputSQL();
        int n2 = -1;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        Version version = connectionFolder.getDbVersion();
        this._context.setProperty("TARGET_DATABASE_VERSION", (Object)version);
        Map<String, String> map = updateTableNode.getInMemorySettings(this._context);
        String string4 = map.get("IN_MEMORY_ON");
        String string5 = "FALSE";
        string5 = string4 == null || string4.isEmpty() ? "TRUE" : string4;
        String string6 = map.get("COMPRESSION_METHOD");
        String string7 = map.get("PRIORITY_LEVEL");
        String string8 = updateTableNode.getParallelHint(this._context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        int n3 = string8.indexOf("NOLOGGING");
        if (-1 != n3) {
            string8 = string8.substring(0, n3);
        }
        String string9 = this.newTableOptions.getTableCompression();
        String string10 = this.newTableOptions.getLogging();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context, ConnectionProperties.ALTER_SESSION_FIXES);
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)stringArray);
            Array array2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)stringArray3);
            Array array3 = oracleConnection.createOracleArray("ODMR_OBJECT_VALUES", (Object)stringArray2);
            Array array4 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)arrayList.toArray(new String[arrayList.size()]));
            Array array5 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)arrayList2.toArray(new String[arrayList2.size()]));
            int n4 = 1;
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{? = call ODMR_UTIL.CREATE_TABLE_EXTERNAL2(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
            sQLHelper.cstmt.registerOutParameter(n4++, 2);
            sQLHelper.cstmt.setString(n4++, "\"" + string2 + "\"");
            sQLHelper.cstmt.setArray(n4++, array4);
            sQLHelper.cstmt.setArray(n4++, array5);
            sQLHelper.cstmt.setArray(n4++, array);
            sQLHelper.cstmt.setArray(n4++, array2);
            sQLHelper.cstmt.setArray(n4++, array3);
            sQLHelper.cstmt.setString(n4++, (String)object);
            sQLHelper.cstmt.setString(n4++, string5);
            sQLHelper.cstmt.setString(n4++, string6);
            sQLHelper.cstmt.setString(n4++, string7);
            sQLHelper.cstmt.setString(n4++, string9);
            sQLHelper.cstmt.setString(n4++, string10);
            sQLHelper.cstmt.setString(n4, string8);
            sQLHelper.cstmt.execute();
            n2 = sQLHelper.cstmt.getInt(1);
        }
        return bl;
    }

    public Table getTablePropertyValue() {
        return this.tablePropertyValue;
    }

    static {
        MAX_LENGTH = 32;
        MAX_LENGTH_EX = 130;
    }

    private static class GenericTableTooltipCustom
    extends DataMinerTable {
        private GenericTableTooltipCustom() {
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.repaint();
        }
    }

    private class TableAttributes
    extends GeneralAttributesTableModel {
        TableAttributes(List<DBColumnType> list) {
            super(list);
            this.setColumnIdentifiers(UpdateTableNodeCreateTablePanel.this._columnNames_table);
        }

        @Override
        protected int getAliasColumn() {
            return 4;
        }
    }

    private abstract class GeneralAttributesTableModel
    extends ODMrTableModel<DBColumnType> {
        private GeneralAttributesTableModel(List<DBColumnType> list) {
            super(list);
        }

        protected abstract int getAliasColumn();

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != this.getAliasColumn() && n2 != 3 && n2 != 2) {
                return;
            }
            DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
            if (n2 == this.getAliasColumn()) {
                Vector vector = new Vector();
                vector.addAll(this.srcData);
                vector.remove(dBColumnType);
                String string = null;
                String string2 = dBColumnType.getAlias();
                String string3 = dBColumnType.getName();
                if (object != null) {
                    string = ((String)object).trim();
                }
                if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                    string2 = StringUtils.addDoubleQuotes(string2);
                }
                if (string.length() != 0) {
                    if (!StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (string2 != null && string2.compareTo(string) == 0) {
                        return;
                    }
                    if (!AttributeNameValidator.validateAttributeName(string, vector, UpdateTableNodeCreateTablePanel.this._context, true)) {
                        return;
                    }
                } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, UpdateTableNodeCreateTablePanel.this._context, true)) {
                    return;
                }
                if (string2 != null && string2.compareTo(string) == 0) {
                    return;
                }
                string = StringUtils.trimDoubleQuotes(string);
                dBColumnType.setAlias(string);
            } else if (n2 == 2) {
                dBColumnType.setKey(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getIndex().equals("Yes")) {
                    dBColumnType.setIndex("No");
                }
            } else if (n2 == 3) {
                dBColumnType.setIndex(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getKey().equals("Yes")) {
                    dBColumnType.setKey("No");
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
            Object object = null;
            if (n2 == 0) {
                object = dBColumnType.getName();
            } else if (n2 == this.getAliasColumn()) {
                object = dBColumnType.getAlias();
            } else if (n2 == 1) {
                String string = dBColumnType.getDataType();
                String string2 = dBColumnType.getDataTypeQualifier();
                object = DatabaseMetadataUtils.isACharacterOracleDataType(string) ? DatabaseMetadataUtils.getJSONDataType(string, string2) : string;
            } else if (n2 == 3) {
                String string = dBColumnType.getIndex();
                object = "Yes".equals(string);
            } else if (n2 == 2) {
                String string = dBColumnType.getKey();
                object = "Yes".equals(string);
            } else assert (false) : "Out of bounds column when accessing items";
            return object != null ? object : "";
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == this.getAliasColumn()) {
                return true;
            }
            return n2 == 3 || n2 == 2;
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            UpdateTableNodeCreateTablePanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            for (AttributeType attributeType : UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute()) {
                if (!attributeType.getName().equals(object.toString()) || 0 != attributeType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl3 = true;
                break;
            }
            this.setIcon(bl3 ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png"));
            return component;
        }
    }
}

