/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible;

import java.awt.BorderLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ListSelectionModel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractModelSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.MainExtensibleSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;

public class ExtensibleSettingsPanel
extends AbstractSettingsPanel {
    private static final Logger LOGGER = Logger.getLogger(ExtensibleSettingsPanel.class.getName());
    protected AbstractModelSettingsPanel host;

    public ExtensibleSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, AbstractNode abstractNode, NodeType nodeType) {
        super(advancedSettingsPanel, context, abstractNode, nodeType);
        this.initUI();
    }

    public void initUI() {
        this.host = new MainExtensibleSettingsPanel(this.getEnclosingPanel());
        this.setLayout(new BorderLayout());
        this.add(this.host);
    }

    @Override
    public boolean canProceed(ListSelectionModel listSelectionModel) {
        ModelType modelType;
        this.host.processInput();
        boolean bl = this.host.isValidState();
        if (bl && this.host.apply() && (modelType = this.host.getParentPanel().findEditedModel(this.host.getModelType())) == null) {
            modelType = this.host.getModelType();
            this.addEditedModelRecord(modelType, 1);
        }
        return bl;
    }

    @Override
    protected boolean canHandleModelSelectionChange(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty()) {
            this.host.processInput();
            bl = this.host.isValidState();
        }
        return bl;
    }

    @Override
    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!super.handleModelSelectionChanged(listSelectionModel)) {
            return bl;
        }
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            int[] nArray = this.getSelectedModelRowsInModel();
            ModelType modelType = this.getModelsDataList().get(nArray[0]);
            AbstractBuildNode abstractBuildNode = this.getWorkflowNode();
            try {
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
                AbstractDataNode abstractDataNode = abstractBuildNode.findBuildDataNode(workflowModel);
                this.host.processInput();
                if (this.host.isValidState()) {
                    if (this.host.apply()) {
                        ModelType modelType2 = this.host.getParentPanel().findEditedModel(modelType);
                        if (modelType2 == null) {
                            this.addEditedModelRecord(modelType, 1);
                        } else {
                            modelType = modelType2;
                        }
                    }
                    this.host.loadModel(this.getContext(), modelType, (BuildNodeType)abstractBuildNode.getData(), abstractDataNode);
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.host.loadUnderConstruction();
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() != listSelectionModel.getMaxSelectionIndex()) {
            this.host.loadMultipleSelection();
        }
        return bl;
    }

    protected void handleModelMetadataChanged() {
    }

    @Override
    protected void loadEmptySelectionUI() {
        this.host.loadEmptySelection();
    }
}

