/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.NamedSwingWorker;
import oracle.dmt.dataminer.teditor.data.ODMrColumnAutoSize;
import oracle.dmt.dataminer.teditor.data.ODMrCopyableResultSetTableAdapter;
import oracle.dmt.dataminer.teditor.data.ODMrDefaultCellRenderer;
import oracle.dmt.dataminer.teditor.data.ODMrRSTableHeaderMenu;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableCellEditor;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableColumnModel;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel12c;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModelBase;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.ui.KeyNavigationManager;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class ODMrResultSetTable
extends JTable {
    private static final int ROW_NUMBER_WIDTH = 45;
    private static final int ROW_HEIGHT = 20;
    private static Vector<String> columnNames = new Vector();
    private JTable rowHeader;
    private KeyNavigationManager keyNavigationManager;
    private ODMrCopyableResultSetTableAdapter copyAdapter;
    private KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
    private KeyStroke copyWithHeader = KeyStroke.getKeyStroke(67, 3, false);
    private KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
    private KeyStroke fetchAll = KeyStroke.getKeyStroke(34, 2, false);
    private KeyStroke fetchEndAll = KeyStroke.getKeyStroke(35, 2, false);
    private Object LOCK = new Object();
    private volatile NamedSwingWorker _worker;
    private String _where;
    private DataViewerState state;
    private Context _context;
    private boolean _is12c;
    private DataViewerPanel parentPanel;
    private int orderCol = -1;
    private boolean ascending = true;
    private final TableModelListener _tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                    if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                        ((DataEditor)editor).updateToolbar();
                    }
                }
            });
        }
    };
    private ActionListener _copyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().compareTo("Copy") == 0) {
                ODMrResultSetTable.this.copyAdapter.setNullString("");
                ODMrResultSetTable.this.copyAdapter.copyToClipboard();
            } else if (actionEvent.getActionCommand().compareTo("Paste") == 0) {
                ODMrResultSetTable.this.copyAdapter.setNullString("");
                ODMrResultSetTable.this.copyAdapter.pasteToJTable();
            } else if (actionEvent.getActionCommand().compareTo("Copy.With.Header") == 0) {
                ODMrResultSetTable.this.copyAdapter.setNullString("");
                ODMrResultSetTable.this.copyAdapter.copyToClipboard(false, true);
            }
        }
    };

    public ODMrResultSetTable() {
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.setColumnModel(new ODMrResultSetTableColumnModel(this));
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setAutoscrolls(true);
        this.setDragEnabled(true);
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                ODMrResultSetTable.this.autoScrollColumn(mouseEvent.getPoint());
            }
        });
        this.setDefaultRenderer(TableColumn.class, new ODMrDefaultCellRenderer());
        this.setDefaultEditor(TableColumn.class, new ODMrResultSetTableCellEditor(this));
        this.setSurrendersFocusOnKeystroke(true);
        this.setAutoCreateColumnsFromModel(true);
        this.getTableHeader().addMouseListener(new ODMrColumnAutoSize());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getSource() instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    JTable jTable = jTableHeader.getTable();
                    if (jTable.isEditing()) {
                        jTable.getCellEditor().cancelCellEditing();
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        int n;
                        int n2 = jTableHeader.getResizingColumn() != null ? jTableHeader.getResizingColumn().getModelIndex() : -1;
                        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                        int n3 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                        if (n3 != -1 && (n = tableColumnModel.getColumn(n3).getModelIndex()) != -1 && n2 == -1) {
                            if (ODMrResultSetTable.this.orderCol == -1 || ODMrResultSetTable.this.orderCol != n3) {
                                ODMrResultSetTable.this.orderCol = n3;
                                ODMrResultSetTable.this.ascending = true;
                            } else if (ODMrResultSetTable.this.orderCol == n3) {
                                ODMrResultSetTable.this.ascending = !ODMrResultSetTable.this.ascending;
                            }
                            ODMrResultSetTable.this.parentPanel.headerSortClicked(n3, ODMrResultSetTable.this.ascending);
                        }
                    } else if (mouseEvent.getClickCount() == 1) {
                        ODMrResultSetTable.this.setCellSelectionEnabled(false);
                        ODMrResultSetTable.this.setColumnSelectionAllowed(true);
                        ODMrResultSetTable.this.setRowSelectionAllowed(false);
                        ODMrRSTableHeaderMenu.select(ODMrResultSetTable.this.getColumnModel().getSelectionModel(), mouseEvent, ODMrResultSetTable.this.columnAtPoint(mouseEvent.getPoint()));
                        ODMrResultSetTable.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this.keyNavigationManager = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TableKeyAdapter((JTable)this));
        this.registerKeyboardAction(this._copyListener, "Copy", this.copy, 0);
        this.registerKeyboardAction(this._copyListener, "Copy.With.Header", this.copyWithHeader, 0);
        this.registerKeyboardAction(this._copyListener, "Paste", this.paste, 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODMrResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchAll, 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODMrResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchEndAll, 0);
        this.copyAdapter = new ODMrCopyableResultSetTableAdapter(this);
    }

    public void setState(DataViewerState dataViewerState) {
        this.state = dataViewerState;
    }

    void setParentPanel(DataViewerPanel dataViewerPanel) {
        this.parentPanel = dataViewerPanel;
    }

    public ODMrResultSetTableModelBase getTableModel() {
        TableModel tableModel = this.getModel();
        return tableModel instanceof ODMrResultSetTableModelBase ? (ODMrResultSetTableModelBase)tableModel : null;
    }

    public boolean isSorting() {
        if (this.getModel() instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.getModel();
            return oDMrResultSetTableModelBase.isSorting();
        }
        return false;
    }

    public boolean isRunning() {
        if (this.getModel() instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.getModel();
            return oDMrResultSetTableModelBase.isRunning();
        }
        return false;
    }

    public boolean isOperationInprogress() {
        if (this.getModel() instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.getModel();
            boolean bl = oDMrResultSetTableModelBase.isRunning();
            boolean bl2 = oDMrResultSetTableModelBase.isSorting();
            if (bl || bl2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            int n3 = oDMrResultSetTableModelBase.getSortColumn();
            if (oDMrResultSetTableModelBase.isSorting() && n3 == n2 + 1) {
                component.setBackground(Color.LIGHT_GRAY);
            }
        }
        return component;
    }

    public boolean isColSortable(int n) {
        boolean bl = false;
        ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.getModel();
        String string = oDMrResultSetTableModelBase.getSQL();
        int n2 = oDMrResultSetTableModelBase.getType(n);
        if (string != null && !oDMrResultSetTableModelBase.isVerticalDisplay()) {
            switch (n2) {
                case 12: {
                    String string2 = oDMrResultSetTableModelBase.getValueAt(0, n + 1).toString();
                    if (string2.indexOf("SQLDEV:") == 0) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 91: 
                case 101: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private void is12c(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this._is12c = DbVersionHelper.isDB121Up((Version)connectionFolder.getDbVersion());
    }

    public ODMrResultSetTableModelBase resetModelSorting() {
        ODMrResultSetTableModelBase oDMrResultSetTableModelBase = null;
        if (this.getModel() != null && this.getModel() instanceof ODMrResultSetTableModelBase) {
            oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.getModel();
            oDMrResultSetTableModelBase.prepareForSort();
        } else {
            assert (this._context != null);
            assert (this.state != null);
            oDMrResultSetTableModelBase = this._is12c ? new ODMrResultSetTableModel12c(this.state) : new ODMrResultSetTableModel(this.state);
        }
        return oDMrResultSetTableModelBase;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyNavigationManager != null) {
            this.keyNavigationManager.preProcessKeyEvent(keyEvent);
        }
        super.processKeyEvent(keyEvent);
        if (this.keyNavigationManager != null) {
            this.keyNavigationManager.postProcessKeyEvent(keyEvent);
        }
    }

    private static void invokeAfterRepaint(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public void displayLoadingStatus(GenericBaseTableModel genericBaseTableModel) {
        this.setSuperModel((TableModel)genericBaseTableModel);
    }

    @Override
    public void setModel(final TableModel tableModel) {
        TableModel tableModel2 = this.getModel();
        if (tableModel2 != null && tableModel2 != tableModel && tableModel2 instanceof ODMrResultSetTableModelBase) {
            tableModel2.removeTableModelListener(this._tableModelListener);
            ((ODMrResultSetTableModelBase)tableModel2).close();
        }
        ODMrResultSetTable.invokeAfterRepaint(new Runnable(){

            @Override
            public void run() {
                ODMrResultSetTableModelBase oDMrResultSetTableModelBase;
                ODMrResultSetTable.this.setSuperModel(tableModel);
                if (tableModel instanceof ODMrResultSetTableModelBase && (oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel).getConnection() != null) {
                    oDMrResultSetTableModelBase.addTableModelListener(ODMrResultSetTable.this._tableModelListener);
                    if (oDMrResultSetTableModelBase.getSQL() != null && ODMrResultSetTable.this.getModel() != null) {
                        boolean bl = oDMrResultSetTableModelBase.isThreaded();
                        oDMrResultSetTableModelBase.setThreaded(true);
                        oDMrResultSetTableModelBase.open();
                        if (ODMrResultSetTable.this.rowHeader != null) {
                            ODMrResultSetTable.this.rowHeader.setModel(oDMrResultSetTableModelBase);
                        }
                        oDMrResultSetTableModelBase.fireTableStructureChanged();
                        ODMrResultSetTable.this.applyDefaultSettings();
                        oDMrResultSetTableModelBase.setThreaded(bl);
                    }
                }
            }
        });
    }

    public void setModel(ODMrResultSetTableModelBase oDMrResultSetTableModelBase, int n) {
        TableModel tableModel = this.getModel();
        if (tableModel != null && tableModel != oDMrResultSetTableModelBase && tableModel instanceof ODMrResultSetTableModelBase) {
            tableModel.removeTableModelListener(this._tableModelListener);
            ((ODMrResultSetTableModelBase)tableModel).close();
        }
        this.setSuperModel(oDMrResultSetTableModelBase);
        if (oDMrResultSetTableModelBase.getConnection() != null) {
            oDMrResultSetTableModelBase.addTableModelListener(this._tableModelListener);
            oDMrResultSetTableModelBase.open(n);
            if (this.rowHeader != null) {
                this.rowHeader.setModel(oDMrResultSetTableModelBase);
            }
        }
    }

    public JTable getRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = new JTable();
            this.rowHeader.setRowHeight(20);
            this.rowHeader.setColumnModel(new ODMrRowHeaderTableColumnModel(45, 4));
            this.rowHeader.setModel(this.getModel() == null ? (this._is12c ? new ODMrResultSetTableModel12c(this.state) : new ODMrResultSetTableModel(this.state)) : this.getModel());
            this.rowHeader.setSelectionModel(this.getSelectionModel());
            this.rowHeader.setAutoResizeMode(0);
            this.rowHeader.setColumnSelectionAllowed(false);
            this.rowHeader.setCellSelectionEnabled(false);
            this.rowHeader.setSelectionBackground(this.rowHeader.getBackground());
            this.rowHeader.setMaximumSize(new Dimension(45, Integer.MAX_VALUE));
            this.rowHeader.addHierarchyListener(new HierarchyListener(){
                private JViewport view;
                private ChangeListener cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        for (Container container = ODMrResultSetTable.this.getParent(); container != null; container = container.getParent()) {
                            if (!(container instanceof JViewport)) continue;
                            JViewport jViewport = (JViewport)container;
                            Point point = ((JViewport)changeEvent.getSource()).getViewPosition();
                            Point point2 = jViewport.getViewPosition();
                            if (point.y == point2.y) break;
                            point2.y = point.y;
                            jViewport.setViewPosition(point2);
                            break;
                        }
                    }
                };

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    for (Container container = ODMrResultSetTable.this.rowHeader.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof JViewport)) continue;
                        if (this.view == container) break;
                        if (this.view != null) {
                            this.view.removeChangeListener(this.cl);
                        }
                        this.view = (JViewport)container;
                        this.view.setPreferredSize(ODMrResultSetTable.this.rowHeader.getMaximumSize());
                        this.view.addChangeListener(this.cl);
                        break;
                    }
                }
            });
            this.rowHeader.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ODMrResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchAll, 0);
            this.rowHeader.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ODMrResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchEndAll, 0);
        }
        this.rowHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ODMrResultSetTable.this.setColumnSelectionAllowed(false);
                ODMrResultSetTable.this.setRowSelectionAllowed(true);
                ODMrRSTableHeaderMenu.select(ODMrResultSetTable.this.getSelectionModel(), mouseEvent, ODMrResultSetTable.this.rowAtPoint(mouseEvent.getPoint()));
                ODMrResultSetTable.this.requestFocusInWindow();
            }
        });
        return this.rowHeader;
    }

    public JTable getDummyRowHeader() {
        JTable jTable = new JTable();
        jTable.setRowHeight(20);
        jTable.setColumnModel(new ODMrRowHeaderTableColumnModel());
        jTable.setModel(this.getModel());
        jTable.setAutoResizeMode(4);
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        jTable.setSelectionBackground(jTable.getBackground());
        jTable.setMaximumSize(new Dimension(2000, Integer.MAX_VALUE));
        jTable.setFillsViewportHeight(true);
        return jTable;
    }

    public void fetchAll() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            final ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            final boolean bl = oDMrResultSetTableModelBase.isThreaded();
            oDMrResultSetTableModelBase.setThreaded(true);
            oDMrResultSetTableModelBase.fetchAll();
            Runnable runnable = new Runnable(){
                int lastScroll = 0;

                @Override
                public void run() {
                    oDMrResultSetTableModelBase.setThreaded(bl);
                    if (this.lastScroll != oDMrResultSetTableModelBase.getLoadedCount()) {
                        ODMrResultSetTable.this.scrollToRow(oDMrResultSetTableModelBase.getLoadedCount());
                        this.lastScroll = oDMrResultSetTableModelBase.getLoadedCount();
                    }
                    if (!oDMrResultSetTableModelBase.allFetched()) {
                        SwingUtilities.invokeLater(this);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void scrollToRow(int n) {
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public void autoScrollColumn(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x, point.y, 0, 0);
            this.scrollRectToVisible(rectangle3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this._worker = new NamedSwingWorker("SelectAll"){

                @Override
                public Object construct() {
                    Ide.getMainWindow().setCursor(new Cursor(3));
                    return this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finished() {
                    ODMrResultSetTable.this.superSelectAll();
                    Ide.getMainWindow().setCursor(new Cursor(0));
                    Object object = ODMrResultSetTable.this.LOCK;
                    synchronized (object) {
                        ODMrResultSetTable.this._worker = null;
                    }
                }
            };
            this._worker.start();
        }
    }

    private void superSelectAll() {
        super.selectAll();
    }

    public void setSuperModel(TableModel tableModel) {
        super.setModel(tableModel);
    }

    public void setContext(Context context) {
        this._context = context;
        this.is12c(this._context);
    }

    void applyDefaultSettings() {
        this.setAutoResizeMode(0);
    }

    public String getRawColumnName(int n) {
        return this.getModel() instanceof ODMrResultSetTableModelBase ? ((ODMrResultSetTableModelBase)this.getModel()).getRawColumnName(n) : null;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                int n2 = ODMrResultSetTable.this.rowAtPoint(point);
                Rectangle rectangle = ODMrResultSetTable.this.getCellRect(n2, n, false);
                int n3 = this.columnModel.getColumnIndexAtX(point.x);
                if (n3 != -1 && ODMrResultSetTable.this.getModel() instanceof ODMrResultSetTableModelBase) {
                    int n4 = Double.valueOf(new JLabel(((ODMrResultSetTableModelBase)ODMrResultSetTable.this.getModel()).getRawColumnName(n3)).getPreferredSize().getWidth()).intValue();
                    return rectangle.width > n4 ? null : ((ODMrResultSetTableModelBase)ODMrResultSetTable.this.getModel()).getRawColumnName(n3);
                }
                return null;
            }
        };
    }

    @Override
    public int getRowCount() {
        if (this.getModel() == null) {
            return 0;
        }
        return super.getRowCount();
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        boolean bl = super.editCellAt(n, n2, eventObject);
        return bl;
    }

    public void setWhere(String string) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            oDMrResultSetTableModelBase.setWhere(string);
            this._where = string;
        }
    }

    public String getWhereClause() {
        return this._where;
    }

    public String getColumnDBName(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            return oDMrResultSetTableModelBase.getRawColumnName(n);
        }
        return null;
    }

    public String getColumnType(String string) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            return oDMrResultSetTableModelBase.getColumnType(string);
        }
        return null;
    }

    public void setOrderBy(String string) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            oDMrResultSetTableModelBase.setOrderBy(string);
        }
    }

    public void interruptSorting() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)tableModel;
            oDMrResultSetTableModelBase.interruptSorting();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!this.isEnabled()) {
            this.setEnabled(true);
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        super.tableChanged(tableModelEvent);
    }

    static {
        columnNames.add(DataLrb.get("DATA_VIEWER_COLUMN_NAME"));
    }

    private static class ODMrRowHeaderTableColumnModel
    extends DefaultTableColumnModel {
        private int maxwidth = -1;
        private int alignment = 2;

        ODMrRowHeaderTableColumnModel(int n, int n2) {
            this.maxwidth = n;
            this.alignment = n2;
        }

        ODMrRowHeaderTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int n) {
            TableColumn tableColumn = null;
            if (n < this.getColumnCount()) {
                tableColumn = (TableColumn)this.tableColumns.elementAt(n);
            }
            return tableColumn;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setCellRenderer(this.alignment == 4 ? ODMrRowHeaderCellRenderer.INSTANCE_RIGHT_ALIGNMENT : ODMrRowHeaderCellRenderer.INSTANCE_LEFT_ALIGNMENT);
                if (this.maxwidth != -1) {
                    tableColumn.setMaxWidth(this.maxwidth);
                }
                super.addColumn(tableColumn);
            }
        }
    }

    private static class ODMrRowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        static final ODMrRowHeaderCellRenderer INSTANCE_RIGHT_ALIGNMENT = new ODMrRowHeaderCellRenderer(4);
        static final ODMrRowHeaderCellRenderer INSTANCE_LEFT_ALIGNMENT = new ODMrRowHeaderCellRenderer(2);
        static final Dimension SORT_ICON_SIZE = new Dimension(9, 5);
        private int alignment = 4;

        ODMrRowHeaderCellRenderer(int n) {
            this.alignment = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(this.alignment);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = jLabel.getBorder();
            if (border != null) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            jLabel.setBorder(border);
            return jLabel;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }
}

