/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.core.model.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.core.model.generated.server.DmHistograms;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetails;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModel;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.StateChangeListener;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public class SingleClusterViewerState
extends BaseViewerState
implements GraphModelProvider,
ClusterDetails {
    private static final int _DEPTH_RADIUS = 0;
    private static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    private static final int PRECISION_LEVEL_OF_HISTOGRAM_LABELS = 5;
    private boolean _loaded;
    private boolean _levelDetails = true;
    private boolean _leafsOnly = true;
    private ClusterDetailsModel _tableModel;
    private Map<String, ClusteringDetailRowShort> _clusterCountsMap;
    private ClusteringFilterSetting _filterSetting;
    private String _clusterLabel;
    private List<String> _clusterLabels;
    private String _styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int _depthRadius = 0;
    private int _precisionLevelOfHistogramLabels = 5;
    private boolean _maxPrecision;
    private StateChangeListener stateChangeListener;

    public SingleClusterViewerState(Context context) {
        super(context);
        this._tableModel = new ClusterDetailsModel(true);
    }

    public HelpInfo getHelpInfo() {
        String string = "cluster_detail_help";
        return new HelpInfo(string);
    }

    public SingleClusterViewerState load(String string) throws Exception {
        assert (this.isClustering()) : "Viewer for clustering";
        Node node = this.context.getNode();
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)node;
        if (this.isKM()) {
            if (clusteringModelNode.isKMnoneOptionEnabled() || !clusteringModelNode.isStatsEnabled() && DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion())) {
                this._levelDetails = false;
            }
        } else if (this.isEM() && !clusteringModelNode.isStatsEnabled()) {
            this._levelDetails = false;
        }
        if (this._levelDetails) {
            this.loadClusterNew(false, string);
        }
        this._loaded = true;
        clusteringModelNode.setClusterDetails(this);
        clusteringModelNode.setClusterDetailsLoaded();
        return this;
    }

    public void reload(boolean bl, String string) throws Exception {
        Node node = this.context.getNode();
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)node;
        if (this.isKM()) {
            this._levelDetails = !(clusteringModelNode.isKMnoneOptionEnabled() || !clusteringModelNode.isStatsEnabled() && DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion()));
        } else if (this.isEM()) {
            this._levelDetails = clusteringModelNode.isStatsEnabled() || !DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion());
        }
        this._loaded = false;
        if (this._levelDetails) {
            this.loadClusterNew(bl, string);
        }
        this._loaded = true;
        clusteringModelNode.setClusterDetails(this);
        clusteringModelNode.setClusterDetailsLoaded();
    }

    private void createAllGraphDataModelsTotalPopulation() throws Exception {
        Vector vector = this._tableModel.getDataVector();
        for (ClusterDetailsModelRow clusterDetailsModelRow : vector) {
            String string = clusterDetailsModelRow.getFullAttributeName();
            GraphDataModel graphDataModel = this.createGraphDataModelClusterPopulationGeneric(string, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(Integer.valueOf(0));
            graphDataModel.setLineDataLineDisplayed(false);
            clusterDetailsModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string, true);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        ClusterDetailsModelRow clusterDetailsModelRow = this._tableModel.getClusterDetailRow(string);
        DmHistograms dmHistograms = clusterDetailsModelRow.getHistogram();
        int n = 0;
        if (dmHistograms == null || dmHistograms.length() == 0) {
            return defaultGraphDataModel;
        }
        int n2 = dmHistograms.length();
        int n3 = 1;
        Object[][] objectArray = new Object[n2][n3];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new String[n3];
        for (int i = 0; i < n3; ++i) {
            BigDecimal bigDecimal;
            DmHistogramBin dmHistogramBin;
            int n4;
            objectArray3[i] = bl ? ClusterLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (n4 = 0; n4 < n2; ++n4) {
                dmHistogramBin = dmHistograms.getElement((long)n4);
                bigDecimal = dmHistogramBin.getCount();
                n += bigDecimal.intValue();
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dmHistogramBin = dmHistograms.getElement((long)n4);
                bigDecimal = dmHistogramBin.getCount();
                BigDecimal bigDecimal2 = dmHistogramBin.getUpperBound();
                BigDecimal bigDecimal3 = dmHistogramBin.getLowerBound();
                int n5 = dmHistogramBin.getBinId().intValue();
                if (n5 > n2) {
                    n5 = n2;
                }
                String string2 = bigDecimal2 != null && bigDecimal3 != null ? (this._maxPrecision ? dmHistogramBin.getLabel() : this.formatLabelFromBoundaries(bigDecimal3, bigDecimal2)) : dmHistogramBin.getLabel();
                objectArray[n5 - 1][i] = this.isKM() ? (n == 0 ? Double.valueOf(bigDecimal.doubleValue() * 100.0) : Double.valueOf(bigDecimal.doubleValue() / (double)n * 100.0)) : Double.valueOf(bigDecimal.doubleValue() * 100.0);
                objectArray2[n5 - 1] = bl ? string2 : "";
            }
        }
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLegendVisible(false);
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        return defaultGraphDataModel;
    }

    private String formatLabelFromBoundaries(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        double d = bigDecimal.doubleValue();
        double d2 = bigDecimal2.doubleValue();
        String string = NumericFormat.format((double)d, (boolean)true, (int)this._precisionLevelOfHistogramLabels);
        String string2 = NumericFormat.format((double)d2, (boolean)true, (int)this._precisionLevelOfHistogramLabels);
        return string + " : " + string2;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        Vector vector = this._tableModel.getDataVector();
        ClusterDetailsModelRow clusterDetailsModelRow = (ClusterDetailsModelRow)vector.get(n);
        GraphDataModel graphDataModel = clusterDetailsModelRow.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this._styleSelection;
    }

    private Map<String, ClusteringDetailRowShort> getMap() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.context.getNode();
        Map<String, ClusteringDetailRowShort> map = clusteringModelNode.getClusterCountsMap(this.getUserName(), this.getModelName());
        return map;
    }

    private void setMap(Map<String, ClusteringDetailRowShort> map) {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.context.getNode();
        clusteringModelNode.setClusterCountsMap(this.getUserName(), this.getModelName(), map);
    }

    private void loadClusterNew(boolean bl, String string) throws Exception {
        ArrayList<ClusterDetailsModelRow> arrayList = new ArrayList(0);
        Clustering clustering = this.getClustering();
        clustering.setPartitionId(string);
        if (this._clusterCountsMap == null) {
            this._clusterCountsMap = this.getMap();
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = clustering.getTotalNumberOfModelAttributesPerCluster2();
                this.setMap(this._clusterCountsMap);
            }
            this.loadClusterMapFromCacheNew();
            this.selectInitialClusterToLoadFirstInList();
        } else if (bl) {
            this._clusterCountsMap = clustering.getTotalNumberOfModelAttributesPerCluster2();
            this.setMap(this._clusterCountsMap);
            this.reloadClusterMapFromCacheNew();
        }
        arrayList = clustering.getModelAttributeDetails(this._filterSetting);
        this._tableModel = new ClusterDetailsModel(arrayList);
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void selectInitialClusterToLoadByCountNew() {
        Collection<ClusteringDetailRowShort> collection = this._clusterCountsMap.values();
        String string = "";
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        for (ClusteringDetailRowShort clusteringDetailRowShort : collection) {
            if (bl) {
                bl = false;
                n2 = clusteringDetailRowShort.getAttributeCount();
                string = clusteringDetailRowShort.getClusterId();
                n = clusteringDetailRowShort.getId();
                continue;
            }
            if (clusteringDetailRowShort.getAttributeCount() >= n2) continue;
            n2 = clusteringDetailRowShort.getAttributeCount();
            string = clusteringDetailRowShort.getClusterId();
            n = clusteringDetailRowShort.getId();
        }
        this._filterSetting.setClusterId(n);
        this._clusterLabel = string;
    }

    public void selectInitialClusterToLoadFirstInList() {
        if (this._clusterLabels != null && this._clusterLabels.size() > 0) {
            this._clusterLabel = this._clusterLabels.get(0);
            ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(this._clusterLabel);
            if (this._filterSetting == null) {
                this._filterSetting = new ClusteringFilterSetting();
            }
            this._filterSetting.setClusterId(clusteringDetailRowShort.getId());
        } else {
            this._clusterLabel = "";
        }
    }

    public void clearRows() {
        this._tableModel.clearRows();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public boolean getLevelDetails() {
        return this._levelDetails;
    }

    public void setCluster_id(Integer n) {
        this._filterSetting.setClusterId(n);
    }

    public Integer getCluster_id() {
        return this._filterSetting.getClusterId();
    }

    public ClusterDetailsModel getTableModel() {
        return this._tableModel;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setFetchSize(Integer n) {
        this._filterSetting.setFetchSize(n);
    }

    public Map<String, ClusteringDetailRowShort> getClusterLabelToIDMap() {
        return this._clusterCountsMap;
    }

    public void setLeafsOnly(boolean bl) {
        if (this.isLoaded() && this._leafsOnly != bl) {
            this._leafsOnly = bl;
            this.reloadClusterMapFromCacheNew();
            this.resetClusterIDIfNotInMapping();
        }
    }

    private void resetClusterIDIfNotInMapping() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        ClusteringDetailRowShort clusteringDetailRowShort = map.get(this._clusterLabel);
        if (clusteringDetailRowShort == null) {
            this.selectInitialClusterToLoadFirstInList();
        }
    }

    private void loadClusterMapFromCacheNew() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, LetterNumberComparator.getComparator());
    }

    private void reloadClusterMapFromCacheNew() {
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(this._clusterLabel);
        this._clusterLabel = clusteringDetailRowShort != null ? clusteringDetailRowShort.getClusterId() : this._clusterLabels.get(0);
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, LetterNumberComparator.getComparator());
        if (this._clusterLabel == null) {
            this._clusterLabel = this._clusterLabels.get(0);
        }
    }

    public boolean isLeafsOnly() {
        return this._leafsOnly;
    }

    public void setClusterLabel(String string) {
        this._clusterLabel = string;
    }

    public String getClusterLabel() {
        return this._clusterLabel;
    }

    public Object[] getClusterLabels() {
        return this._clusterLabels.toArray(new Object[this._clusterLabels.size()]);
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    @Override
    public Integer getTotalNumberOfModelAttributes() {
        Integer n = this.getCluster_id();
        Integer n2 = null;
        Collection<ClusteringDetailRowShort> collection = this._clusterCountsMap.values();
        for (ClusteringDetailRowShort clusteringDetailRowShort : collection) {
            String string = clusteringDetailRowShort.getClusterId();
            if (n == null || !string.equals(n.toString())) continue;
            n2 = clusteringDetailRowShort.getAttributeCount();
            break;
        }
        return n2;
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    @Override
    public void triggerUpdate() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.stateChanged();
        }
    }

    private Map<String, ClusteringDetailRowShort> getLeafsOnlyMap(Map<String, ClusteringDetailRowShort> map) {
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        for (Map.Entry<String, ClusteringDetailRowShort> entry : map.entrySet()) {
            String string = entry.getKey();
            ClusteringDetailRowShort clusteringDetailRowShort = entry.getValue();
            if (clusteringDetailRowShort.hasChildren()) continue;
            hashMap.put(string, clusteringDetailRowShort);
        }
        return hashMap;
    }
}

