/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.chain.Messages;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;

public class ChainStepCreateAction
extends ActionDialog {
    private static final String STEP_NAME = "Step Name";
    private static final String CHAIN_NAME = "Chain Name";
    public static final String PAUSE = "pause";
    public static final String SKIP = "skip";
    public static final String RESTART_ON_FAILURE = "restart_on_failure";
    public static final String RESTART_ON_RECOVERY = "restart_on_recovery";
    public static final String DESTINATION = "destination";
    public static final String CREDENTIAL_NAME = "credential_name";
    private static final String TYPE = "TYPE";
    public static final String PROGRAM = "PROGRAM";
    public static final String SCHEDULE = "SCHEDULE";
    public static final String CHAIN = "CHAIN";
    public static final String PROGRAM_NLS = Messages.getString("ChainStepCreateAction.Program");
    public static final String SCHEDULE_NLS = Messages.getString("ChainStepCreateAction.Schedule");
    public static final String CHAIN_NLS = Messages.getString("ChainStepCreateAction.Chain");
    private String chain_name;
    private String owner;
    private String type = PROGRAM_NLS;
    private BooleanCheckBoxActionControl pauseCtl = null;
    private BooleanCheckBoxActionControl skipCtl = null;
    private BooleanCheckBoxActionControl restart_on_failureCtl = null;
    private BooleanCheckBoxActionControl restart_on_recoveryCtl = null;
    private IdSqlComboBoxActionControl destinationCtl = null;
    private IdSqlComboBoxActionControl credential_nameCtl = null;

    public ChainStepCreateAction() {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(false);
        objectAction.setReload(true);
        this.setObjectAction(objectAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        NameBoxActionControl nameBoxActionControl;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.chain_name;
        String string2 = this.getDBObject().getDBVersion();
        if (Connections.getInstance().lock(connection)) {
            block12: {
                object = null;
                try {
                    nameBoxActionControl = new HashMap();
                    nameBoxActionControl.put("CHAIN_NAME", string);
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getChainOwner"), nameBoxActionControl);
                    if (object == null || !object.next()) break block12;
                    this.owner = object.getString("owner");
                }
                catch (Exception exception) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        hashMap.put("OBJECT_OWNER", this.owner);
        object = new NameBoxActionControl(CHAIN_NAME, Messages.getString("ChainStepCreateAction.6"), this.chain_name);
        object.setEditable(false);
        nameBoxActionControl = new NameBoxActionControl(STEP_NAME, Messages.getString("ChainStepCreateAction.7"), null);
        dBUtil = new SqlComboBoxActionControl(PROGRAM, Messages.getString("ChainStepCreateAction.8"), connection, this.getQuery(connection, "getPrograms"), null, null);
        this.pauseCtl = new BooleanCheckBoxActionControl(PAUSE, Messages.getString("ChainStepCreateAction.pause"), false);
        this.skipCtl = new BooleanCheckBoxActionControl(SKIP, Messages.getString("ChainStepCreateAction.skip"), false);
        if (!(string2.startsWith("11.1.") || string2.startsWith("10.") || string2.startsWith("9.") || string2.startsWith("8."))) {
            this.restart_on_failureCtl = new BooleanCheckBoxActionControl(RESTART_ON_FAILURE, Messages.getString("ChainStepCreateAction.restart_on_failure"), false);
        }
        this.restart_on_recoveryCtl = new BooleanCheckBoxActionControl(RESTART_ON_RECOVERY, Messages.getString("ChainStepCreateAction.restart_on_recovery"), false);
        if (!(string2.startsWith("10.") || string2.startsWith("9.") || string2.startsWith("8."))) {
            if (!string2.startsWith("11.1.")) {
                this.destinationCtl = new IdSqlComboBoxActionControl(DESTINATION, SchedulerArb.getString("CHAIN_STEP_CREATE_DESTINATION_LABEL"), connection, this.getQueryFromTemplate(connection, "CHAIN_STEP_DB_DEST_LIST"), hashMap, null);
            }
            this.credential_nameCtl = new IdSqlComboBoxActionControl(CREDENTIAL_NAME, SchedulerArb.getString("CHAIN_STEP_CREATE_CREDENTIAL_LABEL"), connection, this.getQueryFromTemplate(connection, "CHAIN_STEP_CRED_LIST"), hashMap, null);
        }
        SqlComboBoxActionControl sqlComboBoxActionControl = new SqlComboBoxActionControl(SCHEDULE, Messages.getString("ChainStepCreateAction.9"), connection, this.getQuery(connection, "getSchedulerEvents"), null, null);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("OWNER", this.owner);
        hashMap2.put("CHAIN_NAME", string);
        SqlComboBoxActionControl sqlComboBoxActionControl2 = new SqlComboBoxActionControl(CHAIN, Messages.getString("ChainStepCreateAction.9"), connection, this.getQuery(connection, "getChains"), hashMap2, null);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)dBUtil);
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls(arrayList);
        arrayList = new ArrayList();
        arrayList.add((ActionControl)sqlComboBoxActionControl);
        PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl();
        propertyPanelActionControl2.addChildControls(arrayList);
        arrayList = new ArrayList();
        arrayList.add((ActionControl)sqlComboBoxActionControl2);
        PropertyPanelActionControl propertyPanelActionControl3 = new PropertyPanelActionControl();
        propertyPanelActionControl3.addChildControls(arrayList);
        TreeMap<String, PropertyPanelActionControl> treeMap = new TreeMap<String, PropertyPanelActionControl>();
        treeMap.put(PROGRAM_NLS, propertyPanelActionControl);
        treeMap.put(SCHEDULE_NLS, propertyPanelActionControl2);
        treeMap.put(CHAIN_NLS, propertyPanelActionControl3);
        CardLayoutActionControl cardLayoutActionControl = new CardLayoutActionControl(TYPE, null, CardLayoutPanel.Type.PLAIN, treeMap);
        cardLayoutActionControl.setSelected((Object)this.type);
        arrayList = new ArrayList();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)nameBoxActionControl);
        arrayList.add((ActionControl)this.pauseCtl);
        arrayList.add((ActionControl)this.skipCtl);
        if (this.restart_on_failureCtl != null) {
            arrayList.add((ActionControl)this.restart_on_failureCtl);
        }
        if (this.restart_on_recoveryCtl != null) {
            arrayList.add((ActionControl)this.restart_on_recoveryCtl);
        }
        if (this.credential_nameCtl != null) {
            arrayList.add((ActionControl)this.credential_nameCtl);
        }
        if (this.destinationCtl != null) {
            arrayList.add((ActionControl)this.destinationCtl);
        }
        arrayList.add((ActionControl)cardLayoutActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        String string;
        String string2 = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        try {
            string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            string = null;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        String string3 = this.checkNull(values.get(STEP_NAME));
        string3 = ObjectNameValidator.validateName(string3);
        String string4 = this.checkNull(values.get(CHAIN_NAME));
        String string5 = values.get(TYPE);
        String string6 = this.checkNull(values.get("TYPE/PROGRAM"));
        String string7 = this.checkNull(values.get("TYPE/SCHEDULE"));
        String string8 = this.checkNull(values.get("TYPE/CHAIN"));
        String string9 = values.get(PAUSE);
        String string10 = values.get(SKIP);
        String string11 = values.get(RESTART_ON_FAILURE);
        String string12 = values.get(RESTART_ON_RECOVERY);
        String string13 = this.checkNull(values.get(CREDENTIAL_NAME));
        String string14 = this.checkNull(values.get(DESTINATION));
        if (string13 != null) {
            object = new IdentifierImpl(string13);
            string13 = ((IdentifierImpl)object).getId();
        }
        if (string14 != null) {
            object = new IdentifierImpl(string14);
            string14 = ((IdentifierImpl)object).getId();
        }
        object = new TreeMap();
        object.put("schema", string);
        object.put("step_name", string3);
        object.put("ref_program_name", string6);
        object.put("ref_chain_name", string8);
        object.put("chain_name", string4);
        object.put("ref_event_schedule_name", string7);
        object.put(PAUSE, string9);
        object.put(SKIP, string10);
        object.put(RESTART_ON_FAILURE, string11);
        object.put(RESTART_ON_RECOVERY, string12);
        object.put(CREDENTIAL_NAME, string13);
        object.put(DESTINATION, string14);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("model", object);
        String string15 = null;
        string15 = string5.equals(SCHEDULE_NLS) ? dBMSSchedulerCodeGenerator.generate(string2, "CHAIN_EVENT_STEP_CREATE", treeMap) : (string5.equals(CHAIN_NLS) ? dBMSSchedulerCodeGenerator.generate(string2, "CHAIN_CHAIN_STEP_CREATE", treeMap) : dBMSSchedulerCodeGenerator.generate(string2, "CHAIN_STEP_CREATE", treeMap));
        return string15;
    }

    protected String getTitle() {
        return Messages.getString("ChainStepCreateAction.15");
    }

    protected String getQueryFromTemplate(Connection connection, String string) {
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string3 = dBMSSchedulerCodeGenerator.generate(string2, string, null);
        return RaptorQueryUtils.promoteToDba((String)string3, (Connection)connection);
    }

    public void setStepType(String string) {
        this.type = string.equals(PROGRAM) ? PROGRAM_NLS : (string.equals(SCHEDULE) ? SCHEDULE_NLS : (string.equals(CHAIN) ? CHAIN_NLS : string));
    }

    public void setChainName(String string) {
        this.chain_name = string;
    }

    private String checkNull(String string) {
        if (string != null && ((string = string.trim()).length() == 0 || string.equalsIgnoreCase("NULL") || string.equalsIgnoreCase("\"NULL\""))) {
            string = null;
        }
        return string;
    }

    protected boolean isCloseOnError() {
        return false;
    }
}

