/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dbtools.scheduler.editors.chain.ChainNode;
import oracle.dbtools.scheduler.editors.chain.IJGraphModel;
import oracle.dbtools.scheduler.editors.chain.RuleData;
import oracle.dbtools.scheduler.editors.chain.StepData;

public class ChainGraphModel
implements IJGraphModel {
    private static final String[] reservedWords = new String[]{"NOT_STARTED", "SCHEDULED", "RUNNING", "PAUSED", "STALLED", "SUCCEEDED", "FAILED", "STOPPED", "COMPLETED", "AND", "OR", "NOT"};
    private HashSet<String> reservedSet = new HashSet<String>(Arrays.asList(reservedWords));
    private String CHAIN_NAME;
    private HashMap<String, StepData> stepHashMap;
    private List<RuleData> ruleDataList;
    private HashMap<String, ChainNode> chainStepMap;
    Processor processor;
    List<String> listConditions;
    Processor inIdentifierProcessor = new Processor(){
        StringBuffer b = new StringBuffer();

        @Override
        public void processChar(char c) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') {
                this.b.append(c);
            } else {
                ChainGraphModel.this.setState(ChainGraphModel.this.notInIdentifierProcessor, c);
            }
        }

        @Override
        public void enterState(char c) {
            this.b.setLength(0);
            this.b.append(c);
        }

        @Override
        public void exitState() {
            ChainGraphModel.this.processIdentifier(this.b.toString().toUpperCase());
        }
    };
    Processor inQuotedIdentifierProcessor = new Processor(){
        StringBuffer b = new StringBuffer();

        @Override
        public void processChar(char c) {
            this.b.append(c);
            if (c == '\"') {
                ChainGraphModel.this.setState(ChainGraphModel.this.notInIdentifierProcessor, c);
            }
        }

        @Override
        public void enterState(char c) {
            this.b.setLength(0);
            this.b.append(c);
        }

        @Override
        public void exitState() {
            ChainGraphModel.this.processIdentifier(this.b.toString());
        }
    };
    Processor notInIdentifierProcessor = new Processor(){

        @Override
        public void processChar(char c) {
            if (!Character.isWhitespace(c)) {
                if (c == '\"') {
                    ChainGraphModel.this.setState(ChainGraphModel.this.inQuotedIdentifierProcessor, c);
                } else if (Character.isLetter(c)) {
                    ChainGraphModel.this.setState(ChainGraphModel.this.inIdentifierProcessor, c);
                }
            }
        }

        @Override
        public void enterState(char c) {
        }

        @Override
        public void exitState() {
        }
    };

    public ChainGraphModel(String string) {
        this.CHAIN_NAME = string;
        this.chainStepMap = new HashMap();
        this.stepHashMap = new HashMap();
        this.ruleDataList = new LinkedList<RuleData>();
    }

    public void addStep(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        StepData stepData = new StepData(string.trim(), string2 != null ? string2.trim() : string2, string3 != null ? string3.trim() : string3, string4 != null ? string4.trim() : string4, string5, string6, string7, string8, string9, string10);
        this.stepHashMap.put(string, stepData);
    }

    public void fillRuleDataList(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                String string = resultSet.getString(1).trim();
                String string2 = resultSet.getString(2).trim();
                String string3 = resultSet.getString(3).trim();
                String string4 = resultSet.getString(4);
                List<String> list = this.getConditionList(string2);
                this.ruleDataList.add(new RuleData(string, string2, string3, string4, list));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean setGraphModel() {
        return !this.stepHashMap.isEmpty();
    }

    public List<StepData> getStepForRule(RuleData ruleData) {
        String string = ruleData.getRuleAction();
        String[] stringArray = string.split("[\\s,]+");
        Vector<StepData> vector = new Vector<StepData>();
        for (String string2 : stringArray) {
            if (!this.stepHashMap.containsKey(string2 = string2.replace("\"", ""))) continue;
            vector.add(this.stepHashMap.get(string2));
        }
        return vector;
    }

    private void setState(Processor processor, char c) {
        if (this.processor != null) {
            this.processor.exitState();
        }
        this.processor = processor;
        if (this.processor != null) {
            this.processor.enterState(c);
        }
    }

    private void processIdentifier(String string) {
        if (string.startsWith("\"")) {
            String string2 = string.substring(1, string.length() - 1);
            if (this.reservedSet.contains(string2)) {
                if (this.listConditions.contains(string2)) {
                    return;
                }
                this.listConditions.add(string2);
                return;
            }
            string = string2;
        }
        if (this.listConditions.contains(string)) {
            return;
        }
        if (this.reservedSet.contains(string)) {
            return;
        }
        this.listConditions.add(string);
    }

    private List<String> getConditionList(String object) {
        this.listConditions = new Vector<String>();
        if ((object = " " + ((String)object).trim()) != null || ((String)object).length() > 0) {
            this.setState(this.notInIdentifierProcessor, '\u0000');
            for (int i = 0; i < ((String)object).length(); ++i) {
                this.processor.processChar(((String)object).charAt(i));
            }
            this.setState(null, '\u0000');
        }
        return this.listConditions;
    }

    @Override
    public String getJGraphName() {
        return this.CHAIN_NAME;
    }

    @Override
    public void clear() {
        this.ruleDataList.clear();
        this.chainStepMap.clear();
        this.stepHashMap.clear();
    }

    public Map<String, StepData> getStepDataMap() {
        return this.stepHashMap;
    }

    public List<RuleData> getRuleDataList() {
        return this.ruleDataList;
    }

    public HashMap<String, ChainNode> getChainStepMap() {
        return this.chainStepMap;
    }

    public static String[] getReservedWords() {
        return reservedWords;
    }

    static interface Processor {
        public void enterState(char var1);

        public void exitState();

        public void processChar(char var1);
    }
}

