/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Destination;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_JobArguments;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.dbtools.scheduler.panels.program.ProgramCreateAction;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenActionControl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.javatools.util.ArrayMap;

public class NewJobCreateActionDialogTab_EditProperties
extends ActionDialogTab
implements PropertyChangeListener {
    private NewJobModel model;
    private SqlComboBoxActionControl addChainCtl;
    private NameBoxActionControl nameCtl1 = null;
    private ActionControl enabledCtl = null;
    private ActionControl commentsCtl = null;
    private ActionControl jobClassCtl = null;
    private CardLayoutActionControl whatJobCtl = null;
    private ScheduleWhenActionControl whenJobCtl = null;
    private SqlComboBoxActionControl addStoredProcedureCtl = null;
    private TextBoxActionControl addRemoteStoredProcedureCtl = null;
    private EditorActionControl plsqlEditorCtl = null;
    private ActionControl addUsersCtl = null;
    private SqlComboBoxActionControl addNamedProgramCtl = null;
    private FilePathActionControl execNameCtl = null;
    private ComboBoxActionControl scriptTypeCtl = null;
    private EditorActionControl scriptTxtCtl = null;
    protected String schema = null;
    private String job_name_text = "";
    private String jobDescription = null;
    private boolean jobEnabled = true;
    private final String DEFAULT_JOB_CLASS_NAME = "SYS.DEFAULT_JOB_CLASS";
    private final String NULL_JOB_CLASS_NAME = "SYS.null";
    private String jobClassName = "SYS.DEFAULT_JOB_CLASS";
    private String jobStyle = "REGULAR";
    private String jobAction = "";
    private String nlsJobType = NewJobModel.JOB_TYPE_PLSQL_BLOCK;
    private String jobType = null;
    private String programName = "";
    private boolean delayLoading = true;
    private Connection conn;
    private String jobActionPlsqlBlock = null;
    private String jobActionChain = "";
    private String jobActionExecutable = "";
    private String jobActionScript = "";
    private String jobActionScriptType = NewJobModel.SCRIPT_TYPE_SQLPLUS;
    private String jobActionStoredProcedure = "";
    private String jobActionRemoteStoredProcedure = "";
    private String jobActionStoredProcedureSchema = "";
    private String jobActionProgramName = "";
    private String programOwner = null;
    private String editScheduleType = "IMMEDIATE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewJobCreateActionDialogTab_EditProperties(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (newJobModel.getOperation() == NewJobModel.Operation.EDIT) {
                this.job_name_text = (String)newJobModel.getPreviousJobData("oldObjectName");
                this.job_name_text = ObjectNameValidator.displayName(this.job_name_text);
            }
            this.jobEnabled = new Boolean((String)newJobModel.getPreviousJobData("oldEnabled"));
            this.jobDescription = (String)newJobModel.getPreviousJobData("oldComments");
            this.jobClassName = (String)newJobModel.getPreviousJobData("oldJobclass");
            if (this.jobClassName == null || this.jobClassName.equals("\"SYS\".\"null\"")) {
                this.jobClassName = "SYS.null";
            }
            this.jobStyle = (String)newJobModel.getPreviousJobData("oldJobStyle");
            this.jobType = (String)newJobModel.getPreviousJobData("oldJobType");
            this.nlsJobType = this.getNLSJobType(this.jobType);
            this.jobAction = (String)newJobModel.getPreviousJobData("oldJobAction");
            if (this.jobAction == null) {
                this.jobAction = "";
            }
            this.programName = (String)newJobModel.getPreviousJobData("oldProgramName");
            if (this.programName == null) {
                this.programName = "";
            }
            this.programOwner = (String)newJobModel.getPreviousJobData("oldProgramOwner");
            if (this.jobType == null) {
                if (this.programName.length() > 0) {
                    this.jobActionProgramName = this.programOwner + "." + this.programName;
                }
            } else {
                if (this.jobType.equals("PLSQL_BLOCK")) {
                    this.jobActionPlsqlBlock = this.jobAction;
                } else if (this.jobType.equals("CHAIN")) {
                    this.jobActionChain = this.jobAction;
                } else if (this.jobType.equals("EXTERNAL_SCRIPT")) {
                    this.jobActionScript = this.jobAction;
                    this.jobActionScriptType = NewJobModel.SCRIPT_TYPE_EXTERNAL;
                } else if (this.jobType.equals("SQL_SCRIPT")) {
                    this.jobActionScript = this.jobAction;
                    this.jobActionScriptType = NewJobModel.SCRIPT_TYPE_SQLPLUS;
                } else if (this.jobType.equals("BACKUP_SCRIPT")) {
                    this.jobActionScript = this.jobAction;
                    this.jobActionScriptType = NewJobModel.SCRIPT_TYPE_BACKUP;
                } else if (this.jobType.equals("EXECUTABLE")) {
                    this.jobActionExecutable = this.jobAction;
                } else if (this.jobType.equals("STORED_PROCEDURE")) {
                    Connection connection = newJobModel.getConnection();
                    if (Connections.getInstance().lock(connection)) {
                        try {
                            QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(this.jobAction);
                            String string3 = qualifiedIdentifier.getUserName();
                            String string4 = null;
                            String string5 = qualifiedIdentifier.getObjectName();
                            String string6 = qualifiedIdentifier.getSubObjectName();
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            if (string3 != null && string3.length() > 2 && string3.startsWith("\"") && string3.endsWith("\"")) {
                                bl = true;
                            }
                            if (string5 != null && string5.length() > 2 && string5.startsWith("\"") && string5.endsWith("\"")) {
                                bl3 = true;
                            }
                            if (string6 != null && string6.length() > 2 && string6.startsWith("\"") && string6.endsWith("\"")) {
                                bl4 = true;
                            }
                            if (string6 != null && string6.length() > 0) {
                                string4 = string5;
                                bl2 = bl3;
                                string5 = string6;
                                bl3 = bl4;
                            } else {
                                string6 = null;
                            }
                            if (string3 != null && !bl) {
                                string3 = string3.toUpperCase();
                            }
                            if (string5 != null && !bl3) {
                                string5 = string5.toUpperCase();
                            }
                            if (string4 != null && !bl2) {
                                string4 = string4.toUpperCase();
                            }
                            String string7 = newJobModel.getSchema();
                            if (string3 != null && string6 == null && ProgramCreateAction.isLocalPackage(connection, string7, string3)) {
                                this.jobActionStoredProcedureSchema = string7;
                                this.jobActionStoredProcedure = string3 + "." + string5;
                            } else {
                                String string8 = string3;
                                if (string3 == null) {
                                    string8 = string7;
                                }
                                if (ProgramCreateAction.isLocalStoredProcedure(connection, string8, string4, string5)) {
                                    this.jobActionStoredProcedureSchema = string3 != null && string3.length() > 0 ? string3 : string7;
                                    this.jobActionStoredProcedure = string4 != null && string4.length() > 0 ? string4 + "." + string5 : string5;
                                } else {
                                    this.jobType = "REMOTE_STORED_PROCEDURE";
                                    this.jobActionRemoteStoredProcedure = this.jobAction;
                                }
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                }
                this.editScheduleType = (String)newJobModel.getPreviousJobData("oldScheduleType");
                this.delayLoading = newJobModel.getDelayLoadingChoice();
            }
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        Object object;
        String string;
        PropertyPanelActionControl propertyPanelActionControl;
        this.conn = connection;
        this.getCurrentUser(connection);
        if (this.jobActionStoredProcedureSchema.length() == 0) {
            this.jobActionStoredProcedureSchema = this.schema;
        }
        this.nameCtl1 = new NameBoxActionControl("JOB_NAME", SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_NAME_LABEL"), this.job_name_text, null, true);
        this.nameCtl1.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.model.getOperation() == NewJobModel.Operation.EDIT) {
            this.nameCtl1.setEditable(false);
        } else {
            this.nameCtl1.setEditable(true);
        }
        this.enabledCtl = new BooleanCheckBoxActionControl("ENABLED", SchedulerArb.getString("JOB_CREATE_DETAILS_ENABLED_LABEL"), this.jobEnabled, false, true);
        this.commentsCtl = new TextBoxActionControl("COMMENTS", SchedulerArb.getString("JOB_CREATE_DETAILS_DESCRIPTION_LABEL"), this.jobDescription, null, true);
        String string2 = this.getQuery(connection, "jobCreateGetJobClasses");
        this.jobClassCtl = new IdSqlComboBoxActionControl("JOB_CLASS", SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_CLASS_LABEL"), connection, string2, null, this.jobClassName, true);
        PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl("WHAT_PANEL", null);
        this.plsqlEditorCtl = new EditorActionControl("WHAT_JOB_TYPE_PANEL_PLSQL_BLOCK", this.jobActionPlsqlBlock, "x.pls");
        propertyPanelActionControl2.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(NewJobCreateActionDialogTab_EditProperties.this.plsqlEditorCtl);
            }
        });
        PropertyPanelActionControl propertyPanelActionControl3 = new PropertyPanelActionControl("WHAT_EXECUTABLE_PANEL", null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.execNameCtl = new FilePathActionControl("WHAT_JOB_TYPE_PANEL_EXECUTABLE", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_EXECUTABLE"), this.jobActionExecutable, 0);
        arrayList.add(this.execNameCtl);
        propertyPanelActionControl3.addChildControls(arrayList);
        PropertyPanelActionControl propertyPanelActionControl4 = new PropertyPanelActionControl("WHAT_SCRIPT_PANEL", null);
        if (this.model.FeatureMin121()) {
            propertyPanelActionControl = new ArrayList();
            this.scriptTypeCtl = new ComboBoxActionControl("WHAT_JOB_TYPE_PANEL_SCRIPT_TYPE", SchedulerArb.getString("WHAT_JOB_TYPE_PANEL_ADD_SCRIPT_TYPE"), NewJobModel.EXTERNAL_SCRIPT_TYPE_LIST, this.jobActionScriptType);
            arrayList.add(this.scriptTypeCtl);
            this.scriptTxtCtl = new EditorActionControl("WHAT_JOB_TYPE_PANEL_SCRIPT", this.jobActionScript, "x.pls");
            propertyPanelActionControl.add(this.scriptTypeCtl);
            propertyPanelActionControl.add(this.scriptTxtCtl);
            propertyPanelActionControl4.addChildControls((List)propertyPanelActionControl);
        }
        propertyPanelActionControl = null;
        if (this.model.FeatureMin102()) {
            string = this.getQuery(connection, "getChains");
            this.addChainCtl = new IdSqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_CHAIN", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_CHAIN"), connection, string, null, this.jobActionChain, false, this.delayLoading);
            propertyPanelActionControl = new PropertyPanelActionControl("WHAT_CHAIN_PANEL", null);
            object = new ArrayList();
            ((ArrayList)object).add(this.addChainCtl);
            propertyPanelActionControl.addChildControls((List)object);
        }
        string = this.getQuery(connection, "getPrograms");
        this.addNamedProgramCtl = new IdSqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_NAMED_PROGRAM"), connection, string, null, this.jobActionProgramName, true, this.delayLoading);
        object = new PropertyPanelActionControl("WHAT_NAME_PROGRAM_PANEL", null);
        ArrayList<SqlComboBoxActionControl> arrayList2 = new ArrayList<SqlComboBoxActionControl>();
        arrayList2.add(this.addNamedProgramCtl);
        object.addChildControls(arrayList2);
        String string3 = this.getQuery(connection, "jobCreateGetUsers");
        this.addUsersCtl = new SqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_STORED_PROCEDURE_SCHEMA"), connection, string3, null, this.jobActionStoredProcedureSchema, true, this.delayLoading);
        String string4 = this.getQuery(connection, "getStoredProceduresGivenOwner");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.model.setSchemaForStoredProcedure(this.jobActionStoredProcedureSchema);
        hashtable.put("OWNER", this.jobActionStoredProcedureSchema);
        this.addStoredProcedureCtl = new SqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_STORED_PROCEDURE_NAME"), connection, string4, hashtable, this.jobActionStoredProcedure, true, this.delayLoading);
        PropertyPanelActionControl propertyPanelActionControl5 = new PropertyPanelActionControl("WHAT_STORED_PROCEDURE_PANEL", null);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(this.addUsersCtl);
        this.addUsersCtl.addPropertyChangeListener((PropertyChangeListener)this);
        arrayList3.add(this.addStoredProcedureCtl);
        propertyPanelActionControl5.addChildControls(arrayList3);
        this.addRemoteStoredProcedureCtl = new TextBoxActionControl("REMOTE_STORED_PROCEDURE", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_REMOTE_STORED_PROCEDURE_NAME"), this.jobActionRemoteStoredProcedure);
        PropertyPanelActionControl propertyPanelActionControl6 = new PropertyPanelActionControl("WHAT_REMOTE_STORED_PROCEDURE_PANEL", null);
        ArrayList<TextBoxActionControl> arrayList4 = new ArrayList<TextBoxActionControl>();
        arrayList4.add(this.addRemoteStoredProcedureCtl);
        propertyPanelActionControl6.addChildControls(arrayList4);
        ArrayMap arrayMap = new ArrayMap();
        arrayMap.put(NewJobModel.JOB_TYPE_PLSQL_BLOCK, propertyPanelActionControl2);
        if (this.model.FeatureMin102()) {
            arrayMap.put(NewJobModel.JOB_TYPE_CHAIN, propertyPanelActionControl);
        }
        arrayMap.put(NewJobModel.JOB_TYPE_STORED_PROCEDURE, propertyPanelActionControl5);
        arrayMap.put(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE, propertyPanelActionControl6);
        arrayMap.put(NewJobModel.JOB_TYPE_NAMED_PROGRAM, object);
        arrayMap.put(NewJobModel.JOB_TYPE_EXECUTABLE, propertyPanelActionControl3);
        if (this.model.FeatureMin121()) {
            arrayMap.put(NewJobModel.JOB_TYPE_SCRIPT, propertyPanelActionControl4);
        }
        this.whatJobCtl = new CardLayoutActionControl("WHAT_JOB_TYPE_PANEL_NAME", null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_TITLE"), (Map)arrayMap);
        if (this.model.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (this.programName.length() > 0) {
                this.whatJobCtl.setSelected((Object)this.getNLSJobType("NAMED_PROGRAM"));
            } else {
                this.whatJobCtl.setSelected((Object)this.getNLSJobType(this.jobType));
            }
        }
        this.whatJobCtl.getUI().setPreferredSize(new Dimension(313, 400));
        this.whenJobCtl = new ScheduleWhenActionControl("WHEN_JOB_TYPE_PANEL_NAME", null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("JOB_CREATE_DETAILS_WHEN_PANEL_TITLE"), ScheduleWhenActionControl.FCOTarget.JOB, connection);
        ScheduleWhenModel scheduleWhenModel = this.model.getWhenModel();
        scheduleWhenModel.doInitialize();
        this.whenJobCtl.setModel(scheduleWhenModel);
        this.whatJobCtl.setFillVertical(true);
        this.whenJobCtl.setFillVertical(true);
        SideBySideActionControl sideBySideActionControl = new SideBySideActionControl("WHAT_WHEN", null, (ActionControl)this.whatJobCtl, (ActionControl)this.whenJobCtl, 4);
        ArrayList<ActionControl> arrayList5 = new ArrayList<ActionControl>();
        arrayList5.add((ActionControl)this.nameCtl1);
        arrayList5.add(this.enabledCtl);
        arrayList5.add(this.commentsCtl);
        arrayList5.add(this.jobClassCtl);
        arrayList5.add((ActionControl)sideBySideActionControl);
        return arrayList5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        String string2 = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
        if (string2 == null) {
            return;
        }
        if (string.equals("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA") && Connections.getInstance().lock(this.conn)) {
            String string3 = string2;
            this.model.setSchemaForStoredProcedure(string3);
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("OWNER", string3);
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                dBUtil.setRaiseError(true);
                String string4 = this.getQuery(this.conn, "getStoredProceduresGivenOwner");
                this.addStoredProcedureCtl.resetQuery(this.conn, string4, hashtable, "");
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCurrentUser(Connection connection) {
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block5: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string = this.getQuery(connection, "jobCreateGetCurrentUser");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    if (resultSet == null) break block5;
                    this.setCurrentUserFromResultSet(resultSet);
                }
                catch (Exception exception) {
                    try {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    private void setCurrentUserFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.schema = this.getStringFromRS(resultSet, "USER");
            }
        }
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void addListener(ActionDialogTab actionDialogTab) {
        if (actionDialogTab instanceof NewJobCreateActionDialogTab_Destination) {
            this.whatJobCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            if (this.scriptTypeCtl != null) {
                this.scriptTypeCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            }
        } else if (actionDialogTab instanceof NewJobCreateActionDialogTab_JobArguments) {
            this.addStoredProcedureCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.addNamedProgramCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.whatJobCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.execNameCtl.getUI().addDocumentListener((DocumentListener)actionDialogTab);
            this.execNameCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
        }
    }

    private String getNLSJobType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("PLSQL_BLOCK")) {
            return NewJobModel.JOB_TYPE_PLSQL_BLOCK;
        }
        if (string.equals("EXECUTABLE")) {
            return NewJobModel.JOB_TYPE_EXECUTABLE;
        }
        if (string.equals("EXTERNAL_SCRIPT")) {
            return NewJobModel.JOB_TYPE_SCRIPT;
        }
        if (string.equals("BACKUP_SCRIPT")) {
            return NewJobModel.JOB_TYPE_SCRIPT;
        }
        if (string.equals("SQL_SCRIPT")) {
            return NewJobModel.JOB_TYPE_SCRIPT;
        }
        if (string.equals("STORED_PROCEDURE")) {
            return NewJobModel.JOB_TYPE_STORED_PROCEDURE;
        }
        if (string.equals("REMOTE_STORED_PROCEDURE")) {
            return NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE;
        }
        if (string.equals("CHAIN")) {
            return NewJobModel.JOB_TYPE_CHAIN;
        }
        if (string.equals("NAMED_PROGRAM")) {
            return NewJobModel.JOB_TYPE_NAMED_PROGRAM;
        }
        return null;
    }

    public void setEditOptions() {
        if (this.model.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (this.jobType != null) {
                if (this.jobType.equals("PLSQL_BLOCK")) {
                    if (this.plsqlEditorCtl != null) {
                        this.plsqlEditorCtl.set(this.jobActionPlsqlBlock);
                    }
                } else if (this.jobType.equals("CHAIN")) {
                    if (this.addChainCtl != null) {
                        this.addChainCtl.setSelected((Object)this.jobActionChain);
                    }
                } else if (this.jobType.equals("EXECUTABLE")) {
                    this.whatJobCtl.firePropertyChangeListeners(this.getNLSJobType(this.jobType));
                    if (this.execNameCtl != null) {
                        this.execNameCtl.set(this.jobActionExecutable);
                        this.execNameCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_EXECUTABLE");
                    }
                } else if (this.jobType.equals("EXTERNAL_SCRIPT") || this.jobType.equals("SQL_SCRIPT") || this.jobType.equals("BACKUP_SCRIPT")) {
                    this.whatJobCtl.firePropertyChangeListeners(this.getNLSJobType(this.jobType));
                    if (this.scriptTypeCtl != null) {
                        this.scriptTypeCtl.set(this.jobActionScriptType);
                    }
                    if (this.scriptTxtCtl != null) {
                        this.scriptTxtCtl.set(this.jobActionScript);
                    }
                    if (this.scriptTypeCtl != null) {
                        this.scriptTypeCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_SCRIPT");
                    }
                } else if (this.jobType.equals("STORED_PROCEDURE")) {
                    this.whatJobCtl.firePropertyChangeListeners(NewJobModel.JOB_TYPE_STORED_PROCEDURE);
                    if (this.addStoredProcedureCtl != null) {
                        this.addStoredProcedureCtl.setSelected((Object)this.jobActionStoredProcedure);
                        this.addStoredProcedureCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE");
                    }
                } else if (this.jobType.equals("REMOTE_STORED_PROCEDURE")) {
                    this.whatJobCtl.firePropertyChangeListeners(NewJobModel.JOB_TYPE_REMOTE_STORED_PROCEDURE);
                    if (this.addRemoteStoredProcedureCtl != null) {
                        this.addRemoteStoredProcedureCtl.set(this.jobActionRemoteStoredProcedure);
                        this.addRemoteStoredProcedureCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_REMOTE_STORED_PROCEDURE");
                    }
                }
            } else if (this.programName != null && this.programName.trim().length() > 0) {
                this.whatJobCtl.firePropertyChangeListeners(NewJobModel.JOB_TYPE_NAMED_PROGRAM);
                if (this.addNamedProgramCtl != null) {
                    this.addNamedProgramCtl.setSelected((Object)this.jobActionProgramName);
                    this.addNamedProgramCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM");
                }
            }
        }
    }

    private String stripSchemaNameInJobAction(String string) {
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringTokenizer.countTokens() == 2) {
                stringArray[0] = stringTokenizer.nextToken().trim();
                return this.stripQuotes(stringTokenizer.nextToken().trim());
            }
        } else {
            return this.stripQuotes(string);
        }
        return null;
    }

    private String getSchemaNameInJobAction(String string) {
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringTokenizer.countTokens() == 2) {
                stringArray[0] = stringTokenizer.nextToken().trim();
                return this.stripQuotes(stringArray[0]);
            }
        } else {
            return this.stripQuotes(string);
        }
        return null;
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }

    private String stripQuotes(String string) {
        String string2 = string;
        if (string.startsWith("\"") && !string.endsWith("\"")) {
            string2 = string.substring(1);
        } else if (!string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(0, string.length() - 1);
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }
}

