/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.tree;

import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dTree.DTreeActivateListener;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TreeComponentPopupListener;

public class TopicTreePane
extends JScrollPane {
    private TopicTreeComponent _tree;
    private ListenerManager _listeners;

    public TopicTreePane(TopicTreeComponent tree) {
        super((Component)((Object)tree), 20, 30);
        this._tree = tree;
        TreeListener listener = new TreeListener();
        tree.addActivateListener(listener);
        tree.addPropertyChangeListener(listener);
        tree.addPopupRequestListener(listener);
        this._listeners = new ListenerManager();
    }

    public TopicTreeComponent getTopicTreeComponent() {
        return this._tree;
    }

    public TopicTreeItem getSelectedItem() {
        return (TopicTreeItem)this._tree.getSelection().getFirstItem();
    }

    public boolean selectTopicTreeNode(TopicTreeNode node) {
        boolean foundMatch = false;
        if (this._tree != null) {
            foundMatch = this._tree.selectTopicTreeNode(node);
        }
        return foundMatch;
    }

    public void addTopicTreeListener(TopicTreeListener listener) {
        this._listeners.addListener((EventListener)listener);
    }

    public void removeTopicTreeListener(TopicTreeListener listener) {
        this._listeners.removeListener((EventListener)listener);
    }

    private class TreeListener
    implements DTreeActivateListener,
    PropertyChangeListener,
    TreeComponentPopupListener {
        private boolean _popupActive = false;

        private TreeListener() {
        }

        public void dTreeItemActivate(DTreeItemEvent evt) {
            if (evt.getID() == 2004) {
                this._fireTopicActivated((TopicTreeItem)evt.getItem(), false);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopicTreeItem selectedItem = (TopicTreeItem)TopicTreePane.this._tree.getSelection().getFirstItem();
            Enumeration listeners = TopicTreePane.this._listeners.getListeners();
            if (listeners != null) {
                while (listeners.hasMoreElements()) {
                    ((TopicTreeListener)listeners.nextElement()).topicSelected(selectedItem);
                }
            }
        }

        @Override
        public void popupRequested(TopicTreeEvent evt, Point location) {
            if (!this._popupActive) {
                if (evt != null && evt.getID() == 2002) {
                    Point scrollLoc = TopicTreePane.this.getViewport().getViewPosition();
                    TopicTreeItem selected = evt.getTopicTreeItem();
                    TreePanePopup popup = new TreePanePopup();
                    Enumeration listeners = TopicTreePane.this._listeners.getListeners();
                    if (listeners != null) {
                        while (listeners.hasMoreElements()) {
                            TopicTreeListener l = (TopicTreeListener)listeners.nextElement();
                            l.popupDisplayed(selected, popup);
                        }
                    }
                    if (popup.getSubElements().length > 0) {
                        MenuUtils.showPopupMenu((JPopupMenu)popup, (Component)((Object)TopicTreePane.this._tree), (int)(location.x - scrollLoc.x), (int)(location.y - scrollLoc.y));
                        this._popupActive = true;
                    }
                } else {
                    this._popupActive = false;
                }
            }
        }

        private void _fireTopicActivated(TopicTreeItem item, boolean newWindow) {
            Enumeration listeners = TopicTreePane.this._listeners.getListeners();
            if (listeners != null) {
                while (listeners.hasMoreElements()) {
                    TopicTreeListener l = (TopicTreeListener)listeners.nextElement();
                    l.topicActivated(item, newWindow);
                }
            }
        }

        private class TreePanePopup
        extends JPopupMenu {
            private TreePanePopup() {
            }

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    TreeListener.this._popupActive = false;
                }
            }
        }
    }
}

