/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.xml.parser.v2.XMLNode;

public class XMLMViewAccessor
extends XMLSchemaObjAccessor {
    private XMLSegmentAccessor m_segment = null;
    private static final String MVIEW_ATTR_REFRESH_TYPE_FORCE = "FORCE";
    private static final String MVIEW_ATTR_REFRESH_TYPE_FAST = "FAST";
    private static final String MVIEW_ATTR_REFRESH_TYPE_COMPLETE = "COMPLETE";
    private static final String MVIEW_ATTR_REFRESH_INTERVAL_ON_DEMAND = "onDemand";
    private static final String MVIEW_ATTR_REFRESH_INTERVAL_ON_COMMIT = "onEachCommit";
    private static final String MVIEW_ATTR_REFRESH_INTERVAL_AUTO = "automaticallyOn";
    private static final String MVIEW_ATTR_REFRESH_INTERVAL_NEVER = "never";
    private static final String MVIEW_ATTR_REFRESH_METHOD_ROWID = "rowID";
    private static final String MVIEW_ATTR_REFRESH_METHOD_PRIMARY_KEY = "primaryKey";
    private static final String X_UPDATABLE = "sxml:FOR_UPDATE";
    private static final String X_PREBUILT_TABLE = "sxml:ON_PREBUILT_TABLE";
    private static final String X_REDUCED_PRECISION = "sxml:ON_PREBUILT_TABLE/sxml:REDUCED_PRECISION";
    private static final String X_REFRESH = "sxml:REFRESH";
    private static final String X_REFRESH_FAST = "sxml:REFRESH/sxml:FAST";
    private static final String X_REFRESH_COMPLETE = "sxml:REFRESH/sxml:COMPLETE";
    private static final String X_REFRESH_ON_COMMIT = "sxml:REFRESH/sxml:ON_COMMIT";
    private static final String X_REFRESH_NEVER = "sxml:REFRESH/sxml:NEVER_REFRESH";
    private static final String X_REFRESH_START_WITH = "sxml:REFRESH/sxml:START_WITH";
    private static final String X_REFRESH_NEXT = "sxml:REFRESH/sxml:NEXT";
    private static final String X_REFRESH_WITH_PRIMARY_KEY = "sxml:REFRESH/sxml:WITH_PRIMARY_KEY";
    private static final String X_REFRESH_WITH_ROWID = "sxml:REFRESH/sxml:WITH_ROWID";
    private static final String X_MASTER_RBS = "sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT";
    private static final String X_MASTER_RBS_SEG_NAME = "sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME";
    private static final String X_MASTER_RBS_DEFAULT = "sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:DEFAULT";
    private static final String X_LOCAL_RBS = "sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT";
    private static final String X_LOCAL_RBS_SEG_NAME = "sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:NAME";
    private static final String X_LOCAL_RBS_DEFAULT = "sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:DEFAULT";
    private static final String X_QUERY = "sxml:SUBQUERY";
    private static final String X_QUERY_REWRITE = "sxml:QUERY_REWRITE";
    private static final String X_PARALLEL = "sxml:PARALLEL";
    private static final String X_PARALLEL_DEGREE = "sxml:PARALLEL_DEGREE";
    private static final String X_CACHE = "sxml:CACHE";
    private static final String X_INDEX_ATTRIBUTES = "sxml:INDEX_ATTRIBUTES";
    private static final String s_getMViewCommentsQuery_DBA = "select * from ( select null, comments from dba_mview_comments where owner = ? and mview_name = ?   and comments is not null union all select column_name, comments from dba_col_comments where owner = ? and table_name = ?   and comments is not null ) order by 1 asc nulls first";
    private static final String s_getMViewCommentsQuery_ALL = "select * from ( select null, comments from all_mview_comments where owner = ? and mview_name = ?   and comments is not null union all select column_name, comments from all_col_comments where owner = ? and table_name = ?   and comments is not null ) order by 1 asc nulls first";

    protected XMLMViewAccessor() {
    }

    protected XMLMViewAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    protected String getTypePathElement() {
        return "MATERIALIZED_VIEW";
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.initializeSegments();
    }

    private void initializeSegments() throws XMLAccessorException {
        XMLAccessor accessor = XMLMViewAccessor.getXMLAccessorForType(101, this.getXmlRoot(), this.getAccessorClient());
        this.m_segment = (XMLSegmentAccessor)accessor;
    }

    @Override
    public XMLSegmentAccessor getSegment() {
        return this.m_segment;
    }

    public String getMasterOwner() {
        return null;
    }

    public String getMasterName() {
        return null;
    }

    public String getMasterLink() {
        return null;
    }

    public boolean getUpdatable() {
        return this.nodeExists(X_UPDATABLE);
    }

    public boolean getOnPrebuiltTable() {
        return this.nodeExists(X_PREBUILT_TABLE);
    }

    public boolean getIsReducedPrecision() {
        return this.nodeExists(X_REDUCED_PRECISION);
    }

    public String getRefreshType() {
        String MVrType = MVIEW_ATTR_REFRESH_TYPE_FORCE;
        if (this.nodeExists(X_REFRESH_FAST)) {
            MVrType = MVIEW_ATTR_REFRESH_TYPE_FAST;
        } else if (this.nodeExists(X_REFRESH_COMPLETE)) {
            MVrType = MVIEW_ATTR_REFRESH_TYPE_COMPLETE;
        }
        return MVrType;
    }

    public String getRefreshInterval() {
        String MVrInterval = MVIEW_ATTR_REFRESH_INTERVAL_NEVER;
        if (this.nodeExists(X_REFRESH)) {
            MVrInterval = MVIEW_ATTR_REFRESH_INTERVAL_ON_DEMAND;
            if (this.nodeExists(X_REFRESH_ON_COMMIT)) {
                MVrInterval = MVIEW_ATTR_REFRESH_INTERVAL_ON_COMMIT;
            } else if (this.nodeExists(X_REFRESH_NEXT)) {
                MVrInterval = MVIEW_ATTR_REFRESH_INTERVAL_AUTO;
            }
        } else if (this.nodeExists(X_REFRESH_NEVER)) {
            MVrInterval = MVIEW_ATTR_REFRESH_INTERVAL_NEVER;
        }
        return MVrInterval;
    }

    public String getRefreshDate() {
        return null;
    }

    public String getRefreshMethod() {
        String MVrMethod = MVIEW_ATTR_REFRESH_METHOD_PRIMARY_KEY;
        if (this.nodeExists(X_REFRESH_WITH_ROWID)) {
            MVrMethod = MVIEW_ATTR_REFRESH_METHOD_ROWID;
        }
        return MVrMethod;
    }

    public String getMasterRBS() {
        return this.selectTextValue(X_MASTER_RBS_SEG_NAME);
    }

    public boolean getMasterRBSDefault() {
        return this.nodeExists(X_MASTER_RBS_DEFAULT);
    }

    public String getLocalRBS() {
        return this.selectTextValue(X_LOCAL_RBS_SEG_NAME);
    }

    public boolean getLocalRBSDefault() {
        return this.nodeExists(X_LOCAL_RBS_DEFAULT);
    }

    public String getQuery() {
        return this.selectTextValue(X_QUERY);
    }

    public boolean getQueryRewrite() {
        return this.nodeExists(X_QUERY_REWRITE);
    }

    public boolean getIsParallel() {
        return this.getParallel();
    }

    public String getParallelDegree() {
        String pd = null;
        pd = this.nodeExists(X_PARALLEL_DEGREE) ? this.selectTextValue(X_PARALLEL_DEGREE) : this.selectTextValue(X_PARALLEL);
        return pd;
    }

    public boolean getParallelDegreeDefault() {
        return this.getDegreeDefault();
    }

    public boolean getIsCache() {
        return this.nodeExists(X_CACHE);
    }

    public boolean getIsLogging() {
        return this.getSegment().getLogging() == 1;
    }

    @Override
    public String getTablespace() {
        return this.getSegment().getTblspcName();
    }

    public boolean getUsesIndex() {
        return this.nodeExists(X_INDEX_ATTRIBUTES);
    }

    public String getIndexSchema() {
        return null;
    }

    public String getIndexName() {
        return null;
    }

    @Override
    protected boolean isCommentableType() {
        return true;
    }

    @Override
    protected String getParallelPath() {
        return X_PARALLEL;
    }

    @Override
    protected String getParallelDegreePath() {
        return X_PARALLEL_DEGREE;
    }

    @Override
    protected String getParallelDegreeDegreePath() {
        return "sxml:PARALLEL_DEGREE/sxml:DEGREE";
    }

    @Override
    protected ResultSet getCommentsForObject(CMConnection dbConn, String objSchema, String objName) throws SQLException {
        String query = dbConn.canAccessDbaViews() ? s_getMViewCommentsQuery_DBA : s_getMViewCommentsQuery_ALL;
        this.m_commentsStmt = dbConn.prepareStatement(query);
        this.m_commentsStmt.setString(1, objSchema);
        this.m_commentsStmt.setString(2, objName);
        this.m_commentsStmt.setString(3, objSchema);
        this.m_commentsStmt.setString(4, objName);
        ResultSet rs = this.m_commentsStmt.executeQuery();
        return rs;
    }

    @Override
    protected String getTypeNameForDDL() {
        return "MATERIALIZED VIEW";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString()).append("  For Update: ").append(XMLMViewAccessor.YorN(this.getUpdatable())).append("\n").append("  On Prebuilt Table: ").append(XMLMViewAccessor.YorN(this.getOnPrebuiltTable())).append("\n").append("  Refresh Type: ").append(this.nin(this.getRefreshType())).append("\n").append("  Refresh Interval: ").append(this.getRefreshInterval()).append("\n").append("  Refresh Date: ").append(this.nin(this.getRefreshDate())).append("\n").append("  Refresh Method: ").append(this.getRefreshMethod()).append("\n").append("  Master RBS: ").append(this.nin(this.getMasterRBS())).append("\n").append("  Master RBS Default: ").append(XMLMViewAccessor.YorN(this.getMasterRBSDefault())).append("\n").append("  Local RBS: ").append(this.nin(this.getLocalRBS())).append("\n").append("  Local RBS Default: ").append(XMLMViewAccessor.YorN(this.getLocalRBSDefault())).append("\n").append("  Query: ").append(this.getQuery()).append("\n").append("  Query Rewrite: ").append(XMLMViewAccessor.YorN(this.getQueryRewrite())).append("\n").append("  Parallel: ").append(XMLMViewAccessor.YorN(this.getIsParallel())).append("\n").append("  Parallel Degree: ").append(this.nin(this.getParallelDegree())).append("\n").append("  Parallel Degree Default: ").append(XMLMViewAccessor.YorN(this.getParallelDegreeDefault())).append("\n").append("  Cache: ").append(XMLMViewAccessor.YorN(this.getIsCache())).append("\n").append("  Logging: ").append(XMLMViewAccessor.YorN(this.getIsLogging())).append("\n").append("  Tablespace: ").append(this.getTablespace()).append("\n").append("  Uses Index: ").append(XMLMViewAccessor.YorN(this.getUsesIndex())).append("\n").append("  Index Schema: ").append(this.nin(this.getIndexSchema())).append("\n").append("  Index Name: ").append(this.nin(this.getIndexName())).append("\n");
        return sb.toString();
    }
}

